#-*- coding: utf-8 -*-

# Copyright 2010-2013 Calculate Ltd. http://www.calculate-linux.org
#
#  Licensed under the Apache License, Version 2.0 (the "License");
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.

import os
import re
import sys
import time
import traceback
from os import path

from calculate.lib.cl_lang import setLocalTranslate
setLocalTranslate('cl_install3',sys.modules[__name__])

class FileSystemManager:
    """Convert dict install option"""

    defaultOpt = ['noatime']
    defaultBindOpts = ['bind']
    supportFS = {
        'ext2': {'defaultopt': defaultOpt,
                  'format': '/sbin/mkfs.ext2',
                  'formatparam': '{labelparam} {device}',
                  'gpt': '8300',
                  'label': '-L {labelname}',
                  'msdos': '83',
                  'type':['hdd','usb-hdd']},
         'ext3': {'defaultopt': defaultOpt,
                  'format': '/sbin/mkfs.ext3',
                  'formatparam': '{labelparam} {device}',
                  'gpt': '8300',
                  'label': '-L {labelname}',
                  'msdos': '83',
                  'type':['hdd','usb-hdd']},
         'ext4': {'defaultopt': defaultOpt,
                  'format': '/sbin/mkfs.ext4',
                  'formatparam': '{labelparam} {device}',
                  'gpt': '8300',
                  'label': '-L {labelname}',
                  'msdos': '83',
                  'type':['hdd','usb-hdd']},
         'reiserfs': {'defaultopt': defaultOpt,
                      'format': '/sbin/mkfs.reiserfs',
                      'formatparam': '{labelparam} -f {device}',
                      'gpt': '8300',
                      'label': '-l {labelname}',
                      'msdos': '83',
                      'type':['hdd','usb-hdd']},
         'btrfs': {'defaultopt': defaultOpt,
                   'format':'/sbin/mkfs.btrfs',
                   'formatparam': '{labelparam} -f {device}',
                   'gpt': '8300',
                   'label': '-L {labelname}',
                   'msdos': '83',
                   'type':['hdd','usb-hdd']},
         'jfs': {'defaultopt': defaultOpt,
                 'format': '/sbin/mkfs.jfs',
                 'formatparam': '{labelparam} -f {device}',
                 'gpt': '8300',
                 'label': '-L {labelname}',
                 'msdos': '83',
                 'type':['hdd','usb-hdd']},
         'xfs': {'defaultopt': defaultOpt,
                 'format': '/sbin/mkfs.xfs',
                 'formatparam': '{labelparam} -f {device}',
                 'gpt': '8300',
                 'label': '-L {labelname}',
                 'msdos': '83',
                 'type':['hdd','usb-hdd']},
         'nilfs2': {'defaultopt': defaultOpt,
                    'format': '/sbin/mkfs.nilfs2',
                    'formatparam': '{labelparam} {device}',
                    'gpt': '8300',
                    'label': '-L {labelname}',
                    'msdos': '83',
                    'type':['hdd','usb-hdd']},
         'swap': {'defaultopt': 'sw',
                  'format': '/sbin/mkswap',
                  'formatparam': '{device}',
                  'gpt': '8200',
                  'label': '',
                  'msdos': '82'},
         'uefi': {'defaultopt': defaultOpt,
                  'format': '/usr/sbin/mkfs.vfat',
                  'formatparam': '{labelparam} -F 32 {device}',
                  'gpt': 'EF00',
                  'label': '-n {labelname}',
                  'msdos': '0b',
                  'type':['hdd']},
         'vfat': {'defaultopt': defaultOpt,
                  'format': '/usr/sbin/mkfs.vfat',
                  'formatparam': '{labelparam} -F 32 {device}',
                  'gpt': '0700',
                  'label': '-n {labelname}',
                  'msdos': '0b',
                  'type':['flash']},
         'ntfs': {'defaultopt': defaultOpt,
                  'format': '/usr/sbin/mkfs.ntfs',
                  'formatparam': '{labelparam} -FQ {device}',
                  'gpt': '8300',
                  'label': '-L {labelname}',
                  'msdos': '7',
                  'compatible':['ntfs-3g']},
         'ntfs-3g': {'defaultopt': defaultOpt,
                     'format': '/usr/sbin/mkfs.ntfs',
                     'formatparam': '{labelparam} -FQ {device}',
                     'gpt': '8300',
                     'label': '-L {labelname}',
                     'msdos': '7',
                     'compatible':['ntfs']}}
    @classmethod
    def firstAvailable(cls,listFS):
        for fs in listFS:
            if path.exists(cls.supportFS['format']):
                return fs
        else:
            return ""

    defaultFS = {'hdd':"ext4" \
                       if path.exists(supportFS['ext4']['format']) else \
                       "reiserfs" \
                       if path.exists(supportFS['reiserfs']['format']) else \
                       "ext3",
                 'flash':"vfat",
                 'usb-hdd': "ext4" \
                        if path.exists(supportFS['ext4']['format']) else \
                        "reiserfs" \
                        if path.exists(supportFS['reiserfs']['format']) else \
                        "ext3"}

    @classmethod
    def getDefaultOpt(cls,fs):
        return ",".join(cls.supportFS.get(fs,{'defaultopt':[]})['defaultopt'])

    @classmethod
    def checkFSForTypeMount(cls,fs,roottype,mp):
        if mp == '/boot/efi':
            if not fs in ('uefi','vfat'):
                return False
            else:
                return True
        return roottype in cls.supportFS.get(fs,{}).get('type',[])
