/*
 * Hardware modules present on the OMAP44xx chips
 *
 * Copyright (C) 2009-2010 Texas Instruments, Inc.
 * Copyright (C) 2009-2010 Nokia Corporation
 *
 * Paul Walmsley
 * Benoit Cousson
 *
 * This file is automatically generated from the OMAP hardware databases.
 * We respectfully ask that any modifications to this file be coordinated
 * with the public linux-omap@vger.kernel.org mailing list and the
 * authors above to ensure that the autogeneration scripts are kept
 * up-to-date with the file contents.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 */

#include <linux/io.h>

#include <plat/omap_hwmod.h>
#include <plat/cpu.h>
#include <plat/gpio.h>
#include <plat/dma.h>

#include "omap_hwmod_common_data.h"

#include "cm1_44xx.h"
#include "cm2_44xx.h"
#include "prm44xx.h"
#include "prm-regbits-44xx.h"
#include "wd_timer.h"

/* Base offset for all OMAP4 interrupts external to MPUSS */
#define OMAP44XX_IRQ_GIC_START	32

/* Base offset for all OMAP4 dma requests */
#define OMAP44XX_DMA_REQ_START  1

/* Backward references (IPs with Bus Master capability) */
static struct omap_hwmod omap44xx_dma_system_hwmod;
static struct omap_hwmod omap44xx_dmm_hwmod;
static struct omap_hwmod omap44xx_dsp_hwmod;
static struct omap_hwmod omap44xx_emif_fw_hwmod;
static struct omap_hwmod omap44xx_iva_hwmod;
static struct omap_hwmod omap44xx_l3_instr_hwmod;
static struct omap_hwmod omap44xx_l3_main_1_hwmod;
static struct omap_hwmod omap44xx_l3_main_2_hwmod;
static struct omap_hwmod omap44xx_l3_main_3_hwmod;
static struct omap_hwmod omap44xx_l4_abe_hwmod;
static struct omap_hwmod omap44xx_l4_cfg_hwmod;
static struct omap_hwmod omap44xx_l4_per_hwmod;
static struct omap_hwmod omap44xx_l4_wkup_hwmod;
static struct omap_hwmod omap44xx_mpu_hwmod;
static struct omap_hwmod omap44xx_mpu_private_hwmod;

/*
 * Interconnects omap_hwmod structures
 * hwmods that compose the global OMAP interconnect
 */

/*
 * 'dmm' class
 * instance(s): dmm
 */
static struct omap_hwmod_class omap44xx_dmm_hwmod_class = {
	.name	= "dmm",
};

/* dmm interface data */
/* l3_main_1 -> dmm */
static struct omap_hwmod_ocp_if omap44xx_l3_main_1__dmm = {
	.master		= &omap44xx_l3_main_1_hwmod,
	.slave		= &omap44xx_dmm_hwmod,
	.clk		= "l3_div_ck",
	.user		= OCP_USER_SDMA,
};

static struct omap_hwmod_addr_space omap44xx_dmm_addrs[] = {
	{
		.pa_start	= 0x4e000000,
		.pa_end		= 0x4e0007ff,
		.flags		= ADDR_TYPE_RT
	},
};

/* mpu -> dmm */
static struct omap_hwmod_ocp_if omap44xx_mpu__dmm = {
	.master		= &omap44xx_mpu_hwmod,
	.slave		= &omap44xx_dmm_hwmod,
	.clk		= "l3_div_ck",
	.addr		= omap44xx_dmm_addrs,
	.addr_cnt	= ARRAY_SIZE(omap44xx_dmm_addrs),
	.user		= OCP_USER_MPU,
};

/* dmm slave ports */
static struct omap_hwmod_ocp_if *omap44xx_dmm_slaves[] = {
	&omap44xx_l3_main_1__dmm,
	&omap44xx_mpu__dmm,
};

static struct omap_hwmod_irq_info omap44xx_dmm_irqs[] = {
	{ .irq = 113 + OMAP44XX_IRQ_GIC_START },
};

static struct omap_hwmod omap44xx_dmm_hwmod = {
	.name		= "dmm",
	.class		= &omap44xx_dmm_hwmod_class,
	.slaves		= omap44xx_dmm_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap44xx_dmm_slaves),
	.mpu_irqs	= omap44xx_dmm_irqs,
	.mpu_irqs_cnt	= ARRAY_SIZE(omap44xx_dmm_irqs),
	.omap_chip	= OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
};

/*
 * 'emif_fw' class
 * instance(s): emif_fw
 */
static struct omap_hwmod_class omap44xx_emif_fw_hwmod_class = {
	.name	= "emif_fw",
};

/* emif_fw interface data */
/* dmm -> emif_fw */
static struct omap_hwmod_ocp_if omap44xx_dmm__emif_fw = {
	.master		= &omap44xx_dmm_hwmod,
	.slave		= &omap44xx_emif_fw_hwmod,
	.clk		= "l3_div_ck",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

static struct omap_hwmod_addr_space omap44xx_emif_fw_addrs[] = {
	{
		.pa_start	= 0x4a20c000,
		.pa_end		= 0x4a20c0ff,
		.flags		= ADDR_TYPE_RT
	},
};

/* l4_cfg -> emif_fw */
static struct omap_hwmod_ocp_if omap44xx_l4_cfg__emif_fw = {
	.master		= &omap44xx_l4_cfg_hwmod,
	.slave		= &omap44xx_emif_fw_hwmod,
	.clk		= "l4_div_ck",
	.addr		= omap44xx_emif_fw_addrs,
	.addr_cnt	= ARRAY_SIZE(omap44xx_emif_fw_addrs),
	.user		= OCP_USER_MPU,
};

/* emif_fw slave ports */
static struct omap_hwmod_ocp_if *omap44xx_emif_fw_slaves[] = {
	&omap44xx_dmm__emif_fw,
	&omap44xx_l4_cfg__emif_fw,
};

static struct omap_hwmod omap44xx_emif_fw_hwmod = {
	.name		= "emif_fw",
	.class		= &omap44xx_emif_fw_hwmod_class,
	.slaves		= omap44xx_emif_fw_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap44xx_emif_fw_slaves),
	.omap_chip	= OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
};

/*
 * 'l3' class
 * instance(s): l3_instr, l3_main_1, l3_main_2, l3_main_3
 */
static struct omap_hwmod_class omap44xx_l3_hwmod_class = {
	.name	= "l3",
};

/* l3_instr interface data */
/* iva -> l3_instr */
static struct omap_hwmod_ocp_if omap44xx_iva__l3_instr = {
	.master		= &omap44xx_iva_hwmod,
	.slave		= &omap44xx_l3_instr_hwmod,
	.clk		= "l3_div_ck",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l3_main_3 -> l3_instr */
static struct omap_hwmod_ocp_if omap44xx_l3_main_3__l3_instr = {
	.master		= &omap44xx_l3_main_3_hwmod,
	.slave		= &omap44xx_l3_instr_hwmod,
	.clk		= "l3_div_ck",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l3_instr slave ports */
static struct omap_hwmod_ocp_if *omap44xx_l3_instr_slaves[] = {
	&omap44xx_iva__l3_instr,
	&omap44xx_l3_main_3__l3_instr,
};

static struct omap_hwmod omap44xx_l3_instr_hwmod = {
	.name		= "l3_instr",
	.class		= &omap44xx_l3_hwmod_class,
	.slaves		= omap44xx_l3_instr_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap44xx_l3_instr_slaves),
	.omap_chip	= OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
};

/* l3_main_1 interface data */
/* dsp -> l3_main_1 */
static struct omap_hwmod_ocp_if omap44xx_dsp__l3_main_1 = {
	.master		= &omap44xx_dsp_hwmod,
	.slave		= &omap44xx_l3_main_1_hwmod,
	.clk		= "l3_div_ck",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l3_main_2 -> l3_main_1 */
static struct omap_hwmod_ocp_if omap44xx_l3_main_2__l3_main_1 = {
	.master		= &omap44xx_l3_main_2_hwmod,
	.slave		= &omap44xx_l3_main_1_hwmod,
	.clk		= "l3_div_ck",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_cfg -> l3_main_1 */
static struct omap_hwmod_ocp_if omap44xx_l4_cfg__l3_main_1 = {
	.master		= &omap44xx_l4_cfg_hwmod,
	.slave		= &omap44xx_l3_main_1_hwmod,
	.clk		= "l4_div_ck",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* mpu -> l3_main_1 */
static struct omap_hwmod_ocp_if omap44xx_mpu__l3_main_1 = {
	.master		= &omap44xx_mpu_hwmod,
	.slave		= &omap44xx_l3_main_1_hwmod,
	.clk		= "l3_div_ck",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l3_main_1 slave ports */
static struct omap_hwmod_ocp_if *omap44xx_l3_main_1_slaves[] = {
	&omap44xx_dsp__l3_main_1,
	&omap44xx_l3_main_2__l3_main_1,
	&omap44xx_l4_cfg__l3_main_1,
	&omap44xx_mpu__l3_main_1,
};

static struct omap_hwmod omap44xx_l3_main_1_hwmod = {
	.name		= "l3_main_1",
	.class		= &omap44xx_l3_hwmod_class,
	.slaves		= omap44xx_l3_main_1_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap44xx_l3_main_1_slaves),
	.omap_chip	= OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
};

/* l3_main_2 interface data */
/* dma_system -> l3_main_2 */
static struct omap_hwmod_ocp_if omap44xx_dma_system__l3_main_2 = {
	.master		= &omap44xx_dma_system_hwmod,
	.slave		= &omap44xx_l3_main_2_hwmod,
	.clk		= "l3_div_ck",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* iva -> l3_main_2 */
static struct omap_hwmod_ocp_if omap44xx_iva__l3_main_2 = {
	.master		= &omap44xx_iva_hwmod,
	.slave		= &omap44xx_l3_main_2_hwmod,
	.clk		= "l3_div_ck",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l3_main_1 -> l3_main_2 */
static struct omap_hwmod_ocp_if omap44xx_l3_main_1__l3_main_2 = {
	.master		= &omap44xx_l3_main_1_hwmod,
	.slave		= &omap44xx_l3_main_2_hwmod,
	.clk		= "l3_div_ck",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_cfg -> l3_main_2 */
static struct omap_hwmod_ocp_if omap44xx_l4_cfg__l3_main_2 = {
	.master		= &omap44xx_l4_cfg_hwmod,
	.slave		= &omap44xx_l3_main_2_hwmod,
	.clk		= "l4_div_ck",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l3_main_2 slave ports */
static struct omap_hwmod_ocp_if *omap44xx_l3_main_2_slaves[] = {
	&omap44xx_dma_system__l3_main_2,
	&omap44xx_iva__l3_main_2,
	&omap44xx_l3_main_1__l3_main_2,
	&omap44xx_l4_cfg__l3_main_2,
};

static struct omap_hwmod omap44xx_l3_main_2_hwmod = {
	.name		= "l3_main_2",
	.class		= &omap44xx_l3_hwmod_class,
	.slaves		= omap44xx_l3_main_2_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap44xx_l3_main_2_slaves),
	.omap_chip	= OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
};

/* l3_main_3 interface data */
/* l3_main_1 -> l3_main_3 */
static struct omap_hwmod_ocp_if omap44xx_l3_main_1__l3_main_3 = {
	.master		= &omap44xx_l3_main_1_hwmod,
	.slave		= &omap44xx_l3_main_3_hwmod,
	.clk		= "l3_div_ck",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l3_main_2 -> l3_main_3 */
static struct omap_hwmod_ocp_if omap44xx_l3_main_2__l3_main_3 = {
	.master		= &omap44xx_l3_main_2_hwmod,
	.slave		= &omap44xx_l3_main_3_hwmod,
	.clk		= "l3_div_ck",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_cfg -> l3_main_3 */
static struct omap_hwmod_ocp_if omap44xx_l4_cfg__l3_main_3 = {
	.master		= &omap44xx_l4_cfg_hwmod,
	.slave		= &omap44xx_l3_main_3_hwmod,
	.clk		= "l4_div_ck",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l3_main_3 slave ports */
static struct omap_hwmod_ocp_if *omap44xx_l3_main_3_slaves[] = {
	&omap44xx_l3_main_1__l3_main_3,
	&omap44xx_l3_main_2__l3_main_3,
	&omap44xx_l4_cfg__l3_main_3,
};

static struct omap_hwmod omap44xx_l3_main_3_hwmod = {
	.name		= "l3_main_3",
	.class		= &omap44xx_l3_hwmod_class,
	.slaves		= omap44xx_l3_main_3_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap44xx_l3_main_3_slaves),
	.omap_chip	= OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
};

/*
 * 'l4' class
 * instance(s): l4_abe, l4_cfg, l4_per, l4_wkup
 */
static struct omap_hwmod_class omap44xx_l4_hwmod_class = {
	.name	= "l4",
};

/* l4_abe interface data */
/* dsp -> l4_abe */
static struct omap_hwmod_ocp_if omap44xx_dsp__l4_abe = {
	.master		= &omap44xx_dsp_hwmod,
	.slave		= &omap44xx_l4_abe_hwmod,
	.clk		= "ocp_abe_iclk",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l3_main_1 -> l4_abe */
static struct omap_hwmod_ocp_if omap44xx_l3_main_1__l4_abe = {
	.master		= &omap44xx_l3_main_1_hwmod,
	.slave		= &omap44xx_l4_abe_hwmod,
	.clk		= "l3_div_ck",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* mpu -> l4_abe */
static struct omap_hwmod_ocp_if omap44xx_mpu__l4_abe = {
	.master		= &omap44xx_mpu_hwmod,
	.slave		= &omap44xx_l4_abe_hwmod,
	.clk		= "ocp_abe_iclk",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_abe slave ports */
static struct omap_hwmod_ocp_if *omap44xx_l4_abe_slaves[] = {
	&omap44xx_dsp__l4_abe,
	&omap44xx_l3_main_1__l4_abe,
	&omap44xx_mpu__l4_abe,
};

static struct omap_hwmod omap44xx_l4_abe_hwmod = {
	.name		= "l4_abe",
	.class		= &omap44xx_l4_hwmod_class,
	.slaves		= omap44xx_l4_abe_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap44xx_l4_abe_slaves),
	.omap_chip	= OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
};

/* l4_cfg interface data */
/* l3_main_1 -> l4_cfg */
static struct omap_hwmod_ocp_if omap44xx_l3_main_1__l4_cfg = {
	.master		= &omap44xx_l3_main_1_hwmod,
	.slave		= &omap44xx_l4_cfg_hwmod,
	.clk		= "l3_div_ck",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_cfg slave ports */
static struct omap_hwmod_ocp_if *omap44xx_l4_cfg_slaves[] = {
	&omap44xx_l3_main_1__l4_cfg,
};

static struct omap_hwmod omap44xx_l4_cfg_hwmod = {
	.name		= "l4_cfg",
	.class		= &omap44xx_l4_hwmod_class,
	.slaves		= omap44xx_l4_cfg_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap44xx_l4_cfg_slaves),
	.omap_chip	= OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
};

/* l4_per interface data */
/* l3_main_2 -> l4_per */
static struct omap_hwmod_ocp_if omap44xx_l3_main_2__l4_per = {
	.master		= &omap44xx_l3_main_2_hwmod,
	.slave		= &omap44xx_l4_per_hwmod,
	.clk		= "l3_div_ck",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_per slave ports */
static struct omap_hwmod_ocp_if *omap44xx_l4_per_slaves[] = {
	&omap44xx_l3_main_2__l4_per,
};

static struct omap_hwmod omap44xx_l4_per_hwmod = {
	.name		= "l4_per",
	.class		= &omap44xx_l4_hwmod_class,
	.slaves		= omap44xx_l4_per_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap44xx_l4_per_slaves),
	.omap_chip	= OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
};

/* l4_wkup interface data */
/* l4_cfg -> l4_wkup */
static struct omap_hwmod_ocp_if omap44xx_l4_cfg__l4_wkup = {
	.master		= &omap44xx_l4_cfg_hwmod,
	.slave		= &omap44xx_l4_wkup_hwmod,
	.clk		= "l4_div_ck",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_wkup slave ports */
static struct omap_hwmod_ocp_if *omap44xx_l4_wkup_slaves[] = {
	&omap44xx_l4_cfg__l4_wkup,
};

static struct omap_hwmod omap44xx_l4_wkup_hwmod = {
	.name		= "l4_wkup",
	.class		= &omap44xx_l4_hwmod_class,
	.slaves		= omap44xx_l4_wkup_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap44xx_l4_wkup_slaves),
	.omap_chip	= OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
};

/*
 * 'mpu_bus' class
 * instance(s): mpu_private
 */
static struct omap_hwmod_class omap44xx_mpu_bus_hwmod_class = {
	.name	= "mpu_bus",
};

/* mpu_private interface data */
/* mpu -> mpu_private */
static struct omap_hwmod_ocp_if omap44xx_mpu__mpu_private = {
	.master		= &omap44xx_mpu_hwmod,
	.slave		= &omap44xx_mpu_private_hwmod,
	.clk		= "l3_div_ck",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* mpu_private slave ports */
static struct omap_hwmod_ocp_if *omap44xx_mpu_private_slaves[] = {
	&omap44xx_mpu__mpu_private,
};

static struct omap_hwmod omap44xx_mpu_private_hwmod = {
	.name		= "mpu_private",
	.class		= &omap44xx_mpu_bus_hwmod_class,
	.slaves		= omap44xx_mpu_private_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap44xx_mpu_private_slaves),
	.omap_chip	= OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
};

/*
 * Modules omap_hwmod structures
 *
 * The following IPs are excluded for the moment because:
 * - They do not need an explicit SW control using omap_hwmod API.
 * - They still need to be validated with the driver
 *   properly adapted to omap_hwmod / omap_device
 *
 *  aess
 *  bandgap
 *  c2c
 *  c2c_target_fw
 *  cm_core
 *  cm_core_aon
 *  counter_32k
 *  ctrl_module_core
 *  ctrl_module_pad_core
 *  ctrl_module_pad_wkup
 *  ctrl_module_wkup
 *  debugss
 *  dmic
 *  dss
 *  dss_dispc
 *  dss_dsi1
 *  dss_dsi2
 *  dss_hdmi
 *  dss_rfbi
 *  dss_venc
 *  efuse_ctrl_cust
 *  efuse_ctrl_std
 *  elm
 *  emif1
 *  emif2
 *  fdif
 *  gpmc
 *  gpu
 *  hdq1w
 *  hsi
 *  ipu
 *  iss
 *  kbd
 *  mailbox
 *  mcasp
 *  mcbsp1
 *  mcbsp2
 *  mcbsp3
 *  mcbsp4
 *  mcpdm
 *  mcspi1
 *  mcspi2
 *  mcspi3
 *  mcspi4
 *  mmc1
 *  mmc2
 *  mmc3
 *  mmc4
 *  mmc5
 *  mpu_c0
 *  mpu_c1
 *  ocmc_ram
 *  ocp2scp_usb_phy
 *  ocp_wp_noc
 *  prcm
 *  prcm_mpu
 *  prm
 *  scrm
 *  sl2if
 *  slimbus1
 *  slimbus2
 *  spinlock
 *  timer1
 *  timer10
 *  timer11
 *  timer2
 *  timer3
 *  timer4
 *  timer5
 *  timer6
 *  timer7
 *  timer8
 *  timer9
 *  usb_host_fs
 *  usb_host_hs
 *  usb_otg_hs
 *  usb_phy_cm
 *  usb_tll_hs
 *  usim
 */

/*
 * 'dma' class
 * dma controller for data exchange between memory to memory (i.e. internal or
 * external memory) and gp peripherals to memory or memory to gp peripherals
 */

static struct omap_hwmod_class_sysconfig omap44xx_dma_sysc = {
	.rev_offs	= 0x0000,
	.sysc_offs	= 0x002c,
	.syss_offs	= 0x0028,
	.sysc_flags	= (SYSC_HAS_AUTOIDLE | SYSC_HAS_CLOCKACTIVITY |
			   SYSC_HAS_EMUFREE | SYSC_HAS_MIDLEMODE |
			   SYSC_HAS_SIDLEMODE | SYSC_HAS_SOFTRESET |
			   SYSS_HAS_RESET_STATUS),
	.idlemodes	= (SIDLE_FORCE | SIDLE_NO | SIDLE_SMART |
			   MSTANDBY_FORCE | MSTANDBY_NO | MSTANDBY_SMART),
	.sysc_fields	= &omap_hwmod_sysc_type1,
};

static struct omap_hwmod_class omap44xx_dma_hwmod_class = {
	.name	= "dma",
	.sysc	= &omap44xx_dma_sysc,
};

/* dma dev_attr */
static struct omap_dma_dev_attr dma_dev_attr = {
	.dev_caps	= RESERVE_CHANNEL | DMA_LINKED_LCH | GLOBAL_PRIORITY |
			  IS_CSSA_32 | IS_CDSA_32 | IS_RW_PRIORITY,
	.lch_count	= 32,
};

/* dma_system */
static struct omap_hwmod_irq_info omap44xx_dma_system_irqs[] = {
	{ .name = "0", .irq = 12 + OMAP44XX_IRQ_GIC_START },
	{ .name = "1", .irq = 13 + OMAP44XX_IRQ_GIC_START },
	{ .name = "2", .irq = 14 + OMAP44XX_IRQ_GIC_START },
	{ .name = "3", .irq = 15 + OMAP44XX_IRQ_GIC_START },
};

/* dma_system master ports */
static struct omap_hwmod_ocp_if *omap44xx_dma_system_masters[] = {
	&omap44xx_dma_system__l3_main_2,
};

static struct omap_hwmod_addr_space omap44xx_dma_system_addrs[] = {
	{
		.pa_start	= 0x4a056000,
		.pa_end		= 0x4a0560ff,
		.flags		= ADDR_TYPE_RT
	},
};

/* l4_cfg -> dma_system */
static struct omap_hwmod_ocp_if omap44xx_l4_cfg__dma_system = {
	.master		= &omap44xx_l4_cfg_hwmod,
	.slave		= &omap44xx_dma_system_hwmod,
	.clk		= "l4_div_ck",
	.addr		= omap44xx_dma_system_addrs,
	.addr_cnt	= ARRAY_SIZE(omap44xx_dma_system_addrs),
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* dma_system slave ports */
static struct omap_hwmod_ocp_if *omap44xx_dma_system_slaves[] = {
	&omap44xx_l4_cfg__dma_system,
};

static struct omap_hwmod omap44xx_dma_system_hwmod = {
	.name		= "dma_system",
	.class		= &omap44xx_dma_hwmod_class,
	.mpu_irqs	= omap44xx_dma_system_irqs,
	.mpu_irqs_cnt	= ARRAY_SIZE(omap44xx_dma_system_irqs),
	.main_clk	= "l3_div_ck",
	.prcm = {
		.omap4 = {
			.clkctrl_reg = OMAP4430_CM_SDMA_SDMA_CLKCTRL,
		},
	},
	.dev_attr	= &dma_dev_attr,
	.slaves		= omap44xx_dma_system_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap44xx_dma_system_slaves),
	.masters	= omap44xx_dma_system_masters,
	.masters_cnt	= ARRAY_SIZE(omap44xx_dma_system_masters),
	.omap_chip	= OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
};

/*
 * 'dsp' class
 * dsp sub-system
 */

static struct omap_hwmod_class omap44xx_dsp_hwmod_class = {
	.name	= "dsp",
};

/* dsp */
static struct omap_hwmod_irq_info omap44xx_dsp_irqs[] = {
	{ .irq = 28 + OMAP44XX_IRQ_GIC_START },
};

static struct omap_hwmod_rst_info omap44xx_dsp_resets[] = {
	{ .name = "mmu_cache", .rst_shift = 1 },
};

static struct omap_hwmod_rst_info omap44xx_dsp_c0_resets[] = {
	{ .name = "dsp", .rst_shift = 0 },
};

/* dsp -> iva */
static struct omap_hwmod_ocp_if omap44xx_dsp__iva = {
	.master		= &omap44xx_dsp_hwmod,
	.slave		= &omap44xx_iva_hwmod,
	.clk		= "dpll_iva_m5x2_ck",
};

/* dsp master ports */
static struct omap_hwmod_ocp_if *omap44xx_dsp_masters[] = {
	&omap44xx_dsp__l3_main_1,
	&omap44xx_dsp__l4_abe,
	&omap44xx_dsp__iva,
};

/* l4_cfg -> dsp */
static struct omap_hwmod_ocp_if omap44xx_l4_cfg__dsp = {
	.master		= &omap44xx_l4_cfg_hwmod,
	.slave		= &omap44xx_dsp_hwmod,
	.clk		= "l4_div_ck",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* dsp slave ports */
static struct omap_hwmod_ocp_if *omap44xx_dsp_slaves[] = {
	&omap44xx_l4_cfg__dsp,
};

/* Pseudo hwmod for reset control purpose only */
static struct omap_hwmod omap44xx_dsp_c0_hwmod = {
	.name		= "dsp_c0",
	.class		= &omap44xx_dsp_hwmod_class,
	.flags		= HWMOD_INIT_NO_RESET,
	.rst_lines	= omap44xx_dsp_c0_resets,
	.rst_lines_cnt	= ARRAY_SIZE(omap44xx_dsp_c0_resets),
	.prcm = {
		.omap4 = {
			.rstctrl_reg = OMAP4430_RM_TESLA_RSTCTRL,
		},
	},
	.omap_chip	= OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
};

static struct omap_hwmod omap44xx_dsp_hwmod = {
	.name		= "dsp",
	.class		= &omap44xx_dsp_hwmod_class,
	.mpu_irqs	= omap44xx_dsp_irqs,
	.mpu_irqs_cnt	= ARRAY_SIZE(omap44xx_dsp_irqs),
	.rst_lines	= omap44xx_dsp_resets,
	.rst_lines_cnt	= ARRAY_SIZE(omap44xx_dsp_resets),
	.main_clk	= "dsp_fck",
	.prcm = {
		.omap4 = {
			.clkctrl_reg = OMAP4430_CM_TESLA_TESLA_CLKCTRL,
			.rstctrl_reg = OMAP4430_RM_TESLA_RSTCTRL,
		},
	},
	.slaves		= omap44xx_dsp_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap44xx_dsp_slaves),
	.masters	= omap44xx_dsp_masters,
	.masters_cnt	= ARRAY_SIZE(omap44xx_dsp_masters),
	.omap_chip	= OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
};

/*
 * 'gpio' class
 * general purpose io module
 */

static struct omap_hwmod_class_sysconfig omap44xx_gpio_sysc = {
	.rev_offs	= 0x0000,
	.sysc_offs	= 0x0010,
	.syss_offs	= 0x0114,
	.sysc_flags	= (SYSC_HAS_AUTOIDLE | SYSC_HAS_ENAWAKEUP |
			   SYSC_HAS_SIDLEMODE | SYSC_HAS_SOFTRESET |
			   SYSS_HAS_RESET_STATUS),
	.idlemodes	= (SIDLE_FORCE | SIDLE_NO | SIDLE_SMART |
			   SIDLE_SMART_WKUP),
	.sysc_fields	= &omap_hwmod_sysc_type1,
};

static struct omap_hwmod_class omap44xx_gpio_hwmod_class = {
	.name	= "gpio",
	.sysc	= &omap44xx_gpio_sysc,
	.rev	= 2,
};

/* gpio dev_attr */
static struct omap_gpio_dev_attr gpio_dev_attr = {
	.bank_width	= 32,
	.dbck_flag	= true,
};

/* gpio1 */
static struct omap_hwmod omap44xx_gpio1_hwmod;
static struct omap_hwmod_irq_info omap44xx_gpio1_irqs[] = {
	{ .irq = 29 + OMAP44XX_IRQ_GIC_START },
};

static struct omap_hwmod_addr_space omap44xx_gpio1_addrs[] = {
	{
		.pa_start	= 0x4a310000,
		.pa_end		= 0x4a3101ff,
		.flags		= ADDR_TYPE_RT
	},
};

/* l4_wkup -> gpio1 */
static struct omap_hwmod_ocp_if omap44xx_l4_wkup__gpio1 = {
	.master		= &omap44xx_l4_wkup_hwmod,
	.slave		= &omap44xx_gpio1_hwmod,
	.clk		= "l4_wkup_clk_mux_ck",
	.addr		= omap44xx_gpio1_addrs,
	.addr_cnt	= ARRAY_SIZE(omap44xx_gpio1_addrs),
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* gpio1 slave ports */
static struct omap_hwmod_ocp_if *omap44xx_gpio1_slaves[] = {
	&omap44xx_l4_wkup__gpio1,
};

static struct omap_hwmod_opt_clk gpio1_opt_clks[] = {
	{ .role = "dbclk", .clk = "gpio1_dbclk" },
};

static struct omap_hwmod omap44xx_gpio1_hwmod = {
	.name		= "gpio1",
	.class		= &omap44xx_gpio_hwmod_class,
	.mpu_irqs	= omap44xx_gpio1_irqs,
	.mpu_irqs_cnt	= ARRAY_SIZE(omap44xx_gpio1_irqs),
	.main_clk	= "gpio1_ick",
	.prcm = {
		.omap4 = {
			.clkctrl_reg = OMAP4430_CM_WKUP_GPIO1_CLKCTRL,
		},
	},
	.opt_clks	= gpio1_opt_clks,
	.opt_clks_cnt	= ARRAY_SIZE(gpio1_opt_clks),
	.dev_attr	= &gpio_dev_attr,
	.slaves		= omap44xx_gpio1_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap44xx_gpio1_slaves),
	.omap_chip	= OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
};

/* gpio2 */
static struct omap_hwmod omap44xx_gpio2_hwmod;
static struct omap_hwmod_irq_info omap44xx_gpio2_irqs[] = {
	{ .irq = 30 + OMAP44XX_IRQ_GIC_START },
};

static struct omap_hwmod_addr_space omap44xx_gpio2_addrs[] = {
	{
		.pa_start	= 0x48055000,
		.pa_end		= 0x480551ff,
		.flags		= ADDR_TYPE_RT
	},
};

/* l4_per -> gpio2 */
static struct omap_hwmod_ocp_if omap44xx_l4_per__gpio2 = {
	.master		= &omap44xx_l4_per_hwmod,
	.slave		= &omap44xx_gpio2_hwmod,
	.clk		= "l4_div_ck",
	.addr		= omap44xx_gpio2_addrs,
	.addr_cnt	= ARRAY_SIZE(omap44xx_gpio2_addrs),
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* gpio2 slave ports */
static struct omap_hwmod_ocp_if *omap44xx_gpio2_slaves[] = {
	&omap44xx_l4_per__gpio2,
};

static struct omap_hwmod_opt_clk gpio2_opt_clks[] = {
	{ .role = "dbclk", .clk = "gpio2_dbclk" },
};

static struct omap_hwmod omap44xx_gpio2_hwmod = {
	.name		= "gpio2",
	.class		= &omap44xx_gpio_hwmod_class,
	.flags		= HWMOD_CONTROL_OPT_CLKS_IN_RESET,
	.mpu_irqs	= omap44xx_gpio2_irqs,
	.mpu_irqs_cnt	= ARRAY_SIZE(omap44xx_gpio2_irqs),
	.main_clk	= "gpio2_ick",
	.prcm = {
		.omap4 = {
			.clkctrl_reg = OMAP4430_CM_L4PER_GPIO2_CLKCTRL,
		},
	},
	.opt_clks	= gpio2_opt_clks,
	.opt_clks_cnt	= ARRAY_SIZE(gpio2_opt_clks),
	.dev_attr	= &gpio_dev_attr,
	.slaves		= omap44xx_gpio2_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap44xx_gpio2_slaves),
	.omap_chip	= OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
};

/* gpio3 */
static struct omap_hwmod omap44xx_gpio3_hwmod;
static struct omap_hwmod_irq_info omap44xx_gpio3_irqs[] = {
	{ .irq = 31 + OMAP44XX_IRQ_GIC_START },
};

static struct omap_hwmod_addr_space omap44xx_gpio3_addrs[] = {
	{
		.pa_start	= 0x48057000,
		.pa_end		= 0x480571ff,
		.flags		= ADDR_TYPE_RT
	},
};

/* l4_per -> gpio3 */
static struct omap_hwmod_ocp_if omap44xx_l4_per__gpio3 = {
	.master		= &omap44xx_l4_per_hwmod,
	.slave		= &omap44xx_gpio3_hwmod,
	.clk		= "l4_div_ck",
	.addr		= omap44xx_gpio3_addrs,
	.addr_cnt	= ARRAY_SIZE(omap44xx_gpio3_addrs),
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* gpio3 slave ports */
static struct omap_hwmod_ocp_if *omap44xx_gpio3_slaves[] = {
	&omap44xx_l4_per__gpio3,
};

static struct omap_hwmod_opt_clk gpio3_opt_clks[] = {
	{ .role = "dbclk", .clk = "gpio3_dbclk" },
};

static struct omap_hwmod omap44xx_gpio3_hwmod = {
	.name		= "gpio3",
	.class		= &omap44xx_gpio_hwmod_class,
	.flags		= HWMOD_CONTROL_OPT_CLKS_IN_RESET,
	.mpu_irqs	= omap44xx_gpio3_irqs,
	.mpu_irqs_cnt	= ARRAY_SIZE(omap44xx_gpio3_irqs),
	.main_clk	= "gpio3_ick",
	.prcm = {
		.omap4 = {
			.clkctrl_reg = OMAP4430_CM_L4PER_GPIO3_CLKCTRL,
		},
	},
	.opt_clks	= gpio3_opt_clks,
	.opt_clks_cnt	= ARRAY_SIZE(gpio3_opt_clks),
	.dev_attr	= &gpio_dev_attr,
	.slaves		= omap44xx_gpio3_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap44xx_gpio3_slaves),
	.omap_chip	= OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
};

/* gpio4 */
static struct omap_hwmod omap44xx_gpio4_hwmod;
static struct omap_hwmod_irq_info omap44xx_gpio4_irqs[] = {
	{ .irq = 32 + OMAP44XX_IRQ_GIC_START },
};

static struct omap_hwmod_addr_space omap44xx_gpio4_addrs[] = {
	{
		.pa_start	= 0x48059000,
		.pa_end		= 0x480591ff,
		.flags		= ADDR_TYPE_RT
	},
};

/* l4_per -> gpio4 */
static struct omap_hwmod_ocp_if omap44xx_l4_per__gpio4 = {
	.master		= &omap44xx_l4_per_hwmod,
	.slave		= &omap44xx_gpio4_hwmod,
	.clk		= "l4_div_ck",
	.addr		= omap44xx_gpio4_addrs,
	.addr_cnt	= ARRAY_SIZE(omap44xx_gpio4_addrs),
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* gpio4 slave ports */
static struct omap_hwmod_ocp_if *omap44xx_gpio4_slaves[] = {
	&omap44xx_l4_per__gpio4,
};

static struct omap_hwmod_opt_clk gpio4_opt_clks[] = {
	{ .role = "dbclk", .clk = "gpio4_dbclk" },
};

static struct omap_hwmod omap44xx_gpio4_hwmod = {
	.name		= "gpio4",
	.class		= &omap44xx_gpio_hwmod_class,
	.flags		= HWMOD_CONTROL_OPT_CLKS_IN_RESET,
	.mpu_irqs	= omap44xx_gpio4_irqs,
	.mpu_irqs_cnt	= ARRAY_SIZE(omap44xx_gpio4_irqs),
	.main_clk	= "gpio4_ick",
	.prcm = {
		.omap4 = {
			.clkctrl_reg = OMAP4430_CM_L4PER_GPIO4_CLKCTRL,
		},
	},
	.opt_clks	= gpio4_opt_clks,
	.opt_clks_cnt	= ARRAY_SIZE(gpio4_opt_clks),
	.dev_attr	= &gpio_dev_attr,
	.slaves		= omap44xx_gpio4_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap44xx_gpio4_slaves),
	.omap_chip	= OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
};

/* gpio5 */
static struct omap_hwmod omap44xx_gpio5_hwmod;
static struct omap_hwmod_irq_info omap44xx_gpio5_irqs[] = {
	{ .irq = 33 + OMAP44XX_IRQ_GIC_START },
};

static struct omap_hwmod_addr_space omap44xx_gpio5_addrs[] = {
	{
		.pa_start	= 0x4805b000,
		.pa_end		= 0x4805b1ff,
		.flags		= ADDR_TYPE_RT
	},
};

/* l4_per -> gpio5 */
static struct omap_hwmod_ocp_if omap44xx_l4_per__gpio5 = {
	.master		= &omap44xx_l4_per_hwmod,
	.slave		= &omap44xx_gpio5_hwmod,
	.clk		= "l4_div_ck",
	.addr		= omap44xx_gpio5_addrs,
	.addr_cnt	= ARRAY_SIZE(omap44xx_gpio5_addrs),
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* gpio5 slave ports */
static struct omap_hwmod_ocp_if *omap44xx_gpio5_slaves[] = {
	&omap44xx_l4_per__gpio5,
};

static struct omap_hwmod_opt_clk gpio5_opt_clks[] = {
	{ .role = "dbclk", .clk = "gpio5_dbclk" },
};

static struct omap_hwmod omap44xx_gpio5_hwmod = {
	.name		= "gpio5",
	.class		= &omap44xx_gpio_hwmod_class,
	.flags		= HWMOD_CONTROL_OPT_CLKS_IN_RESET,
	.mpu_irqs	= omap44xx_gpio5_irqs,
	.mpu_irqs_cnt	= ARRAY_SIZE(omap44xx_gpio5_irqs),
	.main_clk	= "gpio5_ick",
	.prcm = {
		.omap4 = {
			.clkctrl_reg = OMAP4430_CM_L4PER_GPIO5_CLKCTRL,
		},
	},
	.opt_clks	= gpio5_opt_clks,
	.opt_clks_cnt	= ARRAY_SIZE(gpio5_opt_clks),
	.dev_attr	= &gpio_dev_attr,
	.slaves		= omap44xx_gpio5_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap44xx_gpio5_slaves),
	.omap_chip	= OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
};

/* gpio6 */
static struct omap_hwmod omap44xx_gpio6_hwmod;
static struct omap_hwmod_irq_info omap44xx_gpio6_irqs[] = {
	{ .irq = 34 + OMAP44XX_IRQ_GIC_START },
};

static struct omap_hwmod_addr_space omap44xx_gpio6_addrs[] = {
	{
		.pa_start	= 0x4805d000,
		.pa_end		= 0x4805d1ff,
		.flags		= ADDR_TYPE_RT
	},
};

/* l4_per -> gpio6 */
static struct omap_hwmod_ocp_if omap44xx_l4_per__gpio6 = {
	.master		= &omap44xx_l4_per_hwmod,
	.slave		= &omap44xx_gpio6_hwmod,
	.clk		= "l4_div_ck",
	.addr		= omap44xx_gpio6_addrs,
	.addr_cnt	= ARRAY_SIZE(omap44xx_gpio6_addrs),
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* gpio6 slave ports */
static struct omap_hwmod_ocp_if *omap44xx_gpio6_slaves[] = {
	&omap44xx_l4_per__gpio6,
};

static struct omap_hwmod_opt_clk gpio6_opt_clks[] = {
	{ .role = "dbclk", .clk = "gpio6_dbclk" },
};

static struct omap_hwmod omap44xx_gpio6_hwmod = {
	.name		= "gpio6",
	.class		= &omap44xx_gpio_hwmod_class,
	.flags		= HWMOD_CONTROL_OPT_CLKS_IN_RESET,
	.mpu_irqs	= omap44xx_gpio6_irqs,
	.mpu_irqs_cnt	= ARRAY_SIZE(omap44xx_gpio6_irqs),
	.main_clk	= "gpio6_ick",
	.prcm = {
		.omap4 = {
			.clkctrl_reg = OMAP4430_CM_L4PER_GPIO6_CLKCTRL,
		},
	},
	.opt_clks	= gpio6_opt_clks,
	.opt_clks_cnt	= ARRAY_SIZE(gpio6_opt_clks),
	.dev_attr	= &gpio_dev_attr,
	.slaves		= omap44xx_gpio6_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap44xx_gpio6_slaves),
	.omap_chip	= OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
};

/*
 * 'i2c' class
 * multimaster high-speed i2c controller
 */

static struct omap_hwmod_class_sysconfig omap44xx_i2c_sysc = {
	.sysc_offs	= 0x0010,
	.syss_offs	= 0x0090,
	.sysc_flags	= (SYSC_HAS_AUTOIDLE | SYSC_HAS_CLOCKACTIVITY |
			   SYSC_HAS_ENAWAKEUP | SYSC_HAS_SIDLEMODE |
			   SYSC_HAS_SOFTRESET | SYSS_HAS_RESET_STATUS),
	.idlemodes	= (SIDLE_FORCE | SIDLE_NO | SIDLE_SMART |
			   SIDLE_SMART_WKUP),
	.sysc_fields	= &omap_hwmod_sysc_type1,
};

static struct omap_hwmod_class omap44xx_i2c_hwmod_class = {
	.name	= "i2c",
	.sysc	= &omap44xx_i2c_sysc,
};

/* i2c1 */
static struct omap_hwmod omap44xx_i2c1_hwmod;
static struct omap_hwmod_irq_info omap44xx_i2c1_irqs[] = {
	{ .irq = 56 + OMAP44XX_IRQ_GIC_START },
};

static struct omap_hwmod_dma_info omap44xx_i2c1_sdma_reqs[] = {
	{ .name = "tx", .dma_req = 26 + OMAP44XX_DMA_REQ_START },
	{ .name = "rx", .dma_req = 27 + OMAP44XX_DMA_REQ_START },
};

static struct omap_hwmod_addr_space omap44xx_i2c1_addrs[] = {
	{
		.pa_start	= 0x48070000,
		.pa_end		= 0x480700ff,
		.flags		= ADDR_TYPE_RT
	},
};

/* l4_per -> i2c1 */
static struct omap_hwmod_ocp_if omap44xx_l4_per__i2c1 = {
	.master		= &omap44xx_l4_per_hwmod,
	.slave		= &omap44xx_i2c1_hwmod,
	.clk		= "l4_div_ck",
	.addr		= omap44xx_i2c1_addrs,
	.addr_cnt	= ARRAY_SIZE(omap44xx_i2c1_addrs),
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* i2c1 slave ports */
static struct omap_hwmod_ocp_if *omap44xx_i2c1_slaves[] = {
	&omap44xx_l4_per__i2c1,
};

static struct omap_hwmod omap44xx_i2c1_hwmod = {
	.name		= "i2c1",
	.class		= &omap44xx_i2c_hwmod_class,
	.flags		= HWMOD_INIT_NO_RESET,
	.mpu_irqs	= omap44xx_i2c1_irqs,
	.mpu_irqs_cnt	= ARRAY_SIZE(omap44xx_i2c1_irqs),
	.sdma_reqs	= omap44xx_i2c1_sdma_reqs,
	.sdma_reqs_cnt	= ARRAY_SIZE(omap44xx_i2c1_sdma_reqs),
	.main_clk	= "i2c1_fck",
	.prcm = {
		.omap4 = {
			.clkctrl_reg = OMAP4430_CM_L4PER_I2C1_CLKCTRL,
		},
	},
	.slaves		= omap44xx_i2c1_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap44xx_i2c1_slaves),
	.omap_chip	= OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
};

/* i2c2 */
static struct omap_hwmod omap44xx_i2c2_hwmod;
static struct omap_hwmod_irq_info omap44xx_i2c2_irqs[] = {
	{ .irq = 57 + OMAP44XX_IRQ_GIC_START },
};

static struct omap_hwmod_dma_info omap44xx_i2c2_sdma_reqs[] = {
	{ .name = "tx", .dma_req = 28 + OMAP44XX_DMA_REQ_START },
	{ .name = "rx", .dma_req = 29 + OMAP44XX_DMA_REQ_START },
};

static struct omap_hwmod_addr_space omap44xx_i2c2_addrs[] = {
	{
		.pa_start	= 0x48072000,
		.pa_end		= 0x480720ff,
		.flags		= ADDR_TYPE_RT
	},
};

/* l4_per -> i2c2 */
static struct omap_hwmod_ocp_if omap44xx_l4_per__i2c2 = {
	.master		= &omap44xx_l4_per_hwmod,
	.slave		= &omap44xx_i2c2_hwmod,
	.clk		= "l4_div_ck",
	.addr		= omap44xx_i2c2_addrs,
	.addr_cnt	= ARRAY_SIZE(omap44xx_i2c2_addrs),
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* i2c2 slave ports */
static struct omap_hwmod_ocp_if *omap44xx_i2c2_slaves[] = {
	&omap44xx_l4_per__i2c2,
};

static struct omap_hwmod omap44xx_i2c2_hwmod = {
	.name		= "i2c2",
	.class		= &omap44xx_i2c_hwmod_class,
	.flags		= HWMOD_INIT_NO_RESET,
	.mpu_irqs	= omap44xx_i2c2_irqs,
	.mpu_irqs_cnt	= ARRAY_SIZE(omap44xx_i2c2_irqs),
	.sdma_reqs	= omap44xx_i2c2_sdma_reqs,
	.sdma_reqs_cnt	= ARRAY_SIZE(omap44xx_i2c2_sdma_reqs),
	.main_clk	= "i2c2_fck",
	.prcm = {
		.omap4 = {
			.clkctrl_reg = OMAP4430_CM_L4PER_I2C2_CLKCTRL,
		},
	},
	.slaves		= omap44xx_i2c2_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap44xx_i2c2_slaves),
	.omap_chip	= OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
};

/* i2c3 */
static struct omap_hwmod omap44xx_i2c3_hwmod;
static struct omap_hwmod_irq_info omap44xx_i2c3_irqs[] = {
	{ .irq = 61 + OMAP44XX_IRQ_GIC_START },
};

static struct omap_hwmod_dma_info omap44xx_i2c3_sdma_reqs[] = {
	{ .name = "tx", .dma_req = 24 + OMAP44XX_DMA_REQ_START },
	{ .name = "rx", .dma_req = 25 + OMAP44XX_DMA_REQ_START },
};

static struct omap_hwmod_addr_space omap44xx_i2c3_addrs[] = {
	{
		.pa_start	= 0x48060000,
		.pa_end		= 0x480600ff,
		.flags		= ADDR_TYPE_RT
	},
};

/* l4_per -> i2c3 */
static struct omap_hwmod_ocp_if omap44xx_l4_per__i2c3 = {
	.master		= &omap44xx_l4_per_hwmod,
	.slave		= &omap44xx_i2c3_hwmod,
	.clk		= "l4_div_ck",
	.addr		= omap44xx_i2c3_addrs,
	.addr_cnt	= ARRAY_SIZE(omap44xx_i2c3_addrs),
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* i2c3 slave ports */
static struct omap_hwmod_ocp_if *omap44xx_i2c3_slaves[] = {
	&omap44xx_l4_per__i2c3,
};

static struct omap_hwmod omap44xx_i2c3_hwmod = {
	.name		= "i2c3",
	.class		= &omap44xx_i2c_hwmod_class,
	.flags		= HWMOD_INIT_NO_RESET,
	.mpu_irqs	= omap44xx_i2c3_irqs,
	.mpu_irqs_cnt	= ARRAY_SIZE(omap44xx_i2c3_irqs),
	.sdma_reqs	= omap44xx_i2c3_sdma_reqs,
	.sdma_reqs_cnt	= ARRAY_SIZE(omap44xx_i2c3_sdma_reqs),
	.main_clk	= "i2c3_fck",
	.prcm = {
		.omap4 = {
			.clkctrl_reg = OMAP4430_CM_L4PER_I2C3_CLKCTRL,
		},
	},
	.slaves		= omap44xx_i2c3_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap44xx_i2c3_slaves),
	.omap_chip	= OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
};

/* i2c4 */
static struct omap_hwmod omap44xx_i2c4_hwmod;
static struct omap_hwmod_irq_info omap44xx_i2c4_irqs[] = {
	{ .irq = 62 + OMAP44XX_IRQ_GIC_START },
};

static struct omap_hwmod_dma_info omap44xx_i2c4_sdma_reqs[] = {
	{ .name = "tx", .dma_req = 123 + OMAP44XX_DMA_REQ_START },
	{ .name = "rx", .dma_req = 124 + OMAP44XX_DMA_REQ_START },
};

static struct omap_hwmod_addr_space omap44xx_i2c4_addrs[] = {
	{
		.pa_start	= 0x48350000,
		.pa_end		= 0x483500ff,
		.flags		= ADDR_TYPE_RT
	},
};

/* l4_per -> i2c4 */
static struct omap_hwmod_ocp_if omap44xx_l4_per__i2c4 = {
	.master		= &omap44xx_l4_per_hwmod,
	.slave		= &omap44xx_i2c4_hwmod,
	.clk		= "l4_div_ck",
	.addr		= omap44xx_i2c4_addrs,
	.addr_cnt	= ARRAY_SIZE(omap44xx_i2c4_addrs),
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* i2c4 slave ports */
static struct omap_hwmod_ocp_if *omap44xx_i2c4_slaves[] = {
	&omap44xx_l4_per__i2c4,
};

static struct omap_hwmod omap44xx_i2c4_hwmod = {
	.name		= "i2c4",
	.class		= &omap44xx_i2c_hwmod_class,
	.flags		= HWMOD_INIT_NO_RESET,
	.mpu_irqs	= omap44xx_i2c4_irqs,
	.mpu_irqs_cnt	= ARRAY_SIZE(omap44xx_i2c4_irqs),
	.sdma_reqs	= omap44xx_i2c4_sdma_reqs,
	.sdma_reqs_cnt	= ARRAY_SIZE(omap44xx_i2c4_sdma_reqs),
	.main_clk	= "i2c4_fck",
	.prcm = {
		.omap4 = {
			.clkctrl_reg = OMAP4430_CM_L4PER_I2C4_CLKCTRL,
		},
	},
	.slaves		= omap44xx_i2c4_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap44xx_i2c4_slaves),
	.omap_chip	= OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
};

/*
 * 'iva' class
 * multi-standard video encoder/decoder hardware accelerator
 */

static struct omap_hwmod_class omap44xx_iva_hwmod_class = {
	.name	= "iva",
};

/* iva */
static struct omap_hwmod_irq_info omap44xx_iva_irqs[] = {
	{ .name = "sync_1", .irq = 103 + OMAP44XX_IRQ_GIC_START },
	{ .name = "sync_0", .irq = 104 + OMAP44XX_IRQ_GIC_START },
	{ .name = "mailbox_0", .irq = 107 + OMAP44XX_IRQ_GIC_START },
};

static struct omap_hwmod_rst_info omap44xx_iva_resets[] = {
	{ .name = "logic", .rst_shift = 2 },
};

static struct omap_hwmod_rst_info omap44xx_iva_seq0_resets[] = {
	{ .name = "seq0", .rst_shift = 0 },
};

static struct omap_hwmod_rst_info omap44xx_iva_seq1_resets[] = {
	{ .name = "seq1", .rst_shift = 1 },
};

/* iva master ports */
static struct omap_hwmod_ocp_if *omap44xx_iva_masters[] = {
	&omap44xx_iva__l3_main_2,
	&omap44xx_iva__l3_instr,
};

static struct omap_hwmod_addr_space omap44xx_iva_addrs[] = {
	{
		.pa_start	= 0x5a000000,
		.pa_end		= 0x5a07ffff,
		.flags		= ADDR_TYPE_RT
	},
};

/* l3_main_2 -> iva */
static struct omap_hwmod_ocp_if omap44xx_l3_main_2__iva = {
	.master		= &omap44xx_l3_main_2_hwmod,
	.slave		= &omap44xx_iva_hwmod,
	.clk		= "l3_div_ck",
	.addr		= omap44xx_iva_addrs,
	.addr_cnt	= ARRAY_SIZE(omap44xx_iva_addrs),
	.user		= OCP_USER_MPU,
};

/* iva slave ports */
static struct omap_hwmod_ocp_if *omap44xx_iva_slaves[] = {
	&omap44xx_dsp__iva,
	&omap44xx_l3_main_2__iva,
};

/* Pseudo hwmod for reset control purpose only */
static struct omap_hwmod omap44xx_iva_seq0_hwmod = {
	.name		= "iva_seq0",
	.class		= &omap44xx_iva_hwmod_class,
	.flags		= HWMOD_INIT_NO_RESET,
	.rst_lines	= omap44xx_iva_seq0_resets,
	.rst_lines_cnt	= ARRAY_SIZE(omap44xx_iva_seq0_resets),
	.prcm = {
		.omap4 = {
			.rstctrl_reg = OMAP4430_RM_IVAHD_RSTCTRL,
		},
	},
	.omap_chip	= OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
};

/* Pseudo hwmod for reset control purpose only */
static struct omap_hwmod omap44xx_iva_seq1_hwmod = {
	.name		= "iva_seq1",
	.class		= &omap44xx_iva_hwmod_class,
	.flags		= HWMOD_INIT_NO_RESET,
	.rst_lines	= omap44xx_iva_seq1_resets,
	.rst_lines_cnt	= ARRAY_SIZE(omap44xx_iva_seq1_resets),
	.prcm = {
		.omap4 = {
			.rstctrl_reg = OMAP4430_RM_IVAHD_RSTCTRL,
		},
	},
	.omap_chip	= OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
};

static struct omap_hwmod omap44xx_iva_hwmod = {
	.name		= "iva",
	.class		= &omap44xx_iva_hwmod_class,
	.mpu_irqs	= omap44xx_iva_irqs,
	.mpu_irqs_cnt	= ARRAY_SIZE(omap44xx_iva_irqs),
	.rst_lines	= omap44xx_iva_resets,
	.rst_lines_cnt	= ARRAY_SIZE(omap44xx_iva_resets),
	.main_clk	= "iva_fck",
	.prcm = {
		.omap4 = {
			.clkctrl_reg = OMAP4430_CM_IVAHD_IVAHD_CLKCTRL,
			.rstctrl_reg = OMAP4430_RM_IVAHD_RSTCTRL,
		},
	},
	.slaves		= omap44xx_iva_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap44xx_iva_slaves),
	.masters	= omap44xx_iva_masters,
	.masters_cnt	= ARRAY_SIZE(omap44xx_iva_masters),
	.omap_chip	= OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
};

/*
 * 'mpu' class
 * mpu sub-system
 */

static struct omap_hwmod_class omap44xx_mpu_hwmod_class = {
	.name	= "mpu",
};

/* mpu */
static struct omap_hwmod_irq_info omap44xx_mpu_irqs[] = {
	{ .name = "pl310", .irq = 0 + OMAP44XX_IRQ_GIC_START },
	{ .name = "cti0", .irq = 1 + OMAP44XX_IRQ_GIC_START },
	{ .name = "cti1", .irq = 2 + OMAP44XX_IRQ_GIC_START },
};

/* mpu master ports */
static struct omap_hwmod_ocp_if *omap44xx_mpu_masters[] = {
	&omap44xx_mpu__l3_main_1,
	&omap44xx_mpu__l4_abe,
	&omap44xx_mpu__dmm,
};

static struct omap_hwmod omap44xx_mpu_hwmod = {
	.name		= "mpu",
	.class		= &omap44xx_mpu_hwmod_class,
	.flags		= (HWMOD_INIT_NO_IDLE | HWMOD_INIT_NO_RESET),
	.mpu_irqs	= omap44xx_mpu_irqs,
	.mpu_irqs_cnt	= ARRAY_SIZE(omap44xx_mpu_irqs),
	.main_clk	= "dpll_mpu_m2_ck",
	.prcm = {
		.omap4 = {
			.clkctrl_reg = OMAP4430_CM_MPU_MPU_CLKCTRL,
		},
	},
	.masters	= omap44xx_mpu_masters,
	.masters_cnt	= ARRAY_SIZE(omap44xx_mpu_masters),
	.omap_chip	= OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
};

/*
 * 'smartreflex' class
 * smartreflex module (monitor silicon performance and outputs a measure of
 * performance error)
 */

/* The IP is not compliant to type1 / type2 scheme */
static struct omap_hwmod_sysc_fields omap_hwmod_sysc_type_smartreflex = {
	.sidle_shift	= 24,
	.enwkup_shift	= 26,
};

static struct omap_hwmod_class_sysconfig omap44xx_smartreflex_sysc = {
	.sysc_offs	= 0x0038,
	.sysc_flags	= (SYSC_HAS_ENAWAKEUP | SYSC_HAS_SIDLEMODE),
	.idlemodes	= (SIDLE_FORCE | SIDLE_NO | SIDLE_SMART |
			   SIDLE_SMART_WKUP),
	.sysc_fields	= &omap_hwmod_sysc_type_smartreflex,
};

static struct omap_hwmod_class omap44xx_smartreflex_hwmod_class = {
	.name	= "smartreflex",
	.sysc	= &omap44xx_smartreflex_sysc,
	.rev	= 2,
};

/* smartreflex_core */
static struct omap_hwmod omap44xx_smartreflex_core_hwmod;
static struct omap_hwmod_irq_info omap44xx_smartreflex_core_irqs[] = {
	{ .irq = 19 + OMAP44XX_IRQ_GIC_START },
};

static struct omap_hwmod_addr_space omap44xx_smartreflex_core_addrs[] = {
	{
		.pa_start	= 0x4a0dd000,
		.pa_end		= 0x4a0dd03f,
		.flags		= ADDR_TYPE_RT
	},
};

/* l4_cfg -> smartreflex_core */
static struct omap_hwmod_ocp_if omap44xx_l4_cfg__smartreflex_core = {
	.master		= &omap44xx_l4_cfg_hwmod,
	.slave		= &omap44xx_smartreflex_core_hwmod,
	.clk		= "l4_div_ck",
	.addr		= omap44xx_smartreflex_core_addrs,
	.addr_cnt	= ARRAY_SIZE(omap44xx_smartreflex_core_addrs),
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* smartreflex_core slave ports */
static struct omap_hwmod_ocp_if *omap44xx_smartreflex_core_slaves[] = {
	&omap44xx_l4_cfg__smartreflex_core,
};

static struct omap_hwmod omap44xx_smartreflex_core_hwmod = {
	.name		= "smartreflex_core",
	.class		= &omap44xx_smartreflex_hwmod_class,
	.mpu_irqs	= omap44xx_smartreflex_core_irqs,
	.mpu_irqs_cnt	= ARRAY_SIZE(omap44xx_smartreflex_core_irqs),
	.main_clk	= "smartreflex_core_fck",
	.vdd_name	= "core",
	.prcm = {
		.omap4 = {
			.clkctrl_reg = OMAP4430_CM_ALWON_SR_CORE_CLKCTRL,
		},
	},
	.slaves		= omap44xx_smartreflex_core_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap44xx_smartreflex_core_slaves),
	.omap_chip	= OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
};

/* smartreflex_iva */
static struct omap_hwmod omap44xx_smartreflex_iva_hwmod;
static struct omap_hwmod_irq_info omap44xx_smartreflex_iva_irqs[] = {
	{ .irq = 102 + OMAP44XX_IRQ_GIC_START },
};

static struct omap_hwmod_addr_space omap44xx_smartreflex_iva_addrs[] = {
	{
		.pa_start	= 0x4a0db000,
		.pa_end		= 0x4a0db03f,
		.flags		= ADDR_TYPE_RT
	},
};

/* l4_cfg -> smartreflex_iva */
static struct omap_hwmod_ocp_if omap44xx_l4_cfg__smartreflex_iva = {
	.master		= &omap44xx_l4_cfg_hwmod,
	.slave		= &omap44xx_smartreflex_iva_hwmod,
	.clk		= "l4_div_ck",
	.addr		= omap44xx_smartreflex_iva_addrs,
	.addr_cnt	= ARRAY_SIZE(omap44xx_smartreflex_iva_addrs),
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* smartreflex_iva slave ports */
static struct omap_hwmod_ocp_if *omap44xx_smartreflex_iva_slaves[] = {
	&omap44xx_l4_cfg__smartreflex_iva,
};

static struct omap_hwmod omap44xx_smartreflex_iva_hwmod = {
	.name		= "smartreflex_iva",
	.class		= &omap44xx_smartreflex_hwmod_class,
	.mpu_irqs	= omap44xx_smartreflex_iva_irqs,
	.mpu_irqs_cnt	= ARRAY_SIZE(omap44xx_smartreflex_iva_irqs),
	.main_clk	= "smartreflex_iva_fck",
	.vdd_name	= "iva",
	.prcm = {
		.omap4 = {
			.clkctrl_reg = OMAP4430_CM_ALWON_SR_IVA_CLKCTRL,
		},
	},
	.slaves		= omap44xx_smartreflex_iva_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap44xx_smartreflex_iva_slaves),
	.omap_chip	= OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
};

/* smartreflex_mpu */
static struct omap_hwmod omap44xx_smartreflex_mpu_hwmod;
static struct omap_hwmod_irq_info omap44xx_smartreflex_mpu_irqs[] = {
	{ .irq = 18 + OMAP44XX_IRQ_GIC_START },
};

static struct omap_hwmod_addr_space omap44xx_smartreflex_mpu_addrs[] = {
	{
		.pa_start	= 0x4a0d9000,
		.pa_end		= 0x4a0d903f,
		.flags		= ADDR_TYPE_RT
	},
};

/* l4_cfg -> smartreflex_mpu */
static struct omap_hwmod_ocp_if omap44xx_l4_cfg__smartreflex_mpu = {
	.master		= &omap44xx_l4_cfg_hwmod,
	.slave		= &omap44xx_smartreflex_mpu_hwmod,
	.clk		= "l4_div_ck",
	.addr		= omap44xx_smartreflex_mpu_addrs,
	.addr_cnt	= ARRAY_SIZE(omap44xx_smartreflex_mpu_addrs),
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* smartreflex_mpu slave ports */
static struct omap_hwmod_ocp_if *omap44xx_smartreflex_mpu_slaves[] = {
	&omap44xx_l4_cfg__smartreflex_mpu,
};

static struct omap_hwmod omap44xx_smartreflex_mpu_hwmod = {
	.name		= "smartreflex_mpu",
	.class		= &omap44xx_smartreflex_hwmod_class,
	.mpu_irqs	= omap44xx_smartreflex_mpu_irqs,
	.mpu_irqs_cnt	= ARRAY_SIZE(omap44xx_smartreflex_mpu_irqs),
	.main_clk	= "smartreflex_mpu_fck",
	.vdd_name	= "mpu",
	.prcm = {
		.omap4 = {
			.clkctrl_reg = OMAP4430_CM_ALWON_SR_MPU_CLKCTRL,
		},
	},
	.slaves		= omap44xx_smartreflex_mpu_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap44xx_smartreflex_mpu_slaves),
	.omap_chip	= OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
};

/*
 * 'uart' class
 * universal asynchronous receiver/transmitter (uart)
 */

static struct omap_hwmod_class_sysconfig omap44xx_uart_sysc = {
	.rev_offs	= 0x0050,
	.sysc_offs	= 0x0054,
	.syss_offs	= 0x0058,
	.sysc_flags	= (SYSC_HAS_AUTOIDLE | SYSC_HAS_ENAWAKEUP |
			   SYSC_HAS_SIDLEMODE | SYSC_HAS_SOFTRESET |
			   SYSS_HAS_RESET_STATUS),
	.idlemodes	= (SIDLE_FORCE | SIDLE_NO | SIDLE_SMART |
			   SIDLE_SMART_WKUP),
	.sysc_fields	= &omap_hwmod_sysc_type1,
};

static struct omap_hwmod_class omap44xx_uart_hwmod_class = {
	.name	= "uart",
	.sysc	= &omap44xx_uart_sysc,
};

/* uart1 */
static struct omap_hwmod omap44xx_uart1_hwmod;
static struct omap_hwmod_irq_info omap44xx_uart1_irqs[] = {
	{ .irq = 72 + OMAP44XX_IRQ_GIC_START },
};

static struct omap_hwmod_dma_info omap44xx_uart1_sdma_reqs[] = {
	{ .name = "tx", .dma_req = 48 + OMAP44XX_DMA_REQ_START },
	{ .name = "rx", .dma_req = 49 + OMAP44XX_DMA_REQ_START },
};

static struct omap_hwmod_addr_space omap44xx_uart1_addrs[] = {
	{
		.pa_start	= 0x4806a000,
		.pa_end		= 0x4806a0ff,
		.flags		= ADDR_TYPE_RT
	},
};

/* l4_per -> uart1 */
static struct omap_hwmod_ocp_if omap44xx_l4_per__uart1 = {
	.master		= &omap44xx_l4_per_hwmod,
	.slave		= &omap44xx_uart1_hwmod,
	.clk		= "l4_div_ck",
	.addr		= omap44xx_uart1_addrs,
	.addr_cnt	= ARRAY_SIZE(omap44xx_uart1_addrs),
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* uart1 slave ports */
static struct omap_hwmod_ocp_if *omap44xx_uart1_slaves[] = {
	&omap44xx_l4_per__uart1,
};

static struct omap_hwmod omap44xx_uart1_hwmod = {
	.name		= "uart1",
	.class		= &omap44xx_uart_hwmod_class,
	.mpu_irqs	= omap44xx_uart1_irqs,
	.mpu_irqs_cnt	= ARRAY_SIZE(omap44xx_uart1_irqs),
	.sdma_reqs	= omap44xx_uart1_sdma_reqs,
	.sdma_reqs_cnt	= ARRAY_SIZE(omap44xx_uart1_sdma_reqs),
	.main_clk	= "uart1_fck",
	.prcm = {
		.omap4 = {
			.clkctrl_reg = OMAP4430_CM_L4PER_UART1_CLKCTRL,
		},
	},
	.slaves		= omap44xx_uart1_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap44xx_uart1_slaves),
	.omap_chip	= OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
};

/* uart2 */
static struct omap_hwmod omap44xx_uart2_hwmod;
static struct omap_hwmod_irq_info omap44xx_uart2_irqs[] = {
	{ .irq = 73 + OMAP44XX_IRQ_GIC_START },
};

static struct omap_hwmod_dma_info omap44xx_uart2_sdma_reqs[] = {
	{ .name = "tx", .dma_req = 50 + OMAP44XX_DMA_REQ_START },
	{ .name = "rx", .dma_req = 51 + OMAP44XX_DMA_REQ_START },
};

static struct omap_hwmod_addr_space omap44xx_uart2_addrs[] = {
	{
		.pa_start	= 0x4806c000,
		.pa_end		= 0x4806c0ff,
		.flags		= ADDR_TYPE_RT
	},
};

/* l4_per -> uart2 */
static struct omap_hwmod_ocp_if omap44xx_l4_per__uart2 = {
	.master		= &omap44xx_l4_per_hwmod,
	.slave		= &omap44xx_uart2_hwmod,
	.clk		= "l4_div_ck",
	.addr		= omap44xx_uart2_addrs,
	.addr_cnt	= ARRAY_SIZE(omap44xx_uart2_addrs),
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* uart2 slave ports */
static struct omap_hwmod_ocp_if *omap44xx_uart2_slaves[] = {
	&omap44xx_l4_per__uart2,
};

static struct omap_hwmod omap44xx_uart2_hwmod = {
	.name		= "uart2",
	.class		= &omap44xx_uart_hwmod_class,
	.mpu_irqs	= omap44xx_uart2_irqs,
	.mpu_irqs_cnt	= ARRAY_SIZE(omap44xx_uart2_irqs),
	.sdma_reqs	= omap44xx_uart2_sdma_reqs,
	.sdma_reqs_cnt	= ARRAY_SIZE(omap44xx_uart2_sdma_reqs),
	.main_clk	= "uart2_fck",
	.prcm = {
		.omap4 = {
			.clkctrl_reg = OMAP4430_CM_L4PER_UART2_CLKCTRL,
		},
	},
	.slaves		= omap44xx_uart2_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap44xx_uart2_slaves),
	.omap_chip	= OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
};

/* uart3 */
static struct omap_hwmod omap44xx_uart3_hwmod;
static struct omap_hwmod_irq_info omap44xx_uart3_irqs[] = {
	{ .irq = 74 + OMAP44XX_IRQ_GIC_START },
};

static struct omap_hwmod_dma_info omap44xx_uart3_sdma_reqs[] = {
	{ .name = "tx", .dma_req = 52 + OMAP44XX_DMA_REQ_START },
	{ .name = "rx", .dma_req = 53 + OMAP44XX_DMA_REQ_START },
};

static struct omap_hwmod_addr_space omap44xx_uart3_addrs[] = {
	{
		.pa_start	= 0x48020000,
		.pa_end		= 0x480200ff,
		.flags		= ADDR_TYPE_RT
	},
};

/* l4_per -> uart3 */
static struct omap_hwmod_ocp_if omap44xx_l4_per__uart3 = {
	.master		= &omap44xx_l4_per_hwmod,
	.slave		= &omap44xx_uart3_hwmod,
	.clk		= "l4_div_ck",
	.addr		= omap44xx_uart3_addrs,
	.addr_cnt	= ARRAY_SIZE(omap44xx_uart3_addrs),
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* uart3 slave ports */
static struct omap_hwmod_ocp_if *omap44xx_uart3_slaves[] = {
	&omap44xx_l4_per__uart3,
};

static struct omap_hwmod omap44xx_uart3_hwmod = {
	.name		= "uart3",
	.class		= &omap44xx_uart_hwmod_class,
	.flags		= (HWMOD_INIT_NO_IDLE | HWMOD_INIT_NO_RESET),
	.mpu_irqs	= omap44xx_uart3_irqs,
	.mpu_irqs_cnt	= ARRAY_SIZE(omap44xx_uart3_irqs),
	.sdma_reqs	= omap44xx_uart3_sdma_reqs,
	.sdma_reqs_cnt	= ARRAY_SIZE(omap44xx_uart3_sdma_reqs),
	.main_clk	= "uart3_fck",
	.prcm = {
		.omap4 = {
			.clkctrl_reg = OMAP4430_CM_L4PER_UART3_CLKCTRL,
		},
	},
	.slaves		= omap44xx_uart3_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap44xx_uart3_slaves),
	.omap_chip	= OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
};

/* uart4 */
static struct omap_hwmod omap44xx_uart4_hwmod;
static struct omap_hwmod_irq_info omap44xx_uart4_irqs[] = {
	{ .irq = 70 + OMAP44XX_IRQ_GIC_START },
};

static struct omap_hwmod_dma_info omap44xx_uart4_sdma_reqs[] = {
	{ .name = "tx", .dma_req = 54 + OMAP44XX_DMA_REQ_START },
	{ .name = "rx", .dma_req = 55 + OMAP44XX_DMA_REQ_START },
};

static struct omap_hwmod_addr_space omap44xx_uart4_addrs[] = {
	{
		.pa_start	= 0x4806e000,
		.pa_end		= 0x4806e0ff,
		.flags		= ADDR_TYPE_RT
	},
};

/* l4_per -> uart4 */
static struct omap_hwmod_ocp_if omap44xx_l4_per__uart4 = {
	.master		= &omap44xx_l4_per_hwmod,
	.slave		= &omap44xx_uart4_hwmod,
	.clk		= "l4_div_ck",
	.addr		= omap44xx_uart4_addrs,
	.addr_cnt	= ARRAY_SIZE(omap44xx_uart4_addrs),
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* uart4 slave ports */
static struct omap_hwmod_ocp_if *omap44xx_uart4_slaves[] = {
	&omap44xx_l4_per__uart4,
};

static struct omap_hwmod omap44xx_uart4_hwmod = {
	.name		= "uart4",
	.class		= &omap44xx_uart_hwmod_class,
	.mpu_irqs	= omap44xx_uart4_irqs,
	.mpu_irqs_cnt	= ARRAY_SIZE(omap44xx_uart4_irqs),
	.sdma_reqs	= omap44xx_uart4_sdma_reqs,
	.sdma_reqs_cnt	= ARRAY_SIZE(omap44xx_uart4_sdma_reqs),
	.main_clk	= "uart4_fck",
	.prcm = {
		.omap4 = {
			.clkctrl_reg = OMAP4430_CM_L4PER_UART4_CLKCTRL,
		},
	},
	.slaves		= omap44xx_uart4_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap44xx_uart4_slaves),
	.omap_chip	= OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
};

/*
 * 'wd_timer' class
 * 32-bit watchdog upward counter that generates a pulse on the reset pin on
 * overflow condition
 */

static struct omap_hwmod_class_sysconfig omap44xx_wd_timer_sysc = {
	.rev_offs	= 0x0000,
	.sysc_offs	= 0x0010,
	.syss_offs	= 0x0014,
	.sysc_flags	= (SYSC_HAS_EMUFREE | SYSC_HAS_SIDLEMODE |
			   SYSC_HAS_SOFTRESET | SYSS_HAS_RESET_STATUS),
	.idlemodes	= (SIDLE_FORCE | SIDLE_NO | SIDLE_SMART |
			   SIDLE_SMART_WKUP),
	.sysc_fields	= &omap_hwmod_sysc_type1,
};

static struct omap_hwmod_class omap44xx_wd_timer_hwmod_class = {
	.name		= "wd_timer",
	.sysc		= &omap44xx_wd_timer_sysc,
	.pre_shutdown	= &omap2_wd_timer_disable,
};

/* wd_timer2 */
static struct omap_hwmod omap44xx_wd_timer2_hwmod;
static struct omap_hwmod_irq_info omap44xx_wd_timer2_irqs[] = {
	{ .irq = 80 + OMAP44XX_IRQ_GIC_START },
};

static struct omap_hwmod_addr_space omap44xx_wd_timer2_addrs[] = {
	{
		.pa_start	= 0x4a314000,
		.pa_end		= 0x4a31407f,
		.flags		= ADDR_TYPE_RT
	},
};

/* l4_wkup -> wd_timer2 */
static struct omap_hwmod_ocp_if omap44xx_l4_wkup__wd_timer2 = {
	.master		= &omap44xx_l4_wkup_hwmod,
	.slave		= &omap44xx_wd_timer2_hwmod,
	.clk		= "l4_wkup_clk_mux_ck",
	.addr		= omap44xx_wd_timer2_addrs,
	.addr_cnt	= ARRAY_SIZE(omap44xx_wd_timer2_addrs),
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* wd_timer2 slave ports */
static struct omap_hwmod_ocp_if *omap44xx_wd_timer2_slaves[] = {
	&omap44xx_l4_wkup__wd_timer2,
};

static struct omap_hwmod omap44xx_wd_timer2_hwmod = {
	.name		= "wd_timer2",
	.class		= &omap44xx_wd_timer_hwmod_class,
	.mpu_irqs	= omap44xx_wd_timer2_irqs,
	.mpu_irqs_cnt	= ARRAY_SIZE(omap44xx_wd_timer2_irqs),
	.main_clk	= "wd_timer2_fck",
	.prcm = {
		.omap4 = {
			.clkctrl_reg = OMAP4430_CM_WKUP_WDT2_CLKCTRL,
		},
	},
	.slaves		= omap44xx_wd_timer2_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap44xx_wd_timer2_slaves),
	.omap_chip	= OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
};

/* wd_timer3 */
static struct omap_hwmod omap44xx_wd_timer3_hwmod;
static struct omap_hwmod_irq_info omap44xx_wd_timer3_irqs[] = {
	{ .irq = 36 + OMAP44XX_IRQ_GIC_START },
};

static struct omap_hwmod_addr_space omap44xx_wd_timer3_addrs[] = {
	{
		.pa_start	= 0x40130000,
		.pa_end		= 0x4013007f,
		.flags		= ADDR_TYPE_RT
	},
};

/* l4_abe -> wd_timer3 */
static struct omap_hwmod_ocp_if omap44xx_l4_abe__wd_timer3 = {
	.master		= &omap44xx_l4_abe_hwmod,
	.slave		= &omap44xx_wd_timer3_hwmod,
	.clk		= "ocp_abe_iclk",
	.addr		= omap44xx_wd_timer3_addrs,
	.addr_cnt	= ARRAY_SIZE(omap44xx_wd_timer3_addrs),
	.user		= OCP_USER_MPU,
};

static struct omap_hwmod_addr_space omap44xx_wd_timer3_dma_addrs[] = {
	{
		.pa_start	= 0x49030000,
		.pa_end		= 0x4903007f,
		.flags		= ADDR_TYPE_RT
	},
};

/* l4_abe -> wd_timer3 (dma) */
static struct omap_hwmod_ocp_if omap44xx_l4_abe__wd_timer3_dma = {
	.master		= &omap44xx_l4_abe_hwmod,
	.slave		= &omap44xx_wd_timer3_hwmod,
	.clk		= "ocp_abe_iclk",
	.addr		= omap44xx_wd_timer3_dma_addrs,
	.addr_cnt	= ARRAY_SIZE(omap44xx_wd_timer3_dma_addrs),
	.user		= OCP_USER_SDMA,
};

/* wd_timer3 slave ports */
static struct omap_hwmod_ocp_if *omap44xx_wd_timer3_slaves[] = {
	&omap44xx_l4_abe__wd_timer3,
	&omap44xx_l4_abe__wd_timer3_dma,
};

static struct omap_hwmod omap44xx_wd_timer3_hwmod = {
	.name		= "wd_timer3",
	.class		= &omap44xx_wd_timer_hwmod_class,
	.mpu_irqs	= omap44xx_wd_timer3_irqs,
	.mpu_irqs_cnt	= ARRAY_SIZE(omap44xx_wd_timer3_irqs),
	.main_clk	= "wd_timer3_fck",
	.prcm = {
		.omap4 = {
			.clkctrl_reg = OMAP4430_CM1_ABE_WDT3_CLKCTRL,
		},
	},
	.slaves		= omap44xx_wd_timer3_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap44xx_wd_timer3_slaves),
	.omap_chip	= OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
};

static __initdata struct omap_hwmod *omap44xx_hwmods[] = {

	/* dmm class */
	&omap44xx_dmm_hwmod,

	/* emif_fw class */
	&omap44xx_emif_fw_hwmod,

	/* l3 class */
	&omap44xx_l3_instr_hwmod,
	&omap44xx_l3_main_1_hwmod,
	&omap44xx_l3_main_2_hwmod,
	&omap44xx_l3_main_3_hwmod,

	/* l4 class */
	&omap44xx_l4_abe_hwmod,
	&omap44xx_l4_cfg_hwmod,
	&omap44xx_l4_per_hwmod,
	&omap44xx_l4_wkup_hwmod,

	/* mpu_bus class */
	&omap44xx_mpu_private_hwmod,

	/* dma class */
	&omap44xx_dma_system_hwmod,

	/* dsp class */
	&omap44xx_dsp_hwmod,
	&omap44xx_dsp_c0_hwmod,

	/* gpio class */
	&omap44xx_gpio1_hwmod,
	&omap44xx_gpio2_hwmod,
	&omap44xx_gpio3_hwmod,
	&omap44xx_gpio4_hwmod,
	&omap44xx_gpio5_hwmod,
	&omap44xx_gpio6_hwmod,

	/* i2c class */
	&omap44xx_i2c1_hwmod,
	&omap44xx_i2c2_hwmod,
	&omap44xx_i2c3_hwmod,
	&omap44xx_i2c4_hwmod,

	/* iva class */
	&omap44xx_iva_hwmod,
	&omap44xx_iva_seq0_hwmod,
	&omap44xx_iva_seq1_hwmod,

	/* mpu class */
	&omap44xx_mpu_hwmod,

	/* smartreflex class */
	&omap44xx_smartreflex_core_hwmod,
	&omap44xx_smartreflex_iva_hwmod,
	&omap44xx_smartreflex_mpu_hwmod,

	/* uart class */
	&omap44xx_uart1_hwmod,
	&omap44xx_uart2_hwmod,
	&omap44xx_uart3_hwmod,
	&omap44xx_uart4_hwmod,

	/* wd_timer class */
	&omap44xx_wd_timer2_hwmod,
	&omap44xx_wd_timer3_hwmod,

	NULL,
};

int __init omap44xx_hwmod_init(void)
{
	return omap_hwmod_init(omap44xx_hwmods);
}

