/* Copyright (C) 2003 Thorsten Kukuk
   Author: Thorsten Kukuk <kukuk@suse.de>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License version 2 as
   published by the Free Software Foundation.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <utmp.h>
#include <stdio.h>
#include <string.h>

#include "public.h"

/* Return 0 if name is POSIX conform, -1 else.  */
int
check_name (const char *name)
{
  /* The login name/group name should not be longer than the space we
     have for it in the utmp entry.  */
  if (strlen (name) > UT_NAMESIZE)
    return -1;

  /* User/group names must match [A-Za-z_][A-Za-z0-9_-.]*[A-Za-z0-9_-.$].
     This is the POSIX portable character class. The $ at the end is
     needed for SAMBA.  */
  if (!*name || !((*name >= 'a' && *name <= 'z') || *name == '_'
		  || (*name >= 'A' && *name <= 'Z')))
    return -1;

  ++name;
  while (*name)
    {
      if (!((*name >= 'a' && *name <= 'z') ||
	    (*name >= 'A' && *name <= 'Z') ||
	    (*name >= '0' && *name <= '9') ||
	    *name == '_' || *name == '-' || *name == '.' ||
	    (*name == '$' && *(name + 1) == '\0')))
	return -1;

      ++name;
    }

  return 0;
}

