/* Copyright (C) 2004 Thorsten Kukuk
   Author: Thorsten Kukuk <kukuk@suse.de>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License version 2 as
   published by the Free Software Foundation.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  */

#ifndef __LOGGING_H__
#define __LOGGING_H__

#include <stdarg.h>

extern void open_sec_log (void);

extern void (*sec_log_fnc) (const char *program, unsigned int id, ...);

#define sec_log(program, id, args...)     \
  do {                                    \
    if (sec_log_fnc)                      \
      sec_log_fnc (program, id, ##args);  \
  } while (0);

#define MSG_PATH_ARG_DENIED 1 /* caller uid */
#define MSG_PERMISSION_DENIED 2 /* account, id, caller uid */
#define MSG_SHADOW_DATA_PRINTED 3 /* account, uid, caller uid */
#define MSG_UNKNOWN_GROUP 4 /* group, caller uid */
#define MSG_CHANGING_GROUP_PASSWORD 5 /* group, caller uid */
#define MSG_PASSWORD_CHANGE_ABORTED 6 /* account, caller uid */
#define MSG_MAX_GROUP_PASSWD_TRIES 7 /* group, caller uid */
#define MSG_ERROR_CHANGE_GROUP_PASSWORD 8 /* group, caller uid */
#define MSG_GROUP_PASSWORD_REMOVED 9 /* group, caller uid */
#define MSG_GROUP_PASSWORD_CHANGED 10 /* group, caller uid */
#define MSG_NO_FREE_GID 11 /* gid_min, gid max */
#define MSG_GID_NOT_UNIQUE 12 /* new_gid, caller uid */
#define MSG_GROUP_NAME_INVALID 13 /* group, caller uid */
#define MSG_GROUP_FILE_ALREADY_LOCKED 14 /* - */
#define MSG_GROUP_ALREADY_EXISTS 15 /* group, caller uid */
#define MSG_ERROR_ADDING_NEW_GROUP 16 /* group, gid, caller uid */
#define MSG_NEW_GROUP_ADDED 17 /* group, gid, caller uid */

#endif
