/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.midas.xmlada;

import br.gov.serpro.midas.xmlada.DomDocument;
import br.gov.serpro.midas.xmlada.Util;
import org.w3c.dom.Element;

public class DocConfig
extends DomDocument {
    private String mCaminhoAmbientes;
    private String mCaminhoEstruturas;
    private String mCaminhoXSL;
    private String mCaminhoVirtualXSL;
    private String mCaminhoConsultas;
    private String mCaminhoTipos;
    private String mAmbienteDefault;
    private String mTipoDefault;
    private long mMaxRows;

    public String getCaminhoAmbientes() {
        return this.mCaminhoAmbientes;
    }

    public void setCaminhoAmbientes(String c) {
        this.mCaminhoAmbientes = c;
    }

    public String getCaminhoEstruturas() {
        return this.mCaminhoEstruturas;
    }

    public String getCaminhoXSL() {
        return this.mCaminhoXSL;
    }

    public String getCaminhoVirtualXSL() {
        return this.mCaminhoVirtualXSL;
    }

    public String getCaminhoConsultas() {
        return this.mCaminhoConsultas;
    }

    public String getCaminhoTipos() {
        return this.mCaminhoTipos;
    }

    public String getAmbienteDefault() {
        return this.mAmbienteDefault;
    }

    public String getTipoDefault() {
        return this.mTipoDefault;
    }

    public long getMaxRows() {
        return this.mMaxRows;
    }

    public void setMaxRows(long max) {
        this.mMaxRows = max;
    }

    public DocConfig(String docStr, String appPath) {
        super(docStr);
        if (this.getOk()) {
            Element node = this.getSingleNode("config", this.getRaiz(), "id=ambientes");
            if (node != null) {
                this.mCaminhoAmbientes = node.getAttribute("path");
                if (this.mCaminhoAmbientes.equals(".")) {
                    this.mCaminhoAmbientes = Util.nomePasta(docStr);
                }
                if (this.mCaminhoAmbientes.startsWith("..")) {
                    this.mCaminhoAmbientes = Util.caminho(Util.nomePasta(docStr), this.mCaminhoAmbientes);
                }
                this.mAmbienteDefault = node.getAttribute("default");
            }
            if ((node = this.getSingleNode("config", this.getRaiz(), "id=estruturas_xsl")) != null) {
                this.mCaminhoXSL = node.getAttribute("path");
                if (this.mCaminhoXSL.equals(".")) {
                    this.mCaminhoXSL = Util.nomePasta(docStr);
                }
                if (this.mCaminhoXSL.startsWith("..")) {
                    this.mCaminhoXSL = Util.caminho(Util.nomePasta(docStr), this.mCaminhoXSL);
                }
                this.mCaminhoVirtualXSL = node.getAttribute("virtualpath");
            }
            if ((node = this.getSingleNode("config", this.getRaiz(), "id=consultas")) != null) {
                this.mCaminhoConsultas = node.getAttribute("path");
                if (this.mCaminhoConsultas.equals(".")) {
                    this.mCaminhoConsultas = Util.nomePasta(docStr);
                }
                if (this.mCaminhoConsultas.startsWith("..")) {
                    this.mCaminhoConsultas = Util.caminho(Util.nomePasta(docStr), this.mCaminhoConsultas);
                }
            }
            if ((node = this.getSingleNode("config", this.getRaiz(), "id=arquivos")) != null) {
                this.mCaminhoEstruturas = node.getAttribute("path");
                if (this.mCaminhoEstruturas.equals(".")) {
                    this.mCaminhoEstruturas = Util.nomePasta(docStr);
                }
                if (this.mCaminhoEstruturas.startsWith("..")) {
                    this.mCaminhoEstruturas = Util.caminho(Util.nomePasta(docStr), this.mCaminhoEstruturas);
                }
            }
            if ((node = this.getSingleNode("config", this.getRaiz(), "id=tipos")) != null) {
                this.mCaminhoTipos = node.getAttribute("path");
                if (this.mCaminhoTipos.equals(".")) {
                    this.mCaminhoTipos = Util.nomePasta(docStr);
                }
                if (this.mCaminhoTipos.startsWith("..")) {
                    this.mCaminhoTipos = Util.caminho(Util.nomePasta(docStr), this.mCaminhoTipos);
                }
                this.mTipoDefault = node.getAttribute("default");
            }
            this.mMaxRows = this.getRaiz().getAttribute("maxrows").length() <= 0 ? 0L : new Long(this.getRaiz().getAttribute("maxrows"));
        } else {
            this.mCaminhoAmbientes = appPath;
            this.mCaminhoEstruturas = appPath;
            this.mCaminhoXSL = appPath;
            this.mCaminhoTipos = appPath;
            this.mCaminhoConsultas = appPath;
        }
    }
}

