/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.midas.xmlada;

import br.gov.serpro.midas.xmlada.DomDocument;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;

public class TextBuffer {
    private StringBuffer stringBuffer;
    private BufferedWriter outFileBuffer;
    private BufferedReader inFileBuffer;
    private boolean isfile;
    private String filename;
    private long numLines;

    public TextBuffer(String doc, boolean isfilename) {
        this(doc, isfilename, false);
    }

    public TextBuffer(String doc, boolean isfilename, boolean isIn) {
        block6: {
            this.isfile = isfilename;
            if (this.isfile) {
                try {
                    if (isIn) {
                        this.inFileBuffer = new BufferedReader(new FileReader(doc));
                        this.filename = doc;
                        break block6;
                    }
                    this.outFileBuffer = new BufferedWriter(new FileWriter(doc));
                    this.filename = doc;
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                this.stringBuffer = new StringBuffer(doc);
            }
        }
    }

    public void putLine(String linha) {
        try {
            if (this.isfile) {
                this.outFileBuffer.write(linha);
                this.outFileBuffer.newLine();
                ++this.numLines;
            } else if (this.stringBuffer != null) {
                this.stringBuffer.append(String.valueOf(linha) + "\n");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String Dump() {
        return this.stringBuffer == null ? this.filename : this.stringBuffer.toString();
    }

    public boolean valido() {
        return this.isfile ? new DomDocument(this.filename).getOk() : new DomDocument(this.stringBuffer.toString()).getOk();
    }

    public boolean isFile() {
        return this.isfile;
    }

    public void CloseFile() {
        if (this.isfile) {
            try {
                if (this.outFileBuffer != null) {
                    this.outFileBuffer.close();
                }
                if (this.inFileBuffer != null) {
                    this.inFileBuffer.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    protected void finalize() throws Throwable {
        this.CloseFile();
        super.finalize();
    }

    public long getNumLines() {
        this.numLines = 0L;
        if (this.inFileBuffer != null) {
            try {
                int chr;
                while ((chr = this.inFileBuffer.read()) != -1) {
                    if (chr != 13) continue;
                    ++this.numLines;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (this.stringBuffer != null) {
            try {
                int i = 0;
                while (i < this.stringBuffer.length()) {
                    char e = this.stringBuffer.charAt(i);
                    if (e == '\n') {
                        ++this.numLines;
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.numLines;
    }

    public StringBuffer getStringBuffer() {
        return this.stringBuffer;
    }

    public BufferedWriter getOutFile() {
        if (this.isfile && this.outFileBuffer == null) {
            try {
                this.outFileBuffer = new BufferedWriter(new FileWriter(this.filename));
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return this.outFileBuffer;
    }

    public BufferedReader getInFile() {
        if (this.inFileBuffer == null) {
            if (this.isfile) {
                try {
                    this.inFileBuffer = new BufferedReader(new FileReader(this.filename));
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
            } else {
                this.inFileBuffer = new BufferedReader(new StringReader(this.stringBuffer.toString()));
            }
        }
        return this.inFileBuffer;
    }

    public String getTexto() {
        String tmp = "";
        try {
            String ttmp = this.inFileBuffer.readLine();
            while (ttmp != null) {
                tmp = String.valueOf(tmp) + ttmp + "\n";
                ttmp = this.inFileBuffer.readLine();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return tmp;
    }

    public void saveAs(String nome) {
        if (!this.isfile) {
            try {
                String linha;
                BufferedWriter outFile = new BufferedWriter(new FileWriter(nome));
                BufferedReader inFile = this.getInFile();
                while ((linha = inFile.readLine()) != null) {
                    outFile.write(linha);
                    outFile.newLine();
                }
                outFile.close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

