/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.iconlabel;

import java.awt.Color;
import java.io.Serializable;
import net.sf.jasperreports.components.iconlabel.ContainerFillEnum;
import net.sf.jasperreports.components.iconlabel.IconPositionEnum;
import net.sf.jasperreports.engine.JRAlignment;
import net.sf.jasperreports.engine.JRBoxContainer;
import net.sf.jasperreports.engine.JRDefaultStyleProvider;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JRTextField;
import net.sf.jasperreports.engine.base.JRBaseLineBox;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;
import net.sf.jasperreports.engine.component.BaseComponentContext;
import net.sf.jasperreports.engine.component.ComponentContext;
import net.sf.jasperreports.engine.component.ContextAwareComponent;
import net.sf.jasperreports.engine.design.JRDesignTextField;
import net.sf.jasperreports.engine.design.events.JRChangeEventsSupport;
import net.sf.jasperreports.engine.design.events.JRPropertyChangeSupport;
import net.sf.jasperreports.engine.type.HorizontalAlignEnum;
import net.sf.jasperreports.engine.type.VerticalAlignEnum;
import net.sf.jasperreports.engine.util.JRStyleResolver;

public class IconLabelComponent
implements ContextAwareComponent,
JRBoxContainer,
JRAlignment,
Serializable,
JRChangeEventsSupport {
    private static final long serialVersionUID = 1L;
    public static final String PROPERTY_ICON_POSITION = "iconPosition";
    public static final String PROPERTY_LABEL_FILL = "labelFill";
    public static final String PROPERTY_HORIZONTAL_ALIGNMENT = "horizontalAlignment";
    public static final String PROPERTY_VERTICAL_ALIGNMENT = "verticalAlignment";
    private JRLineBox lineBox;
    private JRTextField labelTextField;
    private JRTextField iconTextField;
    private IconPositionEnum iconPosition;
    private ContainerFillEnum labelFill;
    private HorizontalAlignEnum horizontalAlign;
    private VerticalAlignEnum verticalAlign;
    private ComponentContext context;
    private transient JRPropertyChangeSupport eventSupport;

    public IconLabelComponent(JRDefaultStyleProvider defaultStyleProvider) {
        this.lineBox = new JRBaseLineBox(this);
        this.labelTextField = new JRDesignTextField(defaultStyleProvider);
        this.iconTextField = new JRDesignTextField(defaultStyleProvider);
    }

    public IconLabelComponent(IconLabelComponent component, JRBaseObjectFactory objectFactory) {
        this.lineBox = component.getLineBox().clone(this);
        this.labelTextField = (JRTextField)objectFactory.getVisitResult(component.getLabelTextField());
        this.iconTextField = (JRTextField)objectFactory.getVisitResult(component.getIconTextField());
        this.iconPosition = component.getIconPosition();
        this.labelFill = component.getLabelFill();
        this.horizontalAlign = component.getOwnHorizontalAlignmentValue();
        this.verticalAlign = component.getOwnVerticalAlignmentValue();
        this.context = new BaseComponentContext(component.getContext(), objectFactory);
    }

    @Override
    public void setContext(ComponentContext context) {
        this.context = context;
    }

    @Override
    public ComponentContext getContext() {
        return this.context;
    }

    @Override
    public JRLineBox getLineBox() {
        return this.lineBox;
    }

    public void setLineBox(JRLineBox lineBox) {
        this.lineBox = lineBox;
    }

    @Override
    public JRDefaultStyleProvider getDefaultStyleProvider() {
        return this.context == null ? null : this.context.getComponentElement().getDefaultStyleProvider();
    }

    @Override
    public JRStyle getStyle() {
        return this.context == null ? null : this.context.getComponentElement().getStyle();
    }

    @Override
    public String getStyleNameReference() {
        return this.context == null ? null : this.context.getComponentElement().getStyleNameReference();
    }

    @Override
    public Color getDefaultLineColor() {
        return Color.black;
    }

    public JRTextField getLabelTextField() {
        return this.labelTextField;
    }

    public void setLabelTextField(JRTextField labelTextField) {
        this.labelTextField = labelTextField;
    }

    public JRTextField getIconTextField() {
        return this.iconTextField;
    }

    public void setIconTextField(JRTextField iconTextField) {
        this.iconTextField = iconTextField;
    }

    public IconPositionEnum getIconPosition() {
        return this.iconPosition;
    }

    public void setIconPosition(IconPositionEnum iconPosition) {
        IconPositionEnum old = this.iconPosition;
        this.iconPosition = iconPosition;
        this.getEventSupport().firePropertyChange(PROPERTY_ICON_POSITION, old, this.iconPosition);
    }

    @Override
    public HorizontalAlignEnum getHorizontalAlignmentValue() {
        return JRStyleResolver.getHorizontalAlignmentValue(this);
    }

    @Override
    public HorizontalAlignEnum getOwnHorizontalAlignmentValue() {
        return this.horizontalAlign;
    }

    @Override
    public void setHorizontalAlignment(HorizontalAlignEnum horizontalAlign) {
        HorizontalAlignEnum old = this.horizontalAlign;
        this.horizontalAlign = horizontalAlign;
        this.getEventSupport().firePropertyChange(PROPERTY_HORIZONTAL_ALIGNMENT, old, this.horizontalAlign);
    }

    @Override
    public VerticalAlignEnum getVerticalAlignmentValue() {
        return JRStyleResolver.getVerticalAlignmentValue(this);
    }

    @Override
    public VerticalAlignEnum getOwnVerticalAlignmentValue() {
        return this.verticalAlign;
    }

    @Override
    public void setVerticalAlignment(VerticalAlignEnum verticalAlign) {
        VerticalAlignEnum old = this.verticalAlign;
        this.verticalAlign = verticalAlign;
        this.getEventSupport().firePropertyChange(PROPERTY_VERTICAL_ALIGNMENT, old, this.verticalAlign);
    }

    public ContainerFillEnum getLabelFill() {
        return this.labelFill;
    }

    public void setLabelFill(ContainerFillEnum labelFill) {
        ContainerFillEnum old = this.labelFill;
        this.labelFill = labelFill;
        this.getEventSupport().firePropertyChange(PROPERTY_LABEL_FILL, old, this.labelFill);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JRPropertyChangeSupport getEventSupport() {
        IconLabelComponent iconLabelComponent = this;
        synchronized (iconLabelComponent) {
            if (this.eventSupport == null) {
                this.eventSupport = new JRPropertyChangeSupport(this);
            }
        }
        return this.eventSupport;
    }
}

