/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.crosstabs.fill.calculation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.sf.jasperreports.crosstabs.fill.calculation.BucketDefinition;
import net.sf.jasperreports.crosstabs.fill.calculation.BucketingServiceContext;
import net.sf.jasperreports.crosstabs.fill.calculation.MeasureDefinition;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.type.CalculationEnum;

public abstract class BucketingService {
    public static final String PROPERTY_BUCKET_MEASURE_LIMIT = "net.sf.jasperreports.crosstab.bucket.measure.limit";
    protected static final byte DIMENSION_ROW = 0;
    protected static final byte DIMENSION_COLUMN = 1;
    protected static final int DIMENSIONS = 2;
    protected final BucketingServiceContext serviceContext;
    protected final BucketDefinition[] allBuckets;
    protected final BucketDefinition[][] buckets;
    protected final int rowBucketCount;
    protected final int colBucketCount;
    protected final boolean[][] retrieveTotal;
    protected boolean[] rowRetrTotals;
    protected int rowRetrTotalMin;
    protected int rowRetrTotalMax;
    protected int[] rowRetrColMax;
    protected final MeasureDefinition[] measures;
    protected final int origMeasureCount;
    protected final int[] measureIndexes;
    protected final boolean sorted;
    protected final BucketMap bucketValueMap;
    protected final BucketMap columnBucketMap;
    protected long dataCount;
    protected boolean processed;
    protected final MeasureDefinition.MeasureValue[] zeroMeasureValues;
    protected final MeasureDefinition.MeasureValue[] zeroUserMeasureValues;
    private final int bucketMeasureLimit;
    private int runningBucketMeasureCount;

    public BucketingService(BucketingServiceContext serviceContext, List<BucketDefinition> rowBuckets, List<BucketDefinition> columnBuckets, List<MeasureDefinition> measures, boolean sorted, boolean[][] retrieveTotal) {
        this.serviceContext = serviceContext;
        this.sorted = sorted;
        this.buckets = new BucketDefinition[2][];
        this.rowBucketCount = rowBuckets.size();
        this.buckets[0] = new BucketDefinition[this.rowBucketCount];
        rowBuckets.toArray(this.buckets[0]);
        this.colBucketCount = columnBuckets.size();
        this.buckets[1] = new BucketDefinition[this.colBucketCount];
        columnBuckets.toArray(this.buckets[1]);
        this.allBuckets = new BucketDefinition[this.rowBucketCount + this.colBucketCount];
        System.arraycopy(this.buckets[0], 0, this.allBuckets, 0, this.rowBucketCount);
        System.arraycopy(this.buckets[1], 0, this.allBuckets, this.rowBucketCount, this.colBucketCount);
        this.origMeasureCount = measures.size();
        ArrayList<MeasureDefinition> measuresList = new ArrayList<MeasureDefinition>(measures.size() * 2);
        ArrayList<Integer> measureIndexList = new ArrayList<Integer>(measures.size() * 2);
        int i = 0;
        while (i < measures.size()) {
            MeasureDefinition measure = measures.get(i);
            this.addMeasure(measure, i, measuresList, measureIndexList);
            ++i;
        }
        this.measures = new MeasureDefinition[measuresList.size()];
        measuresList.toArray(this.measures);
        this.measureIndexes = new int[measureIndexList.size()];
        i = 0;
        while (i < this.measureIndexes.length) {
            this.measureIndexes[i] = (Integer)measureIndexList.get(i);
            ++i;
        }
        this.retrieveTotal = retrieveTotal;
        this.checkTotals();
        this.bucketValueMap = this.createBucketMap(0);
        this.columnBucketMap = this.createBucketMapMap(this.rowBucketCount);
        this.zeroMeasureValues = this.initMeasureValues();
        this.zeroUserMeasureValues = this.initUserMeasureValues();
        this.bucketMeasureLimit = JRPropertiesUtil.getInstance(serviceContext.getJasperReportsContext()).getIntegerProperty(PROPERTY_BUCKET_MEASURE_LIMIT, 0);
    }

    protected void checkTotals() {
        this.rowRetrTotalMin = this.rowBucketCount + 1;
        this.rowRetrTotalMax = -1;
        this.rowRetrTotals = new boolean[this.rowBucketCount + 1];
        this.rowRetrColMax = new int[this.rowBucketCount + 1];
        int row = 0;
        while (row <= this.rowBucketCount) {
            this.rowRetrColMax[row] = -1;
            boolean total = false;
            int col = 0;
            while (col <= this.colBucketCount) {
                if (this.retrieveTotal[row][col]) {
                    total = true;
                    this.rowRetrColMax[row] = col;
                }
                ++col;
            }
            this.rowRetrTotals[row] = total;
            if (total) {
                if (row < this.rowRetrTotalMin) {
                    this.rowRetrTotalMin = row;
                }
                this.rowRetrTotalMax = row;
                if (row < this.rowBucketCount) {
                    this.allBuckets[row].setComputeTotal();
                }
            }
            ++row;
        }
        int col = 0;
        while (col < this.colBucketCount) {
            BucketDefinition colBucket = this.allBuckets[this.rowBucketCount + col];
            if (!colBucket.computeTotal()) {
                boolean total = false;
                int row2 = 0;
                while (!total && row2 <= this.rowBucketCount) {
                    total = this.retrieveTotal[row2][col];
                    ++row2;
                }
                if (total) {
                    colBucket.setComputeTotal();
                }
            }
            ++col;
        }
        int d = 0;
        while (d < 2) {
            boolean dTotal = false;
            int i = 0;
            while (i < this.buckets[d].length) {
                if (dTotal) {
                    this.buckets[d][i].setComputeTotal();
                } else {
                    dTotal = this.buckets[d][i].computeTotal();
                }
                ++i;
            }
            ++d;
        }
    }

    public void clear() {
        this.bucketValueMap.clear();
        this.columnBucketMap.clear();
        this.processed = false;
        this.dataCount = 0L;
        this.runningBucketMeasureCount = 0;
    }

    protected BucketMap createBucketMap(int level) {
        BucketMap map = this.sorted ? new BucketListMap(level) : this.createBucketMapMap(level);
        return map;
    }

    protected BucketMapMap createBucketMapMap(int level) {
        boolean sortedMap = !this.sorted && this.allBuckets[level].isSorted();
        return new BucketMapMap(level, sortedMap);
    }

    protected BucketMapMap createRowTotalsBucketMap() {
        BucketMapMap totalsBucketMap = new BucketMapMap(this.rowBucketCount, false);
        totalsBucketMap.copyEntries(this.columnBucketMap);
        return totalsBucketMap;
    }

    protected void addMeasure(MeasureDefinition measure, int index, List<MeasureDefinition> measuresList, List<Integer> measureIndexList) {
        switch (measure.getCalculation()) {
            case AVERAGE: 
            case VARIANCE: {
                MeasureDefinition sumMeasure = MeasureDefinition.createHelperMeasure(measure, CalculationEnum.SUM);
                this.addMeasure(sumMeasure, index, measuresList, measureIndexList);
                MeasureDefinition countMeasure = MeasureDefinition.createHelperMeasure(measure, CalculationEnum.COUNT);
                this.addMeasure(countMeasure, index, measuresList, measureIndexList);
                break;
            }
            case STANDARD_DEVIATION: {
                MeasureDefinition varianceMeasure = MeasureDefinition.createHelperMeasure(measure, CalculationEnum.VARIANCE);
                this.addMeasure(varianceMeasure, index, measuresList, measureIndexList);
                break;
            }
            case DISTINCT_COUNT: {
                MeasureDefinition countMeasure = MeasureDefinition.createDistinctCountHelperMeasure(measure);
                this.addMeasure(countMeasure, index, measuresList, measureIndexList);
            }
        }
        measuresList.add(measure);
        measureIndexList.add(index);
    }

    public void addData(Object[] bucketValues, Object[] measureValues) throws JRException {
        if (this.processed) {
            throw new JRException("Crosstab data has already been processed.");
        }
        ++this.dataCount;
        BucketDefinition.Bucket[] bucketVals = this.getBucketValues(bucketValues);
        MeasureDefinition.MeasureValue[] values = this.bucketValueMap.insertMeasureValues(bucketVals, true, 0);
        int i = 0;
        while (i < this.measures.length) {
            Object measureValue = measureValues[this.measureIndexes[i]];
            values[i].addValue(measureValue);
            ++i;
        }
        this.columnBucketMap.insertMeasureValues(bucketVals, false, this.rowBucketCount);
    }

    protected void bucketMeasuresCreated() {
        this.runningBucketMeasureCount += this.origMeasureCount;
        this.checkBucketMeasureCount(this.runningBucketMeasureCount);
    }

    protected BucketDefinition.Bucket[] getBucketValues(Object[] bucketValues) {
        BucketDefinition.Bucket[] bucketVals = new BucketDefinition.Bucket[this.allBuckets.length];
        int i = 0;
        while (i < this.allBuckets.length) {
            BucketDefinition bucket = this.allBuckets[i];
            Object value = bucketValues[i];
            bucketVals[i] = bucket.create(value);
            ++i;
        }
        return bucketVals;
    }

    protected MeasureDefinition.MeasureValue[] initMeasureValues() {
        MeasureDefinition.MeasureValue[] values = new MeasureDefinition.MeasureValue[this.measures.length];
        int i = 0;
        while (i < this.measures.length) {
            MeasureDefinition measure = this.measures[i];
            values[i] = new MeasureDefinition.MeasureValue(measure);
            switch (measure.getCalculation()) {
                case AVERAGE: 
                case VARIANCE: {
                    values[i].setHelper(values[i - 2], (byte)1);
                    values[i].setHelper(values[i - 1], (byte)0);
                    break;
                }
                case STANDARD_DEVIATION: {
                    values[i].setHelper(values[i - 1], (byte)2);
                }
                case DISTINCT_COUNT: {
                    values[i].setHelper(values[i - 1], (byte)0);
                }
            }
            ++i;
        }
        return values;
    }

    protected MeasureDefinition.MeasureValue[] initUserMeasureValues() {
        MeasureDefinition.MeasureValue[] vals = new MeasureDefinition.MeasureValue[this.origMeasureCount];
        int c = 0;
        int i = 0;
        while (i < this.measures.length) {
            if (!this.measures[i].isSystemDefined()) {
                vals[c] = new MeasureDefinition.MeasureValue(this.measures[i]);
                ++c;
            }
            ++i;
        }
        return vals;
    }

    public void processData() throws JRException {
        if (!this.processed) {
            if (this.dataCount > 0L && (this.allBuckets[this.rowBucketCount - 1].computeTotal() || this.allBuckets[this.allBuckets.length - 1].computeTotal())) {
                this.computeTotals(this.columnBucketMap);
                this.computeTotals(this.bucketValueMap);
            }
            this.processed = true;
        }
    }

    public boolean hasData() {
        return this.dataCount > 0L;
    }

    public MeasureDefinition.MeasureValue[] getMeasureValues(BucketDefinition.Bucket[] bucketValues) {
        BucketMap map = this.bucketValueMap;
        int i = 0;
        while (map != null && i < this.allBuckets.length - 1) {
            map = (BucketMap)map.get(bucketValues[i]);
            ++i;
        }
        return map == null ? null : (MeasureDefinition.MeasureValue[])map.get(bucketValues[this.allBuckets.length - 1]);
    }

    public MeasureDefinition.MeasureValue[] getUserMeasureValues(MeasureDefinition.MeasureValue[] values) {
        MeasureDefinition.MeasureValue[] vals = new MeasureDefinition.MeasureValue[this.origMeasureCount];
        int c = 0;
        int i = 0;
        while (i < this.measures.length) {
            if (!this.measures[i].isSystemDefined()) {
                vals[c] = values[i];
                ++c;
            }
            ++i;
        }
        return vals;
    }

    public MeasureDefinition.MeasureValue[] getZeroUserMeasureValues() {
        return this.zeroUserMeasureValues;
    }

    public MeasureDefinition.MeasureValue[] getGrandTotals() {
        BucketMap map = this.bucketValueMap;
        int i = 0;
        while (map != null && i < this.allBuckets.length - 1) {
            map = (BucketMap)map.getTotalEntry().getValue();
            ++i;
        }
        return map == null ? null : (MeasureDefinition.MeasureValue[])map.getTotalEntry().getValue();
    }

    protected void computeTotals(BucketMap bucketMap) throws JRException {
        boolean dimension;
        boolean bl = dimension = bucketMap.level >= this.rowBucketCount;
        if (dimension && !this.allBuckets[this.allBuckets.length - 1].computeTotal()) {
            return;
        }
        if (!bucketMap.last) {
            Iterator<Map.Entry<BucketDefinition.Bucket, Object>> it = bucketMap.entryIterator();
            while (it.hasNext()) {
                Map.Entry<BucketDefinition.Bucket, Object> entry = it.next();
                this.computeTotals((BucketMap)entry.getValue());
            }
        }
        if (this.allBuckets[bucketMap.level].computeTotal()) {
            if (dimension) {
                this.computeColumnTotal(bucketMap);
            } else {
                this.computeRowTotals(bucketMap);
            }
        }
    }

    protected void sumVals(MeasureDefinition.MeasureValue[] totals, MeasureDefinition.MeasureValue[] vals) throws JRException {
        int i = 0;
        while (i < this.measures.length) {
            totals[i].addValue(vals[i]);
            ++i;
        }
    }

    protected void computeColumnTotal(BucketMap bucketMap) throws JRException {
        MeasureDefinition.MeasureValue[] totals = this.initMeasureValues();
        Iterator<Map.Entry<BucketDefinition.Bucket, Object>> it = bucketMap.entryIterator();
        while (it.hasNext()) {
            MapEntry entry = it.next();
            int i = bucketMap.level + 1;
            while (i < this.allBuckets.length) {
                entry = ((BucketMap)entry.getValue()).getTotalEntry();
                ++i;
            }
            this.sumVals(totals, (MeasureDefinition.MeasureValue[])entry.getValue());
        }
        int i = bucketMap.level + 1;
        while (i < this.allBuckets.length) {
            bucketMap = bucketMap.addTotalNextMap();
            ++i;
        }
        bucketMap.addTotalEntry(totals);
    }

    protected void computeRowTotals(BucketMap bucketMap) throws JRException {
        BucketMapMap totals = this.createRowTotalsBucketMap();
        Iterator<Map.Entry<BucketDefinition.Bucket, Object>> it = bucketMap.entryIterator();
        while (it.hasNext()) {
            MapEntry entry = it.next();
            int i = bucketMap.level + 1;
            while (i < this.rowBucketCount) {
                entry = ((BucketMap)entry.getValue()).getTotalEntry();
                ++i;
            }
            totals.sumValues((BucketMap)entry.getValue());
        }
        BucketMap totalBucketMap = bucketMap;
        int i = bucketMap.level + 1;
        while (i < this.rowBucketCount) {
            totalBucketMap = totalBucketMap.addTotalNextMap();
            ++i;
        }
        totalBucketMap.addTotalEntry(totals);
    }

    protected void checkBucketMeasureCount(int bucketMeasureCount) {
        if (this.bucketMeasureLimit > 0 && bucketMeasureCount > this.bucketMeasureLimit) {
            throw new JRRuntimeException("Crosstab bucket/measure limit (" + this.bucketMeasureLimit + ") exceeded.");
        }
    }

    public BucketDefinition[] getRowBuckets() {
        return this.buckets[0];
    }

    protected class BucketListMap
    extends BucketMap {
        List<Map.Entry<BucketDefinition.Bucket, Object>> entries;
        Map<BucketDefinition.Bucket, Object> entryMap;

        BucketListMap(int level) {
            super(level);
            this.entries = new ArrayList<Map.Entry<BucketDefinition.Bucket, Object>>();
            this.entryMap = new HashMap<BucketDefinition.Bucket, Object>();
        }

        @Override
        void clear() {
            this.entries.clear();
            this.entryMap.clear();
        }

        @Override
        public Iterator<Map.Entry<BucketDefinition.Bucket, Object>> entryIterator() {
            return this.entries.iterator();
        }

        private void add(BucketDefinition.Bucket key, Object value) {
            this.entries.add(new MapEntry(key, value));
            this.entryMap.put(key, value);
        }

        @Override
        public Object get(BucketDefinition.Bucket key) {
            return this.entryMap.get(key);
        }

        /*
         * Unable to fully structure code
         */
        @Override
        MeasureDefinition.MeasureValue[] insertMeasureValues(BucketDefinition.Bucket[] bucketValues, boolean createValues, int offset) {
            i = offset;
            levelObj = this;
            map = null;
            while (i < BucketingService.this.allBuckets.length) {
                map = levelObj;
                size = map.entries.size();
                if (size == 0) break;
                lastEntry = (MapEntry)map.entries.get(size - 1);
                if (!lastEntry.key.equals(bucketValues[i])) break;
                ++i;
                levelObj = lastEntry.value;
            }
            if (i != BucketingService.this.allBuckets.length) ** GOTO lbl19
            return (MeasureDefinition.MeasureValue[])levelObj;
lbl-1000:
            // 1 sources

            {
                nextMap = new BucketListMap(i + 1);
                map.add(bucketValues[i], nextMap);
                map = nextMap;
                ++i;
lbl19:
                // 2 sources

                ** while (i < BucketingService.this.allBuckets.length - 1)
            }
lbl20:
            // 1 sources

            if (createValues) {
                values = BucketingService.this.initMeasureValues();
                BucketingService.this.bucketMeasuresCreated();
            } else {
                values = BucketingService.this.zeroMeasureValues;
            }
            map.add(bucketValues[i], values);
            return values;
        }

        @Override
        public int size() {
            return this.entries.size();
        }

        @Override
        void addTotalEntry(Object value) {
            this.add(this.totalKey, value);
        }

        @Override
        public Object getTotal() {
            MapEntry totalEntry = this.getTotalEntry();
            return totalEntry == null ? null : totalEntry.getValue();
        }

        @Override
        public MapEntry getTotalEntry() {
            MapEntry lastEntry = (MapEntry)this.entries.get(this.entries.size() - 1);
            if (lastEntry.key.isTotal()) {
                return lastEntry;
            }
            return null;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append('{');
            Iterator<Map.Entry<BucketDefinition.Bucket, Object>> it = this.entries.iterator();
            while (it.hasNext()) {
                Map.Entry<BucketDefinition.Bucket, Object> entry = it.next();
                sb.append(entry);
                if (!it.hasNext()) continue;
                sb.append(", ");
            }
            sb.append('}');
            return sb.toString();
        }
    }

    public abstract class BucketMap {
        final int level;
        final boolean last;
        final BucketDefinition.Bucket totalKey;

        BucketMap(int level) {
            this.level = level;
            this.last = level == BucketingService.this.allBuckets.length - 1;
            this.totalKey = BucketingService.this.allBuckets[level].VALUE_TOTAL;
        }

        BucketMap addTotalNextMap() {
            BucketMap nextMap = BucketingService.this.createBucketMap(this.level + 1);
            this.addTotalEntry(nextMap);
            return nextMap;
        }

        abstract void clear();

        public abstract Iterator<Map.Entry<BucketDefinition.Bucket, Object>> entryIterator();

        public abstract Object get(BucketDefinition.Bucket var1);

        abstract MeasureDefinition.MeasureValue[] insertMeasureValues(BucketDefinition.Bucket[] var1, boolean var2, int var3);

        abstract void addTotalEntry(Object var1);

        public abstract int size();

        public abstract Object getTotal();

        public abstract MapEntry getTotalEntry();
    }

    protected class BucketMapMap
    extends BucketMap {
        Map<BucketDefinition.Bucket, Object> map;

        BucketMapMap(int level, boolean sortedMap) {
            super(level);
            this.map = sortedMap ? new TreeMap() : new LinkedHashMap();
        }

        @Override
        void clear() {
            this.map.clear();
        }

        @Override
        public Iterator<Map.Entry<BucketDefinition.Bucket, Object>> entryIterator() {
            return this.map.entrySet().iterator();
        }

        @Override
        public Object get(BucketDefinition.Bucket key) {
            return this.map.get(key);
        }

        @Override
        MeasureDefinition.MeasureValue[] insertMeasureValues(BucketDefinition.Bucket[] bucketValues, boolean createValues, int offset) {
            BucketMapMap levelMap = this;
            int i = offset;
            while (i < bucketValues.length - 1) {
                BucketMapMap nextMap = (BucketMapMap)levelMap.get(bucketValues[i]);
                if (nextMap == null) {
                    nextMap = BucketingService.this.createBucketMapMap(i + 1);
                    levelMap.map.put(bucketValues[i], nextMap);
                }
                levelMap = nextMap;
                ++i;
            }
            MeasureDefinition.MeasureValue[] values = (MeasureDefinition.MeasureValue[])levelMap.get(bucketValues[bucketValues.length - 1]);
            if (values == null) {
                if (createValues) {
                    values = BucketingService.this.initMeasureValues();
                    BucketingService.this.bucketMeasuresCreated();
                } else {
                    values = BucketingService.this.zeroMeasureValues;
                }
                levelMap.map.put(bucketValues[bucketValues.length - 1], values);
            }
            return values;
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        void addTotalEntry(Object value) {
            this.map.put(this.totalKey, value);
        }

        @Override
        public Object getTotal() {
            return this.get(this.totalKey);
        }

        @Override
        public MapEntry getTotalEntry() {
            Object value = this.get(this.totalKey);
            return value == null ? null : new MapEntry(this.totalKey, value);
        }

        void copyEntries(BucketMap bucketMap) {
            Iterator<Map.Entry<BucketDefinition.Bucket, Object>> bucketIterator = bucketMap.entryIterator();
            while (bucketIterator.hasNext()) {
                Object copyBucketValue;
                Map.Entry<BucketDefinition.Bucket, Object> bucketEntry = bucketIterator.next();
                BucketDefinition.Bucket bucketKey = bucketEntry.getKey();
                if (bucketMap.last) {
                    copyBucketValue = BucketingService.this.initMeasureValues();
                } else {
                    BucketMap bucketSubMap = (BucketMap)bucketEntry.getValue();
                    BucketMapMap copyBucketSubMap = new BucketMapMap(this.level + 1, false);
                    copyBucketSubMap.copyEntries(bucketSubMap);
                    copyBucketValue = copyBucketSubMap;
                }
                this.map.put(bucketKey, copyBucketValue);
            }
        }

        void sumValues(BucketMap bucketMap) throws JRException {
            Iterator<Map.Entry<BucketDefinition.Bucket, Object>> it = bucketMap.entryIterator();
            while (it.hasNext()) {
                Map.Entry<BucketDefinition.Bucket, Object> entry = it.next();
                Object value = this.get(entry.getKey());
                if (this.last) {
                    BucketingService.this.sumVals((MeasureDefinition.MeasureValue[])value, (MeasureDefinition.MeasureValue[])entry.getValue());
                    continue;
                }
                ((BucketMapMap)value).sumValues((BucketMap)entry.getValue());
            }
        }

        public String toString() {
            return this.map.toString();
        }
    }

    protected static class MapEntry
    implements Map.Entry<BucketDefinition.Bucket, Object>,
    Comparable<MapEntry> {
        final BucketDefinition.Bucket key;
        final Object value;

        MapEntry(BucketDefinition.Bucket key, Object value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public BucketDefinition.Bucket getKey() {
            return this.key;
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        @Override
        public Object setValue(Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int compareTo(MapEntry o) {
            return this.key.compareTo(o.key);
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }
}

