/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.MessageFormat;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.export.HtmlResourceHandler;

public class FileHtmlResourceHandler
implements HtmlResourceHandler {
    private File parentFolder;
    private String pathPattern;

    public FileHtmlResourceHandler(File parentFolder, String pathPattern) {
        this.parentFolder = parentFolder;
        this.pathPattern = pathPattern;
    }

    public FileHtmlResourceHandler(File parentFolder) {
        this(parentFolder, null);
    }

    @Override
    public String getResourcePath(String id) {
        if (this.pathPattern == null) {
            return id;
        }
        return MessageFormat.format(this.pathPattern, id);
    }

    @Override
    public void handleResource(String id, byte[] data) {
        this.ensureParentFolder();
        FileOutputStream fos = null;
        try {
            try {
                fos = new FileOutputStream(new File(this.parentFolder, id));
                fos.write(data);
            }
            catch (IOException e) {
                throw new JRRuntimeException(e);
            }
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    throw new JRRuntimeException(e);
                }
            }
        }
    }

    private void ensureParentFolder() {
        if (this.parentFolder == null) {
            throw new JRRuntimeException("The resources directory was not specified for the exporter.");
        }
        if (!this.parentFolder.exists()) {
            this.parentFolder.mkdir();
        }
    }
}

