/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.gui.pendencia;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.table.AbstractTableModel;
import serpro.ppgd.gui.pendencia.LinhaPendencia;
import serpro.ppgd.negocio.Pendencia;
import serpro.ppgd.negocio.util.UtilitariosArquivo;
import serpro.ppgd.negocio.util.UtilitariosString;

public class TableModelPendencia
extends AbstractTableModel {
    private static final ImageIcon ICO_ERRO_EXTENDIDO = new ImageIcon(UtilitariosArquivo.localizaArquivoEmClasspath((String)"/icones/erro-desc.png"));
    private static final ImageIcon ICO_AVISO_EXTENDIDO = new ImageIcon(UtilitariosArquivo.localizaArquivoEmClasspath((String)"/icones/aviso-desc.png"));
    protected String[] nomeColunas;
    protected List<Pendencia> lstPendencia;
    protected List<LinhaPendencia> lstPendenciaTable;
    protected int numMinLinhas;
    protected int numLinhasTitulo;
    protected int totalAvisos;
    protected int totalErros;
    protected int[] tamColunas;
    private Map<String, String> classesFichas = new HashMap<String, String>();
    protected int posicaoQuebraDeLinhaMensagem = 90;

    public TableModelPendencia(String[] nomeColunas, int numMinLinhas, int[] pTamColunas, List<Pendencia> lstPendencia) {
        this.nomeColunas = nomeColunas;
        this.lstPendencia = lstPendencia;
        this.lstPendenciaTable = this.montaTableListaPendencia(lstPendencia);
        this.numMinLinhas = numMinLinhas;
        this.tamColunas = pTamColunas;
    }

    @Override
    public int getColumnCount() {
        return this.nomeColunas.length;
    }

    @Override
    public int getRowCount() {
        if (this.numMinLinhas > this.lstPendenciaTable.size()) {
            return this.numMinLinhas;
        }
        return this.lstPendenciaTable.size();
    }

    @Override
    public String getColumnName(int col) {
        return this.nomeColunas[col];
    }

    @Override
    public Object getValueAt(int row, int col) {
        LinhaPendencia linhaPendencia = this.getLinhaPendenciaAt(row);
        if (linhaPendencia != null) {
            switch (col) {
                case 0: {
                    if (linhaPendencia.getSeveridade() == 3) {
                        return ICO_ERRO_EXTENDIDO;
                    }
                    if (linhaPendencia.getSeveridade() == 2) {
                        return ICO_AVISO_EXTENDIDO;
                    }
                    return null;
                }
                case 1: {
                    if (linhaPendencia.getSeveridade() == 0) {
                        String texto = linhaPendencia.getCampo();
                        texto = texto.replaceAll("<BR>", " ");
                        texto = texto.replaceAll("\n", " ");
                        texto = texto.replaceAll("<HTML>", " ");
                        texto = texto.replaceAll("</HTML>", " ");
                        return "<html><b>" + texto + "</b></html>";
                    }
                    String texto = linhaPendencia.getCampo();
                    texto = texto.replaceAll("<BR>", " ");
                    texto = texto.replaceAll("\n", " ");
                    texto = texto.replaceAll("<HTML>", " ");
                    texto = texto.replaceAll("</HTML>", " ");
                    texto = "<html>" + UtilitariosString.insereQuebraDeLinha((String)texto, (int)130, (String)"<br>") + "</html>";
                    return texto;
                }
            }
        }
        return "";
    }

    @Override
    public Class<?> getColumnClass(int c) {
        if (c == 0) {
            return ImageIcon.class;
        }
        return String.class;
    }

    public Pendencia getPendenciaAt(int index) {
        LinhaPendencia linha = this.getLinhaPendenciaAt(index);
        if (linha == null) {
            return null;
        }
        return linha.getPendencia();
    }

    public LinhaPendencia getLinhaPendenciaAt(int index) {
        if (index < this.lstPendenciaTable.size()) {
            return this.lstPendenciaTable.get(index);
        }
        return null;
    }

    public int getTotalAvisos() {
        return this.totalAvisos;
    }

    public int getTotalErros() {
        return this.totalErros;
    }

    public List<LinhaPendencia> getListaPendencias() {
        return this.lstPendenciaTable;
    }

    protected List<LinhaPendencia> montaTableListaPendencia(List<Pendencia> lstPendencia) {
        ArrayList<LinhaPendencia> listaPendencia = new ArrayList<LinhaPendencia>(lstPendencia.size());
        int contaLinhasTitulo = 0;
        String tituloFichaAnterior = "";
        String item = "";
        String itemPendente = "";
        for (int i = 0; i < lstPendencia.size(); ++i) {
            if (lstPendencia.get(i) == null) continue;
            Pendencia pendencia = lstPendencia.get(i);
            String tituloFichaAtual = pendencia.getCampoInformacao() != null ? pendencia.getCampoInformacao().getFicha() : pendencia.getColecao().getFicha();
            byte severidade = pendencia.getSeveridade();
            if (!tituloFichaAtual.equals(tituloFichaAnterior)) {
                if (severidade == 2 || severidade == 3 || severidade == 5) {
                    listaPendencia.add(new LinhaPendencia(0, tituloFichaAtual, null));
                }
                tituloFichaAnterior = tituloFichaAtual;
                ++contaLinhasTitulo;
            }
            if (i != 0 && !tituloFichaAtual.equals(tituloFichaAnterior) || i > 0 && pendencia.getCampoInformacao() == lstPendencia.get(i - 1).getCampoInformacao() && pendencia.getNumItem() == lstPendencia.get(i - 1).getNumItem()) continue;
            item = "";
            if (pendencia.getNumItem() >= 1) {
                item = this.getLabelNumeracaoItem(pendencia);
            }
            if (item.equals("")) {
                itemPendente = pendencia.getMsg();
            } else {
                String msgPendencia = pendencia.getMsg();
                if (msgPendencia.endsWith(".")) {
                    msgPendencia = msgPendencia.substring(0, msgPendencia.length() - 1);
                }
                itemPendente = msgPendencia + item;
            }
            if (itemPendente.equals("")) continue;
            switch (severidade) {
                case 2: {
                    ++this.totalAvisos;
                    break;
                }
                case 3: {
                    ++this.totalErros;
                    break;
                }
                case 5: {
                    ++this.totalErros;
                }
            }
            if (severidade != 2 && severidade != 3 && severidade != 5) continue;
            listaPendencia.add(new LinhaPendencia(severidade, itemPendente, pendencia));
        }
        this.numLinhasTitulo = contaLinhasTitulo;
        return listaPendencia;
    }

    private void atualizaClassesFichas() {
        Pendencia pendencia = null;
        Iterator<LinhaPendencia> it = this.getListaPendencias().iterator();
        this.classesFichas.clear();
        while (it.hasNext()) {
            pendencia = it.next().getPendencia();
            if (pendencia == null) continue;
            String classePainel = pendencia.getClassePainel();
            if (classePainel == null) {
                System.err.println("Aten\u00e7\u00e3o: adicionando pend\u00eancia com classe de painel nula. N\u00e3o foi implementado o ObjetoFicha? Pend\u00eancia: " + pendencia.getMsg());
            }
            this.classesFichas.put(pendencia.getCampoInformacao().getFicha(), classePainel);
        }
    }

    public int[] getTamColunas() {
        return this.tamColunas;
    }

    public void setTamColunas(int[] tamColunas) {
        this.tamColunas = tamColunas;
    }

    public int getNumMinLinhas() {
        return this.numMinLinhas;
    }

    public void setNumMinLinhas(int numMinLinhas) {
        this.numMinLinhas = numMinLinhas;
    }

    public void atualizaPendencias(List<Pendencia> pLstPendencia) {
        this.lstPendencia = pLstPendencia;
        this.totalAvisos = 0;
        this.totalErros = 0;
        this.lstPendenciaTable = this.montaTableListaPendencia(this.lstPendencia);
        this.atualizaClassesFichas();
        this.fireTableDataChanged();
    }

    public int getPosicaoQuebraDeLinhaMensagem() {
        return this.posicaoQuebraDeLinhaMensagem;
    }

    public void setPosicaoQuebraDeLinhaMensagem(int posicaoQuebraDeLinhaMensagem) {
        this.posicaoQuebraDeLinhaMensagem = posicaoQuebraDeLinhaMensagem;
    }

    public String getLabelNumeracaoItem(Pendencia pendencia) {
        return " - Item n\u00ba " + pendencia.getNumItem();
    }

    public Map<String, String> getClassesFichas() {
        return this.classesFichas;
    }
}

