/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.gui.xbeans;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.UIManager;
import javax.swing.event.EventListenerList;
import serpro.ppgd.gui.xbeans.BotaoItemIf;
import serpro.ppgd.gui.xbeans.GroupPanelEvent;
import serpro.ppgd.gui.xbeans.GroupPanelListener;
import serpro.ppgd.gui.xbeans.JButtonMensagem;
import serpro.ppgd.gui.xbeans.JEditCampo;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.Informacao;

public class JButtonGroupPanel
extends JEditCampo
implements ActionListener,
FocusListener,
ItemListener {
    private static final Color COR_HABILITADO = UIManager.getColor("Label.enabledForeground");
    private static final Color COR_DESABILITADO = UIManager.getColor("Label.disabledForeground");
    private ButtonGroup buttonGroup = new ButtonGroup();
    private Map<Component, Component> buttons = new LinkedHashMap<Component, Component>();
    private boolean selecaoMultipla = false;
    private String delimitadorOpcoes = "#";
    private EventListenerList listeners = new EventListenerList();

    public JButtonGroupPanel() {
        super((Informacao<?>)new Alfa(null, "", 20));
        this.setBorder(BorderFactory.createEtchedBorder());
    }

    private void preparaFocusListener(AbstractButton btn) {
        btn.addFocusListener(this);
    }

    public JButtonGroupPanel(Alfa campo) {
        super((Informacao<?>)campo);
    }

    public JButtonGroupPanel(Alfa campo, String idAjuda) {
        super((Informacao<?>)campo, idAjuda);
    }

    @Override
    protected void instanciaComponentes() {
        this.buttonGroup = new ButtonGroup();
        this.buttons = new Hashtable<Component, Component>();
        this.selecaoMultipla = false;
    }

    @Override
    public int getBaseline(int width, int height) {
        return -1;
    }

    @Override
    public Component.BaselineResizeBehavior getBaselineResizeBehavior() {
        return Component.BaselineResizeBehavior.OTHER;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            this.actionPerformed(new ActionEvent(e.getSource(), e.getID(), "Selected"));
        } else if (e.getStateChange() == 2) {
            // empty if block
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() != null && e.getSource() instanceof BotaoItemIf) {
            String strVal = this.montaConteudo();
            this.setIdentificacaoFoco(false);
            if (!this.getInformacao().getListaValidadoresImpeditivos().isEmpty() && !this.verificaValidacoesImpeditivas(strVal)) {
                return;
            }
            this.setarCampo(e, strVal);
            this.chamaValidacao();
        }
    }

    private String montaConteudo() {
        Iterator<Component> iter = this.buttons.values().iterator();
        StringBuilder strVal = new StringBuilder();
        while (iter.hasNext()) {
            AbstractButton radio = (AbstractButton)iter.next();
            if (!radio.isSelected()) continue;
            strVal.append(((BotaoItemIf)((Object)radio)).getValorSelecionadoTrue());
            strVal.append(this.delimitadorOpcoes);
        }
        if (strVal.toString().endsWith(this.delimitadorOpcoes)) {
            strVal.deleteCharAt(strVal.length() - 1);
        }
        return strVal.toString();
    }

    public void setarCampo(ActionEvent e, String strVal) {
        this.getInformacao().setConteudo(strVal);
        GroupPanelEvent evt = new GroupPanelEvent(e.getSource());
        evt.setInformacao(this.getInformacao());
        this.fireAtualizaPanel(evt);
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
    }

    private void fireAtualizaPanel(GroupPanelEvent evt) {
        GroupPanelListener[] navListeners = (GroupPanelListener[])this.listeners.getListeners(GroupPanelListener.class);
        for (int i = 0; i < navListeners.length; ++i) {
            navListeners[i].atualizaPainel(evt);
        }
    }

    public void addGroupPanelListener(GroupPanelListener listener) {
        this.listeners.add(GroupPanelListener.class, listener);
    }

    public void removeGroupPanelListener(GroupPanelListener listener) {
        this.listeners.remove(GroupPanelListener.class, listener);
    }

    @Override
    public Component add(Component comp, int index) {
        this.adicionaOpcao(comp);
        return super.add(comp, index);
    }

    public void adicionaOpcao(Component comp) {
        comp.setEnabled(this.isEnabled());
        if (comp instanceof JRadioButton) {
            JRadioButton radio = (JRadioButton)comp;
            radio.addItemListener(this);
            this.buttons.put(comp, comp);
            if (!this.isSelecaoMultipla()) {
                this.buttonGroup.add((AbstractButton)comp);
            }
            ((BotaoItemIf)((Object)comp)).setEstiloFonte(this.getEstiloFonte());
            ((BotaoItemIf)((Object)comp)).setIncrementoTamanhoFonte(this.getIncrementoTamanhoFonte());
            this.conteudoPropertyChange(null);
            if (this.getInformacao() != null) {
                this.readOnlyPropertyChange(this.getInformacao().isReadOnly());
            }
        } else if (comp instanceof BotaoItemIf) {
            ((AbstractButton)comp).addActionListener(this);
            this.buttons.put(comp, comp);
            if (!this.isSelecaoMultipla()) {
                this.buttonGroup.add((AbstractButton)comp);
            }
            ((BotaoItemIf)((Object)comp)).setEstiloFonte(this.getEstiloFonte());
            ((BotaoItemIf)((Object)comp)).setIncrementoTamanhoFonte(this.getIncrementoTamanhoFonte());
            this.conteudoPropertyChange(null);
            if (this.getInformacao() != null) {
                this.readOnlyPropertyChange(this.getInformacao().isReadOnly());
            }
        } else if (comp instanceof JButtonMensagem) {
            this.setButtonMensagem((JButtonMensagem)comp);
        }
    }

    @Override
    public void add(Component comp, Object constraints, int index) {
        this.adicionaOpcao(comp);
        super.add(comp, constraints, index);
    }

    @Override
    public void add(Component comp, Object constraints) {
        this.adicionaOpcao(comp);
        super.add(comp, constraints);
    }

    @Override
    public Component add(Component comp) {
        this.adicionaOpcao(comp);
        return super.add(comp);
    }

    @Override
    public Component add(String name, Component comp) {
        this.adicionaOpcao(comp);
        return super.add(name, comp);
    }

    @Override
    public void remove(Component comp) {
        if (this.buttons != null && comp instanceof BotaoItemIf) {
            this.buttons.remove(comp);
            this.buttonGroup.remove((AbstractButton)comp);
        }
        super.remove(comp);
    }

    @Override
    public void removeAll() {
        if (this.buttons != null) {
            this.buttons.clear();
            this.removeDoButtonGroup(true);
        }
        super.removeAll();
    }

    private void removeDoButtonGroup(boolean removeListener) {
        this.buttonGroup = new ButtonGroup();
        for (AbstractButton abstractButton : this.buttons.values()) {
            abstractButton.getModel().setGroup(null);
            if (!removeListener) continue;
            abstractButton.removeActionListener(this);
        }
    }

    public boolean isSelecaoMultipla() {
        return this.selecaoMultipla;
    }

    public void setSelecaoMultipla(boolean selecaoMul) {
        this.selecaoMultipla = selecaoMul;
        this.removeDoButtonGroup(false);
        if (!this.isSelecaoMultipla()) {
            this.readicionaAoButtonGroup();
        }
    }

    private void readicionaAoButtonGroup() {
        Iterator<Component> it = this.buttons.values().iterator();
        while (it.hasNext()) {
            this.buttonGroup.add((AbstractButton)it.next());
        }
    }

    @Override
    protected void buildComponente() {
    }

    @Override
    protected void informacaoModificada() {
        this.conteudoPropertyChange(null);
    }

    @Override
    protected void readOnlyPropertyChange(boolean readOnly) {
        this.setEnabled(!readOnly);
        for (AbstractButton abstractButton : this.buttons.values()) {
            abstractButton.setEnabled(!readOnly);
            abstractButton.setForeground(readOnly ? COR_DESABILITADO : COR_HABILITADO);
        }
        if (this.getButtonMensagem() != null) {
            this.getButtonMensagem().setEnabled(!readOnly);
        }
    }

    @Override
    protected void habilitadoPropertyChange(boolean habilitado) {
        this.setEnabled(habilitado);
        for (AbstractButton abstractButton : this.buttons.values()) {
            abstractButton.setEnabled(habilitado);
        }
        if (this.getButtonMensagem() != null) {
            this.getButtonMensagem().setEnabled(habilitado);
        }
    }

    @Override
    public void conteudoPropertyChange(PropertyChangeEvent evt) {
        this.removeDoButtonGroup(false);
        this.readicionaAoButtonGroup();
        if (this.getInformacao().isVazio()) {
            for (AbstractButton abstractButton : this.buttons.values()) {
                abstractButton.setSelected(false);
            }
        } else {
            Hashtable<String, AbstractButton> listaTemp = new Hashtable<String, AbstractButton>();
            for (AbstractButton abstractButton : this.buttons.values()) {
                listaTemp.put(((BotaoItemIf)((Object)abstractButton)).getValorSelecionadoTrue(), abstractButton);
            }
            StringTokenizer stringTokenizer = new StringTokenizer(this.getInformacao().asString(), this.delimitadorOpcoes);
            while (stringTokenizer.hasMoreTokens()) {
                String opt = stringTokenizer.nextToken();
                AbstractButton radio = (AbstractButton)listaTemp.get(opt);
                if (radio == null) continue;
                radio.setSelected(true);
            }
        }
    }

    @Override
    public JComponent getComponenteEditor() {
        if (!this.buttons.isEmpty()) {
            return (AbstractButton)this.buttons.values().toArray()[0];
        }
        return this;
    }

    @Override
    public JComponent getComponenteFoco() {
        if (!this.buttons.isEmpty()) {
            return (AbstractButton)this.buttons.values().toArray()[0];
        }
        return this;
    }

    @Override
    public void setEstiloFonte(int estilo) {
        Font f = this.getFont();
        f = f == null ? new JLabel().getFont() : f;
        f = f.deriveFont(estilo);
        this.setFont(f);
        for (BotaoItemIf botaoItemIf : this.buttons.values()) {
            botaoItemIf.setEstiloFonte(estilo);
        }
    }

    public int getEstiloFonte() {
        Font f = this.getFont();
        if (f == null) {
            return 0;
        }
        return f.getStyle();
    }

    @Override
    public void setIncrementoTamanhoFonte(int incremento) {
        this.incrementoTamanhoFonte = incremento;
        Font f = new JLabel().getFont();
        if (this.tamanhoOriginal == -1.0f) {
            this.tamanhoOriginal = f.getSize2D();
        }
        f = f.deriveFont(this.tamanhoOriginal + (float)incremento);
        this.setFont(f);
        for (BotaoItemIf botaoItemIf : this.buttons.values()) {
            botaoItemIf.setIncrementoTamanhoFonte(incremento);
        }
    }

    @Override
    public int getIncrementoTamanhoFonte() {
        return this.incrementoTamanhoFonte;
    }

    public ButtonGroup getGroup() {
        return this.buttonGroup;
    }
}

