/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.gui.xbeans;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.IOException;
import java.util.Random;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.TransferHandler;
import serpro.ppgd.gui.xbeans.JEditMascara;
import serpro.ppgd.negocio.CNPJ;
import serpro.ppgd.negocio.CPF;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.NI;
import serpro.ppgd.negocio.util.FabricaUtilitarios;
import serpro.ppgd.negocio.util.UtilitariosString;

public class JEditNI
extends JEditMascara
implements FocusListener {
    private static String maskara14 = "**************";
    private static String maskara18 = "******************";
    private static String maskara11 = "***********";
    private static String maskaraCPF = "***.***.***-**";
    private static String maskaraCNPJ = "**.***.***/****-**";
    private static String caracteresValidos = "0123456789./- ";
    private byte tiposAceitos = 0;

    public JEditNI() {
        this((Informacao)new NI(null, "NI"));
        this.componente.setTransferHandler(new TransferHandler("text"){

            @Override
            public int getSourceActions(JComponent c) {
                return 3;
            }

            @Override
            protected Transferable createTransferable(JComponent c) {
                JTextField txt = (JTextField)c;
                return new StringSelection(txt.getText());
            }

            @Override
            protected void exportDone(JComponent source, Transferable data, int action) {
                super.exportDone(source, data, action);
            }

            @Override
            public boolean canImport(TransferHandler.TransferSupport support) {
                return support.isDataFlavorSupported(DataFlavor.stringFlavor);
            }

            @Override
            public boolean importData(TransferHandler.TransferSupport support) {
                if (!this.canImport(support)) {
                    return false;
                }
                Transferable t = support.getTransferable();
                try {
                    String data = (String)t.getTransferData(DataFlavor.stringFlavor);
                    JTextField txt = (JTextField)support.getComponent();
                    data = UtilitariosString.retiraMascara((String)data);
                    txt.setText(data);
                }
                catch (UnsupportedFlavorException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return true;
            }
        });
    }

    public JEditNI(Informacao campo) {
        this.setInformacao(campo);
        this.setCaracteresValidos(caracteresValidos);
        this.getComponenteEditor().addFocusListener(this);
        Boolean testes = Boolean.valueOf(FabricaUtilitarios.getProperties().getProperty("versao_testes", "false"));
        if (testes.booleanValue()) {
            this.getComponenteEditor().getInputMap().put(KeyStroke.getKeyStroke("F7"), "gerarNI");
            this.getComponenteEditor().getActionMap().put("gerarNI", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JEditNI.this.getInformacao().clear();
                    if (JEditNI.this.tiposAceitos == 1) {
                        JEditNI.this.getInformacao().setConteudo(CPF.gerarAleatorio());
                    } else if (JEditNI.this.tiposAceitos == 2) {
                        JEditNI.this.getInformacao().setConteudo(CNPJ.gerarAleatorio());
                    } else {
                        Random random = new Random();
                        if (random.nextInt(2) == 0) {
                            JEditNI.this.getInformacao().setConteudo(CPF.gerarAleatorio());
                        } else {
                            JEditNI.this.getInformacao().setConteudo(CNPJ.gerarAleatorio());
                        }
                    }
                }
            });
        }
    }

    public void setarMascaraCPF() {
        this.getInformacao().setConteudo(this.getInformacao().asString().trim());
        this.setMascara(maskaraCPF);
        this.setCaracteresValidos(caracteresValidos);
    }

    public void setarMascaraCNPJ() {
        this.setMascara(maskaraCNPJ);
        this.setCaracteresValidos(caracteresValidos);
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.aplicaMascaraCorrespondente(this.getInformacao());
    }

    @Override
    public void focusGained(FocusEvent e) {
        String txt = UtilitariosString.retiraMascara((String)this.componente.getText());
        if (this.tiposAceitos == 0 || this.tiposAceitos == 2) {
            this.setMascara(maskara14);
        } else {
            this.setMascara(maskara11);
        }
        this.setCaracteresValidos(caracteresValidos);
        this.componente.setText(txt);
    }

    private void aplicaMascaraCorrespondente(Informacao campo) {
        if (campo.asString().length() == 11 && (this.tiposAceitos == 0 || this.tiposAceitos == 1)) {
            this.setarMascaraCPF();
        } else if (campo.asString().length() == 14) {
            this.setarMascaraCNPJ();
        } else {
            this.setMascara(maskara14);
        }
    }

    @Override
    protected void informacaoModificada() {
        super.informacaoModificada();
        this.aplicaMascaraCorrespondente(this.getInformacao());
    }

    public void setTiposAceitos(byte tiposAceitos) {
        this.tiposAceitos = tiposAceitos;
    }
}

