/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.gui.xbeans;

import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import serpro.ppgd.gui.xbeans.JEditObjetoNegocioItemIf;
import serpro.ppgd.negocio.util.LogPPGD;
import serpro.ppgd.negocio.util.UtilitariosString;

class KeySelectionCustomizadoObjNegocio
implements JComboBox.KeySelectionManager {
    long ultimaVez = 0L;
    String filtro = "";
    int colunaFiltro;

    public KeySelectionCustomizadoObjNegocio(int aColunaFiltro) {
        this.colunaFiltro = aColunaFiltro;
    }

    public int selectionForKey(char aKey, ComboBoxModel aModel) {
        int itemSelecionado = -1;
        if (this.colunaFiltro < 0) {
            LogPPGD.erro((String)"N\u00e3o foi especificada nenhuma coluna-filtro para o Combo!");
            LogPPGD.erro((String)"N\u00e3o ser\u00e1 poss\u00edvel fazer filtragem por teclado");
            LogPPGD.erro((String)"");
        } else {
            long atual = System.currentTimeMillis();
            long diferenca = atual - this.ultimaVez;
            if (diferenca < 500L) {
                this.filtro = this.filtro + aKey;
                itemSelecionado = this.tentaSelecionar(aModel);
            } else {
                this.filtro = "";
                this.filtro = this.filtro + aKey;
                itemSelecionado = this.tentaSelecionar(aModel);
            }
            this.ultimaVez = atual;
            if (this.filtro.length() > 100) {
                this.filtro = "";
            }
        }
        return itemSelecionado;
    }

    private synchronized int tentaSelecionar(ComboBoxModel aModel) {
        int total = aModel.getSize();
        int itemSelecionado = -1;
        String upperFiltro = this.filtro.toUpperCase();
        for (int i = 0; i < total; ++i) {
            JEditObjetoNegocioItemIf elem = (JEditObjetoNegocioItemIf)aModel.getElementAt(i);
            String item = UtilitariosString.removeAcentos((String)elem.getConteudo(this.colunaFiltro));
            if (!item.toUpperCase().startsWith(upperFiltro)) continue;
            itemSelecionado = i;
            break;
        }
        return itemSelecionado;
    }
}

