/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.persistenciagenerica;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.xml.bind.annotation.adapters.HexBinaryAdapter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import serpro.ppgd.negocio.Colecao;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.util.FabricaUtilitarios;
import serpro.ppgd.negocio.util.LogPPGD;
import serpro.ppgd.persistenciagenerica.BackupInexistenteException;
import serpro.ppgd.persistenciagenerica.HashInvalidoException;
import serpro.ppgd.persistenciagenerica.RepositorioGenericoIf;
import serpro.ppgd.repositorio.repositorioXML.RepositorioXMLException;

public class RepositorioXMLDefault
implements RepositorioGenericoIf {
    private Map<String, ObjetoNegocio> cacheObjetosAbertos;
    private static RepositorioXMLDefault instancia;
    private boolean manterCache = true;

    public static RepositorioXMLDefault getInstancia() {
        return instancia != null ? instancia : (instancia = new RepositorioXMLDefault());
    }

    public void setManterCache(boolean manterCache) {
        this.manterCache = manterCache;
        if (!manterCache) {
            this.zeraCache();
        }
    }

    public boolean isManterCache() {
        return this.manterCache;
    }

    public void zeraCache() {
        this.getCacheObjetosAbertos().clear();
    }

    @Override
    public ObjetoNegocio getObjeto(String pathArquivoXML) throws RepositorioXMLException, HashInvalidoException {
        FabricaUtilitarios.getCacheTempToReflection().clear();
        if (this.manterCache && this.getCacheObjetosAbertos().containsKey(pathArquivoXML)) {
            return this.getCacheObjetosAbertos().get(pathArquivoXML);
        }
        Document arquivoDados = this.leArquivo(pathArquivoXML);
        if (arquivoDados == null) {
            return null;
        }
        String classe = arquivoDados.getDocumentElement().getAttribute("classeJava");
        ObjetoNegocio retorno = this.instanciaObjetoNegocio(classe);
        this.preencheObjetoNegocio(arquivoDados.getDocumentElement(), null, retorno);
        if (this.manterCache) {
            this.getCacheObjetosAbertos().put(pathArquivoXML, retorno);
        }
        return retorno;
    }

    public boolean temObjetoNegocioEmCache(String pathArquivoXML) {
        return this.manterCache && this.getCacheObjetosAbertos().containsKey(pathArquivoXML);
    }

    public boolean temObjetoPersistido(String pathArquivoXML) {
        File f = new File(pathArquivoXML);
        return f.exists();
    }

    public ObjetoNegocio preencheObjeto(ObjetoNegocio obj, String pathArquivoXML, boolean armazenaEmCache) throws RepositorioXMLException, HashInvalidoException {
        FabricaUtilitarios.getCacheTempToReflection().clear();
        Document arquivoDados = this.leArquivo(pathArquivoXML);
        if (arquivoDados == null) {
            return null;
        }
        String classe = arquivoDados.getDocumentElement().getAttribute("classeJava");
        this.preencheObjetoNegocio(arquivoDados.getDocumentElement(), null, obj);
        if (this.manterCache && armazenaEmCache) {
            this.getCacheObjetosAbertos().put(pathArquivoXML, obj);
        }
        return obj;
    }

    @Override
    public void salvar(ObjetoNegocio obj, String pathArquivoXML) throws RepositorioXMLException {
        FabricaUtilitarios.getCacheTempToReflection().clear();
        if (this.manterCache && !this.getCacheObjetosAbertos().containsKey(pathArquivoXML)) {
            this.getCacheObjetosAbertos().put(pathArquivoXML, obj);
        }
        try {
            Document cacheDados = this.obterDOM(obj);
            File arquivoXML = new File(pathArquivoXML);
            FileOutputStream os = new FileOutputStream(arquivoXML);
            StreamResult result = new StreamResult(os);
            DOMSource source = new DOMSource(cacheDados);
            TransformerFactory transFactory = TransformerFactory.newInstance();
            Transformer transformer = transFactory.newTransformer();
            transformer.transform(source, result);
            os.close();
            this.salvarHash(pathArquivoXML);
        }
        catch (Exception e) {
            throw new RepositorioXMLException(e);
        }
    }

    public void validarHashXML(String pathArquivo) throws HashInvalidoException {
        if (pathArquivo.endsWith("iddeclaracoes.xml")) {
            return;
        }
        if (FabricaUtilitarios.isWindows() && (pathArquivo.startsWith("/") || pathArquivo.startsWith("\\"))) {
            pathArquivo = pathArquivo.substring(1);
        }
        if (!Files.exists(Paths.get(pathArquivo, new String[0]), new LinkOption[0])) {
            return;
        }
        String pathConf = pathArquivo.substring(0, pathArquivo.length() - 4) + ".conf";
        String hashCalc = this.gerarHash(pathArquivo);
        String hashLido = null;
        try (BufferedReader br = new BufferedReader(new FileReader(pathConf));){
            hashLido = br.readLine();
        }
        catch (FileNotFoundException e) {
            FabricaUtilitarios.printStackEmDesenvolvimento((Exception)e);
        }
        catch (IOException e) {
            FabricaUtilitarios.printStackEmDesenvolvimento((Exception)e);
        }
        if (hashLido == null || !hashCalc.equals(hashLido)) {
            throw new HashInvalidoException(pathArquivo, hashLido, hashCalc);
        }
    }

    public String gerarHash(String pathArquivo) {
        if (FabricaUtilitarios.isWindows() && (pathArquivo.startsWith("/") || pathArquivo.startsWith("\\"))) {
            pathArquivo = pathArquivo.substring(1);
        }
        String finalHash = null;
        Path path = Paths.get(pathArquivo, new String[0]);
        try {
            String xorHex;
            byte[] data = Files.readAllBytes(path);
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            byte[] dataDigest = md.digest(data);
            String ppgdId = FabricaUtilitarios.getPPGDId();
            byte[] ppgdIdDigest = md.digest(ppgdId.getBytes("ISO-8859-1"));
            byte[] xorBytes = new byte[dataDigest.length];
            for (int i = 0; i < dataDigest.length && i < ppgdIdDigest.length; ++i) {
                xorBytes[i] = (byte)(dataDigest[i] << 1 ^ ppgdIdDigest[i] >> 1);
            }
            finalHash = xorHex = new HexBinaryAdapter().marshal(xorBytes);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return finalHash;
    }

    public void salvarHash(String pathArquivo) {
        String hash = this.gerarHash(pathArquivo);
        if (hash == null) {
            return;
        }
        String pathConf = pathArquivo.substring(0, pathArquivo.length() - 4) + ".conf";
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(pathConf), StandardCharsets.UTF_8));){
            writer.write(hash);
        }
        catch (IOException e) {
            FabricaUtilitarios.printStackEmDesenvolvimento((Exception)e);
        }
    }

    public void fazerBackup(String pathArquivoXML) {
        if (FabricaUtilitarios.isWindows() && (pathArquivoXML.startsWith("/") || pathArquivoXML.startsWith("\\"))) {
            pathArquivoXML = pathArquivoXML.substring(1);
        }
        if (pathArquivoXML.endsWith("iddeclaracoes.xml")) {
            return;
        }
        Path source = Paths.get(pathArquivoXML, new String[0]);
        Path target = Paths.get(pathArquivoXML.substring(0, pathArquivoXML.length() - 4) + ".BKP", new String[0]);
        try {
            Files.copy(source, target, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    public void restaurarBackup(String strPathArquivoXML) throws BackupInexistenteException {
        if (FabricaUtilitarios.isWindows() && (strPathArquivoXML.startsWith("/") || strPathArquivoXML.startsWith("\\"))) {
            strPathArquivoXML = strPathArquivoXML.substring(1);
        }
        if (strPathArquivoXML.endsWith("iddeclaracoes.xml")) {
            return;
        }
        Path pathXML = Paths.get(strPathArquivoXML, new String[0]);
        Path pathBKP = Paths.get(strPathArquivoXML.substring(0, strPathArquivoXML.length() - 4) + ".BKP", new String[0]);
        if (!pathBKP.toFile().exists()) {
            throw new BackupInexistenteException(pathBKP.toString());
        }
        try {
            Files.copy(pathBKP, pathXML, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    public void excluirBackup(String strPathArquivoXML) throws BackupInexistenteException {
        if (FabricaUtilitarios.isWindows() && (strPathArquivoXML.startsWith("/") || strPathArquivoXML.startsWith("\\"))) {
            strPathArquivoXML = strPathArquivoXML.substring(1);
        }
        if (strPathArquivoXML.endsWith("iddeclaracoes.xml")) {
            return;
        }
        Path pathXML = Paths.get(strPathArquivoXML, new String[0]);
        Path pathBKP = Paths.get(strPathArquivoXML.substring(0, strPathArquivoXML.length() - 4) + ".BKP", new String[0]);
        if (!pathBKP.toFile().exists()) {
            throw new BackupInexistenteException(pathBKP.toString());
        }
        try {
            Files.delete(pathBKP);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    private void excluirHash(String pathArquivoXML) {
        String pathConf = pathArquivoXML.substring(0, pathArquivoXML.length() - 4) + ".conf";
        File f = new File(pathConf);
        f.delete();
    }

    @Override
    public void excluir(String pathArquivoXML) throws RepositorioXMLException {
        String arq = pathArquivoXML;
        this.excluirHash(pathArquivoXML);
        File f = new File(arq);
        f.delete();
        if (this.manterCache && this.getCacheObjetosAbertos().containsKey(pathArquivoXML)) {
            this.getCacheObjetosAbertos().remove(pathArquivoXML);
        }
    }

    private void preencheObjetoNegocio(Element nodoAtual, Element nodoPai, ObjetoNegocio objetoNegocio) throws RepositorioXMLException {
        NamedNodeMap namedNodeMap = nodoAtual.getAttributes();
        for (Field f : FabricaUtilitarios.getAllFields(objetoNegocio.getClass())) {
            if (Modifier.isTransient(f.getModifiers())) continue;
            try {
                Informacao info = (Informacao)FabricaUtilitarios.getValorFieldGenerico((String)f.getName(), (Object)objetoNegocio);
                Node item = namedNodeMap.getNamedItem(f.getName());
                info.setConteudo(item.getNodeValue());
            }
            catch (Exception info) {}
        }
        if (objetoNegocio instanceof Colecao) {
            this.preencheColecao(nodoAtual, (Colecao)objetoNegocio);
        } else {
            NodeList nodeList = nodoAtual.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                ObjetoNegocio obj;
                Node nodo = nodeList.item(i);
                if (!(nodo instanceof Element) || (obj = (ObjetoNegocio)FabricaUtilitarios.getValorFieldGenerico((String)nodo.getNodeName(), (Object)objetoNegocio)) == null) continue;
                this.preencheObjetoNegocio((Element)nodo, nodoAtual, obj);
            }
        }
    }

    private void preencheColecao(Element nodoAtual, Colecao colecao) throws RepositorioXMLException {
        NamedNodeMap namedNodeMap = nodoAtual.getAttributes();
        for (Field f : FabricaUtilitarios.getAllFields(colecao.getClass())) {
            if (Modifier.isTransient(f.getModifiers())) continue;
            try {
                Informacao info = (Informacao)FabricaUtilitarios.getValorFieldGenerico((String)f.getName(), (Object)colecao);
                Node item = namedNodeMap.getNamedItem(f.getName());
                info.setConteudo(item.getNodeValue());
            }
            catch (Exception info) {}
        }
        NodeList nodeList = nodoAtual.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node nodo = nodeList.item(i);
            if (!(nodo instanceof Element) || !nodo.getNodeName().equals("item")) continue;
            ObjetoNegocio obj = colecao.instanciaNovoObjeto();
            this.preencheObjetoNegocio((Element)nodo, nodoAtual, obj);
            colecao.recuperarLista().add(obj);
        }
    }

    private void preencheElementoXML(Document documentoXML, Element nodoAtual, Element nodoPai, ObjetoNegocio objetoNegocio) {
        if (nodoPai != null) {
            nodoPai.appendChild(nodoAtual);
        }
        for (Field field : FabricaUtilitarios.getAllFields(objetoNegocio.getClass())) {
            if (Modifier.isTransient(field.getModifiers())) continue;
            Object valorAtributo = FabricaUtilitarios.getValorFieldGenerico((String)field.getName(), (Object)objetoNegocio);
            if (valorAtributo instanceof Informacao) {
                if (!((Informacao)valorAtributo).isAtributoPersistente() || valorAtributo == null) continue;
                nodoAtual.setAttribute(field.getName(), ((Informacao)valorAtributo).getConteudoFormatado());
                continue;
            }
            if (!(valorAtributo instanceof ObjetoNegocio)) continue;
            Element novoNodo = documentoXML.createElement(field.getName());
            this.preencheElementoXML(documentoXML, novoNodo, nodoAtual, (ObjetoNegocio)valorAtributo);
            if (!(valorAtributo instanceof Colecao)) continue;
            novoNodo.setAttribute("tipoItens", ((Colecao)valorAtributo).getTipoItens().getName());
            this.preencheElementoXMLColecao(documentoXML, novoNodo, nodoAtual, (Colecao)valorAtributo);
        }
    }

    private void preencheElementoXMLColecao(Document documentoXML, Element nodoAtual, Element nodoPai, Colecao colecao) {
        Iterator itItems = colecao.recuperarLista().iterator();
        while (itItems.hasNext()) {
            Element novoNodo = documentoXML.createElement("item");
            ObjetoNegocio obj = (ObjetoNegocio)itItems.next();
            this.preencheElementoXML(documentoXML, novoNodo, nodoAtual, obj);
        }
    }

    private Document obterDOM(ObjetoNegocio objetoNegocio) throws RepositorioXMLException {
        Document declaracaoDOM = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            declaracaoDOM = builder.newDocument();
            Element root = declaracaoDOM.createElement("classe");
            declaracaoDOM.appendChild(root);
            root.setAttribute("classeJava", objetoNegocio.getClass().getName());
            root.setAttribute("xmlns", ConstantesGlobais.XMLNS);
            if (objetoNegocio instanceof Colecao) {
                root.setAttribute("tipoItens", ((Colecao)objetoNegocio).getTipoItens().getName());
                this.preencheElementoXML(declaracaoDOM, root, null, objetoNegocio);
                this.preencheElementoXMLColecao(declaracaoDOM, root, null, (Colecao)objetoNegocio);
            } else {
                this.preencheElementoXML(declaracaoDOM, root, null, objetoNegocio);
            }
            declaracaoDOM.normalize();
            return declaracaoDOM;
        }
        catch (ParserConfigurationException e) {
            LogPPGD.erro((String)("Erro de configura\u00e7\u00e3o da f\u00e1brica DOM: " + e.getMessage()));
            throw new RepositorioXMLException(e);
        }
    }

    private String calculateHashCode(Document document) {
        DOMSource domSource = new DOMSource(document);
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        TransformerFactory tf = TransformerFactory.newInstance();
        try {
            Transformer transformer = tf.newTransformer();
            transformer.transform(domSource, result);
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            String s1 = "SERPRODE5GD";
            String hex = new HexBinaryAdapter().marshal(md.digest((writer.toString() + s1).getBytes()));
            return hex;
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
    }

    private ObjetoNegocio instanciaObjetoNegocio(String pClasseAInstanciar) throws RepositorioXMLException {
        ObjetoNegocio resultado = null;
        try {
            Class<?> classeAInstanciar = Class.forName(pClasseAInstanciar);
            if (!Class.forName(ObjetoNegocio.class.getName()).isAssignableFrom(classeAInstanciar)) {
                throw new RepositorioXMLException("A classe n\u00e3o \u00e9 um objeto de neg\u00f3cio");
            }
            Constructor<?> construtor = classeAInstanciar.getConstructor(new Class[0]);
            resultado = (ObjetoNegocio)construtor.newInstance(new Object[0]);
            return resultado;
        }
        catch (InvocationTargetException e) {
            throw new RepositorioXMLException(e);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RepositorioXMLException(e);
        }
    }

    private Document leArquivo(String pathArquivoDados) throws HashInvalidoException {
        this.validarHashXML(pathArquivoDados);
        Document declaracaoDOM = null;
        File fileArquivoDados = new File(pathArquivoDados);
        if (pathArquivoDados == null || !fileArquivoDados.exists()) {
            return null;
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            declaracaoDOM = builder.parse(fileArquivoDados);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            FabricaUtilitarios.printStackEmDesenvolvimento((Exception)e);
        }
        return declaracaoDOM;
    }

    public Map<String, ObjetoNegocio> getCacheObjetosAbertos() {
        if (this.cacheObjetosAbertos == null) {
            this.cacheObjetosAbertos = new Hashtable<String, ObjetoNegocio>();
        }
        return this.cacheObjetosAbertos;
    }

    static {
        FabricaUtilitarios.usaCacheParaReflexao = true;
        instancia = null;
    }
}

