/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.repositorio.embeddedDB.util;

import java.io.File;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.Valor;
import serpro.ppgd.negocio.util.FabricaUtilitarios;
import serpro.ppgd.negocio.util.LogPPGD;
import serpro.ppgd.negocio.util.UtilitariosArquivo;
import serpro.ppgd.repositorio.RepositorioException;

public abstract class UtilDB {
    public static String CAMINHO_DB_APLICACAO;
    protected static Connection conexao;

    public static Connection getConexao() throws RepositorioException {
        String pDriver = FabricaUtilitarios.getProperties().getProperty("aplicacao.persistencia.conexaoDB.driver");
        String pUrlConexao = FabricaUtilitarios.getProperties().getProperty("aplicacao.persistencia.conexaoDB.url");
        String pUsuario = FabricaUtilitarios.getProperties().getProperty("aplicacao.persistencia.conexaoDB.usuario");
        String pSenha = FabricaUtilitarios.getProperties().getProperty("aplicacao.persistencia.conexaoDB.senha");
        if (pDriver == null) {
            throw new RepositorioException("Est\u00e1 faltando a chave \"aplicacao.persistencia.conexaoDB.driver\" no arquivo de propriedades da aplica\u00e7\u00e3o");
        }
        if (pUrlConexao == null) {
            throw new RepositorioException("Est\u00e1 faltando a chave \"aplicacao.persistencia.conexaoDB.url\" no arquivo de propriedades da aplica\u00e7\u00e3o");
        }
        if (pUsuario == null) {
            throw new RepositorioException("Est\u00e1 faltando a chave \"aplicacao.persistencia.conexaoDB.usuario\" no arquivo de propriedades da aplica\u00e7\u00e3o");
        }
        if (conexao == null) {
            try {
                Class.forName(pDriver);
                conexao = DriverManager.getConnection(pUrlConexao.replaceAll("<caminho_db_aplicacao>", CAMINHO_DB_APLICACAO), pUsuario, pSenha);
            }
            catch (Exception e) {
                throw new RepositorioException("Erro ao criar conex\u00e3o com BD :" + e.getMessage());
            }
        }
        return conexao;
    }

    public static void preencheObjeto(ResultSet resultSet, Object pObj) throws RepositorioException {
        for (Field field : FabricaUtilitarios.getFieldsCamposInformacao(pObj.getClass())) {
            LogPPGD.debug((String)("field->" + field.getName()));
            Informacao valorAtributo = (Informacao)FabricaUtilitarios.getValorField((Field)field, (Object)pObj);
            if (valorAtributo instanceof Valor && ((Valor)valorAtributo).isCampoCalculado()) continue;
            try {
                valorAtributo.setConteudo(resultSet.getString(field.getName()));
                LogPPGD.debug((String)("preencheu Atributo:" + resultSet.getString(field.getName())));
            }
            catch (Exception exception) {}
        }
    }

    public static void finalizaConexao() {
        if (conexao != null) {
            try {
                conexao.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static int executarDDL(String comando) throws RepositorioException {
        try {
            Statement statement = UtilDB.getConexao().createStatement();
            int retorno = statement.executeUpdate(comando);
            statement.close();
            return retorno;
        }
        catch (SQLException e) {
            throw new RepositorioException("Erro na execu\u00e7\u00e3o do comando DDL :" + e.getMessage());
        }
    }

    static {
        conexao = null;
        CAMINHO_DB_APLICACAO = UtilitariosArquivo.getPathAplicacao() + "db" + File.separator;
    }
}

