/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.grammars.persistency;

import com.siemens.ct.exi.context.GrammarContext;
import com.siemens.ct.exi.context.GrammarUriContext;
import com.siemens.ct.exi.context.QNameContext;
import com.siemens.ct.exi.grammars.Grammars;
import com.siemens.ct.exi.grammars.event.StartElement;
import com.siemens.ct.exi.grammars.grammar.DocEnd;
import com.siemens.ct.exi.grammars.grammar.Document;
import com.siemens.ct.exi.grammars.grammar.Fragment;
import com.siemens.ct.exi.grammars.grammar.Grammar;
import com.siemens.ct.exi.grammars.grammar.SchemaInformedDocContent;
import com.siemens.ct.exi.grammars.grammar.SchemaInformedElement;
import com.siemens.ct.exi.grammars.grammar.SchemaInformedFirstStartTag;
import com.siemens.ct.exi.grammars.grammar.SchemaInformedFirstStartTagGrammar;
import com.siemens.ct.exi.grammars.grammar.SchemaInformedFragmentContent;
import com.siemens.ct.exi.grammars.grammar.SchemaInformedStartTag;
import com.siemens.ct.exi.grammars.persistency.GrammarIdDispenser;
import com.siemens.ct.exi.grammars.production.Production;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class GrammarsPreperation {
    protected GrammarIdDispenser grsIdDispenser = new GrammarIdDispenser();
    protected List<Grammar> sortedGrammars = new ArrayList<Grammar>();
    protected int numberOfFirstStartTagGrammars;
    protected int numberOfStartTagGrammars;
    protected int numberOfElementGrammars;

    public void clear() {
        this.grsIdDispenser.clear();
        this.sortedGrammars.clear();
        this.numberOfFirstStartTagGrammars = 0;
        this.numberOfStartTagGrammars = 0;
        this.numberOfElementGrammars = 0;
    }

    public void prepareGrammars(Grammars grammar) throws IOException {
        this.clear();
        Grammar doc = grammar.getDocumentGrammar();
        this.prepareGrammar(doc);
        Grammar frag = grammar.getFragmentGrammar();
        this.prepareGrammar(frag);
        GrammarContext gc = grammar.getGrammarContext();
        for (int uriId = 0; uriId < gc.getNumberOfGrammarUriContexts(); ++uriId) {
            GrammarUriContext guc = gc.getGrammarUriContext(uriId);
            for (int qnId = 0; qnId < guc.getNumberOfQNames(); ++qnId) {
                QNameContext qnc = guc.getQNameContext(qnId);
                SchemaInformedFirstStartTagGrammar typeGrammar = qnc.getTypeGrammar();
                if (typeGrammar == null) continue;
                this.prepareGrammar((Grammar)typeGrammar);
            }
        }
        this.sortedGrammars.clear();
        for (int k = 0; k < 8; ++k) {
            Iterator<Grammar> iterGrs = this.grsIdDispenser.getGrammarIterator();
            while (iterGrs.hasNext()) {
                Grammar r = iterGrs.next();
                switch (k) {
                    case 0: {
                        if (!(r instanceof Document)) break;
                        this.sortedGrammars.add(r);
                        break;
                    }
                    case 1: {
                        if (!(r instanceof SchemaInformedDocContent)) break;
                        this.sortedGrammars.add(r);
                        break;
                    }
                    case 2: {
                        if (!(r instanceof DocEnd)) break;
                        this.sortedGrammars.add(r);
                        break;
                    }
                    case 3: {
                        if (!(r instanceof Fragment)) break;
                        this.sortedGrammars.add(r);
                        break;
                    }
                    case 4: {
                        if (!(r instanceof SchemaInformedFragmentContent)) break;
                        this.sortedGrammars.add(r);
                        break;
                    }
                    case 5: {
                        if (!(r instanceof SchemaInformedFirstStartTag)) break;
                        ++this.numberOfFirstStartTagGrammars;
                        this.sortedGrammars.add(r);
                        break;
                    }
                    case 6: {
                        if (!(r instanceof SchemaInformedStartTag) || r instanceof SchemaInformedFirstStartTag) break;
                        ++this.numberOfStartTagGrammars;
                        this.sortedGrammars.add(r);
                        break;
                    }
                    case 7: {
                        if (!(r instanceof SchemaInformedElement)) break;
                        ++this.numberOfElementGrammars;
                        this.sortedGrammars.add(r);
                    }
                }
            }
        }
        System.out.println("Sorted Grammars: " + this.sortedGrammars);
    }

    void prepareGrammar(Grammar r) throws IOException {
        if (this.grsIdDispenser.isGrammarHandled(r)) {
            return;
        }
        this.grsIdDispenser.addHandledGrammar(r);
        int numberOfEvents = r.getNumberOfEvents();
        for (int eventCode = 0; eventCode < numberOfEvents; ++eventCode) {
            Production ei = r.getProduction(eventCode);
            switch (ei.getEvent().getEventType()) {
                case START_ELEMENT: {
                    StartElement se = (StartElement)ei.getEvent();
                    if (this.grsIdDispenser.isGrammarHandled(se.getGrammar())) break;
                    this.prepareGrammar(se.getGrammar());
                    break;
                }
            }
            this.prepareGrammar(ei.getNextGrammar());
        }
    }

    public int getGrammarID(Grammar r) {
        int id1 = this.grsIdDispenser.getGrammarID(r);
        Grammar g1 = this.grsIdDispenser.getGrammar(id1);
        for (int i = 0; i < this.sortedGrammars.size(); ++i) {
            Grammar g = this.sortedGrammars.get(i);
            if (g1 != g) continue;
            return i;
        }
        throw new RuntimeException("No grammar id found for: " + r);
    }

    public Grammar getGrammar(int id) {
        return this.sortedGrammars.get(id);
    }

    public int getNumberOfGrammars() {
        return this.sortedGrammars.size();
    }

    public int getNumberOfFirstStartTagGrammars() {
        return this.numberOfFirstStartTagGrammars;
    }

    public int getNumberOfStartTagGrammars() {
        return this.numberOfStartTagGrammars;
    }

    public int getNumberOfElementGrammars() {
        return this.numberOfElementGrammars;
    }
}

