/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.ItemQuadroAuxiliarAb;
import serpro.ppgd.irpf.ItemQuadroGanhosAcoesOuro;
import serpro.ppgd.negocio.Colecao;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.Valor;

public class ColecaoItemQuadroGanhosAcoesOuro
extends Colecao<ItemQuadroGanhosAcoesOuro> {
    private Valor totais = new Valor((ObjetoNegocio)this, "Totais");
    private WeakReference<DeclaracaoIRPF> dec = null;

    public ColecaoItemQuadroGanhosAcoesOuro() {
        this.getTotais().setReadOnly(true);
    }

    public Valor getTotais() {
        return this.totais;
    }

    public void objetoInserido(ItemQuadroGanhosAcoesOuro itemQuadroGanhosAcoesOuro) {
        itemQuadroGanhosAcoesOuro.getValor().addObservador((Observador)this);
        this.calculaTotal();
    }

    public void objetoRemovido(Object object) {
        ((ItemQuadroGanhosAcoesOuro)((Object)object)).getValor().removeObservador((Observador)this);
        this.calculaTotal();
    }

    private void calculaTotal() {
        Iterator iterator = this.itens().iterator();
        this.totais.clear();
        while (iterator.hasNext()) {
            ItemQuadroGanhosAcoesOuro itemQuadroGanhosAcoesOuro = (ItemQuadroGanhosAcoesOuro)((Object)iterator.next());
            this.totais.append('+', itemQuadroGanhosAcoesOuro.getValor());
        }
    }

    public void notifica(Object object, String string, Object object2, Object object3) {
        this.calculaTotal();
    }

    public ItemQuadroGanhosAcoesOuro obterPorCPF(String string) {
        for (ItemQuadroGanhosAcoesOuro itemQuadroGanhosAcoesOuro : this.itens()) {
            if (!itemQuadroGanhosAcoesOuro.getCpfBeneficiario().naoFormatado().equals(string)) continue;
            return itemQuadroGanhosAcoesOuro;
        }
        return null;
    }

    public boolean possuiDependenteComCPF(String string) {
        if ("".equals(string.trim())) {
            return false;
        }
        for (ItemQuadroGanhosAcoesOuro itemQuadroGanhosAcoesOuro : this.itens()) {
            if (!itemQuadroGanhosAcoesOuro.getTipoBeneficiario().naoFormatado().equals("Dependente") || !string.equals(itemQuadroGanhosAcoesOuro.getCpfBeneficiario().naoFormatado())) continue;
            return true;
        }
        return false;
    }

    public void excluirDependentesComCPF(String string) {
        Iterator iterator = this.itens().iterator();
        while (iterator.hasNext()) {
            ItemQuadroGanhosAcoesOuro itemQuadroGanhosAcoesOuro = (ItemQuadroGanhosAcoesOuro)((Object)iterator.next());
            if (!itemQuadroGanhosAcoesOuro.getTipoBeneficiario().naoFormatado().equals("Dependente") || !string.equals(itemQuadroGanhosAcoesOuro.getCpfBeneficiario().naoFormatado())) continue;
            iterator.remove();
        }
    }

    public Valor obterTotalPorCPF(String string, Valor valor) {
        Valor valor2 = new Valor();
        for (ItemQuadroGanhosAcoesOuro itemQuadroGanhosAcoesOuro : this.itens()) {
            if (!itemQuadroGanhosAcoesOuro.getCpfBeneficiario().naoFormatado().equals(string) || itemQuadroGanhosAcoesOuro.getValor() == valor) continue;
            valor2.append('+', itemQuadroGanhosAcoesOuro.getValor());
        }
        return valor2;
    }

    public Set<String> obterCPFsQueExcederamLimite() {
        String string;
        Object object2;
        HashMap<String, Valor> hashMap = new HashMap<String, Valor>();
        for (Object object2 : this.itens()) {
            string = ((ItemQuadroAuxiliarAb)((Object)object2)).getCpfBeneficiario().formatado();
            if (hashMap.containsKey(string)) {
                hashMap.put(string, ((Valor)hashMap.get(string)).operacao('+', ((ItemQuadroAuxiliarAb)((Object)object2)).getValor()));
                continue;
            }
            hashMap.put(string, ((ItemQuadroAuxiliarAb)((Object)object2)).getValor());
        }
        object2 = hashMap.keySet().iterator();
        while (object2.hasNext()) {
            string = (String)object2.next();
            if (((Valor)hashMap.get(string)).comparacao(">", "240.000,00")) continue;
            object2.remove();
        }
        return hashMap.keySet();
    }

    public ItemQuadroGanhosAcoesOuro instanciaNovoObjeto() {
        return new ItemQuadroGanhosAcoesOuro((DeclaracaoIRPF)((Object)this.dec.get()), this);
    }

    public WeakReference<DeclaracaoIRPF> getDec() {
        return this.dec;
    }

    public void setDec(WeakReference<DeclaracaoIRPF> weakReference) {
        this.dec = weakReference;
    }
}

