/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf;

import java.lang.ref.WeakReference;
import java.util.Iterator;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.ItemQuadroMeacaoDissolucao;
import serpro.ppgd.negocio.Colecao;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.Valor;

public class ColecaoItemQuadroMeacaoDissolucao
extends Colecao<ItemQuadroMeacaoDissolucao> {
    private Valor totais = new Valor((ObjetoNegocio)this, "Totais");
    private WeakReference<DeclaracaoIRPF> dec = null;

    public ColecaoItemQuadroMeacaoDissolucao() {
        this.getTotais().setReadOnly(true);
    }

    public Valor getTotais() {
        return this.totais;
    }

    public void objetoInserido(ItemQuadroMeacaoDissolucao itemQuadroMeacaoDissolucao) {
        itemQuadroMeacaoDissolucao.getValor().addObservador((Observador)this);
        this.calculaTotal();
    }

    public void objetoRemovido(Object object) {
        ((ItemQuadroMeacaoDissolucao)((Object)object)).getValor().removeObservador((Observador)this);
        this.calculaTotal();
    }

    private void calculaTotal() {
        Iterator iterator = this.itens().iterator();
        this.totais.clear();
        while (iterator.hasNext()) {
            ItemQuadroMeacaoDissolucao itemQuadroMeacaoDissolucao = (ItemQuadroMeacaoDissolucao)((Object)iterator.next());
            this.totais.append('+', itemQuadroMeacaoDissolucao.getValor());
        }
    }

    public void notifica(Object object, String string, Object object2, Object object3) {
        this.calculaTotal();
    }

    public ItemQuadroMeacaoDissolucao obterPorCPF(String string) {
        for (ItemQuadroMeacaoDissolucao itemQuadroMeacaoDissolucao : this.itens()) {
            if (!itemQuadroMeacaoDissolucao.getCpfBeneficiario().naoFormatado().equals(string)) continue;
            return itemQuadroMeacaoDissolucao;
        }
        return null;
    }

    public boolean possuiDependenteComCPF(String string) {
        if ("".equals(string.trim())) {
            return false;
        }
        for (ItemQuadroMeacaoDissolucao itemQuadroMeacaoDissolucao : this.itens()) {
            if (!itemQuadroMeacaoDissolucao.getTipoBeneficiario().naoFormatado().equals("Dependente") || !string.equals(itemQuadroMeacaoDissolucao.getCpfBeneficiario().naoFormatado())) continue;
            return true;
        }
        return false;
    }

    public void excluirDependentesComCPF(String string) {
        Iterator iterator = this.itens().iterator();
        while (iterator.hasNext()) {
            ItemQuadroMeacaoDissolucao itemQuadroMeacaoDissolucao = (ItemQuadroMeacaoDissolucao)((Object)iterator.next());
            if (!itemQuadroMeacaoDissolucao.getTipoBeneficiario().naoFormatado().equals("Dependente") || !string.equals(itemQuadroMeacaoDissolucao.getCpfBeneficiario().naoFormatado())) continue;
            iterator.remove();
        }
    }

    public ItemQuadroMeacaoDissolucao instanciaNovoObjeto() {
        return new ItemQuadroMeacaoDissolucao((DeclaracaoIRPF)((Object)this.dec.get()));
    }

    public WeakReference<DeclaracaoIRPF> getDec() {
        return this.dec;
    }

    public void setDec(WeakReference<DeclaracaoIRPF> weakReference) {
        this.dec = weakReference;
    }
}

