/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf;

import java.util.Iterator;
import serpro.ppgd.irpf.ItemQuadroPensaoAlimenticia;
import serpro.ppgd.irpf.rendacm.RendAcmTitular;
import serpro.ppgd.negocio.Colecao;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.Valor;

public class ColecaoItemQuadroPensaoAlimenticia
extends Colecao<ItemQuadroPensaoAlimenticia> {
    public static final int MAX_TAMANHO_DESCRICAO = 60;
    private transient RendAcmTitular rendAcm = null;
    private Valor totais = new Valor((ObjetoNegocio)this, "Totais");

    public ColecaoItemQuadroPensaoAlimenticia(RendAcmTitular rendAcmTitular) {
        this.getTotais().setReadOnly(true);
        this.rendAcm = rendAcmTitular;
    }

    public Valor getTotais() {
        return this.totais;
    }

    public void objetoInserido(ItemQuadroPensaoAlimenticia itemQuadroPensaoAlimenticia) {
        itemQuadroPensaoAlimenticia.getAlimentando().addObservador((Observador)this);
        itemQuadroPensaoAlimenticia.getValor().addObservador((Observador)this);
        this.recalculaTotal();
    }

    public void objetoRemovido(Object object) {
        ((ItemQuadroPensaoAlimenticia)((Object)object)).getAlimentando().removeObservador((Observador)this);
        ((ItemQuadroPensaoAlimenticia)((Object)object)).getValor().removeObservador((Observador)this);
        this.recalculaTotal();
    }

    public void recalculaTotal() {
        Iterator iterator = this.itens().iterator();
        this.totais.clear();
        while (iterator.hasNext()) {
            ItemQuadroPensaoAlimenticia itemQuadroPensaoAlimenticia = (ItemQuadroPensaoAlimenticia)((Object)iterator.next());
            this.totais.append('+', itemQuadroPensaoAlimenticia.getValor());
        }
    }

    public String getDescricoes() {
        String string = "";
        Iterator iterator = this.itens().iterator();
        this.totais.clear();
        while (iterator.hasNext()) {
            ItemQuadroPensaoAlimenticia itemQuadroPensaoAlimenticia = (ItemQuadroPensaoAlimenticia)((Object)iterator.next());
            if (!string.equals("")) {
                string = String.valueOf(string) + ", ";
            }
            string = String.valueOf(string) + itemQuadroPensaoAlimenticia.getAlimentando().naoFormatado();
        }
        if (string.length() > 60) {
            string = string.substring(0, 60);
        }
        return string;
    }

    public void notifica(Object object, String string, Object object2, Object object3) {
        this.recalculaTotal();
    }

    public boolean existeAlimentando(String string) {
        for (ItemQuadroPensaoAlimenticia itemQuadroPensaoAlimenticia : this.itens()) {
            if (itemQuadroPensaoAlimenticia.getAlimentando().naoFormatado().isEmpty() || !itemQuadroPensaoAlimenticia.getAlimentando().naoFormatado().equals(string)) continue;
            return true;
        }
        return false;
    }

    public void excluirAlimentando(String string) {
        Iterator iterator = this.itens().iterator();
        while (iterator.hasNext()) {
            ItemQuadroPensaoAlimenticia itemQuadroPensaoAlimenticia = (ItemQuadroPensaoAlimenticia)((Object)iterator.next());
            if (itemQuadroPensaoAlimenticia.getAlimentando().naoFormatado().isEmpty() || !itemQuadroPensaoAlimenticia.getAlimentando().naoFormatado().equals(string)) continue;
            iterator.remove();
        }
        this.recalculaTotal();
        this.rendAcm.getPensaoAlimenticia().setConteudo(this.totais);
    }

    public RendAcmTitular getRendAcm() {
        return this.rendAcm;
    }
}

