/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf;

import java.lang.ref.WeakReference;
import java.util.Iterator;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.ItemQuadroPensaoMolestiaGrave;
import serpro.ppgd.negocio.Colecao;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.Valor;

public class ColecaoItemQuadroPensaoMolestiaGrave
extends Colecao<ItemQuadroPensaoMolestiaGrave> {
    private Valor totais = new Valor((ObjetoNegocio)this, "Totais");
    private Valor totalRendimento = new Valor((ObjetoNegocio)this, "Total Rendimento");
    private Valor totalIRRFDependentes = new Valor((ObjetoNegocio)this, "Total IRRF Dependentes");
    private Valor totalIRRFTitular = new Valor((ObjetoNegocio)this, "Total IRRF do Titular");
    private Valor total13Salario = new Valor((ObjetoNegocio)this, "Total 13 Sal\u00e1rio");
    private Valor totalIRRF13SalarioDependentes = new Valor((ObjetoNegocio)this, "Total IRRF sobre o 13 Sal\u00e1rio");
    private Valor totalIRRF13SalarioTitular = new Valor((ObjetoNegocio)this, "Total IRRF sobre o 13 Sal\u00e1rio do Titular");
    private Valor totalPrevidenciaOficialTitular = new Valor((ObjetoNegocio)this, "Total Previd\u00eancia Oficial do Titular");
    private Valor totalPrevidenciaOficialDependentes = new Valor((ObjetoNegocio)this, "Total Previd\u00eancia Oficial dos Dependentes");
    private WeakReference<DeclaracaoIRPF> dec = null;

    public ColecaoItemQuadroPensaoMolestiaGrave() {
        this.getTotais().setReadOnly(true);
    }

    public Valor getTotais() {
        return this.totais;
    }

    public Valor getTotalRendimento() {
        return this.totalRendimento;
    }

    public Valor getTotalIRRFTitular() {
        return this.totalIRRFTitular;
    }

    public Valor getTotalIRRF13SalarioTitular() {
        return this.totalIRRF13SalarioTitular;
    }

    public Valor getTotalIRRFDependentes() {
        return this.totalIRRFDependentes;
    }

    public Valor getTotal13Salario() {
        return this.total13Salario;
    }

    public Valor getTotalIRRF13SalarioDependentes() {
        return this.totalIRRF13SalarioDependentes;
    }

    public Valor getTotalPrevidenciaOficialTitular() {
        return this.totalPrevidenciaOficialTitular;
    }

    public Valor getTotalPrevidenciaOficialDependentes() {
        return this.totalPrevidenciaOficialDependentes;
    }

    public void objetoInserido(ItemQuadroPensaoMolestiaGrave itemQuadroPensaoMolestiaGrave) {
        itemQuadroPensaoMolestiaGrave.getValor().addObservador((Observador)this);
        itemQuadroPensaoMolestiaGrave.getValorIRRF().addObservador((Observador)this);
        itemQuadroPensaoMolestiaGrave.getValor13Salario().addObservador((Observador)this);
        itemQuadroPensaoMolestiaGrave.getValorIRRF13Salario().addObservador((Observador)this);
        itemQuadroPensaoMolestiaGrave.getValorPrevidenciaOficial().addObservador((Observador)this);
        this.calculaTotal();
    }

    public void objetoRemovido(Object object) {
        ((ItemQuadroPensaoMolestiaGrave)((Object)object)).getValor().removeObservador((Observador)this);
        ((ItemQuadroPensaoMolestiaGrave)((Object)object)).getValorIRRF().removeObservador((Observador)this);
        ((ItemQuadroPensaoMolestiaGrave)((Object)object)).getValor13Salario().removeObservador((Observador)this);
        ((ItemQuadroPensaoMolestiaGrave)((Object)object)).getValorIRRF13Salario().removeObservador((Observador)this);
        ((ItemQuadroPensaoMolestiaGrave)((Object)object)).getValorPrevidenciaOficial().removeObservador((Observador)this);
        this.calculaTotal();
    }

    private void calculaTotal() {
        Valor valor = new Valor();
        Valor valor2 = new Valor();
        Valor valor3 = new Valor();
        Valor valor4 = new Valor();
        Valor valor5 = new Valor();
        Valor valor6 = new Valor();
        Valor valor7 = new Valor();
        Valor valor8 = new Valor();
        Valor valor9 = new Valor();
        for (ItemQuadroPensaoMolestiaGrave itemQuadroPensaoMolestiaGrave : this.itens()) {
            valor2.append('+', itemQuadroPensaoMolestiaGrave.getValor());
            valor3.append('+', (Valor)itemQuadroPensaoMolestiaGrave.getValor13Salario());
            if (itemQuadroPensaoMolestiaGrave.getTipoBeneficiario().naoFormatado().equals("Titular")) {
                valor5.append('+', (Valor)itemQuadroPensaoMolestiaGrave.getValorIRRF());
                valor7.append('+', (Valor)itemQuadroPensaoMolestiaGrave.getValorIRRF13Salario());
                valor9.append('+', (Valor)itemQuadroPensaoMolestiaGrave.getValorPrevidenciaOficial());
                continue;
            }
            valor4.append('+', (Valor)itemQuadroPensaoMolestiaGrave.getValorIRRF());
            valor6.append('+', (Valor)itemQuadroPensaoMolestiaGrave.getValorIRRF13Salario());
            valor8.append('+', (Valor)itemQuadroPensaoMolestiaGrave.getValorPrevidenciaOficial());
        }
        valor.append('+', valor2);
        valor.append('+', valor3);
        this.getTotais().setConteudo(valor);
        this.getTotalRendimento().setConteudo(valor2);
        this.getTotal13Salario().setConteudo(valor3);
        this.getTotalIRRFDependentes().setConteudo(valor4);
        this.getTotalIRRFTitular().setConteudo(valor5);
        this.getTotalIRRF13SalarioDependentes().setConteudo(valor6);
        this.getTotalIRRF13SalarioTitular().setConteudo(valor7);
        this.getTotalPrevidenciaOficialDependentes().setConteudo(valor8);
        this.getTotalPrevidenciaOficialTitular().setConteudo(valor9);
    }

    public void notifica(Object object, String string, Object object2, Object object3) {
        if (string.equals("Valor") || string.equals("Rendimento") || string.equals("IRRF") || string.equals("13\u00ba Sal\u00e1rio") || string.equals("IRRF sobre o 13\u00ba Sal\u00e1rio") || string.equals("Previd\u00eancia Oficial")) {
            this.calculaTotal();
        }
    }

    public boolean possuiDependenteComCPF(String string) {
        if ("".equals(string.trim())) {
            return false;
        }
        for (ItemQuadroPensaoMolestiaGrave itemQuadroPensaoMolestiaGrave : this.itens()) {
            if (!itemQuadroPensaoMolestiaGrave.getTipoBeneficiario().naoFormatado().equals("Dependente") || !string.equals(itemQuadroPensaoMolestiaGrave.getCpfBeneficiario().naoFormatado())) continue;
            return true;
        }
        return false;
    }

    public void excluirDependentesComCPF(String string) {
        Iterator iterator = this.itens().iterator();
        while (iterator.hasNext()) {
            ItemQuadroPensaoMolestiaGrave itemQuadroPensaoMolestiaGrave = (ItemQuadroPensaoMolestiaGrave)((Object)iterator.next());
            if (!itemQuadroPensaoMolestiaGrave.getTipoBeneficiario().naoFormatado().equals("Dependente") || !string.equals(itemQuadroPensaoMolestiaGrave.getCpfBeneficiario().naoFormatado())) continue;
            iterator.remove();
        }
    }

    public ItemQuadroPensaoMolestiaGrave instanciaNovoObjeto() {
        return new ItemQuadroPensaoMolestiaGrave((DeclaracaoIRPF)((Object)this.dec.get()));
    }

    public WeakReference<DeclaracaoIRPF> getDec() {
        return this.dec;
    }

    public void setDec(WeakReference<DeclaracaoIRPF> weakReference) {
        this.dec = weakReference;
    }
}

