/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf;

import java.lang.ref.WeakReference;
import java.util.Iterator;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.ItemQuadroRendimentosNI;
import serpro.ppgd.negocio.Colecao;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.Valor;

public class ColecaoItemQuadroRendimentosNI
extends Colecao<ItemQuadroRendimentosNI> {
    private Valor totais = new Valor((ObjetoNegocio)this, "Totais");
    private WeakReference<DeclaracaoIRPF> dec = null;

    public ColecaoItemQuadroRendimentosNI() {
        this.getTotais().setReadOnly(true);
    }

    public Valor getTotais() {
        return this.totais;
    }

    public void objetoInserido(ItemQuadroRendimentosNI itemQuadroRendimentosNI) {
        itemQuadroRendimentosNI.getValor().addObservador((Observador)this);
        this.calculaTotal();
    }

    public void objetoRemovido(Object object) {
        ((ItemQuadroRendimentosNI)((Object)object)).getValor().removeObservador((Observador)this);
        this.calculaTotal();
    }

    private void calculaTotal() {
        Iterator iterator = this.itens().iterator();
        this.totais.clear();
        while (iterator.hasNext()) {
            ItemQuadroRendimentosNI itemQuadroRendimentosNI = (ItemQuadroRendimentosNI)((Object)iterator.next());
            this.totais.append('+', itemQuadroRendimentosNI.getValor());
        }
    }

    public void notifica(Object object, String string, Object object2, Object object3) {
        this.calculaTotal();
    }

    public boolean possuiDependenteComCPF(String string) {
        if ("".equals(string.trim())) {
            return false;
        }
        for (ItemQuadroRendimentosNI itemQuadroRendimentosNI : this.itens()) {
            if (!itemQuadroRendimentosNI.getTipoBeneficiario().naoFormatado().equals("Dependente") || !string.equals(itemQuadroRendimentosNI.getCpfBeneficiario().naoFormatado())) continue;
            return true;
        }
        return false;
    }

    public void excluirDependentesComCPF(String string) {
        Iterator iterator = this.itens().iterator();
        while (iterator.hasNext()) {
            ItemQuadroRendimentosNI itemQuadroRendimentosNI = (ItemQuadroRendimentosNI)((Object)iterator.next());
            if (!itemQuadroRendimentosNI.getTipoBeneficiario().naoFormatado().equals("Dependente") || !string.equals(itemQuadroRendimentosNI.getCpfBeneficiario().naoFormatado())) continue;
            iterator.remove();
        }
    }

    public ItemQuadroRendimentosNI instanciaNovoObjeto() {
        return new ItemQuadroRendimentosNI((DeclaracaoIRPF)((Object)this.dec.get()));
    }

    public WeakReference<DeclaracaoIRPF> getDec() {
        return this.dec;
    }

    public void setDec(WeakReference<DeclaracaoIRPF> weakReference) {
        this.dec = weakReference;
    }
}

