/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf;

import java.lang.ref.WeakReference;
import java.util.Iterator;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.ItemQuadroTransferenciaPatrimonial;
import serpro.ppgd.negocio.Colecao;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.Valor;

public class ColecaoItemQuadroTransferenciaPatrimonial
extends Colecao<ItemQuadroTransferenciaPatrimonial> {
    private Valor totais = new Valor((ObjetoNegocio)this, "Totais");
    private WeakReference<DeclaracaoIRPF> dec = null;

    public ColecaoItemQuadroTransferenciaPatrimonial() {
        this.getTotais().setReadOnly(true);
    }

    public Valor getTotais() {
        return this.totais;
    }

    public void objetoInserido(ItemQuadroTransferenciaPatrimonial itemQuadroTransferenciaPatrimonial) {
        itemQuadroTransferenciaPatrimonial.getValor().addObservador((Observador)this);
        this.calculaTotal();
    }

    public void objetoRemovido(Object object) {
        ((ItemQuadroTransferenciaPatrimonial)((Object)object)).getValor().removeObservador((Observador)this);
        this.calculaTotal();
    }

    private void calculaTotal() {
        Iterator iterator = this.itens().iterator();
        this.totais.clear();
        while (iterator.hasNext()) {
            ItemQuadroTransferenciaPatrimonial itemQuadroTransferenciaPatrimonial = (ItemQuadroTransferenciaPatrimonial)((Object)iterator.next());
            this.totais.append('+', itemQuadroTransferenciaPatrimonial.getValor());
        }
    }

    public void notifica(Object object, String string, Object object2, Object object3) {
        this.calculaTotal();
    }

    public boolean possuiDependenteComCPF(String string) {
        if ("".equals(string.trim())) {
            return false;
        }
        for (ItemQuadroTransferenciaPatrimonial itemQuadroTransferenciaPatrimonial : this.itens()) {
            if (!itemQuadroTransferenciaPatrimonial.getTipoBeneficiario().naoFormatado().equals("Dependente") || !string.equals(itemQuadroTransferenciaPatrimonial.getCpfBeneficiario().naoFormatado())) continue;
            return true;
        }
        return false;
    }

    public void excluirDependentesComCPF(String string) {
        Iterator iterator = this.itens().iterator();
        while (iterator.hasNext()) {
            ItemQuadroTransferenciaPatrimonial itemQuadroTransferenciaPatrimonial = (ItemQuadroTransferenciaPatrimonial)((Object)iterator.next());
            if (!itemQuadroTransferenciaPatrimonial.getTipoBeneficiario().naoFormatado().equals("Dependente") || !string.equals(itemQuadroTransferenciaPatrimonial.getCpfBeneficiario().naoFormatado())) continue;
            iterator.remove();
        }
    }

    public ItemQuadroTransferenciaPatrimonial instanciaNovoObjeto() {
        return new ItemQuadroTransferenciaPatrimonial((DeclaracaoIRPF)((Object)this.dec.get()));
    }

    public WeakReference<DeclaracaoIRPF> getDec() {
        return this.dec;
    }

    public void setDec(WeakReference<DeclaracaoIRPF> weakReference) {
        this.dec = weakReference;
    }
}

