/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf;

import java.lang.ref.WeakReference;
import java.util.Iterator;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.ItemQuadroTransporteDetalhado;
import serpro.ppgd.negocio.Colecao;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.Valor;

public class ColecaoItemQuadroTransporteDetalhado
extends Colecao<ItemQuadroTransporteDetalhado> {
    private Valor totais = new Valor((ObjetoNegocio)this, "Totais");
    private WeakReference<DeclaracaoIRPF> dec = null;
    private boolean parcIsentaAposentadoria = false;
    private transient ObjetoNegocio parent;

    public ColecaoItemQuadroTransporteDetalhado() {
        this.getTotais().setReadOnly(true);
    }

    public ColecaoItemQuadroTransporteDetalhado(boolean bl2) {
        this();
        this.parcIsentaAposentadoria = bl2;
    }

    public ColecaoItemQuadroTransporteDetalhado(ObjetoNegocio objetoNegocio) {
        this();
        this.parent = objetoNegocio;
    }

    public Valor getTotais() {
        return this.totais;
    }

    public void objetoInserido(ItemQuadroTransporteDetalhado itemQuadroTransporteDetalhado) {
        itemQuadroTransporteDetalhado.getValor().addObservador((Observador)this);
        this.calculaTotal();
    }

    public void objetoRemovido(Object object) {
        ((ItemQuadroTransporteDetalhado)((Object)object)).getValor().removeObservador((Observador)this);
        this.calculaTotal();
    }

    private void calculaTotal() {
        Iterator iterator = this.itens().iterator();
        this.totais.clear();
        while (iterator.hasNext()) {
            ItemQuadroTransporteDetalhado itemQuadroTransporteDetalhado = (ItemQuadroTransporteDetalhado)((Object)iterator.next());
            this.totais.append('+', itemQuadroTransporteDetalhado.getValor());
        }
    }

    public void notifica(Object object, String string, Object object2, Object object3) {
        this.calculaTotal();
    }

    public boolean possuiDependenteComCPF(String string) {
        if ("".equals(string.trim())) {
            return false;
        }
        for (ItemQuadroTransporteDetalhado itemQuadroTransporteDetalhado : this.itens()) {
            if (!itemQuadroTransporteDetalhado.getTipoBeneficiario().naoFormatado().equals("Dependente") || !string.equals(itemQuadroTransporteDetalhado.getCpfBeneficiario().naoFormatado())) continue;
            return true;
        }
        return false;
    }

    public void excluirDependentesComCPF(String string) {
        Iterator iterator = this.itens().iterator();
        while (iterator.hasNext()) {
            ItemQuadroTransporteDetalhado itemQuadroTransporteDetalhado = (ItemQuadroTransporteDetalhado)((Object)iterator.next());
            if (!itemQuadroTransporteDetalhado.getTipoBeneficiario().naoFormatado().equals("Dependente") || !string.equals(itemQuadroTransporteDetalhado.getCpfBeneficiario().naoFormatado())) continue;
            iterator.remove();
        }
    }

    public ItemQuadroTransporteDetalhado instanciaNovoObjeto() {
        if (this.parcIsentaAposentadoria) {
            return new ItemQuadroTransporteDetalhado((DeclaracaoIRPF)((Object)this.dec.get()), this.parcIsentaAposentadoria);
        }
        if (this.parent == null) {
            return new ItemQuadroTransporteDetalhado((DeclaracaoIRPF)((Object)this.dec.get()));
        }
        return new ItemQuadroTransporteDetalhado((DeclaracaoIRPF)((Object)this.dec.get()), this.parent);
    }

    public WeakReference<DeclaracaoIRPF> getDec() {
        return this.dec;
    }

    public void setDec(WeakReference<DeclaracaoIRPF> weakReference) {
        this.dec = weakReference;
    }

    public ObjetoNegocio getParent() {
        return this.parent;
    }
}

