/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf;

import classes.cK;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import serpro.ppgd.irpf.C;
import serpro.ppgd.irpf.ColecaoIdDeclaracao;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.IdentificadorDeclaracao;
import serpro.ppgd.irpf.ModeloDeclaracao;
import serpro.ppgd.irpf.aa;
import serpro.ppgd.irpf.alimentandos.Alimentandos;
import serpro.ppgd.irpf.atividaderural.AtividadeRural;
import serpro.ppgd.irpf.bens.Bens;
import serpro.ppgd.irpf.comparativo.Comparativo;
import serpro.ppgd.irpf.conjuge.Conjuge;
import serpro.ppgd.irpf.contribuinte.Contribuinte;
import serpro.ppgd.irpf.dependentes.Dependentes;
import serpro.ppgd.irpf.dividas.Dividas;
import serpro.ppgd.irpf.doacoes.Doacoes;
import serpro.ppgd.irpf.eca.ColecaoEstatutoCriancaAdolescente;
import serpro.ppgd.irpf.eleicoes.DoacoesEleitorais;
import serpro.ppgd.irpf.espolio.Espolio;
import serpro.ppgd.irpf.gcap.GCAP;
import serpro.ppgd.irpf.herdeiros.Herdeiros;
import serpro.ppgd.irpf.impostopago.ImpostoPago;
import serpro.ppgd.irpf.pagamentos.Pagamentos;
import serpro.ppgd.irpf.rendIsentos.RendIsentos;
import serpro.ppgd.irpf.rendTributacaoExclusiva.RendTributacaoExclusiva;
import serpro.ppgd.irpf.rendacm.ColecaoRendAcmDependente;
import serpro.ppgd.irpf.rendacm.ColecaoRendAcmTitular;
import serpro.ppgd.irpf.rendacm.RendAcm;
import serpro.ppgd.irpf.rendavariavel.ColecaoFundosInvestimentosDependente;
import serpro.ppgd.irpf.rendavariavel.ColecaoRendaVariavelDependente;
import serpro.ppgd.irpf.rendavariavel.FundosInvestimentos;
import serpro.ppgd.irpf.rendavariavel.RendaVariavel;
import serpro.ppgd.irpf.rendpf.ColecaoRendPFDependente;
import serpro.ppgd.irpf.rendpf.RendPF;
import serpro.ppgd.irpf.rendpj.ColecaoRendPJDependente;
import serpro.ppgd.irpf.rendpj.ColecaoRendPJTitular;
import serpro.ppgd.irpf.rendpjexigibilidade.ColecaoRendPJComExigibilidadeDependente;
import serpro.ppgd.irpf.rendpjexigibilidade.ColecaoRendPJComExigibilidadeTitular;
import serpro.ppgd.irpf.resumo.Resumo;
import serpro.ppgd.irpf.saida.Saida;
import serpro.ppgd.negocio.DeclaracaoComIdentificador;
import serpro.ppgd.negocio.IdentificadorDeclaracaoXML;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.PPGDFacade;
import serpro.ppgd.negocio.Valor;
import serpro.ppgd.repositorio.repositorioXML.RepositorioXMLException;

public class IRPFFacade
implements PPGDFacade {
    private WeakReference<DeclaracaoIRPF> declaracaoEmGravacao = null;
    private static IRPFFacade instancia = null;
    private aa repositorioXMLIRPF = new aa();
    public static final String HASH_ALGORITMO_MD5 = "MD5";

    private IRPFFacade() {
    }

    public static IRPFFacade getInstancia() {
        if (instancia == null) {
            instancia = new IRPFFacade();
        }
        return instancia;
    }

    public static void abreDeclaracao(IdentificadorDeclaracao object) {
        try {
            IRPFFacade.getInstancia().repositorioXMLIRPF.abreDeclaracao((IdentificadorDeclaracaoXML)object);
            return;
        }
        catch (RepositorioXMLException repositorioXMLException) {
            object = repositorioXMLException;
            repositorioXMLException.printStackTrace();
            cK.a("excecao_inesperada");
            System.exit(1);
            return;
        }
    }

    public void restaurarBackup(IdentificadorDeclaracao identificadorDeclaracao) {
        IRPFFacade.getInstancia().repositorioXMLIRPF.restaurarBackup(identificadorDeclaracao);
    }

    public void restaurarBackup(String string) {
        IRPFFacade.getInstancia().repositorioXMLIRPF.restaurarBackup(string);
    }

    public void fazerBackup(IdentificadorDeclaracao identificadorDeclaracao) {
        IRPFFacade.getInstancia().repositorioXMLIRPF.fazerBackup(identificadorDeclaracao);
    }

    public void fazerBackup(String string) {
        IRPFFacade.getInstancia().repositorioXMLIRPF.fazerBackup(string);
    }

    public static void abreDeclaracao(DeclaracaoIRPF declaracaoIRPF) {
        IRPFFacade.getInstancia().repositorioXMLIRPF.abreDeclaracao(declaracaoIRPF);
    }

    public static boolean existeDeclaracao(String string) {
        return ((ColecaoIdDeclaracao)IRPFFacade.getInstancia().repositorioXMLIRPF.getListaIdDeclaracoes()).existeCPFCadastrado(string);
    }

    public static ColecaoIdDeclaracao getListaIdDeclaracoes() {
        return (ColecaoIdDeclaracao)IRPFFacade.getInstancia().repositorioXMLIRPF.getListaIdDeclaracoes();
    }

    public static void setCacheIdDeclaracao(boolean bl2) {
        IRPFFacade.getInstancia().repositorioXMLIRPF.setCacheIdDeclaracao(bl2);
    }

    public static void criarDeclaracao(IdentificadorDeclaracao identificadorDeclaracao) {
        identificadorDeclaracao.getDataUltimoAcesso().setConteudo(new Date());
        IRPFFacade.getInstancia().repositorioXMLIRPF.criarDeclaracao(identificadorDeclaracao);
    }

    public static void excluirDeclaracao(String object) {
        object = IRPFFacade.getInstancia().recuperarIdDeclaracao((String)object);
        IRPFFacade.excluirDeclaracao((IdentificadorDeclaracao)object);
    }

    public static void excluirDeclaracao(IdentificadorDeclaracao identificadorDeclaracao) {
        IRPFFacade.getInstancia().repositorioXMLIRPF.excluirDeclaracao(identificadorDeclaracao);
    }

    public static void excluirDeclaracao(List<IdentificadorDeclaracaoXML> list) {
        IRPFFacade.getInstancia().repositorioXMLIRPF.excluirDeclaracao(list);
    }

    public void salvarDeclaracaoAberta() {
        IRPFFacade.getInstancia().repositorioXMLIRPF.salvaDeclaracaoAberta();
    }

    public static void limpaCacheDeclaracoes() {
        IRPFFacade.getInstancia().repositorioXMLIRPF.fechaDeclaracao();
    }

    public Contribuinte getContribuinte() {
        return ((DeclaracaoIRPF)IRPFFacade.getInstancia().repositorioXMLIRPF.getDeclaracaoAberta()).getContribuinte();
    }

    public Conjuge getConjuge() {
        return ((DeclaracaoIRPF)IRPFFacade.getInstancia().repositorioXMLIRPF.getDeclaracaoAberta()).getConjuge();
    }

    public Espolio getEspolio() {
        return ((DeclaracaoIRPF)IRPFFacade.getInstancia().repositorioXMLIRPF.getDeclaracaoAberta()).getEspolio();
    }

    public Resumo getResumo() {
        return ((DeclaracaoIRPF)IRPFFacade.getInstancia().repositorioXMLIRPF.getDeclaracaoAberta()).getResumo();
    }

    public boolean isDeclaracaoAberta() {
        return IRPFFacade.getInstancia().repositorioXMLIRPF != null && IRPFFacade.getInstancia().repositorioXMLIRPF.getDeclaracaoAberta() != null;
    }

    public ImpostoPago getImpostoPago() {
        return ((DeclaracaoIRPF)IRPFFacade.getInstancia().repositorioXMLIRPF.getDeclaracaoAberta()).getImpostoPago();
    }

    public Dependentes getDependentes() {
        return ((DeclaracaoIRPF)IRPFFacade.getInstancia().repositorioXMLIRPF.getDeclaracaoAberta()).getDependentes();
    }

    public RendaVariavel getRendaVariavel() {
        return ((DeclaracaoIRPF)IRPFFacade.getInstancia().repositorioXMLIRPF.getDeclaracaoAberta()).getRendaVariavel();
    }

    public ColecaoRendaVariavelDependente getRendaVariavelDependente() {
        return ((DeclaracaoIRPF)IRPFFacade.getInstancia().repositorioXMLIRPF.getDeclaracaoAberta()).getRendaVariavelDependente();
    }

    public FundosInvestimentos getFundosInvestimentos() {
        return ((DeclaracaoIRPF)IRPFFacade.getInstancia().repositorioXMLIRPF.getDeclaracaoAberta()).getFundosInvestimentos();
    }

    public ColecaoFundosInvestimentosDependente getFundosInvestimentosDependente() {
        return ((DeclaracaoIRPF)IRPFFacade.getInstancia().repositorioXMLIRPF.getDeclaracaoAberta()).getFundosInvestimentosDependente();
    }

    public ColecaoRendPJDependente getColecaoRendPJDependente() {
        return ((DeclaracaoIRPF)IRPFFacade.getInstancia().repositorioXMLIRPF.getDeclaracaoAberta()).getColecaoRendPJDependente();
    }

    public ColecaoRendPJTitular getColecaoRendPJTitular() {
        return ((DeclaracaoIRPF)IRPFFacade.getInstancia().repositorioXMLIRPF.getDeclaracaoAberta()).getColecaoRendPJTitular();
    }

    public RendAcm getRendAcm() {
        return ((DeclaracaoIRPF)IRPFFacade.getInstancia().repositorioXMLIRPF.getDeclaracaoAberta()).getRendAcm();
    }

    public ColecaoRendAcmTitular getColecaoRendAcmTitular() {
        return ((DeclaracaoIRPF)IRPFFacade.getInstancia().repositorioXMLIRPF.getDeclaracaoAberta()).getColecaoRendAcmTitular();
    }

    public ColecaoRendAcmDependente getColecaoRendAcmDependente() {
        return ((DeclaracaoIRPF)IRPFFacade.getInstancia().repositorioXMLIRPF.getDeclaracaoAberta()).getColecaoRendAcmDependente();
    }

    public ColecaoRendPJComExigibilidadeDependente getColecaoRendPJComExigibilidadeDependente() {
        return ((DeclaracaoIRPF)IRPFFacade.getInstancia().repositorioXMLIRPF.getDeclaracaoAberta()).getColecaoRendPJComExigibilidadeDependente();
    }

    public ColecaoRendPJComExigibilidadeTitular getColecaoRendPJComExigibilidadeTitular() {
        return ((DeclaracaoIRPF)IRPFFacade.getInstancia().repositorioXMLIRPF.getDeclaracaoAberta()).getColecaoRendPJComExigibilidadeTitular();
    }

    public Herdeiros getHerdeiros() {
        return ((DeclaracaoIRPF)IRPFFacade.getInstancia().repositorioXMLIRPF.getDeclaracaoAberta()).getHerdeiros();
    }

    public Alimentandos getAlimentandos() {
        return ((DeclaracaoIRPF)IRPFFacade.getInstancia().repositorioXMLIRPF.getDeclaracaoAberta()).getAlimentandos();
    }

    public Pagamentos getPagamentos() {
        return ((DeclaracaoIRPF)IRPFFacade.getInstancia().repositorioXMLIRPF.getDeclaracaoAberta()).getPagamentos();
    }

    public Doacoes getDoacoes() {
        return ((DeclaracaoIRPF)IRPFFacade.getInstancia().repositorioXMLIRPF.getDeclaracaoAberta()).getDoacoes();
    }

    public Bens getBens() {
        return ((DeclaracaoIRPF)IRPFFacade.getInstancia().repositorioXMLIRPF.getDeclaracaoAberta()).getBens();
    }

    public Dividas getDividas() {
        return ((DeclaracaoIRPF)IRPFFacade.getInstancia().repositorioXMLIRPF.getDeclaracaoAberta()).getDividas();
    }

    public AtividadeRural getAtividadeRural() {
        return ((DeclaracaoIRPF)IRPFFacade.getInstancia().repositorioXMLIRPF.getDeclaracaoAberta()).getAtividadeRural();
    }

    public RendPF getRendPFTitular() {
        return ((DeclaracaoIRPF)IRPFFacade.getInstancia().repositorioXMLIRPF.getDeclaracaoAberta()).getRendPFTitular();
    }

    public Comparativo getComparativo() {
        return ((DeclaracaoIRPF)IRPFFacade.getInstancia().repositorioXMLIRPF.getDeclaracaoAberta()).getComparativo();
    }

    public ColecaoRendPFDependente getRendPFDependente() {
        return ((DeclaracaoIRPF)IRPFFacade.getInstancia().repositorioXMLIRPF.getDeclaracaoAberta()).getRendPFDependente();
    }

    public RendIsentos getRendIsentos() {
        return ((DeclaracaoIRPF)IRPFFacade.getInstancia().repositorioXMLIRPF.getDeclaracaoAberta()).getRendIsentos();
    }

    public RendTributacaoExclusiva getRendTributacaoExclusiva() {
        return ((DeclaracaoIRPF)IRPFFacade.getInstancia().repositorioXMLIRPF.getDeclaracaoAberta()).getRendTributacaoExclusiva();
    }

    public DoacoesEleitorais getDoacoesEleitorais() {
        return ((DeclaracaoIRPF)IRPFFacade.getInstancia().repositorioXMLIRPF.getDeclaracaoAberta()).getDoacoesEleitorais();
    }

    public Saida getSaida() {
        return ((DeclaracaoIRPF)IRPFFacade.getInstancia().repositorioXMLIRPF.getDeclaracaoAberta()).getSaida();
    }

    public ColecaoEstatutoCriancaAdolescente getColecaoEstatutoCriancaAdolescente() {
        return ((DeclaracaoIRPF)IRPFFacade.getInstancia().repositorioXMLIRPF.getDeclaracaoAberta()).getColecaoEstatutoCriancaAdolescente();
    }

    public GCAP getGCAP() {
        return ((DeclaracaoIRPF)IRPFFacade.getInstancia().repositorioXMLIRPF.getDeclaracaoAberta()).getGCAP();
    }

    public ModeloDeclaracao getModelo() {
        return this.getDeclaracao().getModelo();
    }

    public IdentificadorDeclaracao getIdDeclaracaoAberto() {
        return (IdentificadorDeclaracao)this.repositorioXMLIRPF.getIdDeclaracaoAberto();
    }

    public IdentificadorDeclaracao recuperarIdDeclaracao(String string) {
        return (IdentificadorDeclaracao)this.repositorioXMLIRPF.obterIdentificador(IRPFFacade.getListaIdDeclaracoes(), string);
    }

    public DeclaracaoIRPF recuperarDeclaracaoIRPF(String object) {
        try {
            return (DeclaracaoIRPF)this.repositorioXMLIRPF.recuperarDeclaracao((String)object);
        }
        catch (Exception exception) {
            object = exception;
            exception.printStackTrace();
            return null;
        }
    }

    public void salvarDeclaracao(String object) {
        try {
            this.repositorioXMLIRPF.salvarDeclaracao(this.repositorioXMLIRPF.recuperarDeclaracao((String)object));
            return;
        }
        catch (Exception exception) {
            object = exception;
            exception.printStackTrace();
            return;
        }
    }

    public void salvarDeclaracao(DeclaracaoIRPF object) {
        try {
            this.limparDeclaracao((DeclaracaoIRPF)((Object)object));
            this.repositorioXMLIRPF.salvarDeclaracao((DeclaracaoComIdentificador)object);
            ((DeclaracaoIRPF)((Object)object)).getDataHoraSalvamento().setConteudo(new Date());
            return;
        }
        catch (Exception exception) {
            object = exception;
            exception.printStackTrace();
            return;
        }
    }

    public void limparDeclaracao(DeclaracaoIRPF object) {
        try {
            if ("E".equals(((DeclaracaoIRPF)((Object)object)).getIdentificadorDeclaracao().getTipoDeclaracaoAES().naoFormatado())) {
                ((DeclaracaoIRPF)((Object)object)).getContribuinte().getTituloEleitor().clear();
                ((DeclaracaoIRPF)((Object)object)).getContribuinte().getOcupacaoPrincipal().clear();
                return;
            }
        }
        catch (Exception exception) {
            object = exception;
            exception.printStackTrace();
        }
    }

    public boolean existeDeclaracoes() {
        return IRPFFacade.getListaIdDeclaracoes().itens().size() > 0;
    }

    public DeclaracaoIRPF getDeclaracao() {
        return (DeclaracaoIRPF)IRPFFacade.getInstancia().repositorioXMLIRPF.getDeclaracaoAberta();
    }

    public void verificarIdDeclaracoes() {
        IRPFFacade.getInstancia().repositorioXMLIRPF.verificaIdDeclaracoes();
    }

    public boolean isTotalRendimentosMenorQueTotalDeducoes() {
        DeclaracaoIRPF declaracaoIRPF = this.getDeclaracao();
        Valor valor = new Valor();
        valor.append('+', declaracaoIRPF.getResumo().getRendimentosTributaveisDeducoes().getTotalRendimentos());
        valor.append('+', declaracaoIRPF.getResumo().getOutrasInformacoes().getRendIsentosNaoTributaveis());
        valor.append('+', declaracaoIRPF.getResumo().getOutrasInformacoes().getRendIsentosTributacaoExclusiva());
        declaracaoIRPF = declaracaoIRPF.getResumo().getRendimentosTributaveisDeducoes().getTotalDeducoes();
        return valor.comparacao("<", (Valor)declaracaoIRPF);
    }

    public static List<IdentificadorDeclaracao> getListaDeclaracoesRecentes() {
        Object object = IRPFFacade.getListaIdDeclaracoes().itens();
        ArrayList<IdentificadorDeclaracao> arrayList = new ArrayList<IdentificadorDeclaracao>();
        Collections.sort(object, new C());
        int n2 = 0;
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            object = (ObjetoNegocio)iterator.next();
            object = (IdentificadorDeclaracao)object;
            arrayList.add((IdentificadorDeclaracao)object);
            if (++n2 >= 10) break;
        }
        return arrayList;
    }

    public void setDeclaracaoEmGravacao(DeclaracaoIRPF declaracaoIRPF) {
        if (declaracaoIRPF != null) {
            this.declaracaoEmGravacao = new WeakReference<DeclaracaoIRPF>(declaracaoIRPF);
            return;
        }
        this.declaracaoEmGravacao = null;
    }

    public DeclaracaoIRPF getDeclaracaoEmGravacao() {
        if (this.declaracaoEmGravacao != null) {
            return (DeclaracaoIRPF)((Object)this.declaracaoEmGravacao.get());
        }
        return null;
    }

    public static String calcularHashMD5(File object) {
        String string = "";
        try {
            int n2;
            MessageDigest messageDigest = MessageDigest.getInstance(HASH_ALGORITMO_MD5);
            object = new FileInputStream((File)object);
            byte[] byArray = new byte[1024];
            while ((n2 = ((InputStream)object).read(byArray)) > 0) {
                messageDigest.update(byArray, 0, n2);
            }
            object = messageDigest.digest();
            object = new BigInteger(1, (byte[])object);
            string = ((BigInteger)object).toString(16);
        }
        catch (IOException | NoSuchAlgorithmException exception) {}
        return string;
    }
}

