/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf;

import classes.dI;
import classes.dL;
import classes.dP;
import java.io.File;
import java.net.URL;
import serpro.ppgd.cacheni.CacheNI;
import serpro.ppgd.irpf.D;
import serpro.ppgd.irpf.E;
import serpro.ppgd.irpf.F;
import serpro.ppgd.irpf.G;
import serpro.ppgd.irpf.H;
import serpro.ppgd.irpf.Y;
import serpro.ppgd.irpf.af;
import serpro.ppgd.irpf.ag;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.CPF;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.DataHora;
import serpro.ppgd.negocio.IdentificadorDeclaracaoXML;
import serpro.ppgd.negocio.Logico;
import serpro.ppgd.negocio.NI;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.ValidadorIf;

public class IdentificadorDeclaracao
extends ObjetoNegocio
implements Comparable<IdentificadorDeclaracao>,
IdentificadorDeclaracaoXML {
    public static final String DEC_COMPLETA = "0";
    public static final String DEC_SIMPLIFICADA = "1";
    public static final String TP_INICIADA_PGD = "1";
    public static final String TP_INICIADA_RASCUNHO = "0";
    public static final String TP_TRANSMITIDA_PGD = "1";
    private CPF cpf = new CPF((ObjetoNegocio)this, "CPF");
    private Alfa nome = new Alfa((ObjetoNegocio)this, "Nome", 60);
    private Alfa exercicio = new Alfa((ObjetoNegocio)this, "Exerc\u00edcio", 4);
    private Logico transmitida = new Logico((ObjetoNegocio)this, "");
    private Alfa tipoDeclaracao = new Alfa((ObjetoNegocio)this, "Tipo da Declara\u00e7\u00e3o", 5);
    private Alfa tipoDeclaracaoAES = new Alfa((ObjetoNegocio)this, "Tipo da Declara\u00e7\u00e3o AES", 1);
    private Alfa declaracaoRetificadora = new Alfa((ObjetoNegocio)this, "Que tipo de declara\u00e7\u00e3o voc\u00ea deseja fazer?", 2);
    private Alfa numReciboDecRetif = new Alfa((ObjetoNegocio)this, "N\u00ba do Recibo Dec. Anterior", 12);
    private Alfa numeroReciboDecAnterior = new Alfa((ObjetoNegocio)this, "N\u00ba do Recibo Dec. Exerc\u00edcio Anterior", 12);
    private Alfa enderecoDiferente = new Alfa((ObjetoNegocio)this, "Houve mudan\u00e7a de endere\u00e7o?", 2);
    private DataHora dataUltimoAcesso = new DataHora((ObjetoNegocio)this, "Data \u00daltimo Acesso");
    private Alfa versaoBeta = new Alfa();
    private Alfa resultadoDeclaracao = new Alfa((ObjetoNegocio)this, "Resultado da Declara\u00e7\u00e3o");
    private Alfa prepreenchida = new Alfa((ObjetoNegocio)this, "Indica se a declara\u00e7\u00e3o \u00e9 pr\u00e9-preenchida", 1);
    private int numGerado;
    private Alfa tpIniciada = new Alfa((ObjetoNegocio)this, "Onde foi iniciada a declara\u00e7\u00e3o?", 1);
    private Alfa inUtilizouPGD = new Alfa((ObjetoNegocio)this, "Utilizou PGD?", 1);
    private Alfa inUtilizouAPP = new Alfa((ObjetoNegocio)this, "Utilizou APP?", 1);
    private Alfa inUtilizouOnLine = new Alfa((ObjetoNegocio)this, "Utilizou OnLine?", 1);
    private Alfa inUtilizouRascunho = new Alfa((ObjetoNegocio)this, "Utilizou Rascunho?", 1);
    private Alfa inUtilizouAssistidaFontePagadora = new Alfa((ObjetoNegocio)this, "Utilizou Assistida Fonte Pagadora?", 1);
    private Alfa inUtilizouAssistidaPlanoSaude = new Alfa((ObjetoNegocio)this, "Utilizou Assistida Fonte Plano Saude?", 1);
    private Alfa inUtilizouSalvarRecuperarOnLine = new Alfa((ObjetoNegocio)this, "Utilizou Salvar Recuperar OnLine?", 1);
    private Alfa inNovaDeclaracao = new Alfa();
    private transient Alfa inPendencia = new Alfa((ObjetoNegocio)this, "Possui pend\u00eancias de erro?", 1);

    public IdentificadorDeclaracao() {
        CacheNI.getInstancia().registrarNINome((NI)this.cpf, this.nome);
        this.versaoBeta.setConteudo("N");
        this.tipoDeclaracao.setConteudo("0");
        this.tipoDeclaracaoAES.addValidador((ValidadorIf)new D(this, 3));
        this.exercicio.setConteudo(ConstantesGlobais.EXERCICIO);
        this.prepreenchida.setConteudo(Logico.NAO);
        this.tpIniciada.setConteudo("1");
        this.inUtilizouPGD.setConteudo(Logico.SIM);
        this.inUtilizouAPP.setConteudo(Logico.NAO);
        this.inUtilizouOnLine.setConteudo(Logico.NAO);
        this.inUtilizouRascunho.setConteudo(Logico.NAO);
        this.inUtilizouAssistidaFontePagadora.setConteudo(Logico.NAO);
        this.inUtilizouAssistidaPlanoSaude.setConteudo(Logico.NAO);
        this.inUtilizouSalvarRecuperarOnLine.setConteudo(Logico.NAO);
        this.inNovaDeclaracao.setConteudo(Logico.NAO);
        this.tipoDeclaracaoAES.setConteudo(dP.a.a());
        this.transmitida.converteEmTipoSimNao(Logico.NAO);
        af af2 = new af(3);
        af2.setMensagemValidacao(dL.a("pergunta_dec_retificadora_branco"));
        this.declaracaoRetificadora.addValidador((ValidadorIf)af2);
        af2 = new E(this, 3);
        this.numReciboDecRetif.addValidador((ValidadorIf)af2);
        this.numReciboDecRetif.addValidador((ValidadorIf)new F(this, 3));
        this.numeroReciboDecAnterior.addValidador((ValidadorIf)new G(this, 3));
        this.cpf.addValidador((ValidadorIf)new af(3));
        this.cpf.addValidador((ValidadorIf)new H(this, 3));
        this.nome.addValidador((ValidadorIf)new af(3, dL.a("nome_branco")));
        this.nome.addValidador((ValidadorIf)new ag());
        this.nome.addObservador((Observador)new Y());
        af2 = new af(3);
        af2.setMensagemValidacao(dL.a("pergunta_mudanca_endereco_branco"));
        this.getEnderecoDiferente().addValidador((ValidadorIf)af2);
    }

    public Alfa getInNovaDeclaracao() {
        return this.inNovaDeclaracao;
    }

    public boolean isDeclaracaoGerada() {
        return true;
    }

    public String getPathArquivo() {
        String string = dI.a;
        Comparable<File> comparable = new File(string = String.valueOf(string) + "/" + this.cpf.naoFormatado());
        if (!((File)comparable).exists()) {
            ((File)comparable).mkdirs();
        }
        comparable = new StringBuffer();
        ((StringBuffer)comparable).append(string);
        ((StringBuffer)comparable).append("/" + this.cpf.naoFormatado());
        ((StringBuffer)comparable).append(".xml");
        return ((StringBuffer)comparable).toString();
    }

    public URL getPathArquivoAsURL() {
        return new File(this.getPathArquivo()).toURI().toURL();
    }

    public CPF getCpf() {
        return this.cpf;
    }

    public Alfa getExercicio() {
        return this.exercicio;
    }

    public Alfa getNome() {
        return this.nome;
    }

    public Alfa getDeclaracaoRetificadora() {
        return this.declaracaoRetificadora;
    }

    public Alfa getNumReciboDecRetif() {
        return this.numReciboDecRetif;
    }

    public Logico getTransmitida() {
        return this.transmitida;
    }

    public boolean equals(Object object) {
        return object instanceof IdentificadorDeclaracao && ((IdentificadorDeclaracao)object).getCpf().naoFormatado().equals(this.getCpf().naoFormatado());
    }

    public Alfa getTipoDeclaracao() {
        return this.tipoDeclaracao;
    }

    public boolean isCompleta() {
        return !this.getTipoDeclaracao().naoFormatado().equals("1");
    }

    public boolean isRetificadora() {
        return this.getDeclaracaoRetificadora().naoFormatado().equals(Logico.SIM);
    }

    public boolean isOriginal() {
        return this.getDeclaracaoRetificadora().naoFormatado().equals(Logico.NAO);
    }

    public Alfa getEnderecoDiferente() {
        return this.enderecoDiferente;
    }

    public Alfa getNumeroReciboDecAnterior() {
        return this.numeroReciboDecAnterior;
    }

    public int getNumGerado() {
        return this.numGerado;
    }

    @Override
    public int compareTo(IdentificadorDeclaracao object) {
        String string = this.getNome().naoFormatado().toUpperCase();
        object = ((IdentificadorDeclaracao)object).getNome().naoFormatado().toUpperCase();
        return string.compareTo((String)object);
    }

    public Alfa getTipoDeclaracaoAES() {
        return this.tipoDeclaracaoAES;
    }

    public boolean isAjuste() {
        return this.getTipoDeclaracaoAES().naoFormatado().equals(dP.a.a());
    }

    public boolean isEspolio() {
        return this.getTipoDeclaracaoAES().naoFormatado().equals(dP.b.a());
    }

    public boolean isSaida() {
        return this.getTipoDeclaracaoAES().naoFormatado().equals(dP.c.a());
    }

    public DataHora getDataUltimoAcesso() {
        return this.dataUltimoAcesso;
    }

    public Alfa getResultadoDeclaracao() {
        return this.resultadoDeclaracao;
    }

    public Alfa getPrepreenchida() {
        return this.prepreenchida;
    }

    public Alfa getVersaoBeta() {
        return this.versaoBeta;
    }

    public Alfa getTpIniciada() {
        return this.tpIniciada;
    }

    public Alfa getInUtilizouPGD() {
        return this.inUtilizouPGD;
    }

    public Alfa getInUtilizouAPP() {
        return this.inUtilizouAPP;
    }

    public Alfa getInUtilizouOnLine() {
        return this.inUtilizouOnLine;
    }

    public Alfa getInUtilizouRascunho() {
        return this.inUtilizouRascunho;
    }

    public Alfa getInUtilizouAssistidaFontePagadora() {
        return this.inUtilizouAssistidaFontePagadora;
    }

    public Alfa getInUtilizouAssistidaPlanoSaude() {
        return this.inUtilizouAssistidaPlanoSaude;
    }

    public Alfa getInUtilizouSalvarRecuperarOnLine() {
        return this.inUtilizouSalvarRecuperarOnLine;
    }

    public Alfa getInPendencia() {
        return this.inPendencia;
    }

    static /* synthetic */ Alfa a(IdentificadorDeclaracao identificadorDeclaracao) {
        return identificadorDeclaracao.tipoDeclaracaoAES;
    }

    static /* synthetic */ Alfa b(IdentificadorDeclaracao identificadorDeclaracao) {
        return identificadorDeclaracao.tipoDeclaracao;
    }

    static /* synthetic */ Alfa c(IdentificadorDeclaracao identificadorDeclaracao) {
        return identificadorDeclaracao.declaracaoRetificadora;
    }

    static /* synthetic */ CPF d(IdentificadorDeclaracao identificadorDeclaracao) {
        return identificadorDeclaracao.cpf;
    }
}

