/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf;

import java.lang.ref.WeakReference;
import serpro.ppgd.cacheni.CacheNI;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.ItemQuadroAuxiliar;
import serpro.ppgd.irpf.M;
import serpro.ppgd.irpf.Y;
import serpro.ppgd.irpf.af;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.NI;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.ValidadorIf;

public class ItemQuadroOutrosRendimentos
extends ItemQuadroAuxiliar {
    private NI cnpjEmpresa = new NI((ObjetoNegocio)this, "CPF/CNPJ da fonte pagadora");
    private Alfa nomeFonte = new Alfa((ObjetoNegocio)this, "Nome da fonte pagadora", 60);
    private Alfa descricaoRendimento = new Alfa((ObjetoNegocio)this, "Descri\u00e7\u00e3o do rendimento", 60);

    public ItemQuadroOutrosRendimentos(DeclaracaoIRPF declaracaoIRPF) {
        super(declaracaoIRPF);
        CacheNI.getInstancia().registrarNINome(this.cnpjEmpresa, this.nomeFonte);
        this.getCnpjEmpresa().addValidador((ValidadorIf)new af(2));
        this.getCnpjEmpresa().addValidador((ValidadorIf)new M(this, 3));
        this.getNomeFonte().addObservador((Observador)new Y());
        this.getNomeFonte().addValidador((ValidadorIf)new af(2));
        this.getDescricaoRendimento().addValidador((ValidadorIf)new af(3));
    }

    public ItemQuadroOutrosRendimentos(DeclaracaoIRPF declaracaoIRPF, ObjetoNegocio objetoNegocio) {
        this(declaracaoIRPF);
        this.parent = new WeakReference<ObjetoNegocio>(objetoNegocio);
    }

    public Alfa getNomeFonte() {
        return this.nomeFonte;
    }

    public NI getCnpjEmpresa() {
        return this.cnpjEmpresa;
    }

    public Alfa getDescricaoRendimento() {
        return this.descricaoRendimento;
    }

    @Override
    public void adicionaCamposParaPendencia() {
        super.adicionaCamposParaPendencia();
        this.camposPendencia.add(this.cnpjEmpresa);
        this.camposPendencia.add(this.nomeFonte);
        this.camposPendencia.add(this.descricaoRendimento);
    }

    @Override
    public NI getNIFontePagadora() {
        return this.getCnpjEmpresa();
    }

    @Override
    public Alfa getNomeFontePagadora() {
        return this.getNomeFonte();
    }

    @Override
    public String getTituloFichaDashboard() {
        return null;
    }
}

