/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf;

import classes.bh;
import classes.bq;
import classes.dF;
import classes.dP;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.ModeloDeclaracao;
import serpro.ppgd.irpf.ah;
import serpro.ppgd.irpf.ai;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Valor;

public class ModeloCompleta
extends ModeloDeclaracao {
    private Valor rendRecebidoPJTitular = new Valor((ObjetoNegocio)this, "");
    private Valor rendRecebidoPJDependentes = new Valor((ObjetoNegocio)this, "");
    private Valor rendRecebidoAcmTitular = new Valor((ObjetoNegocio)this, "");
    private Valor rendRecebidoAcmDependentes = new Valor((ObjetoNegocio)this, "");
    private Valor rendRecebidoPFEXTTitular = new Valor((ObjetoNegocio)this, "");
    private Valor rendRecebidoPFEXTDependentes = new Valor((ObjetoNegocio)this, "");
    private Valor resultadoTributavelAR = new Valor((ObjetoNegocio)this, "");
    private Valor totalRendimentos = new Valor((ObjetoNegocio)this, "");
    private Valor previdenciaOficial = new Valor((ObjetoNegocio)this, "");
    private Valor previdenciaOficialRRA = new Valor((ObjetoNegocio)this, "");
    private Valor previdenciaFAPI = new Valor((ObjetoNegocio)this, "");
    private Valor deducaoDependentes = new Valor((ObjetoNegocio)this, "");
    private Valor despesasInstrucao = new Valor((ObjetoNegocio)this, "");
    private Valor despesasMedicas = new Valor((ObjetoNegocio)this, "");
    private Valor pensaoAlimenticia = new Valor((ObjetoNegocio)this, "");
    private Valor pensaoAlimenticiaRRA = new Valor((ObjetoNegocio)this, "");
    private Valor pensaoCartoral = new Valor((ObjetoNegocio)this, "");
    private Valor livroCaixa = new Valor((ObjetoNegocio)this, "");
    private Valor totalDeducoes = new Valor((ObjetoNegocio)this, "");
    private Valor totalContribEmpregadoDomestico = new Valor((ObjetoNegocio)this, "");
    private Valor imposto = new Valor((ObjetoNegocio)this, "");
    private Valor deducaoIncentivo = new Valor((ObjetoNegocio)this, "");
    private Valor impostoRetidoFonteTitular = new Valor((ObjetoNegocio)this, "");
    private Valor impostoRetidoFonteDependentes = new Valor((ObjetoNegocio)this, "");
    private Valor carneLeaoTitular = new Valor((ObjetoNegocio)this, "");
    private Valor carneLeaoDependentes = new Valor((ObjetoNegocio)this, "");
    private Valor impostoComplementar = new Valor((ObjetoNegocio)this, "");
    private Valor impostoPagoExterior = new Valor((ObjetoNegocio)this, "");
    private Valor impostoRetidoFonteLei11033 = new Valor((ObjetoNegocio)this, "");
    private Valor totalImpostoPago = new Valor((ObjetoNegocio)this, "");
    private Valor bensDireitosExercicioAnterior = new Valor((ObjetoNegocio)this, "");
    private Valor bensDireitosExercicioAtual = new Valor((ObjetoNegocio)this, "");
    private Valor dividasExercicioAnterior = new Valor((ObjetoNegocio)this, "");
    private Valor dividasExercicioAtual = new Valor((ObjetoNegocio)this, "");
    private Valor rendIsentosNaoTributaveis = new Valor((ObjetoNegocio)this, "");
    private Valor rendTributaveisExigibilidadeSuspensa = new Valor((ObjetoNegocio)this, "");
    private Valor depositosJudiciais = new Valor((ObjetoNegocio)this, "");
    private ai rendSujeitoTribExclusiva = new ai(this, "");
    private Valor impostoPagoGCAP = new Valor((ObjetoNegocio)this, "");
    private Valor impostoPagoME = new Valor((ObjetoNegocio)this, "");
    private Valor totalImpostoRetidoNaFonte = new Valor((ObjetoNegocio)this, "");
    private Valor impostoPagoSobreRendaVariavel = new Valor((ObjetoNegocio)this, "");
    private Valor informacoesConjuge = new Valor((ObjetoNegocio)this, "");
    private Valor impostoDiferidoGCAP = new Valor((ObjetoNegocio)this, "");
    private Valor impostoDevidoGCAP = new Valor((ObjetoNegocio)this, "");
    private Valor impostoDevidoRendaVariavel = new Valor((ObjetoNegocio)this, "");
    private Valor impostoDevidoGCME = new Valor((ObjetoNegocio)this, "");
    private Valor impostoDevidoComRendExterior = new Valor((ObjetoNegocio)this, "");
    private Valor impostoDevidoSemRendExterior = new Valor((ObjetoNegocio)this, "");
    private Valor limiteImpPagoExterior = new Valor((ObjetoNegocio)this, "");
    private Valor aliquotaEfetiva = new Valor((ObjetoNegocio)this, "");

    public ModeloCompleta(DeclaracaoIRPF declaracaoIRPF) {
        super(declaracaoIRPF);
    }

    @Override
    public void resumoRendimentosTributaveis() {
        this.rendRecebidoPJTitular.setConteudo(this.declaracaoIRPF.getColecaoRendPJTitular().getTotaisRendRecebidoPJ());
        this.rendRecebidoPJDependentes.setConteudo(this.declaracaoIRPF.getColecaoRendPJDependente().getTotaisRendRecebidoPJ());
        this.rendRecebidoAcmTitular.setConteudo(this.declaracaoIRPF.getColecaoRendAcmTitular().getTotaisRendRecebidosAjuste());
        this.rendRecebidoAcmDependentes.setConteudo(this.declaracaoIRPF.getColecaoRendAcmDependente().getTotaisRendRecebidosAjuste());
        this.rendRecebidoPFEXTTitular.clear();
        this.rendRecebidoPFEXTTitular.append('+', this.declaracaoIRPF.getRendPFTitular().getTotalPessoaFisica());
        this.rendRecebidoPFEXTTitular.append('+', this.declaracaoIRPF.getRendPFTitular().getTotalAlugueis());
        this.rendRecebidoPFEXTTitular.append('+', this.declaracaoIRPF.getRendPFTitular().getTotalOutros());
        this.rendRecebidoPFEXTTitular.append('+', this.declaracaoIRPF.getRendPFTitular().getTotalExterior());
        this.rendRecebidoPFEXTDependentes.clear();
        this.rendRecebidoPFEXTDependentes.append('+', this.declaracaoIRPF.getRendPFDependente().getTotalPessoaFisica());
        this.rendRecebidoPFEXTDependentes.append('+', this.declaracaoIRPF.getRendPFDependente().getTotalAlugueis());
        this.rendRecebidoPFEXTDependentes.append('+', this.declaracaoIRPF.getRendPFDependente().getTotalOutros());
        this.rendRecebidoPFEXTDependentes.append('+', this.declaracaoIRPF.getRendPFDependente().getTotalExterior());
        this.rendRecebidoExterior.clear();
        this.rendRecebidoExterior.append('+', this.declaracaoIRPF.getRendPFTitular().getTotalExterior());
        this.rendRecebidoExterior.append('+', this.declaracaoIRPF.getRendPFDependente().getTotalExterior());
        this.resultadoTributavelAR.clear();
        if (this.declaracaoIRPF.getAtividadeRural().getBrasil().getApuracaoResultado().getResultadoTributavel().comparacao(">", "0,00")) {
            this.resultadoTributavelAR.append('+', (Valor)this.declaracaoIRPF.getAtividadeRural().getBrasil().getApuracaoResultado().getResultadoTributavel());
        }
        if (this.declaracaoIRPF.getAtividadeRural().getExterior().getApuracaoResultado().getResultadoTributavel().comparacao(">", "0,00")) {
            this.resultadoTributavelAR.append('+', (Valor)this.declaracaoIRPF.getAtividadeRural().getExterior().getApuracaoResultado().getResultadoTributavel());
        }
        this.totalRendimentos.clear();
        this.totalRendimentos.append('+', this.rendRecebidoPJTitular);
        this.totalRendimentos.append('+', this.rendRecebidoPJDependentes);
        this.totalRendimentos.append('+', this.rendRecebidoAcmTitular);
        this.totalRendimentos.append('+', this.rendRecebidoAcmDependentes);
        this.totalRendimentos.append('+', this.rendRecebidoPFEXTTitular);
        this.totalRendimentos.append('+', this.rendRecebidoPFEXTDependentes);
        this.totalRendimentos.append('+', this.resultadoTributavelAR);
        this.previdenciaOficial.clear();
        this.previdenciaOficial.append('+', this.declaracaoIRPF.getRendPFTitular().getTotalPrevidencia());
        this.previdenciaOficial.append('+', this.declaracaoIRPF.getRendPFDependente().getTotalPrevidencia());
        this.previdenciaOficial.append('+', this.declaracaoIRPF.getRendPJ().getColecaoRendPJTitular().getTotaisContribuicaoPrevOficial());
        this.previdenciaOficial.append('+', this.declaracaoIRPF.getRendPJ().getColecaoRendPJDependente().getTotaisContribuicaoPrevOficial());
        this.previdenciaOficial.append('+', this.declaracaoIRPF.getPagamentos().getTotalContribuicaoFunpresp());
        this.previdenciaOficial.append('+', this.declaracaoIRPF.getRendIsentos().getPensaoQuadroAuxiliar().getTotalPrevidenciaOficialTitular());
        this.previdenciaOficial.append('+', this.declaracaoIRPF.getRendIsentos().getPensaoQuadroAuxiliar().getTotalPrevidenciaOficialDependentes());
        this.previdenciaOficialRRA.clear();
        this.previdenciaOficialRRA.append('+', this.declaracaoIRPF.getColecaoRendAcmTitular().getTotaisContribuicaoPrevOficialAjuste());
        this.previdenciaOficialRRA.append('+', this.declaracaoIRPF.getColecaoRendAcmDependente().getTotaisContribuicaoPrevOficialAjuste());
        this.previdenciaFAPI.setConteudo(this.declaracaoIRPF.getPagamentos().getTotalContribuicaoFAPI());
        this.deducaoDependentes.setConteudo(this.declaracaoIRPF.getDependentes().getTotalDeducaoDependentes());
        this.despesasInstrucao.setConteudo(this.declaracaoIRPF.getPagamentos().getTotalDeducoesInstrucao());
        this.despesasMedicas.setConteudo(this.declaracaoIRPF.getPagamentos().getTotalDespesasMedicas());
        this.pensaoAlimenticia.clear();
        this.pensaoAlimenticia.append('+', this.declaracaoIRPF.getPagamentos().getTotalPensao());
        this.pensaoCartoral.setConteudo(this.declaracaoIRPF.getPagamentos().getTotalPensaoCartoral());
        this.pensaoAlimenticiaRRA.clear();
        this.pensaoAlimenticiaRRA.append('+', this.declaracaoIRPF.getColecaoRendAcmTitular().getTotaisPensaoAlimenticiaAjuste());
        this.pensaoAlimenticiaRRA.append('+', this.declaracaoIRPF.getColecaoRendAcmDependente().getTotaisPensaoAlimenticiaAjuste());
        this.livroCaixa.clear();
        this.livroCaixa.append('+', this.declaracaoIRPF.getRendPFTitular().getTotalLivroCaixa());
        this.livroCaixa.append('+', this.declaracaoIRPF.getRendPFDependente().getTotalLivroCaixa());
        this.totalContribEmpregadoDomestico.setConteudo(this.declaracaoIRPF.getPagamentos().getTotalContribEmpregadoDomestico());
        this.deducaoIncentivo.clear();
        this.deducaoIncentivo.append('+', this.declaracaoIRPF.getDoacoes().getTotalDeducaoIncentivo());
        this.deducaoIncentivo.append('+', this.declaracaoIRPF.getColecaoEstatutoCriancaAdolescente().getTotalDeducaoIncentivoLiquido());
        this.totalDeducoes.clear();
        this.totalDeducoes.append('+', this.previdenciaOficial);
        this.totalDeducoes.append('+', this.previdenciaFAPI);
        this.totalDeducoes.append('+', this.deducaoDependentes);
        this.totalDeducoes.append('+', this.despesasInstrucao);
        this.totalDeducoes.append('+', this.despesasMedicas);
        this.totalDeducoes.append('+', this.pensaoAlimenticia);
        this.totalDeducoes.append('+', this.pensaoCartoral);
        this.totalDeducoes.append('+', this.livroCaixa);
        this.totalDeducoes.append('+', this.previdenciaOficialRRA);
        this.totalDeducoes.append('+', this.pensaoAlimenticiaRRA);
    }

    @Override
    public void resumoCalculoImposto() {
        Valor valor;
        Valor valor2;
        this.baseCalculo.clear();
        this.baseCalculo.append('+', this.totalRendimentos);
        this.baseCalculo.append('-', this.totalDeducoes);
        if (this.baseCalculo.comparacao("<", "0,00")) {
            this.baseCalculo.clear();
        }
        this.imposto.setConteudo(this.calculaImposto(this.baseCalculo));
        bh.a(this.declaracaoIRPF);
        this.deducaoIncentivo.clear();
        this.deducaoIncentivo.append('+', this.declaracaoIRPF.getDoacoes().getTotalDeducaoIncentivo());
        this.deducaoIncentivo.append('+', this.declaracaoIRPF.getColecaoEstatutoCriancaAdolescente().getTotalDeducaoIncentivoLiquido());
        this.impostoDevido.clear();
        this.impostoDevido.append('+', this.imposto);
        this.impostoDevido.append('-', this.deducaoIncentivo);
        if (this.impostoDevido.comparacao("<", "0,00")) {
            this.impostoDevido.clear();
        }
        this.totalContribEmpregadoDomestico.setConteudo(this.declaracaoIRPF.getPagamentos().getTotalContribEmpregadoDomestico());
        if (this.declaracaoIRPF.identificadorDeclaracao.isEspolio()) {
            int n2 = this.declaracaoIRPF.getEspolio().getQtdMesesParaCalculos();
            valor2 = new Valor("0,0000");
            if (n2 == 12) {
                valor2.setConteudo("1.200,32");
            } else {
                valor2.setConteudo(this.calcularLimiteContribuicaoEmpregadoEspolio(n2));
                valor = this.calcularProporcionalDecimoTerceiroEspolio(n2);
                valor2.append('+', valor);
                Valor valor3 = this.calcularAbonoFerias();
                valor2.append('+', valor3);
            }
            this.calcularTotalContribuicaoEmpregadoDomestico(valor2);
        } else if (this.declaracaoIRPF.identificadorDeclaracao.isSaida()) {
            int n3 = this.declaracaoIRPF.getSaida().getMesInicial();
            int n4 = this.declaracaoIRPF.getSaida().getMesFinal();
            int n5 = n4 - n3 + 1;
            Valor valor4 = new Valor("0,0000");
            if (n5 == 12) {
                valor4.setConteudo("1.200,32");
            } else {
                valor4.setConteudo(this.calcularLimiteContribuicaoEmpregadoSaida(n3, n4));
                Valor valor5 = this.calcularProporcionalDecimoTerceiroSaida(n5, n3, n4);
                valor4.append('+', valor5);
                valor5 = this.calcularAbonoFerias();
                valor4.append('+', valor5);
            }
            this.calcularTotalContribuicaoEmpregadoDomestico(valor4);
        } else {
            this.calcularTotalContribuicaoEmpregadoDomestico(new Valor("1.200,32"));
        }
        this.impostoDevidoRRA.clear();
        this.impostoDevidoRRA.append('+', this.declaracaoIRPF.getRendAcm().getColecaoRendAcmTitular().getTotaisImpostoDevidoRRA());
        this.impostoDevidoRRA.append('+', this.declaracaoIRPF.getRendAcm().getColecaoRendAcmDependente().getTotaisImpostoDevidoRRA());
        this.impostoDevidoI.clear();
        this.impostoDevidoI.append('+', this.impostoDevido);
        this.impostoDevidoI.append('-', this.totalContribEmpregadoDomestico);
        if (this.impostoDevidoI.comparacao("<", "0,00")) {
            this.impostoDevidoI.clear();
        }
        this.impostoDevidoII.clear();
        this.impostoDevidoII.append('+', this.impostoDevido);
        this.impostoDevidoII.append('+', this.impostoDevidoRRA);
        this.impostoDevidoII.append('-', this.totalContribEmpregadoDomestico);
        if (this.impostoDevidoII.comparacao("<", "0,00")) {
            this.impostoDevidoII.clear();
        }
        this.impostoRetidoFonteTitular.clear();
        this.impostoRetidoFonteTitular.append('+', this.declaracaoIRPF.getColecaoRendPJTitular().getTotaisImpostoRetidoFonte());
        this.impostoRetidoFonteTitular.append('+', this.declaracaoIRPF.getColecaoRendAcmTitular().getTotaisImpostoRetidoFonteAjuste());
        this.impostoRetidoFonteTitular.append('+', this.declaracaoIRPF.getRendIsentos().getPensaoQuadroAuxiliar().getTotalIRRFTitular());
        this.impostoRetidoFonteTitular.append('+', this.declaracaoIRPF.getRendIsentos().getPensaoQuadroAuxiliar().getTotalIRRF13SalarioTitular());
        this.impostoRetidoFonteDependentes.clear();
        this.impostoRetidoFonteDependentes.append('+', this.declaracaoIRPF.getColecaoRendPJDependente().getTotaisImpostoRetidoFonte());
        this.impostoRetidoFonteDependentes.append('+', this.declaracaoIRPF.getColecaoRendAcmDependente().getTotaisImpostoRetidoFonteAjuste());
        this.impostoRetidoFonteDependentes.append('+', this.declaracaoIRPF.getRendIsentos().getPensaoQuadroAuxiliar().getTotalIRRFDependentes());
        this.impostoRetidoFonteDependentes.append('+', this.declaracaoIRPF.getRendIsentos().getPensaoQuadroAuxiliar().getTotalIRRF13SalarioDependentes());
        this.carneLeaoTitular.setConteudo(this.declaracaoIRPF.getRendPFTitular().getTotalDarfPago());
        this.carneLeaoDependentes.setConteudo(this.declaracaoIRPF.getRendPFDependente().getTotalDarfPago());
        this.impostoComplementar.setConteudo((Valor)this.declaracaoIRPF.getImpostoPago().getImpostoComplementar());
        Valor valor6 = new Valor();
        this.aplicaLimitesImpostoPagoExterior(valor6);
        this.impostoPagoExterior.setConteudo(valor6);
        this.declaracaoIRPF.getImpostoPago().getImpostoRetidoFonteTitular().setConteudo(this.impostoRetidoFonteTitular);
        this.declaracaoIRPF.getImpostoPago().getImpostoRetidoFonteDependentes().setConteudo(this.impostoRetidoFonteDependentes);
        this.declaracaoIRPF.getImpostoPago().getCarneLeaoTitular().setConteudo(this.carneLeaoTitular);
        this.declaracaoIRPF.getImpostoPago().getCarneLeaoDependentes().setConteudo(this.carneLeaoDependentes);
        this.impostoRetidoFonteLei11033.setConteudo((Valor)this.declaracaoIRPF.getImpostoPago().getImpostoRetidoFonte());
        this.impostoRetidoRRA.clear();
        this.impostoRetidoRRA.append('+', this.declaracaoIRPF.getRendAcm().getColecaoRendAcmTitular().getTotaisImpostoRetidoFonteExclusiva());
        this.impostoRetidoRRA.append('+', this.declaracaoIRPF.getRendAcm().getColecaoRendAcmDependente().getTotaisImpostoRetidoFonteExclusiva());
        this.totalImpostoPago.clear();
        this.totalImpostoPago.append('+', this.impostoRetidoFonteTitular);
        this.totalImpostoPago.append('+', this.impostoRetidoFonteDependentes);
        this.totalImpostoPago.append('+', this.carneLeaoTitular);
        this.totalImpostoPago.append('+', this.carneLeaoDependentes);
        this.totalImpostoPago.append('+', this.impostoRetidoFonteLei11033);
        this.totalImpostoPago.append('+', this.impostoComplementar);
        this.totalImpostoPago.append('+', this.impostoPagoExterior);
        this.totalImpostoPago.append('+', this.impostoRetidoRRA);
        this.saldoImpostoPagar.clear();
        this.impostoRestituir.clear();
        valor2 = new Valor(this.impostoDevidoII.formatado());
        if (valor2.comparacao("<", this.totalImpostoPago)) {
            this.impostoRestituir.clear();
            this.impostoRestituir.append('+', this.totalImpostoPago);
            this.impostoRestituir.append('-', valor2);
        } else {
            this.saldoImpostoPagar.clear();
            this.saldoImpostoPagar.append('+', valor2);
            this.saldoImpostoPagar.append('-', this.totalImpostoPago);
        }
        valor = new ah(null, "Aliquota Efetiva", 11, 4);
        if (!this.totalRendimentos.isVazio()) {
            valor.append('+', this.impostoDevidoI.formatado());
            valor.append('/', this.totalRendimentos.formatado());
            valor.append('*', "100,00");
        }
        this.aliquotaEfetiva.setConteudo(valor);
    }

    private void calcularTotalContribuicaoEmpregadoDomestico(Valor valor) {
        if (this.impostoDevido.comparacao(">", valor)) {
            if (this.totalContribEmpregadoDomestico.comparacao(">", valor)) {
                this.totalContribEmpregadoDomestico.setConteudo(valor);
                return;
            }
        } else if (this.totalContribEmpregadoDomestico.comparacao(">", this.impostoDevido.formatado())) {
            this.totalContribEmpregadoDomestico.setConteudo(this.impostoDevido.formatado());
        }
    }

    private Valor calcularLimiteContribuicaoEmpregadoEspolio(int n2) {
        return this.calcularLimiteContribuicaoEmpregadoSaida(1, n2);
    }

    private Valor calcularLimiteContribuicaoEmpregadoSaida(int n2, int n3) {
        Valor valor = new Valor("0,0000");
        while (n2 <= n3) {
            valor.append('+', dF.h[n2 - 1]);
            ++n2;
        }
        return valor;
    }

    private Valor calcularProporcionalDecimoTerceiroEspolio(Integer n2) {
        return this.calcularProporcionalDecimoTerceiro(n2, 1, n2, dP.b);
    }

    private Valor calcularProporcionalDecimoTerceiroSaida(Integer n2, Integer n3, Integer n4) {
        return this.calcularProporcionalDecimoTerceiro(n2, n3, n4, dP.c);
    }

    private Valor calcularProporcionalDecimoTerceiro(Integer n2, Integer n3, Integer n4, dP dP2) {
        dP2 = new Valor();
        dP2.setCasasDecimais(4);
        int n5 = n2;
        Valor valor = new Valor();
        valor.setCasasDecimais(4);
        int n6 = n3;
        if (n3 != null && n3 == 1) {
            n6 = 2;
            --n5;
            valor.setConteudo(dF.i[0]);
        } else {
            valor.setConteudo("0,00");
        }
        if (n5 > 0) {
            n5 = n6;
            while (n5 <= n4) {
                dP2.append('+', dF.i[n5 - 1]);
                ++n5;
            }
        }
        dP2.append('+', valor);
        return dP2;
    }

    private Valor calcularAbonoFerias() {
        Valor valor = new Valor("0,0000");
        valor.setConteudo("27,9840");
        return valor;
    }

    @Override
    public void resumoOutrasInformacoes() {
        this.bensDireitosExercicioAnterior.setConteudo(this.declaracaoIRPF.getBens().getTotalExercicioAnterior());
        this.bensDireitosExercicioAtual.setConteudo(this.declaracaoIRPF.getBens().getTotalExercicioAtual());
        this.dividasExercicioAnterior.setConteudo(this.declaracaoIRPF.getDividas().getTotalExercicioAnterior());
        this.dividasExercicioAtual.setConteudo(this.declaracaoIRPF.getDividas().getTotalExercicioAtual());
        this.informacoesConjuge.setConteudo((Valor)this.declaracaoIRPF.getConjuge().getResultado());
        this.rendIsentosNaoTributaveis.setConteudo(this.declaracaoIRPF.getRendIsentos().getTotal());
        this.rendTributaveisExigibilidadeSuspensa.setConteudo(this.declaracaoIRPF.getRendPJComExigibilidade().getTotalRendRecebPessoaJuridica());
        this.depositosJudiciais.setConteudo(this.declaracaoIRPF.getRendPJComExigibilidade().getTotalDepositoJudicial());
        this.rendSujeitoTribExclusiva.setConteudo(this.declaracaoIRPF.getRendTributacaoExclusiva().getTotal());
        this.impostoPagoGCAP.setConteudo((Valor)this.declaracaoIRPF.getGCAP().getConsolidacaoGeralBrasil().getTotalImpostoPago());
        this.impostoDevidoGCME.setConteudo((Valor)this.declaracaoIRPF.getGCAP().obterSomatorioImpostoDevido1NoExercicioAlienacoesGCME());
        this.impostoPagoME.setConteudo((Valor)this.declaracaoIRPF.getGCAP().getConsolidacaoGeralExterior().getTotalImpostoPago());
        this.declaracaoIRPF.getResumo().getCalculoImposto().getImpostoEspecie().setConteudo((Valor)this.declaracaoIRPF.getGCAP().getConsolidacaoGeralEspecie().getImpostoDevido());
        this.declaracaoIRPF.getResumo().getOutrasInformacoes().getImpostoDevidoGCME().setConteudo((Valor)this.declaracaoIRPF.getGCAP().obterSomatorioImpostoDevido1NoExercicioAlienacoesGCME());
        this.totalImpostoRetidoNaFonte.clear();
        this.totalImpostoRetidoNaFonte.append('+', this.declaracaoIRPF.getRendaVariavel().getTotalImpostoRetidoFonteLei11033());
        this.totalImpostoRetidoNaFonte.append('+', this.declaracaoIRPF.getRendaVariavelDependente().getTotalImpostoRetidoFonteLei11033());
        this.totalImpostoRetidoNaFonte.append('+', this.declaracaoIRPF.getFundosInvestimentos().getTotalImpostoRetidoFonteLei11033());
        this.totalImpostoRetidoNaFonte.append('+', this.declaracaoIRPF.getFundosInvestimentosDependente().getTotalImpostoRetidoFonteLei11033());
        this.totalImpostoRetidoNaFonte.append('+', (Valor)this.declaracaoIRPF.getGCAP().getConsolidacaoGeralBrasil().getValorIRF());
        Valor valor = new Valor(this.declaracaoIRPF.getRendaVariavel().getTotalImpostoPago().naoFormatado());
        valor.append('+', this.declaracaoIRPF.getFundosInvestimentos().getTotalImpostoPago());
        valor.append('+', this.declaracaoIRPF.getRendaVariavelDependente().getTotalImpostoPago());
        valor.append('+', this.declaracaoIRPF.getFundosInvestimentosDependente().getTotalImpostoPago());
        this.impostoPagoSobreRendaVariavel.setConteudo(valor);
        this.totalDoacoesCampanhasEleitorais.setConteudo(this.declaracaoIRPF.getDoacoesEleitorais().getTotalDoacoes());
        this.impostoDiferidoGCAP.setConteudo((Valor)this.declaracaoIRPF.getGCAP().getConsolidacaoGeralBrasil().getImpostoDiferidoAnosPosteriores());
        this.impostoDevidoGCAP.setConteudo((Valor)this.declaracaoIRPF.getGCAP().getConsolidacaoGeralBrasil().getImpostoDevidoAnoAtual());
        this.impostoDevidoRendaVariavel.clear();
        this.impostoDevidoRendaVariavel.append('+', this.declaracaoIRPF.getRendaVariavel().getTotalImpostoAPagar());
        this.impostoDevidoRendaVariavel.append('+', this.declaracaoIRPF.getRendaVariavelDependente().getTotalImpostoAPagar());
        valor = new Valor();
        valor.append('+', this.declaracaoIRPF.getFundosInvestimentos().getTotalImpostoDevido());
        valor.append('-', this.declaracaoIRPF.getFundosInvestimentos().getTotalImpostoRetidoFonteLei11033());
        Valor valor2 = new Valor();
        valor2.append('+', this.declaracaoIRPF.getFundosInvestimentosDependente().getTotalImpostoDevido());
        valor2.append('-', this.declaracaoIRPF.getFundosInvestimentosDependente().getTotalImpostoRetidoFonteLei11033());
        Valor valor3 = new Valor();
        valor3.append('+', valor);
        valor3.append('+', valor2);
        if (valor3.comparacao("<", "0")) {
            valor3.clear();
        }
        this.impostoDevidoRendaVariavel.append('+', valor3);
        if (this.impostoDevidoRendaVariavel.comparacao("<", "0")) {
            this.impostoDevidoRendaVariavel.clear();
        }
        this.impostoDevidoGCAP.setConteudo((Valor)this.declaracaoIRPF.getGCAP().getConsolidacaoGeralBrasil().getImpostoDevidoAnoAtual());
    }

    private void aplicaLimitesImpostoPagoExterior(Valor valor) {
        if (this.declaracaoIRPF.getImpostoPago().getImpostoPagoExterior().comparacao(">", "0,00")) {
            valor.setConteudo((Valor)this.declaracaoIRPF.getImpostoPago().getImpostoPagoExterior());
            Valor valor2 = new Valor();
            valor2.append('+', this.totalRendimentos);
            valor2.append('-', this.totalDeducoes);
            Valor valor3 = this.calculaImposto(valor2);
            valor3.append('-', this.totalContribEmpregadoDomestico);
            valor3.append('-', this.deducaoIncentivo);
            this.impostoDevidoComRendExterior.setConteudo(valor3);
            valor2 = new Valor();
            valor2.append('+', this.totalRendimentos);
            valor2.append('-', this.rendRecebidoExterior);
            Valor valor4 = new Valor();
            valor4.append('+', this.previdenciaOficial);
            valor4.append('+', bq.a(this.declaracaoIRPF, valor2));
            valor4.append('+', this.deducaoDependentes);
            valor4.append('+', this.despesasInstrucao);
            valor4.append('+', this.despesasMedicas);
            valor4.append('+', this.pensaoAlimenticia);
            valor4.append('+', this.pensaoCartoral);
            valor4.append('+', this.livroCaixa);
            valor4.append('+', this.previdenciaOficialRRA);
            valor4.append('+', this.pensaoAlimenticiaRRA);
            Valor valor5 = new Valor();
            valor5.append('+', valor2);
            valor5.append('-', valor4);
            valor4 = this.calculaImposto(valor5);
            valor2 = bh.a(this.declaracaoIRPF, valor4).getValorAceitoDeducaoExercicio();
            valor4.append('-', this.totalContribEmpregadoDomestico);
            valor4.append('-', valor2);
            if (valor4.comparacao("<", "0,00")) {
                valor4.clear();
            }
            if (valor.comparacao(">", valor2 = valor3.operacao('-', valor4))) {
                valor.setConteudo(valor2);
            }
            this.impostoDevidoSemRendExterior.setConteudo(valor4);
            this.limiteImpPagoExterior.setConteudo(valor);
            return;
        }
        this.impostoDevidoComRendExterior.clear();
        this.impostoDevidoSemRendExterior.clear();
        this.limiteImpPagoExterior.clear();
    }

    @Override
    public void aplicaValoresNaDeclaracao() {
        this.declaracaoIRPF.getImpostoPago().getImpostoDevidoComRendExterior().setConteudo(this.impostoDevidoComRendExterior);
        this.declaracaoIRPF.getImpostoPago().getImpostoDevidoSemRendExterior().setConteudo(this.impostoDevidoSemRendExterior);
        this.declaracaoIRPF.getImpostoPago().getLimiteImpPagoExterior().setConteudo(this.limiteImpPagoExterior);
        this.declaracaoIRPF.getResumo().getRendimentosTributaveisDeducoes().getRendRecebidoPJTitular().setConteudo(this.rendRecebidoPJTitular);
        this.declaracaoIRPF.getResumo().getRendimentosTributaveisDeducoes().getRendRecebidoPJDependentes().setConteudo(this.rendRecebidoPJDependentes);
        this.declaracaoIRPF.getResumo().getRendimentosTributaveisDeducoes().getRendRecebidoAcmTitular().setConteudo(this.rendRecebidoAcmTitular);
        this.declaracaoIRPF.getResumo().getRendimentosTributaveisDeducoes().getRendRecebidoAcmDependentes().setConteudo(this.rendRecebidoAcmDependentes);
        this.declaracaoIRPF.getResumo().getRendimentosTributaveisDeducoes().getRendRecebidoPFEXTTitular().setConteudo(this.rendRecebidoPFEXTTitular);
        this.declaracaoIRPF.getResumo().getRendimentosTributaveisDeducoes().getRendRecebidoPFEXTDependentes().setConteudo(this.rendRecebidoPFEXTDependentes);
        this.declaracaoIRPF.getResumo().getRendimentosTributaveisDeducoes().getRendTributavelAR().setConteudo(this.resultadoTributavelAR);
        this.declaracaoIRPF.getResumo().getRendimentosTributaveisDeducoes().getTotalRendimentos().setConteudo(this.totalRendimentos);
        this.declaracaoIRPF.getResumo().getRendimentosTributaveisDeducoes().getPrevidenciaOficial().setConteudo(this.previdenciaOficial);
        this.declaracaoIRPF.getResumo().getRendimentosTributaveisDeducoes().getPrevidenciaOficialRRA().setConteudo(this.previdenciaOficialRRA);
        this.declaracaoIRPF.getResumo().getRendimentosTributaveisDeducoes().getPrevidenciaFAPI().setConteudo(this.previdenciaFAPI);
        this.declaracaoIRPF.getResumo().getRendimentosTributaveisDeducoes().getDependentes().setConteudo(this.deducaoDependentes);
        this.declaracaoIRPF.getResumo().getRendimentosTributaveisDeducoes().getDespesasInstrucao().setConteudo(this.despesasInstrucao);
        this.declaracaoIRPF.getResumo().getRendimentosTributaveisDeducoes().getDespesasMedicas().setConteudo(this.despesasMedicas);
        this.declaracaoIRPF.getResumo().getRendimentosTributaveisDeducoes().getPensaoAlimenticia().setConteudo(this.pensaoAlimenticia);
        this.declaracaoIRPF.getResumo().getRendimentosTributaveisDeducoes().getPensaoAlimenticiaRRA().setConteudo(this.pensaoAlimenticiaRRA);
        this.declaracaoIRPF.getResumo().getRendimentosTributaveisDeducoes().getPensaoCartoral().setConteudo(this.pensaoCartoral);
        this.declaracaoIRPF.getResumo().getRendimentosTributaveisDeducoes().getLivroCaixa().setConteudo(this.livroCaixa);
        this.declaracaoIRPF.getResumo().getRendimentosTributaveisDeducoes().getTotalDeducoes().setConteudo(this.totalDeducoes);
        this.declaracaoIRPF.getResumo().getCalculoImposto().getBaseCalculo().setConteudo(this.baseCalculo);
        this.declaracaoIRPF.getResumo().getCalculoImposto().getImposto().setConteudo(this.imposto);
        this.declaracaoIRPF.getResumo().getCalculoImposto().getDeducaoIncentivo().setConteudo(this.deducaoIncentivo);
        this.declaracaoIRPF.getResumo().getCalculoImposto().getTotalContribEmpregadoDomestico().setConteudo(this.totalContribEmpregadoDomestico);
        this.declaracaoIRPF.getResumo().getCalculoImposto().getImpostoDevido().setConteudo(this.impostoDevido);
        this.declaracaoIRPF.getResumo().getCalculoImposto().getImpostoDevidoI().setConteudo(this.impostoDevidoI);
        this.declaracaoIRPF.getResumo().getCalculoImposto().getImpostoDevidoII().setConteudo(this.impostoDevidoII);
        this.declaracaoIRPF.getResumo().getCalculoImposto().getImpostoDevidoRRA().setConteudo(this.impostoDevidoRRA);
        this.declaracaoIRPF.getResumo().getCalculoImposto().getImpostoRetidoFonteTitular().setConteudo(this.impostoRetidoFonteTitular);
        this.declaracaoIRPF.getResumo().getCalculoImposto().getImpostoRetidoFonteDependentes().setConteudo(this.impostoRetidoFonteDependentes);
        this.declaracaoIRPF.getResumo().getCalculoImposto().getCarneLeaoTitular().setConteudo(this.carneLeaoTitular);
        this.declaracaoIRPF.getResumo().getCalculoImposto().getCarneLeaoDependentes().setConteudo(this.carneLeaoDependentes);
        this.declaracaoIRPF.getResumo().getCalculoImposto().getImpostoComplementar().setConteudo(this.impostoComplementar);
        this.declaracaoIRPF.getResumo().getCalculoImposto().getImpostoPagoExterior().setConteudo(this.impostoPagoExterior);
        this.declaracaoIRPF.getResumo().getCalculoImposto().getImpostoRetidoFonteLei11033().setConteudo(this.impostoRetidoFonteLei11033);
        this.declaracaoIRPF.getResumo().getCalculoImposto().getImpostoRetidoRRA().setConteudo(this.impostoRetidoRRA);
        this.declaracaoIRPF.getResumo().getCalculoImposto().getTotalImpostoPago().setConteudo(this.totalImpostoPago);
        this.declaracaoIRPF.getResumo().getCalculoImposto().getSaldoImpostoPagar().setConteudo(this.saldoImpostoPagar);
        this.declaracaoIRPF.getResumo().getCalculoImposto().getImpostoRestituir().setConteudo(this.impostoRestituir);
        this.declaracaoIRPF.getResumo().getOutrasInformacoes().getBensDireitosExercicioAnterior().setConteudo(this.bensDireitosExercicioAnterior);
        this.declaracaoIRPF.getResumo().getOutrasInformacoes().getBensDireitosExercicioAtual().setConteudo(this.bensDireitosExercicioAtual);
        this.declaracaoIRPF.getResumo().getOutrasInformacoes().getDividasOnusReaisExercicioAnterior().setConteudo(this.dividasExercicioAnterior);
        this.declaracaoIRPF.getResumo().getOutrasInformacoes().getDividasOnusReaisExercicioAtual().setConteudo(this.dividasExercicioAtual);
        this.declaracaoIRPF.getResumo().getOutrasInformacoes().getInformacoesConjuge().setConteudo(this.informacoesConjuge);
        this.declaracaoIRPF.getResumo().getOutrasInformacoes().getRendIsentosNaoTributaveis().setConteudo(this.rendIsentosNaoTributaveis);
        this.declaracaoIRPF.getResumo().getOutrasInformacoes().getRendIsentosTributacaoExclusiva().setConteudo((Valor)this.rendSujeitoTribExclusiva);
        this.declaracaoIRPF.getResumo().getOutrasInformacoes().getRendTributaveisExigibilidadeSuspensa().setConteudo(this.rendTributaveisExigibilidadeSuspensa);
        this.declaracaoIRPF.getResumo().getOutrasInformacoes().getDepositosJudiciais().setConteudo(this.depositosJudiciais);
        this.declaracaoIRPF.getResumo().getOutrasInformacoes().getImpostoPagoGCAP().setConteudo(this.impostoPagoGCAP);
        this.declaracaoIRPF.getResumo().getOutrasInformacoes().getImpostoDiferidoGCAP().setConteudo(this.impostoDiferidoGCAP);
        this.declaracaoIRPF.getResumo().getOutrasInformacoes().getImpostoDevidoGCAP().setConteudo(this.impostoDevidoGCAP);
        this.declaracaoIRPF.getResumo().getOutrasInformacoes().getImpostoDevidoRendaVariavel().setConteudo(this.impostoDevidoRendaVariavel);
        this.declaracaoIRPF.getResumo().getOutrasInformacoes().getImpostoDevidoGCME().setConteudo(this.impostoDevidoGCME);
        this.declaracaoIRPF.getResumo().getOutrasInformacoes().getImpostoPagoME().setConteudo(this.impostoPagoME);
        this.declaracaoIRPF.getResumo().getOutrasInformacoes().getTotalImpostoRetidoNaFonte().setConteudo(this.totalImpostoRetidoNaFonte);
        this.declaracaoIRPF.getResumo().getOutrasInformacoes().getImpostoPagoSobreRendaVariavel().setConteudo(this.impostoPagoSobreRendaVariavel);
        this.declaracaoIRPF.getResumo().getOutrasInformacoes().getTotalDoacoesCampanhasEleitorais().setConteudo(this.totalDoacoesCampanhasEleitorais);
        Valor valor = this.declaracaoIRPF.getResumo().getCalculoImposto().getImpostoRestituir();
        Valor valor2 = this.declaracaoIRPF.getResumo().getCalculoImposto().getSaldoImpostoPagar();
        int n2 = valor2.compareTo(valor);
        valor2 = new Alfa("resultadoDeclaracao");
        if (n2 == 0) {
            valor2.setConteudo("SSI");
        } else if (n2 < 0) {
            valor2.setConteudo("IAR");
        } else {
            valor2.setConteudo("IAP");
        }
        this.declaracaoIRPF.getIdentificadorDeclaracao().getResultadoDeclaracao().setConteudo((Alfa)valor2);
        this.declaracaoIRPF.getResumo().getCalculoImposto().getAliquotaEfetiva().setConteudo(this.aliquotaEfetiva);
    }

    public Valor getBensDireitosExercicioAnterior() {
        return this.bensDireitosExercicioAnterior;
    }

    public Valor getBensDireitosExercicioAtual() {
        return this.bensDireitosExercicioAtual;
    }

    public Valor getCarneLeaoTitular() {
        return this.carneLeaoTitular;
    }

    public Valor getCarneLeaoDependentes() {
        return this.carneLeaoDependentes;
    }

    public Valor getDeducaoDependentes() {
        return this.deducaoDependentes;
    }

    public Valor getDeducaoIncentivo() {
        return this.deducaoIncentivo;
    }

    public Valor getDespesasInstrucao() {
        return this.despesasInstrucao;
    }

    public Valor getDespesasMedicas() {
        return this.despesasMedicas;
    }

    public Valor getDividasExercicioAnterior() {
        return this.dividasExercicioAnterior;
    }

    public Valor getDividasExercicioAtual() {
        return this.dividasExercicioAtual;
    }

    public Valor getImposto() {
        return this.imposto;
    }

    public Valor getImpostoComplementar() {
        return this.impostoComplementar;
    }

    public Valor getImpostoPagoExterior() {
        return this.impostoPagoExterior;
    }

    public Valor getImpostoPagoGCAP() {
        return this.impostoPagoGCAP;
    }

    public Valor getImpostoPagoME() {
        return this.impostoPagoME;
    }

    public Valor getImpostoPagoSobreRendaVariavel() {
        return this.impostoPagoSobreRendaVariavel;
    }

    @Override
    public Valor getImpostoRestituir() {
        return this.impostoRestituir;
    }

    public Valor getImpostoRetidoFonteDependentes() {
        return this.impostoRetidoFonteDependentes;
    }

    public Valor getImpostoRetidoFonteLei11033() {
        return this.impostoRetidoFonteLei11033;
    }

    public Valor getImpostoRetidoFonteTitular() {
        return this.impostoRetidoFonteTitular;
    }

    public Valor getInformacoesConjuge() {
        return this.informacoesConjuge;
    }

    public Valor getLivroCaixa() {
        return this.livroCaixa;
    }

    public Valor getPensaoAlimenticia() {
        return this.pensaoAlimenticia;
    }

    public Valor getPensaoCartoral() {
        return this.pensaoCartoral;
    }

    public Valor getPrevidenciaFAPI() {
        return this.previdenciaFAPI;
    }

    public Valor getPrevidenciaOficial() {
        return this.previdenciaOficial;
    }

    public Valor getRendIsentosNaoTributaveis() {
        return this.rendIsentosNaoTributaveis;
    }

    public Valor getRendRecebidoPFEXTDependentes() {
        return this.rendRecebidoPFEXTDependentes;
    }

    public Valor getRendRecebidoPFEXTTitular() {
        return this.rendRecebidoPFEXTTitular;
    }

    public Valor getRendRecebidoPJDependentes() {
        return this.rendRecebidoPJDependentes;
    }

    public Valor getRendRecebidoPJTitular() {
        return this.rendRecebidoPJTitular;
    }

    public ai getRendSujeitoTribExclusiva() {
        return this.rendSujeitoTribExclusiva;
    }

    public Valor getResultadoTributavelAR() {
        return this.resultadoTributavelAR;
    }

    public Valor getTotalDeducoes() {
        return this.totalDeducoes;
    }

    public Valor getTotalImpostoPago() {
        return this.totalImpostoPago;
    }

    public Valor getTotalImpostoRetidoNaFonte() {
        return this.totalImpostoRetidoNaFonte;
    }

    public Valor getTotalRendimentos() {
        return this.totalRendimentos;
    }

    @Override
    public Valor recuperarTotalImpostoPago() {
        Valor valor = new Valor();
        valor.append('+', this.declaracaoIRPF.getResumo().getCalculoImposto().getImpostoRetidoFonteTitular());
        valor.append('+', this.declaracaoIRPF.getResumo().getCalculoImposto().getImpostoRetidoFonteDependentes());
        valor.append('+', this.declaracaoIRPF.getResumo().getCalculoImposto().getImpostoPagoExterior());
        valor.append('+', this.declaracaoIRPF.getResumo().getCalculoImposto().getImpostoComplementar());
        valor.append('+', this.declaracaoIRPF.getResumo().getCalculoImposto().getCarneLeaoTitular());
        valor.append('+', this.declaracaoIRPF.getResumo().getCalculoImposto().getCarneLeaoDependentes());
        valor.append('+', this.declaracaoIRPF.getResumo().getCalculoImposto().getImpostoRetidoFonteLei11033());
        return valor;
    }

    @Override
    public String recuperarCodInImpostoPago() {
        int n2 = 0;
        if (!this.declaracaoIRPF.getResumo().getCalculoImposto().getImpostoRetidoFonteTitular().isVazio() || !this.declaracaoIRPF.getResumo().getCalculoImposto().getImpostoRetidoFonteDependentes().isVazio()) {
            ++n2;
        }
        if (!this.declaracaoIRPF.getResumo().getCalculoImposto().getImpostoPagoExterior().isVazio()) {
            n2 += 8;
        }
        if (!this.declaracaoIRPF.getResumo().getCalculoImposto().getImpostoComplementar().isVazio()) {
            n2 += 4;
        }
        if (!this.declaracaoIRPF.getResumo().getCalculoImposto().getCarneLeaoTitular().isVazio() || !this.declaracaoIRPF.getResumo().getCalculoImposto().getCarneLeaoDependentes().isVazio()) {
            n2 += 2;
        }
        if (!this.declaracaoIRPF.getResumo().getCalculoImposto().getImpostoRetidoFonteLei11033().isVazio()) {
            n2 += 16;
        }
        if (!this.declaracaoIRPF.getResumo().getCalculoImposto().getImpostoRetidoRRA().isVazio()) {
            n2 += 32;
        }
        String string = n2 < 9 ? "0" + n2 : String.valueOf(n2);
        return string;
    }

    @Override
    public Valor recuperarTotalRendimentosTributaveis() {
        Valor valor = new Valor(this.declaracaoIRPF.getResumo().getRendimentosTributaveisDeducoes().getTotalRendimentos().formatado());
        return valor;
    }

    public Valor getRendTributaveisExigibilidadeSuspensa() {
        return this.rendTributaveisExigibilidadeSuspensa;
    }

    public Valor getDepositosJudiciais() {
        return this.depositosJudiciais;
    }

    public Valor getImpostoDevidoComRendExterior() {
        return this.impostoDevidoComRendExterior;
    }

    public Valor getImpostoDevidoSemRendExterior() {
        return this.impostoDevidoSemRendExterior;
    }

    public Valor getLimiteImpPagoExterior() {
        return this.limiteImpPagoExterior;
    }

    public Valor getAliquotaEfetiva() {
        return this.aliquotaEfetiva;
    }
}

