/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.alimentandos;

import classes.dL;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import serpro.ppgd.cacheni.CacheNI;
import serpro.ppgd.gui.xbeans.JEditObjetoNegocioItemIf;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.ItemQuadroPensaoAlimenticia;
import serpro.ppgd.irpf.Y;
import serpro.ppgd.irpf.ab;
import serpro.ppgd.irpf.af;
import serpro.ppgd.irpf.ag;
import serpro.ppgd.irpf.alimentandos.a;
import serpro.ppgd.irpf.alimentandos.b;
import serpro.ppgd.irpf.alimentandos.c;
import serpro.ppgd.irpf.alimentandos.d;
import serpro.ppgd.irpf.alimentandos.e;
import serpro.ppgd.irpf.alimentandos.f;
import serpro.ppgd.irpf.alimentandos.g;
import serpro.ppgd.irpf.gui.alimentandos.PainelAlimentandosLista;
import serpro.ppgd.irpf.pagamentos.Pagamento;
import serpro.ppgd.irpf.rendacm.RendAcmDependente;
import serpro.ppgd.irpf.rendacm.RendAcmTitular;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.CPF;
import serpro.ppgd.negocio.Data;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.NI;
import serpro.ppgd.negocio.ObjetoFicha;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.Pendencia;
import serpro.ppgd.negocio.ValidadorIf;

public class Alimentando
extends ObjetoNegocio
implements JEditObjetoNegocioItemIf,
ObjetoFicha {
    public static final String PROP_CAMPO_NOME = "Nome do alimentando";
    public static final String PROP_CAMPO_CPF = "CPF";
    public static final String RESIDENTE_BRASIL = "0";
    public static final String RESIDENTE_EXTERIOR = "1";
    public static final String RESIDENTE_VAZIO = "2";
    private String chave = "";
    private Alfa nome = new Alfa((ObjetoNegocio)this, "Nome do alimentando", 60);
    private Alfa residente = new Alfa((ObjetoNegocio)this, "Residente", 1);
    private CPF cpf = new CPF((ObjetoNegocio)this, "CPF");
    private Data dtNascimento = new Data((ObjetoNegocio)this, "Data de nascimento");
    private WeakReference<DeclaracaoIRPF> refDeclaracao;

    public Alimentando(DeclaracaoIRPF declaracaoIRPF) {
        this.refDeclaracao = new WeakReference<DeclaracaoIRPF>(declaracaoIRPF);
        CacheNI.getInstancia().registrarNINome((NI)this.cpf, this.nome);
        this.getNome().addValidador((ValidadorIf)new g(3, this.getDtNascimento(), dL.a("alimentando_nome_branco")));
        this.getNome().addObservador((Observador)new Y());
        this.getNome().addValidador((ValidadorIf)new af(3, dL.a("alimentando_nome_branco")));
        this.getNome().addValidador((ValidadorIf)new ag());
        this.getCpf().addValidador((ValidadorIf)new a(this, 3));
        this.getCpf().addValidador((ValidadorIf)new ab(3, dL.a("alimentando_cpf_igual_tit"), declaracaoIRPF.getIdentificadorDeclaracao().getCpf()));
        this.getCpf().addValidador((ValidadorIf)new e(this.getResidente(), this.getDtNascimento()));
        this.getCpf().addValidador((ValidadorIf)new d(declaracaoIRPF.getAlimentandos()));
        this.getCpf().addValidador((ValidadorIf)new c(declaracaoIRPF.getDependentes()));
        this.getResidente().addValidador((ValidadorIf)new f(3, dL.a("alimentando_residencia_branco")));
        this.getDtNascimento().addValidador((ValidadorIf)new af(3, dL.a("alimentando_dt_nasc_branco")));
        this.getDtNascimento().addValidador((ValidadorIf)new b(this, 3));
    }

    public Alfa getNome() {
        return this.nome;
    }

    public String toString() {
        return this.nome.naoFormatado();
    }

    public String getConteudo(int n2) {
        return this.getNome().formatado();
    }

    public int getTotalAtributos() {
        return 1;
    }

    public int getColunaFiltro() {
        return 0;
    }

    public String getChave() {
        return this.chave;
    }

    public void setChave(String string) {
        this.chave = string;
    }

    public String getClasseFicha() {
        return PainelAlimentandosLista.class.getName();
    }

    public CPF getCpf() {
        return this.cpf;
    }

    public Data getDtNascimento() {
        return this.dtNascimento;
    }

    public Alfa getResidente() {
        return this.residente;
    }

    public boolean isVazio() {
        for (Informacao informacao : this.recuperarCamposInformacao()) {
            if (informacao.isVazio() || informacao.getNomeCampo().equals("Residente")) continue;
            return false;
        }
        return true;
    }

    protected List<Informacao> recuperarListaCamposPendencia() {
        List list = super.recuperarListaCamposPendencia();
        list.add(this.getResidente());
        list.add(this.getNome());
        list.add(this.getCpf());
        list.add(this.getDtNascimento());
        return list;
    }

    public List<Pendencia> verificarPendencias(int n2) {
        List list = super.verificarPendencias(n2);
        if (!(this.getNome().isVazio() || this.verificaAlimentandoRendAcm() || this.verificaAlimentandoPagamento())) {
            Pendencia pendencia = new Pendencia(2, (Informacao)this.getCpf(), this.getCpf().getNomeCampo(), dL.a("alimentando_nao_dedutivel"), n2);
            pendencia.setClassePainel(this.getClasseFicha());
            list.add(pendencia);
        }
        return list;
    }

    protected boolean verificaAlimentandoPagamento() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("");
        arrayList.add("01");
        arrayList.add("02");
        arrayList.add("09");
        arrayList.add("10");
        arrayList.add("11");
        arrayList.add("12");
        arrayList.add("13");
        arrayList.add("14");
        arrayList.add("15");
        arrayList.add("16");
        arrayList.add("17");
        arrayList.add("18");
        arrayList.add("19");
        arrayList.add("20");
        arrayList.add("21");
        arrayList.add("22");
        arrayList.add("26");
        arrayList.add("30");
        arrayList.add("31");
        arrayList.add("33");
        arrayList.add("34");
        Object object = (DeclaracaoIRPF)((Object)this.refDeclaracao.get());
        object = ((DeclaracaoIRPF)((Object)object)).getPagamentos().itens();
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            object = (ObjetoNegocio)iterator.next();
            if (!"A".equals(((Pagamento)(object = (Pagamento)object)).getTipo().naoFormatado()) || !arrayList.contains(((Pagamento)object).getCodigo().naoFormatado()) || this.getNome().naoFormatado().isEmpty() || !this.getNome().naoFormatado().equals(((Pagamento)object).getDependenteOuAlimentando().naoFormatado())) continue;
            return true;
        }
        return false;
    }

    protected boolean verificaAlimentandoRendAcm() {
        ObjetoNegocio objetoNegocio;
        Object object;
        ObjetoNegocio objetoNegocio2 = (DeclaracaoIRPF)((Object)this.refDeclaracao.get());
        Object object2 = objetoNegocio2.getRendAcm().getColecaoRendAcmDependente().itens();
        ObjetoNegocio objetoNegocio3 = object2.iterator();
        while (objetoNegocio3.hasNext()) {
            object2 = (ObjetoNegocio)objetoNegocio3.next();
            object2 = (RendAcmDependente)((Object)object2);
            object = ((RendAcmTitular)((Object)object2)).getPensaoAlimenticiaQuadroAuxiliar().itens();
            objetoNegocio = object.iterator();
            while (objetoNegocio.hasNext()) {
                object = (ObjetoNegocio)objetoNegocio.next();
                object = (ItemQuadroPensaoAlimenticia)((Object)object);
                if (this.getNome().naoFormatado().isEmpty() || !((ItemQuadroPensaoAlimenticia)((Object)object)).getAlimentando().naoFormatado().equals(this.getNome().naoFormatado())) continue;
                return true;
            }
        }
        object2 = objetoNegocio2.getRendAcm().getColecaoRendAcmTitular().itens();
        object2 = object2.iterator();
        while (object2.hasNext()) {
            objetoNegocio3 = (ObjetoNegocio)object2.next();
            object = (RendAcmTitular)objetoNegocio3;
            object = ((RendAcmTitular)((Object)object)).getPensaoAlimenticiaQuadroAuxiliar().itens();
            object = object.iterator();
            while (object.hasNext()) {
                objetoNegocio = (ObjetoNegocio)object.next();
                objetoNegocio2 = (ItemQuadroPensaoAlimenticia)objetoNegocio;
                if (this.getNome().naoFormatado().isEmpty() || !objetoNegocio2.getAlimentando().naoFormatado().equals(this.getNome().naoFormatado())) continue;
                return true;
            }
        }
        return false;
    }

    public String getNomeAba() {
        return null;
    }

    public String getTituloFichaDashboard() {
        return "Alimentandos";
    }
}

