/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.alimentandos;

import java.lang.ref.WeakReference;
import java.util.Iterator;
import javax.swing.JOptionPane;
import serpro.ppgd.infraestrutura.PlataformaPPGD;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.IRPFFacade;
import serpro.ppgd.irpf.alimentandos.Alimentando;
import serpro.ppgd.irpf.gui.alimentandos.PainelAlimentandosLista;
import serpro.ppgd.negocio.Colecao;
import serpro.ppgd.negocio.ObjetoFicha;
import serpro.ppgd.negocio.util.UtilitariosString;

public class Alimentandos
extends Colecao<Alimentando>
implements ObjetoFicha {
    private WeakReference<DeclaracaoIRPF> declaracaoRef = null;

    public Alimentandos(DeclaracaoIRPF declaracaoIRPF) {
        this.setFicha("Alimentandos");
        this.declaracaoRef = new WeakReference<DeclaracaoIRPF>(declaracaoIRPF);
    }

    public void objetoInserido(Alimentando alimentando) {
        this.setFicha(this.getFicha());
    }

    public Alimentando instanciaNovoObjeto() {
        return new Alimentando((DeclaracaoIRPF)((Object)this.declaracaoRef.get()));
    }

    public String getNomeAlimentandoByChave(String string) {
        for (Alimentando alimentando : this.itens()) {
            if (!alimentando.getChave().equals(string)) continue;
            return alimentando.getNome().formatado();
        }
        return null;
    }

    public String getChaveAlimentandoByNome(String string) {
        for (Alimentando alimentando : this.itens()) {
            if (!alimentando.getNome().naoFormatado().equals(string)) continue;
            return alimentando.getChave();
        }
        return null;
    }

    public Alimentando getAlimentandoByNome(String string) {
        if (string != null) {
            string = string.trim().toUpperCase();
            for (Alimentando alimentando : this.itens()) {
                if (!alimentando.getNome().naoFormatado().toUpperCase().equals(string)) continue;
                return alimentando;
            }
        }
        return null;
    }

    public Alimentando getAlimentandoByCpf(String string) {
        for (Alimentando alimentando : this.itens()) {
            if (!alimentando.getCpf().naoFormatado().equals(string)) continue;
            return alimentando;
        }
        return null;
    }

    public boolean isExisteNome(String string) {
        for (Alimentando alimentando : this.itens()) {
            if (!alimentando.getNome().naoFormatado().equals(string)) continue;
            return true;
        }
        return false;
    }

    public boolean isExisteCPF(String string) {
        for (Alimentando alimentando : this.itens()) {
            if (!alimentando.getCpf().naoFormatado().equals(string)) continue;
            return true;
        }
        return false;
    }

    public boolean isNomeDuplicado(String string) {
        Iterator iterator = this.itens().iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            Alimentando alimentando = (Alimentando)((Object)iterator.next());
            if (alimentando.getNome().naoFormatado().isEmpty() || !alimentando.getNome().naoFormatado().equals(string)) continue;
            if (n2 > 0) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean existeAlimentandoComNome() {
        for (Alimentando alimentando : this.itens()) {
            if (alimentando.getNome().isVazio()) continue;
            return true;
        }
        return false;
    }

    public boolean confirmaExclusaoRelacionadasAlimentando(String string) {
        return this.confirmaExclusaoRelacionadasAlimentando(string, null);
    }

    public boolean confirmaExclusaoRelacionadasAlimentando(String string, String string2) {
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        IRPFFacade iRPFFacade = IRPFFacade.getInstancia();
        if (iRPFFacade.getPagamentos().existePagamentosComAlimentando(string)) {
            bl2 = true;
        }
        if (iRPFFacade.getColecaoRendAcmTitular().existeRendAcmComAlimentando(string)) {
            bl3 = true;
        }
        if (iRPFFacade.getColecaoRendAcmDependente().existeRendAcmComAlimentando(string)) {
            bl4 = true;
        }
        string2 = string2 != null && !"".equals(string2) ? "Este alimentando (CPF: " + UtilitariosString.formataCPF((String)string2) + ") \u00e9 utilizado na(s) ficha(s): \n" : "Este alimentando (" + string + ") \u00e9 utilizado na(s) ficha(s): \n";
        if (bl2) {
            string2 = String.valueOf(string2) + "- Pagamentos \n";
        }
        if (bl3) {
            string2 = String.valueOf(string2) + "- Rendimentos Recebidos Acumuladamente pelo Titular \n";
        }
        if (bl4) {
            string2 = String.valueOf(string2) + "- Rendimentos Recebidos Acumuladamente pelos Dependentes \n";
        }
        boolean bl5 = bl2 || bl3 || bl4;
        string2 = String.valueOf(string2) + "\nDeseja excluir mesmo assim?";
        if (!bl5) {
            return true;
        }
        if (JOptionPane.showConfirmDialog(PlataformaPPGD.getPlataforma().getJanelaPrincipal(), string2, "Confirma\u00e7\u00e3o", 0) == 0) {
            if (bl2) {
                iRPFFacade.getPagamentos().excluirPagamentosComAlimentando(string);
            }
            if (bl3) {
                iRPFFacade.getColecaoRendAcmTitular().excluirRendAcmComAlimentando(string);
            }
            if (bl4) {
                iRPFFacade.getColecaoRendAcmDependente().excluirRendAcmComAlimentando(string);
            }
            return true;
        }
        return false;
    }

    public String getClasseFicha() {
        return PainelAlimentandosLista.class.getName();
    }

    public String getNomeAba() {
        return null;
    }

    public String getTituloFichaDashboard() {
        return "Alimentandos";
    }
}

