/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.bens;

import java.util.Collections;
import serpro.ppgd.irpf.IdentificadorDeclaracao;
import serpro.ppgd.irpf.bens.Bem;
import serpro.ppgd.irpf.bens.p;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.Colecao;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Valor;

public class Bens
extends Colecao<Bem> {
    private Valor totalExercicioAnterior = new Valor((ObjetoNegocio)this, "Total exercicio Anterior");
    private Valor totalExercicioAtual = new Valor((ObjetoNegocio)this, "Total exercicio Atual");
    private transient IdentificadorDeclaracao idDec;
    private Alfa ultimoIndiceGerado = new Alfa();
    private Alfa totalItens = new Alfa();
    private static long geradorIndices;

    public Bens(IdentificadorDeclaracao identificadorDeclaracao) {
        this.idDec = identificadorDeclaracao;
        this.setFicha("Bens e Direitos");
        this.totalExercicioAnterior.setReadOnly(true);
        this.totalExercicioAtual.setReadOnly(true);
    }

    public void inicializaGeradorIndices() {
        if (this.ultimoIndiceGerado.naoFormatado().trim().equals("")) {
            geradorIndices = 0L;
            return;
        }
        geradorIndices = Long.parseLong(this.ultimoIndiceGerado.naoFormatado());
    }

    private String proximoIndice() {
        this.ultimoIndiceGerado.setConteudo("" + geradorIndices++);
        return this.ultimoIndiceGerado.naoFormatado();
    }

    public void reordenaPorCodigo() {
        Collections.sort(this.itens(), new p(this));
    }

    public Bem instanciaNovoObjeto() {
        Bem bem = new Bem(this.idDec);
        bem.getIndice().setConteudo(this.proximoIndice());
        return bem;
    }

    public void objetoInserido(Bem bem) {
        this.setFicha(this.getFicha());
        this.totalItens.setConteudo(String.valueOf(this.itens().size()));
    }

    public Valor getTotalExercicioAnterior() {
        return this.totalExercicioAnterior;
    }

    public Valor getTotalExercicioAtual() {
        return this.totalExercicioAtual;
    }

    public boolean totalAlto() {
        return this.totalExercicioAtual.comparacao(">", "5.000.000,00");
    }

    public boolean existeBensComHerdeiro(String string) {
        for (Bem bem : this.itens()) {
            if (!bem.getParticipacoesInventario().existeHerdeiro(string)) continue;
            return true;
        }
        return false;
    }

    public void excluirBensComHerdeiro(String string) {
        for (Bem bem : this.itens()) {
            bem.getParticipacoesInventario().excluirHerdeiro(string);
        }
    }
}

