/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.conjuge;

import classes.dL;
import java.util.List;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.IRPFFacade;
import serpro.ppgd.irpf.IdentificadorDeclaracao;
import serpro.ppgd.irpf.ai;
import serpro.ppgd.irpf.conjuge.a;
import serpro.ppgd.irpf.conjuge.b;
import serpro.ppgd.irpf.conjuge.c;
import serpro.ppgd.irpf.gui.conjuge.PainelConjuge;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.CPF;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.ObjetoFicha;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.ValidadorIf;
import serpro.ppgd.negocio.Valor;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorCPF;

public class Conjuge
extends ObjetoNegocio
implements ObjetoFicha {
    protected transient IdentificadorDeclaracao identificadorDeclaracao = null;
    protected static final String CONJUGE_APRESENTOU_SIMPLES = "O c\u00f4njuge ou companheiro(a) apresentou declara\u00e7\u00e3o de ajuste anual do exerc\u00edcio " + ConstantesGlobais.EXERCICIO + "?";
    protected static final String CONJUGE_CPF = "CPF";
    protected static final String CONJUGE_BASECALCULO = "Base de c\u00e1lculo";
    protected static final String CONJUGE_SIMPLES_IMPOSTORETIDOFONTE = "Imposto retido na fonte";
    protected static final String CONJUGE_RENDTRIBUTACAOEXCLUSIVA = "Rendimentos sujeitos \u00e0 tributa\u00e7\u00e3o exclusiva";
    protected static final String CONJUGE_RENDPJEXIGIBILIDADESUSPENSA = "Rendimentos Recebidos de PJ (Exigibilidade Suspen\u00e7a)";
    protected static final String CONJUGE_IMPOSTORETIDOFONTE = "Imposto retido na fonte";
    protected static final String CONJUGE_CARNELEAO = "Carn\u00ea-Le\u00e3o e imposto complementar";
    protected static final String CONJUGE_RENDISENTOSNAOTRIBUTAVEIS = "Rendimentos isentos e n\u00e3o tribut\u00e1veis";
    protected static final String CONJUGE_RESULTADO = "Resultado";
    public static final String CONJUGE_ENTREGOU = "S";
    protected static final String CONJUGE_NAO_ENTREGOU = "N";
    private Valor valAntigoImpostoRetidoFonte = new Valor((ObjetoNegocio)this, "");
    private Valor valAntigoCarneLeao = new Valor((ObjetoNegocio)this, "");
    private CPF cpfConjuge = new CPF((ObjetoNegocio)this, "CPF");
    private Alfa decEntregou = new Alfa((ObjetoNegocio)this, CONJUGE_APRESENTOU_SIMPLES, 1);
    private ai baseCalculoImposto = new ai(this, "Base de c\u00e1lculo");
    private ai impRetidoFonte = new ai(this, "Imposto retido na fonte");
    private ai carneComImpComplementar = new ai(this, "Carn\u00ea-Le\u00e3o e imposto complementar");
    private ai rendIsentoNaoTributaveis = new ai(this, "Rendimentos isentos e n\u00e3o tribut\u00e1veis");
    private ai rendSujeitosTribExcl = new ai(this, "Rendimentos sujeitos \u00e0 tributa\u00e7\u00e3o exclusiva");
    private ai rendPJExigibilidadeSuspensa = new ai(this, "Rendimentos Recebidos de PJ (Exigibilidade Suspen\u00e7a)");
    private ai resultado = new ai(this, "Resultado");

    public Conjuge(IdentificadorDeclaracao identificadorDeclaracao) {
        this.identificadorDeclaracao = identificadorDeclaracao;
        this.setFicha("Informa\u00e7\u00f5es do C\u00f4njuge ou Companheiro(a)");
        this.valAntigoCarneLeao.setAtributoPersistente(false);
        this.valAntigoImpostoRetidoFonte.setAtributoPersistente(false);
        this.decEntregou.setHabilitado(false);
        this.baseCalculoImposto.setHabilitado(false);
        this.impRetidoFonte.setHabilitado(false);
        this.carneComImpComplementar.setReadOnly(true);
        this.rendIsentoNaoTributaveis.setHabilitado(false);
        this.rendSujeitosTribExcl.setHabilitado(false);
        this.rendPJExigibilidadeSuspensa.setHabilitado(false);
        this.resultado.setReadOnly(true);
        identificadorDeclaracao = new ValidadorCPF(3);
        identificadorDeclaracao.setMensagemValidacao(dL.a("conjuge_cpf_invalido"));
        this.getCpfConjuge().addValidador((ValidadorIf)identificadorDeclaracao);
        this.getCpfConjuge().addValidador((ValidadorIf)new a(this, 3));
        this.getDecEntregou().addValidador((ValidadorIf)new b(this, 2));
        this.getDecEntregou().addObservador((Observador)new c(this));
    }

    public boolean existeDeclaracaoConjuge() {
        boolean bl2 = !this.cpfConjuge.isVazio() && this.cpfConjuge.isValido() && IRPFFacade.existeDeclaracao(this.cpfConjuge.naoFormatado());
        return bl2;
    }

    public DeclaracaoIRPF obterDeclaracaoConjuge() {
        return IRPFFacade.getInstancia().recuperarDeclaracaoIRPF(this.cpfConjuge.naoFormatado());
    }

    public boolean existeDeclaracaoConjugeNaoEspolio() {
        DeclaracaoIRPF declaracaoIRPF;
        return this.existeDeclaracaoConjuge() && !(declaracaoIRPF = this.obterDeclaracaoConjuge()).getIdentificadorDeclaracao().isEspolio();
    }

    public void importarDadosConjuge() {
        DeclaracaoIRPF declaracaoIRPF = this.obterDeclaracaoConjuge();
        if (declaracaoIRPF.getIdentificadorDeclaracao().isCompleta()) {
            this.getBaseCalculoImposto().setConteudo(declaracaoIRPF.getModeloCompleta().getBaseCalculo());
            Valor valor = declaracaoIRPF.getResumo().getCalculoImposto().getTotalImpostoPago();
            valor.append('-', declaracaoIRPF.getResumo().getCalculoImposto().getImpostoRetidoRRA());
            this.getImpRetidoFonte().setConteudo(valor);
            this.getRendIsentoNaoTributaveis().setConteudo(declaracaoIRPF.getModeloCompleta().getRendIsentosNaoTributaveis());
            this.getRendSujeitosTribExcl().setConteudo((Valor)declaracaoIRPF.getModeloCompleta().getRendSujeitoTribExclusiva());
            valor = declaracaoIRPF.getModeloCompleta().getRendTributaveisExigibilidadeSuspensa();
            valor.append('-', declaracaoIRPF.getModeloCompleta().getDepositosJudiciais());
            this.getRendPJExigibilidadeSuspensa().setConteudo(valor);
        } else {
            this.getBaseCalculoImposto().setConteudo(declaracaoIRPF.getModeloSimplificada().getBaseCalculo());
            Valor valor = declaracaoIRPF.getResumo().getCalculoImposto().getTotalImpostoPago();
            valor.append('-', declaracaoIRPF.getResumo().getCalculoImposto().getImpostoRetidoRRA());
            this.getImpRetidoFonte().setConteudo(valor);
            this.getRendIsentoNaoTributaveis().setConteudo(declaracaoIRPF.getModeloSimplificada().getRendIsentosNaoTributaveis());
            this.getRendSujeitosTribExcl().setConteudo(declaracaoIRPF.getModeloSimplificada().getRendSujeitoTribExclusiva());
            valor = declaracaoIRPF.getModeloSimplificada().getRendTributaveisExigibilidadeSuspensa();
            valor.append('-', declaracaoIRPF.getModeloSimplificada().getDepositosJudiciais());
            this.getRendPJExigibilidadeSuspensa().setConteudo(valor);
        }
        if (!this.isValoresZerados()) {
            this.getDecEntregou().setConteudo(CONJUGE_ENTREGOU);
        }
    }

    private boolean isValoresZerados() {
        return this.decEntregou.isVazio() && this.baseCalculoImposto.isVazio() && this.impRetidoFonte.isVazio() && this.rendIsentoNaoTributaveis.isVazio() && this.rendSujeitosTribExcl.isVazio() && this.rendPJExigibilidadeSuspensa.isVazio() && this.resultado.isVazio();
    }

    public boolean isVazio() {
        return this.cpfConjuge.isVazio() && this.isValoresZerados();
    }

    public Valor getValAntigoCarneLeao() {
        return this.valAntigoCarneLeao;
    }

    public Valor getValAntigoImpostoRetidoFonte() {
        return this.valAntigoImpostoRetidoFonte;
    }

    public CPF getCpfConjuge() {
        return this.cpfConjuge;
    }

    public Alfa getDecEntregou() {
        return this.decEntregou;
    }

    public Valor getBaseCalculoImposto() {
        return this.baseCalculoImposto;
    }

    public Valor getImpRetidoFonte() {
        return this.impRetidoFonte;
    }

    public Valor getCarneComImpComplementar() {
        return this.carneComImpComplementar;
    }

    public Valor getRendIsentoNaoTributaveis() {
        return this.rendIsentoNaoTributaveis;
    }

    public Valor getRendSujeitosTribExcl() {
        return this.rendSujeitosTribExcl;
    }

    public ai getResultado() {
        return this.resultado;
    }

    protected List<Informacao> recuperarListaCamposPendencia() {
        List list = super.recuperarListaCamposPendencia();
        list.add(this.getCpfConjuge());
        list.add(this.getDecEntregou());
        return list;
    }

    public String getClasseFicha() {
        return PainelConjuge.class.getName();
    }

    public String getNomeAba() {
        return null;
    }

    public ai getRendPJExigibilidadeSuspensa() {
        return this.rendPJExigibilidadeSuspensa;
    }

    public String getTituloFichaDashboard() {
        return null;
    }
}

