/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.contribuinte;

import classes.dL;
import classes.dc;
import java.util.ArrayList;
import java.util.List;
import serpro.ppgd.irpf.IdentificadorDeclaracao;
import serpro.ppgd.irpf.Y;
import serpro.ppgd.irpf.af;
import serpro.ppgd.irpf.contribuinte.A;
import serpro.ppgd.irpf.contribuinte.B;
import serpro.ppgd.irpf.contribuinte.C;
import serpro.ppgd.irpf.contribuinte.D;
import serpro.ppgd.irpf.contribuinte.E;
import serpro.ppgd.irpf.contribuinte.F;
import serpro.ppgd.irpf.contribuinte.G;
import serpro.ppgd.irpf.contribuinte.H;
import serpro.ppgd.irpf.contribuinte.I;
import serpro.ppgd.irpf.contribuinte.J;
import serpro.ppgd.irpf.contribuinte.K;
import serpro.ppgd.irpf.contribuinte.L;
import serpro.ppgd.irpf.contribuinte.M;
import serpro.ppgd.irpf.contribuinte.N;
import serpro.ppgd.irpf.contribuinte.O;
import serpro.ppgd.irpf.contribuinte.P;
import serpro.ppgd.irpf.contribuinte.a;
import serpro.ppgd.irpf.contribuinte.b;
import serpro.ppgd.irpf.contribuinte.c;
import serpro.ppgd.irpf.contribuinte.d;
import serpro.ppgd.irpf.contribuinte.e;
import serpro.ppgd.irpf.contribuinte.f;
import serpro.ppgd.irpf.contribuinte.g;
import serpro.ppgd.irpf.contribuinte.h;
import serpro.ppgd.irpf.contribuinte.i;
import serpro.ppgd.irpf.contribuinte.j;
import serpro.ppgd.irpf.contribuinte.k;
import serpro.ppgd.irpf.contribuinte.l;
import serpro.ppgd.irpf.contribuinte.m;
import serpro.ppgd.irpf.contribuinte.n;
import serpro.ppgd.irpf.contribuinte.o;
import serpro.ppgd.irpf.contribuinte.p;
import serpro.ppgd.irpf.contribuinte.q;
import serpro.ppgd.irpf.contribuinte.r;
import serpro.ppgd.irpf.contribuinte.s;
import serpro.ppgd.irpf.contribuinte.t;
import serpro.ppgd.irpf.contribuinte.u;
import serpro.ppgd.irpf.contribuinte.v;
import serpro.ppgd.irpf.contribuinte.w;
import serpro.ppgd.irpf.contribuinte.x;
import serpro.ppgd.irpf.contribuinte.y;
import serpro.ppgd.irpf.contribuinte.z;
import serpro.ppgd.irpf.gui.contribuinte.PainelEscolheContribuinte;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.CEP;
import serpro.ppgd.negocio.CPF;
import serpro.ppgd.negocio.Codigo;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.Data;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.Logico;
import serpro.ppgd.negocio.ObjetoFicha;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.ValidadorIf;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorCodigo;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorTituloEleitor;

public class Contribuinte
extends ObjetoNegocio
implements ObjetoFicha {
    public static final String CODIGO_NATUREZA_OCUPACAO_AUTONOMO = "11";
    public static final String CODIGO_NATUREZA_OCUPACAO_CAPITALISTA = "13";
    public static final String CODIGO_NATUREZA_OCUPACAO_MICROEMPREENDEDOR_INDIVIDUAL = "14";
    public static final String CODIGO_NATUREZA_OCUPACAO_APOSENTADO = "61";
    public static final String CODIGO_NATUREZA_OCUPACAO_APOSENTADO_PORTADOR_MOLESTIA = "62";
    public static final String CODIGO_NATUREZA_OCUPACAO_PENSAO_ALIMENTICIA_JUDICIAL = "71";
    public static final String CODIGO_NATUREZA_OCUPACAO_BOLSISTA = "72";
    public static final String CODIGO_NATUREZA_ESPOLIO = "81";
    public static final String CODIGO_OCUPACAO_PRINCIPAL_TITULAR_CARTORIO = "117";
    public static final String DEFICIENTE_SIM = "S";
    public static final String DEFICIENTE_NAO = "N";
    public static final String POSSUI_CONJUGE_VAZIO = "2";
    protected transient IdentificadorDeclaracao identificadorDeclaracao = null;
    private Data dataNascimento = new Data((ObjetoNegocio)this, "Data de Nascimento");
    private Alfa tituloEleitor = new Alfa((ObjetoNegocio)this, "T\u00edtulo de Eleitor", 10);
    private Alfa exterior = new Alfa((ObjetoNegocio)this, "Exterior?", 2);
    private CPF cpfProcurador = new CPF((ObjetoNegocio)this, "CPF do procurador");
    private Alfa conjuge = new Alfa((ObjetoNegocio)this, "C\u00f4njuge?", 2);
    private CPF cpfConjuge = new CPF((ObjetoNegocio)this, "CPF do c\u00f4njuge ou companheiro(a)");
    private Codigo tipoLogradouro = new Codigo((ObjetoNegocio)this, "Tipo de Logradouro", dc.F());
    private Alfa logradouro = new Alfa((ObjetoNegocio)this, "Logradouro", 40);
    private Alfa logradouroExt = new Alfa((ObjetoNegocio)this, "Logradouro", 40);
    private Alfa numero = new Alfa((ObjetoNegocio)this, "N\u00famero", 6);
    private Alfa numeroExt = new Alfa((ObjetoNegocio)this, "N\u00famero", 6);
    private Alfa complemento = new Alfa((ObjetoNegocio)this, "Complemento", 21);
    private Alfa complementoExt = new Alfa((ObjetoNegocio)this, "Complemento", 21);
    private Alfa bairro = new Alfa((ObjetoNegocio)this, "Bairro", 19);
    private Alfa bairroExt = new Alfa((ObjetoNegocio)this, "Bairro", 19);
    private Codigo pais = new Codigo((ObjetoNegocio)this, "Pa\u00eds", dc.c());
    private Alfa nomePais = new Alfa((ObjetoNegocio)this, "Nome Pa\u00eds", 200);
    private Codigo codigoExterior = new Codigo((ObjetoNegocio)this, "Cod. EX", dc.D());
    private Codigo uf = new Codigo((ObjetoNegocio)this, "UF", dc.a(1));
    private Codigo municipio = new Codigo((ObjetoNegocio)this, "Munic\u00edpio", new ArrayList());
    private Alfa cidade = new Alfa((ObjetoNegocio)this, "Cidade", 40);
    private CEP cep = new CEP((ObjetoNegocio)this, "CEP");
    private CEP cepExt = new CEP((ObjetoNegocio)this, "C\u00f3digo Postal");
    private Alfa ddd = new Alfa((ObjetoNegocio)this, "DDD", 2);
    private Alfa ddi = new Alfa((ObjetoNegocio)this, "DDI", 4);
    private Alfa telefone = new Alfa((ObjetoNegocio)this, "Telefone", 9);
    private Alfa telefoneExt = new Alfa((ObjetoNegocio)this, "Telefone", 11);
    private Codigo naturezaOcupacao = new Codigo((ObjetoNegocio)this, "Natureza da Ocupa\u00e7\u00e3o", dc.C());
    private Codigo ocupacaoPrincipal = new Codigo((ObjetoNegocio)this, "Ocupa\u00e7\u00e3o Principal", dc.q());
    private Alfa deficiente = new Alfa((ObjetoNegocio)this, "Um dos declarantes \u00e9 pessoa com doen\u00e7a grave ou portadora de defici\u00eancia f\u00edsica ou mental?", 1);
    private Alfa registroProfissional = new Alfa((ObjetoNegocio)this, "Registro Profissional", 20);
    private Alfa dddCelular = new Alfa((ObjetoNegocio)this, "DDD Celular", 2);
    private Alfa celular = new Alfa((ObjetoNegocio)this, "Celular", 9);
    private Alfa email = new Alfa((ObjetoNegocio)this, "E-mail", 90);
    private String UltimaPaisSelecionadoExterior = "";

    public Contribuinte(IdentificadorDeclaracao identificadorDeclaracao) {
        this.identificadorDeclaracao = identificadorDeclaracao;
        this.getDeficiente().setConteudo(DEFICIENTE_NAO);
        this.getPais().setConteudo("105");
        this.getPais().setColunaFiltro(1);
        this.getPais().addObservador((Observador)new a(this));
        this.getExterior().addObservador((Observador)new l(this));
        this.getExterior().setConteudo(Logico.NAO);
        this.getPais().addValidador((ValidadorIf)new w(this, 3));
        this.getPais().addValidador((ValidadorIf)new H(this, 3, dL.a("pais_branco")));
        this.getDdd().addValidador((ValidadorIf)new I(this, 3));
        this.getDddCelular().addValidador((ValidadorIf)new J(this, 3));
        this.getDddCelular().addValidador((ValidadorIf)new K(this, 3, dL.a("ddd_celular")));
        this.getCelular().addValidador((ValidadorIf)new L(this, 3));
        this.getEmail().setDesprezarMascara(false);
        this.getEmail().addValidador((ValidadorIf)new M(this, 3));
        this.getUf().setColunaFiltro(1);
        this.getUf().addValidador((ValidadorIf)new b(this, 3, dL.a("uf_branco")));
        this.getUf().addValidador((ValidadorIf)new ValidadorCodigo(3, dL.a("uf_invalida")));
        this.getUf().addObservador((Observador)new c(this));
        this.getDataNascimento().addValidador((ValidadorIf)new d(this, 3));
        this.getDataNascimento().addValidador((ValidadorIf)new P(3));
        this.getTituloEleitor().addValidador((ValidadorIf)new e(this, 3));
        this.getTipoLogradouro().setColunaFiltro(1);
        this.getTipoLogradouro().addValidador((ValidadorIf)new f(this, 3, dL.a("tipo_logradouro_branco")));
        this.getTipoLogradouro().addValidador((ValidadorIf)new ValidadorCodigo(3, "\"" + this.getTipoLogradouro().getNomeCampo() + "\" est\u00e1 em branco."));
        this.getLogradouro().addObservador((Observador)new Y());
        this.getLogradouro().addValidador((ValidadorIf)new O(3));
        this.getLogradouroExt().addValidador((ValidadorIf)new O(3));
        this.getNumero().addValidador((ValidadorIf)new O(3));
        this.getNumeroExt().addValidador((ValidadorIf)new O(3));
        this.getComplemento().addObservador((Observador)new Y());
        this.getComplemento().addValidador((ValidadorIf)new O(3));
        this.getBairro().addObservador((Observador)new Y());
        this.getBairro().addValidador((ValidadorIf)new O(3));
        this.getMunicipio().addValidador((ValidadorIf)new O(3));
        this.getMunicipio().setColunaFiltro(1);
        this.getMunicipio().addValidador((ValidadorIf)new g(this, 3));
        this.getMunicipio().addValidador((ValidadorIf)new ValidadorCodigo(3, dL.a("municipio_branco")));
        this.getCidade().addValidador((ValidadorIf)new h(this, 3));
        this.getCidade().addValidador((ValidadorIf)new i(this, 3));
        this.getCodigoExterior().addValidador((ValidadorIf)new j(this, 3));
        this.getCodigoExterior().addValidador((ValidadorIf)new ValidadorCodigo(3, dL.a("codigo_exterior_branco")));
        this.getCep().addValidador((ValidadorIf)new k(this, 3, dL.a("cep_branco")));
        this.getCep().addValidador((ValidadorIf)new m(this, 3));
        this.getCep().addValidador((ValidadorIf)new n(this, 3));
        this.getNaturezaOcupacao().setColunaFiltro(1);
        this.getNaturezaOcupacao().addValidador((ValidadorIf)new o(this, 3));
        this.getNaturezaOcupacao().addValidador((ValidadorIf)new ValidadorCodigo(3, dL.a("natureza_ocup_branco")));
        this.getNaturezaOcupacao().addObservador((Observador)new p(this));
        this.getNaturezaOcupacao().addObservador((Observador)new q(this));
        this.getOcupacaoPrincipal().addObservador((Observador)new r(this, identificadorDeclaracao));
        this.getOcupacaoPrincipal().setColunaFiltro(1);
        this.getOcupacaoPrincipal().addValidador((ValidadorIf)new s(this, 3));
        this.getOcupacaoPrincipal().addValidador((ValidadorIf)new ValidadorCodigo(3, dL.a("ocup_principal_branco")));
        this.getDeclaracaoRetificadora().addObservador((Observador)new N(this));
        this.getLogradouro().addValidador((ValidadorIf)new t(this, 3));
        this.getLogradouroExt().addValidador((ValidadorIf)new u(this, 3));
        this.getUf().addValidador((ValidadorIf)new v(this, 3));
        this.getCpfProcurador().addValidador((ValidadorIf)new x(this, 3));
        this.getCpfProcurador().addValidador((ValidadorIf)new y(this, 2));
        this.getCpfProcurador().addValidador((ValidadorIf)new z(this, 3));
        this.getConjuge().setConteudo(POSSUI_CONJUGE_VAZIO);
        this.getConjuge().addValidador((ValidadorIf)new A(this, 3, dL.a("pergunta_possui_conjuge_branco")));
        this.getConjuge().addObservador((Observador)new B(this));
        this.getCpfConjuge().addValidador((ValidadorIf)new C(this, 3));
        this.getCpfConjuge().addValidador((ValidadorIf)new D(this, 3));
        if (this.identificadorDeclaracao.isEspolio()) {
            this.getNaturezaOcupacao().setConteudo(CODIGO_NATUREZA_ESPOLIO);
            this.getNaturezaOcupacao().setHabilitado(false);
        } else if (!this.identificadorDeclaracao.isEspolio()) {
            this.getTituloEleitor().addValidador((ValidadorIf)new af(2, dL.a("titulo_eleitoral_branco")));
            this.getTituloEleitor().addValidador((ValidadorIf)new ValidadorTituloEleitor(3));
        }
        this.getPais().addObservador((Observador)new E(this));
        this.getTelefone().addValidador((ValidadorIf)new F(this, 3));
        this.getTelefoneExt().addValidador((ValidadorIf)new G(this, 3));
        this.setFicha("Identifica\u00e7\u00e3o do Contribuinte");
    }

    public Boolean maiorDe16Anos() {
        String string = "01/01/" + (Integer.parseInt(ConstantesGlobais.EXERCICIO_ANTERIOR) - 16);
        Data data = new Data();
        data.setConteudo(string);
        if (!this.getDataNascimento().isVazio() && this.getDataNascimento().maisAntiga(data)) {
            return true;
        }
        return false;
    }

    public Codigo getCodigoExterior() {
        return this.codigoExterior;
    }

    public Codigo getPais() {
        return this.pais;
    }

    public Alfa getBairro() {
        return this.bairro;
    }

    public CEP getCep() {
        return this.cep;
    }

    public Alfa getComplemento() {
        return this.complemento;
    }

    public Data getDataNascimento() {
        return this.dataNascimento;
    }

    public Alfa getDdd() {
        return this.ddd;
    }

    public Alfa getDeclaracaoRetificadora() {
        return this.identificadorDeclaracao.getDeclaracaoRetificadora();
    }

    public Alfa getEnderecoDiferente() {
        return this.identificadorDeclaracao.getEnderecoDiferente();
    }

    public Alfa getExterior() {
        return this.exterior;
    }

    public Codigo getMunicipio() {
        return this.municipio;
    }

    public Codigo getNaturezaOcupacao() {
        return this.naturezaOcupacao;
    }

    public Alfa getNumero() {
        return this.numero;
    }

    public Alfa getNumeroReciboDecAnterior() {
        return this.identificadorDeclaracao.getNumeroReciboDecAnterior();
    }

    public Codigo getOcupacaoPrincipal() {
        return this.ocupacaoPrincipal;
    }

    public Alfa getTelefone() {
        return this.telefone;
    }

    public Alfa getTelefoneExt() {
        return this.telefoneExt;
    }

    public Codigo getTipoLogradouro() {
        return this.tipoLogradouro;
    }

    public Alfa getTituloEleitor() {
        return this.tituloEleitor;
    }

    public Alfa getLogradouro() {
        return this.logradouro;
    }

    public Codigo getUf() {
        return this.uf;
    }

    protected List<Informacao> recuperarListaCamposPendencia() {
        ArrayList<Informacao> arrayList = new ArrayList<Informacao>();
        arrayList.add((Informacao)this.identificadorDeclaracao.getDeclaracaoRetificadora());
        arrayList.add((Informacao)this.identificadorDeclaracao.getNumReciboDecRetif());
        arrayList.add((Informacao)this.identificadorDeclaracao.getNumeroReciboDecAnterior());
        arrayList.add((Informacao)this.identificadorDeclaracao.getCpf());
        arrayList.add((Informacao)this.identificadorDeclaracao.getNome());
        arrayList.add((Informacao)this.identificadorDeclaracao.getEnderecoDiferente());
        arrayList.add((Informacao)this.identificadorDeclaracao.getTipoDeclaracaoAES());
        arrayList.addAll(this.recuperarCamposInformacao());
        return arrayList;
    }

    public Alfa getCidade() {
        return this.cidade;
    }

    public Alfa getNumReciboDecRetif() {
        return this.identificadorDeclaracao.getNumReciboDecRetif();
    }

    public Alfa getLogradouroExt() {
        return this.logradouroExt;
    }

    public Alfa getNumeroExt() {
        return this.numeroExt;
    }

    public Alfa getComplementoExt() {
        return this.complementoExt;
    }

    public Alfa getBairroExt() {
        return this.bairroExt;
    }

    public CEP getCepExt() {
        return this.cepExt;
    }

    public IdentificadorDeclaracao getIdentificadorDeclaracao() {
        return this.identificadorDeclaracao;
    }

    public Alfa getDdi() {
        return this.ddi;
    }

    public String getClasseFicha() {
        return PainelEscolheContribuinte.class.getName();
    }

    public String getNomeAba() {
        return null;
    }

    public Alfa getDeficiente() {
        return this.deficiente;
    }

    public CPF getCpfProcurador() {
        return this.cpfProcurador;
    }

    public Alfa getNomePais() {
        return this.nomePais;
    }

    public Alfa getConjuge() {
        return this.conjuge;
    }

    public CPF getCpfConjuge() {
        return this.cpfConjuge;
    }

    public Alfa getRegistroProfissional() {
        return this.registroProfissional;
    }

    public boolean isOcupacaoComRegistroProfissionalObrigatorio(String string) {
        if ("E".equals(string)) {
            return false;
        }
        string = this.getOcupacaoPrincipal().naoFormatado().trim();
        return string.equals("225") || string.equals("226") || string.equals("229") || string.equals("255") || string.equals("241") || string.equals("355");
    }

    public Alfa getDddCelular() {
        return this.dddCelular;
    }

    public Alfa getCelular() {
        return this.celular;
    }

    public Alfa getEmail() {
        return this.email;
    }

    public String getTituloFichaDashboard() {
        return "Identifica\u00e7\u00e3o do Contribuinte";
    }

    static /* synthetic */ Codigo a(Contribuinte contribuinte) {
        return contribuinte.pais;
    }

    static /* synthetic */ void a(Contribuinte contribuinte, String string) {
        contribuinte.UltimaPaisSelecionadoExterior = string;
    }

    static /* synthetic */ Alfa b(Contribuinte contribuinte) {
        return contribuinte.ddd;
    }

    static /* synthetic */ String c(Contribuinte contribuinte) {
        return contribuinte.UltimaPaisSelecionadoExterior;
    }

    static /* synthetic */ Codigo d(Contribuinte contribuinte) {
        return contribuinte.uf;
    }

    static /* synthetic */ Codigo e(Contribuinte contribuinte) {
        return contribuinte.municipio;
    }

    static /* synthetic */ Alfa f(Contribuinte contribuinte) {
        return contribuinte.exterior;
    }

    static /* synthetic */ Codigo g(Contribuinte contribuinte) {
        return contribuinte.naturezaOcupacao;
    }

    static /* synthetic */ Codigo h(Contribuinte contribuinte) {
        return contribuinte.ocupacaoPrincipal;
    }

    static /* synthetic */ Alfa i(Contribuinte contribuinte) {
        return contribuinte.logradouro;
    }

    static /* synthetic */ Alfa j(Contribuinte contribuinte) {
        return contribuinte.complemento;
    }

    static /* synthetic */ Alfa k(Contribuinte contribuinte) {
        return contribuinte.logradouroExt;
    }

    static /* synthetic */ Alfa l(Contribuinte contribuinte) {
        return contribuinte.complementoExt;
    }
}

