/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.declaracao.assistida.informerendimentos;

import java.io.File;
import java.io.IOException;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.xml.sax.SAXException;
import serpro.ppgd.irpf.ai;
import serpro.ppgd.irpf.declaracao.assistida.informerendimentos.ColecaoItemPagamento;
import serpro.ppgd.irpf.declaracao.assistida.informerendimentos.ColecaoItemRendAcm;
import serpro.ppgd.irpf.declaracao.assistida.informerendimentos.ColecaoItemRendIsentoOuTributacaoExclusiva;
import serpro.ppgd.irpf.declaracao.assistida.informerendimentos.ColecaoItemRendPJ;
import serpro.ppgd.irpf.declaracao.assistida.informerendimentos.ColecaoItemRendPJComExigibilidade;
import serpro.ppgd.irpf.declaracao.assistida.informerendimentos.HeaderInformeRendimentos;
import serpro.ppgd.irpf.declaracao.assistida.informerendimentos.ItemPagamento;
import serpro.ppgd.irpf.declaracao.assistida.informerendimentos.a;
import serpro.ppgd.irpf.declaracao.assistida.informerendimentos.d;
import serpro.ppgd.irpf.declaracao.assistida.informerendimentos.g;
import serpro.ppgd.negocio.ObjetoNegocio;

public class InformeRendimentosPJ
extends ObjetoNegocio {
    private HeaderInformeRendimentos header = new HeaderInformeRendimentos();
    private ColecaoItemRendPJ colecaoRendimentosPessoaJuridica = new ColecaoItemRendPJ();
    private ColecaoItemPagamento colecaoPagamentosPrevidenciaComplementar = new ColecaoItemPagamento();
    private ColecaoItemPagamento colecaoPagamentosPensaoAlimenticia = new ColecaoItemPagamento();
    private ColecaoItemRendIsentoOuTributacaoExclusiva rendimentosIsentos = new ColecaoItemRendIsentoOuTributacaoExclusiva();
    private ColecaoItemRendIsentoOuTributacaoExclusiva rendimentosTributacaoExclusiva = new ColecaoItemRendIsentoOuTributacaoExclusiva();
    private ColecaoItemRendAcm colecaoRendimentosRecebidosAcumuladamente = new ColecaoItemRendAcm();
    private ColecaoItemRendPJComExigibilidade colecaoRendimentosExigibilidadeSuspensa = new ColecaoItemRendPJComExigibilidade();
    private ColecaoItemPagamento pagamentos = new ColecaoItemPagamento();
    public static final int TIPO_INFORME_TITULAR = 1;
    public static final int TIPO_INFORME_DEPENDENTE = 2;
    private int tipoInforme = 0;

    public InformeRendimentosPJ() {
        this.adicionaValidadores();
    }

    public void adicionaValidadores() {
        this.getColecaoPagamentosPensaoAlimenticia().addObservador("ObjetoInserido", new a(this));
        this.getColecaoRendimentosRecebidosAcumuladamente().addObservador("ObjetoInserido", new d(this));
        this.getPagamentos().addObservador("ObjetoInserido", new g(this));
    }

    public void ajustar13PensoesAlimenticias() {
        for (ItemPagamento itemPagamento : this.getColecaoPagamentosPensaoAlimenticia().itens()) {
            ai ai2 = new ai();
            ai2.setConteudo(itemPagamento.getValorPago());
            ai2.append('+', itemPagamento.getValorDecimoTerceiro());
            itemPagamento.getValorPago().setConteudo(ai2.naoFormatado());
        }
    }

    public static boolean validate(String object, String string) {
        Source source = null;
        try {
            source = new StreamSource(new File(string));
            object = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(new File((String)object));
            object = ((Schema)object).newValidator();
            ((Validator)object).validate(source);
        }
        catch (SAXException sAXException) {
            System.out.println(String.valueOf(source.getSystemId()) + " is NOT valid");
            System.out.println("Reason: " + sAXException.getLocalizedMessage());
            return false;
        }
        catch (IOException iOException) {
            System.out.println(String.valueOf(source.getSystemId()) + " is NOT valid");
            System.out.println("Reason: " + iOException.getLocalizedMessage());
            return false;
        }
        return true;
    }

    public HeaderInformeRendimentos getHeader() {
        return this.header;
    }

    public ColecaoItemRendPJ getColecaoRendimentosPessoaJuridica() {
        return this.colecaoRendimentosPessoaJuridica;
    }

    public ColecaoItemPagamento getColecaoPagamentosPrevidenciaComplementar() {
        return this.colecaoPagamentosPrevidenciaComplementar;
    }

    public ColecaoItemPagamento getColecaoPagamentosPensaoAlimenticia() {
        return this.colecaoPagamentosPensaoAlimenticia;
    }

    public ColecaoItemRendIsentoOuTributacaoExclusiva getRendimentosIsentos() {
        return this.rendimentosIsentos;
    }

    public ColecaoItemRendIsentoOuTributacaoExclusiva getRendimentosTributacaoExclusiva() {
        return this.rendimentosTributacaoExclusiva;
    }

    public ColecaoItemRendAcm getColecaoRendimentosRecebidosAcumuladamente() {
        return this.colecaoRendimentosRecebidosAcumuladamente;
    }

    public ColecaoItemRendPJComExigibilidade getColecaoRendimentosExigibilidadeSuspensa() {
        return this.colecaoRendimentosExigibilidadeSuspensa;
    }

    public ColecaoItemPagamento getPagamentos() {
        return this.pagamentos;
    }

    public int getTipoInforme() {
        return this.tipoInforme;
    }

    public void setTipoInforme(int n2) {
        this.tipoInforme = n2;
    }
}

