/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.dependentes;

import classes.dL;
import classes.dP;
import classes.dc;
import java.util.List;
import serpro.ppgd.cacheni.CacheNI;
import serpro.ppgd.gui.xbeans.JEditObjetoNegocioItemIf;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.IdentificadorDeclaracao;
import serpro.ppgd.irpf.Y;
import serpro.ppgd.irpf.af;
import serpro.ppgd.irpf.ag;
import serpro.ppgd.irpf.contribuinte.P;
import serpro.ppgd.irpf.dependentes.a;
import serpro.ppgd.irpf.dependentes.b;
import serpro.ppgd.irpf.dependentes.c;
import serpro.ppgd.irpf.dependentes.d;
import serpro.ppgd.irpf.dependentes.e;
import serpro.ppgd.irpf.dependentes.f;
import serpro.ppgd.irpf.dependentes.g;
import serpro.ppgd.irpf.dependentes.h;
import serpro.ppgd.irpf.dependentes.i;
import serpro.ppgd.irpf.gui.dependentes.PainelDependentesLista;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.CPF;
import serpro.ppgd.negocio.Codigo;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.Data;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.NI;
import serpro.ppgd.negocio.ObjetoFicha;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.ValidadorIf;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorCodigo;

public class Dependente
extends ObjetoNegocio
implements JEditObjetoNegocioItemIf,
ObjetoFicha {
    public static final String RESPOSTA_SAIDA_VAZIA = "2";
    public static final String PROP_CAMPO_NOME = "Nome";
    public static final String PROP_CAMPO_CPF = "CPF";
    private Codigo codigo = new Codigo((ObjetoNegocio)this, "C\u00f3digo", dc.n());
    private Alfa nome = new Alfa((ObjetoNegocio)this, "Nome", 60);
    private CPF cpfDependente = new CPF((ObjetoNegocio)this, "CPF");
    private Data dataNascimento = new Data((ObjetoNegocio)this, "Data de Nascimento");
    private Alfa indSaidaPaisMesmaData = new Alfa((ObjetoNegocio)this, "Saiu do pa\u00eds na mesma data do contribuinte?", 1);
    private boolean isSaida = false;
    private transient IdentificadorDeclaracao identificadorDeclaracao = null;
    private String chave = "";

    public Dependente(DeclaracaoIRPF declaracaoIRPF) {
        this.identificadorDeclaracao = declaracaoIRPF.getIdentificadorDeclaracao();
        this.isSaida = this.identificadorDeclaracao.getTipoDeclaracaoAES().formatado().equals(dP.c.a());
        this.setFicha("Dependentes");
        CacheNI.getInstancia().registrarNINome((NI)this.cpfDependente, this.nome);
        this.getCodigo().setColunaFiltro(1);
        this.getCodigo().addValidador((ValidadorIf)new af(3, dL.a("dependente_codigo_branco")));
        this.getCodigo().addValidador((ValidadorIf)new ValidadorCodigo(3, dL.a("dependente_codigo_invalido")));
        this.getCodigo().addValidador((ValidadorIf)new a(this, 3, dL.a("dependente_excedeu_limite_rendimentos", new String[]{"22.847,76"}), declaracaoIRPF));
        this.getNome().addValidador((ValidadorIf)new ag());
        this.getNome().addValidador((ValidadorIf)new b(this, 3, dL.a("dependente_nome_branco")));
        this.getNome().addObservador((Observador)new Y());
        String string = "01/01/" + (Integer.parseInt(ConstantesGlobais.EXERCICIO_ANTERIOR) - 22);
        Data data = new Data();
        data.setConteudo(string);
        string = "01/01/" + (Integer.parseInt(ConstantesGlobais.EXERCICIO_ANTERIOR) - 20);
        Data data2 = new Data();
        data2.setConteudo(string);
        string = "01/01/" + (Integer.parseInt(ConstantesGlobais.EXERCICIO_ANTERIOR) - 17);
        data2 = new Data();
        data2.setConteudo(string);
        string = "01/01/" + (Integer.parseInt(ConstantesGlobais.EXERCICIO_ANTERIOR) - 11);
        data2 = new Data();
        data2.setConteudo(string);
        string = "31/12/" + (Integer.parseInt(ConstantesGlobais.EXERCICIO_ANTERIOR) - 8);
        data2 = new Data();
        data2.setConteudo(string);
        string = "01/01/" + (Integer.parseInt(ConstantesGlobais.EXERCICIO_ANTERIOR) - 25);
        data2 = new Data();
        data2.setConteudo(string);
        string = "31/12/" + (Integer.parseInt(ConstantesGlobais.EXERCICIO_ANTERIOR) - 21);
        Data data3 = new Data();
        data3.setConteudo(string);
        this.getCpfDependente().addValidador((ValidadorIf)new c(this, 3));
        this.getCpfDependente().addValidador((ValidadorIf)new af(3, dL.a("dependente_cpf_branco")));
        this.getCpfDependente().addValidador((ValidadorIf)new d(this, 3));
        this.getDataNascimento().addValidador((ValidadorIf)new P(3));
        this.getDataNascimento().addValidador((ValidadorIf)new e(this, 3, dL.a("dependente_data_branco")));
        this.getDataNascimento().addValidador((ValidadorIf)new f(this, 3, data2));
        this.getDataNascimento().addValidador((ValidadorIf)new g(this, 3, data));
        this.getDataNascimento().addValidador((ValidadorIf)new h(this, 2, declaracaoIRPF));
        if (this.isSaida) {
            this.getIndSaidaPaisMesmaData().addValidador((ValidadorIf)new i(this, 3, dL.a("dependente_saida")));
        }
    }

    private boolean isDeclaracaoSaidaComIndSaidaNaoRespondido() {
        if (this.isSaida) {
            return this.getIndSaidaPaisMesmaData().naoFormatado().equals(RESPOSTA_SAIDA_VAZIA);
        }
        return false;
    }

    public Boolean maiorDe16Anos() {
        String string = "01/01/" + (Integer.parseInt(ConstantesGlobais.EXERCICIO_ANTERIOR) - 16);
        Data data = new Data();
        data.setConteudo(string);
        if (!this.getDataNascimento().isVazio() && this.getDataNascimento().maisAntiga(data)) {
            return true;
        }
        return false;
    }

    public String toString() {
        return this.nome.naoFormatado();
    }

    public Codigo getCodigo() {
        return this.codigo;
    }

    public CPF getCpfDependente() {
        return this.cpfDependente;
    }

    public Data getDataNascimento() {
        return this.dataNascimento;
    }

    public Alfa getNome() {
        return this.nome;
    }

    public Alfa getIndSaidaPaisMesmaData() {
        return this.indSaidaPaisMesmaData;
    }

    protected List<Informacao> recuperarListaCamposPendencia() {
        List list = super.recuperarListaCamposPendencia();
        list.add(this.getCodigo());
        list.add(this.getCpfDependente());
        list.add(this.getDataNascimento());
        list.add(this.getNome());
        if (this.isSaida) {
            list.add(this.getIndSaidaPaisMesmaData());
        }
        return list;
    }

    public String getConteudo(int n2) {
        return this.getNome().formatado();
    }

    public int getTotalAtributos() {
        return 1;
    }

    public int getColunaFiltro() {
        return 0;
    }

    public String getChave() {
        return this.chave;
    }

    public void setChave(String string) {
        this.chave = string;
    }

    public IdentificadorDeclaracao getIdentificadorDeclaracao() {
        return this.identificadorDeclaracao;
    }

    public void setIdentificadorDeclaracao(IdentificadorDeclaracao identificadorDeclaracao) {
        this.identificadorDeclaracao = identificadorDeclaracao;
    }

    public boolean isVazio() {
        for (Informacao informacao : this.recuperarCamposInformacao()) {
            if (informacao.isVazio() || informacao.getNomeCampo().equals("Saiu do pa\u00eds na mesma data do contribuinte?")) continue;
            return false;
        }
        return true;
    }

    public void addObservador(Observador observador) {
        this.getCodigo().addObservador(observador);
        this.getNome().addObservador(observador);
    }

    public void removeObservador(Observador observador) {
        this.getCodigo().removeObservador(observador);
        this.getNome().removeObservador(observador);
    }

    public String getClasseFicha() {
        return PainelDependentesLista.class.getName();
    }

    public String getNomeAba() {
        return null;
    }

    public String getTituloFichaDashboard() {
        return "Dependentes";
    }

    static /* synthetic */ boolean a(Dependente dependente) {
        return dependente.isDeclaracaoSaidaComIndSaidaNaoRespondido();
    }

    static /* synthetic */ IdentificadorDeclaracao b(Dependente dependente) {
        return dependente.identificadorDeclaracao;
    }
}

