/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.dependentes;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JOptionPane;
import serpro.ppgd.infraestrutura.PlataformaPPGD;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.IRPFFacade;
import serpro.ppgd.irpf.dependentes.Dependente;
import serpro.ppgd.irpf.dependentes.j;
import serpro.ppgd.negocio.CPF;
import serpro.ppgd.negocio.Colecao;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Valor;
import serpro.ppgd.negocio.util.UtilitariosString;

public class Dependentes
extends Colecao<Dependente> {
    private transient Valor totalDeducaoDependentes = new Valor((ObjetoNegocio)this, "Total de Dedu\u00e7\u00e3o com Dependentes");
    private j obsTotalizaDep;
    private WeakReference<DeclaracaoIRPF> weakDec = null;

    public Dependentes(DeclaracaoIRPF declaracaoIRPF) {
        this.weakDec = new WeakReference<DeclaracaoIRPF>(declaracaoIRPF);
        this.setFicha("Dependentes");
        this.totalDeducaoDependentes.setReadOnly(true);
        this.totalDeducaoDependentes.setFicha(this.getFicha());
        this.totalDeducaoDependentes.setAtributoPersistente(false);
        this.obsTotalizaDep = new j(this);
        this.addObservador(this.obsTotalizaDep);
    }

    public Valor getTotalDeducaoDependentes() {
        return this.totalDeducaoDependentes;
    }

    public void objetoInserido(Dependente dependente) {
        dependente.addObservador(this.obsTotalizaDep);
    }

    public void objetoRemovido(Object object) {
        object = (Dependente)((Object)object);
        ((Dependente)((Object)object)).removeObservador(this.obsTotalizaDep);
    }

    public String getNomeDependenteByChave(String string) {
        for (Dependente dependente : this.itens()) {
            if (!dependente.getChave().equals(string)) continue;
            return dependente.getNome().formatado();
        }
        return null;
    }

    public boolean isCpfDuplicado(String string, String string2) {
        int n2 = 0;
        for (Dependente dependente : this.itens()) {
            if (!dependente.getCpfDependente().naoFormatado().equals(string)) continue;
            ++n2;
        }
        return n2 > 1;
    }

    public boolean isExisteCpf(String string) {
        for (Dependente dependente : this.itens()) {
            if (!dependente.getCpfDependente().naoFormatado().equals(string)) continue;
            return true;
        }
        return false;
    }

    public int countCpf(String string) {
        int n2 = 0;
        Iterator iterator = this.itens().iterator();
        while (iterator.hasNext()) {
            String string2 = ((Dependente)((Object)iterator.next())).getCpfDependente().naoFormatado();
            if (string2.trim().length() <= 0 || !string2.equals(string)) continue;
            ++n2;
        }
        return n2;
    }

    public boolean isExisteNome(String string) {
        for (Dependente dependente : this.itens()) {
            if (!dependente.getNome().naoFormatado().equals(string)) continue;
            return true;
        }
        return false;
    }

    public Dependente getDependenteByNome(String string) {
        if (string != null) {
            string = string.trim().toUpperCase();
            for (Dependente dependente : this.itens()) {
                if (!dependente.getNome().naoFormatado().toUpperCase().equals(string)) continue;
                return dependente;
            }
        }
        return null;
    }

    public Dependente getDependenteByCpf(String string) {
        for (Dependente dependente : this.itens()) {
            if (!dependente.getCpfDependente().naoFormatado().equals(string)) continue;
            return dependente;
        }
        return null;
    }

    public Dependente instanciaNovoObjeto() {
        return new Dependente((DeclaracaoIRPF)((Object)this.weakDec.get()));
    }

    public boolean confirmaExclusaoImportacoesDependente(String string, String string2, boolean bl2) {
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = false;
        boolean bl9 = false;
        boolean bl10 = false;
        boolean bl11 = false;
        boolean bl12 = false;
        IRPFFacade iRPFFacade = IRPFFacade.getInstancia();
        if (iRPFFacade.getPagamentos().possuiDependente(string) && !string2.isEmpty()) {
            bl3 = true;
        }
        if (iRPFFacade.getColecaoRendPJDependente().possuiDependenteComCPF(string2)) {
            bl4 = true;
        }
        if (iRPFFacade.getRendPFDependente().possuiDependenteComCPF(string2)) {
            bl5 = true;
        }
        if (iRPFFacade.getRendIsentos().possuiDependenteComCPF(string2)) {
            bl11 = true;
        }
        if (iRPFFacade.getRendTributacaoExclusiva().possuiDependenteComCPF(string2)) {
            bl12 = true;
        }
        if (!IRPFFacade.getInstancia().getIdDeclaracaoAberto().getCpf().naoFormatado().equals(string2)) {
            if (iRPFFacade.getGCAP().existeDemonstrativoParaCPF(string2)) {
                bl6 = true;
            }
            if (iRPFFacade.getRendaVariavelDependente().possuiDependenteComCPF(string2)) {
                bl7 = true;
            }
            if (iRPFFacade.getFundosInvestimentosDependente().possuiDependenteComCPF(string2)) {
                bl8 = true;
            }
        }
        if (iRPFFacade.getColecaoRendPJComExigibilidadeDependente().possuiDependenteComCPF(string2)) {
            bl9 = true;
        }
        if (iRPFFacade.getColecaoRendAcmDependente().possuiDependenteComCPF(string2)) {
            bl10 = true;
        }
        String string3 = "Este dependente (CPF: " + UtilitariosString.formataCPF((String)string2) + ") \u00e9 utilizado na(s) ficha(s): \n";
        if (bl3) {
            string3 = String.valueOf(string3) + "- Pagamentos \n";
        }
        if (bl4) {
            string3 = String.valueOf(string3) + "- Rend. Trib. Receb. de PJ \n";
        }
        if (bl5) {
            string3 = String.valueOf(string3) + "- Rend. Trib. Receb. de PF/Exterior \n";
        }
        if (bl11) {
            string3 = String.valueOf(string3) + "- Rend. Isentos e N\u00e3o Tribut\u00e1veis \n";
        }
        if (bl12) {
            string3 = String.valueOf(string3) + "- Rend. Sujeitos \u00e0 Tributa\u00e7\u00e3o Exclusiva/Definitiva \n";
        }
        if (bl9) {
            string3 = String.valueOf(string3) + "- Rend. Trib. Receb. de PJ com Exigibilidade Suspensa \n";
        }
        if (bl10) {
            string3 = String.valueOf(string3) + "- Rendimentos Recebidos Acumuladamente \n";
        }
        if (bl6) {
            string3 = String.valueOf(string3) + "- Ganhos de Capital \n";
        }
        if (bl7) {
            string3 = String.valueOf(string3) + "- Renda Vari\u00e1vel - Opera\u00e7\u00f5es Comuns/Day-Trade\n";
        }
        if (bl7) {
            string3 = String.valueOf(string3) + "- Renda Vari\u00e1vel - Opera\u00e7\u00f5es de Fundos de Investimento Imobili\u00e1rio\n";
        }
        boolean bl13 = bl3 || bl4 || bl5 || bl11 || bl12 || bl6 || bl7 || bl8 || bl9 || bl10;
        string3 = bl2 ? String.valueOf(string3) + "\nDeseja excluir mesmo assim?" : String.valueOf(string3) + "\nOs dados deste dependente na(s) ficha(s) acima ser\u00e3o exclu\u00eddos.\nDeseja alterar o CPF mesmo assim?";
        if (!bl13) {
            return true;
        }
        if (JOptionPane.showConfirmDialog(PlataformaPPGD.getPlataforma().getJanelaPrincipal(), string3, "Confirma\u00e7\u00e3o", 0) == 0) {
            if (bl3) {
                iRPFFacade.getPagamentos().excluirPagamentosComDependente(string);
            }
            if (bl4) {
                iRPFFacade.getColecaoRendPJDependente().excluirDependentesComCPF(string2);
            }
            if (bl9) {
                iRPFFacade.getColecaoRendPJComExigibilidadeDependente().excluirDependentesComCPF(string2);
            }
            if (bl10) {
                iRPFFacade.getColecaoRendAcmDependente().excluirDependentesComCPF(string2);
            }
            if (bl5) {
                iRPFFacade.getRendPFDependente().excluirDependentesComCPF(string2);
            }
            if (bl11) {
                iRPFFacade.getRendIsentos().excluirDependentesComCPF(string2);
            }
            if (bl12) {
                iRPFFacade.getRendTributacaoExclusiva().excluirDependentesComCPF(string2);
            }
            if (bl6) {
                iRPFFacade.getGCAP().removerDemonstrativosPorCPF(string2);
            }
            if (bl7) {
                iRPFFacade.getRendaVariavelDependente().excluirDependentesComCPF(string2);
            }
            if (bl8) {
                iRPFFacade.getFundosInvestimentosDependente().excluirDependentesComCPF(string2);
            }
            return true;
        }
        return false;
    }

    public Valor obterTotalRendimentosPorDependente(CPF cPF) {
        Valor valor = new Valor();
        valor.append('+', ((DeclaracaoIRPF)((Object)this.weakDec.get())).getRendPJ().getColecaoRendPJDependente().obterRendimentosRecebidosPorDependente(cPF));
        valor.append('+', ((DeclaracaoIRPF)((Object)this.weakDec.get())).getRendPFDependente().obterRendimentosRecebidosPorDependente(cPF));
        valor.append('+', ((DeclaracaoIRPF)((Object)this.weakDec.get())).getRendPJComExigibilidade().getColecaoRendPJComExigibilidadeDependente().obterRendimentosRecebidosPorDependente(cPF));
        valor.append('+', ((DeclaracaoIRPF)((Object)this.weakDec.get())).getRendAcm().getColecaoRendAcmDependente().obterRendimentosRecebidosPorDependente(cPF));
        valor.append('+', ((DeclaracaoIRPF)((Object)this.weakDec.get())).getRendIsentos().recuperarTotalPorBeneficiario(cPF));
        valor.append('+', ((DeclaracaoIRPF)((Object)this.weakDec.get())).getRendTributacaoExclusiva().recuperarTotalPorBeneficiario(cPF));
        valor.append('+', (Valor)((DeclaracaoIRPF)((Object)this.weakDec.get())).getGCAP().obterSomatorioGanhoCapital1AlienacoesGCAP(cPF.naoFormatado()));
        valor.append('+', ((DeclaracaoIRPF)((Object)this.weakDec.get())).getRendaVariavelDependente().recuperarTotalRendimentosPorBeneficiario(cPF));
        valor.append('+', ((DeclaracaoIRPF)((Object)this.weakDec.get())).getFundosInvestimentosDependente().recuperarTotalRendimentosPorBeneficiario(cPF));
        return valor;
    }

    public ArrayList<String> getCPFDependenteConjuge() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Dependente dependente : this.itens()) {
            if (!dependente.getCodigo().formatado().equals("11")) continue;
            arrayList.add(dependente.getCpfDependente().naoFormatado());
        }
        return arrayList;
    }
}

