/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.dividas;

import classes.dL;
import classes.dN;
import classes.dc;
import java.util.List;
import serpro.ppgd.irpf.af;
import serpro.ppgd.irpf.ai;
import serpro.ppgd.irpf.gui.dividas.PainelDividasLista;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.Codigo;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.ObjetoFicha;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Pendencia;
import serpro.ppgd.negocio.ValidadorIf;
import serpro.ppgd.negocio.Valor;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorCodigo;

public class Divida
extends ObjetoNegocio
implements dN,
ObjetoFicha {
    public static final String NOME_CAMPO_VALOR_ANTERIOR = "Situa\u00e7\u00e3o em 31/12/" + ConstantesGlobais.EXERCICIO_ANTERIOR;
    public static final String NOME_CAMPO_VALOR_ATUAL = "Situa\u00e7\u00e3o em 31/12/" + ConstantesGlobais.EXERCICIO;
    public static final String NOME_CAMPO_VALOR_PGTO_ANUAL = "Valor de pagamento anual";
    private Codigo codigo = new Codigo((ObjetoNegocio)this, "C\u00f3digo", dc.f());
    private Alfa discriminacao = new Alfa((ObjetoNegocio)this, "Discrimina\u00e7\u00e3o", 120);
    private ai valorExercicioAnterior = new ai(this, "Situa\u00e7\u00e3o no exerc\u00edcio passado");
    private ai valorExercicioAtual = new ai(this, "Situa\u00e7\u00e3o no exerc\u00edcio atual");
    private ai valorPgtoAnual = new ai(this, "Valor de pagamento anual");
    private Alfa indice = new Alfa((ObjetoNegocio)this, "Indice");

    public Divida() {
        this.getCodigo().setColunaFiltro(1);
        this.getCodigo().addValidador((ValidadorIf)new af(3));
        this.getCodigo().addValidador((ValidadorIf)new ValidadorCodigo(3, dL.a("divida_codigo_branco")));
        this.getDiscriminacao().addValidador((ValidadorIf)new af(3));
    }

    public Codigo getCodigo() {
        return this.codigo;
    }

    public Alfa getDiscriminacao() {
        return this.discriminacao;
    }

    public Valor getValorExercicioAnterior() {
        return this.valorExercicioAnterior;
    }

    public Valor getValorExercicioAtual() {
        return this.valorExercicioAtual;
    }

    public Valor getValorPgtoAnual() {
        return this.valorPgtoAnual;
    }

    protected List<Informacao> recuperarListaCamposPendencia() {
        List list = super.recuperarListaCamposPendencia();
        list.add(this.codigo);
        list.add(this.discriminacao);
        list.add(this.valorExercicioAtual);
        list.add(this.valorExercicioAnterior);
        list.add(this.valorPgtoAnual);
        return list;
    }

    public boolean isVazio() {
        for (Informacao informacao : this.recuperarCamposInformacao()) {
            if (informacao.isVazio() || informacao.getNomeCampo().equals("Indice")) continue;
            return false;
        }
        return true;
    }

    public List<Pendencia> verificarPendencias(int n2) {
        List list = super.verificarPendencias(n2);
        if (this.getValorExercicioAtual().isVazio() && this.getValorExercicioAnterior().isVazio()) {
            Pendencia pendencia = new Pendencia(2, (Informacao)this.getValorExercicioAnterior(), this.getValorExercicioAnterior().getNomeCampo(), dL.a("divida_valor_nao_informado"), n2);
            pendencia.setClassePainel(this.getClasseFicha());
            list.add(pendencia);
        }
        return list;
    }

    public String getChave() {
        return this.getCodigo().naoFormatado();
    }

    public int compareTo(Object object) {
        object = (Divida)object;
        int n2 = ((Divida)object).getCodigo().asInteger();
        return n2 - this.getCodigo().asInteger();
    }

    public Alfa getIndice() {
        return this.indice;
    }

    public String getClasseFicha() {
        return PainelDividasLista.class.getName();
    }

    public String getNomeAba() {
        return null;
    }

    public String getTituloFichaDashboard() {
        return "D\u00edvidas e \u00d4nus Reais";
    }
}

