/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.dividas;

import serpro.ppgd.irpf.dividas.Divida;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.Colecao;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Valor;

public class Dividas
extends Colecao<Divida> {
    private Valor totalExercicioAnterior = new Valor((ObjetoNegocio)this, "Total exercicio Anterior");
    private Valor totalExercicioAtual = new Valor((ObjetoNegocio)this, "Total exercicio Atual");
    private Valor totalPgtoAnual = new Valor((ObjetoNegocio)this, "Total pagamento anual");
    private Alfa ultimoIndiceGerado = new Alfa();
    private static long geradorIndices;

    public Dividas() {
        this.setFicha("D\u00edvidas e \u00d4nus Reais");
        this.totalExercicioAnterior.setReadOnly(true);
        this.totalExercicioAtual.setReadOnly(true);
        this.totalPgtoAnual.setReadOnly(true);
        this.inicializaGeradorIndices();
    }

    public void inicializaGeradorIndices() {
        if (this.ultimoIndiceGerado.naoFormatado().trim().equals("")) {
            geradorIndices = 0L;
            return;
        }
        geradorIndices = Long.parseLong(this.ultimoIndiceGerado.naoFormatado());
    }

    private String proximoIndice() {
        this.ultimoIndiceGerado.setConteudo("" + geradorIndices++);
        return this.ultimoIndiceGerado.naoFormatado();
    }

    public Divida instanciaNovoObjeto() {
        Divida divida = (Divida)super.instanciaNovoObjeto();
        divida.getIndice().setConteudo(this.proximoIndice());
        return divida;
    }

    public void objetoInserido(Divida divida) {
        this.setFicha(this.getFicha());
    }

    public boolean totalAlto() {
        return this.totalExercicioAtual.comparacao(">", "1.000.000,00");
    }

    public Valor getTotalExercicioAnterior() {
        return this.totalExercicioAnterior;
    }

    public Valor getTotalExercicioAtual() {
        return this.totalExercicioAtual;
    }

    public Valor getTotalPgtoAnual() {
        return this.totalPgtoAnual;
    }
}

