/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.doacoes;

import java.lang.ref.WeakReference;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.doacoes.Doacao;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.Colecao;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Valor;

public class Doacoes
extends Colecao<Doacao> {
    private Valor totalDeducaoIncentivo = new Valor((ObjetoNegocio)this, "");
    private Alfa ultimoIndiceGerado = new Alfa();
    private static long geradorIndices;
    private WeakReference<DeclaracaoIRPF> declaracaoRef = null;

    public Doacoes(DeclaracaoIRPF declaracaoIRPF) {
        this.declaracaoRef = new WeakReference<DeclaracaoIRPF>(declaracaoIRPF);
        this.setFicha("Doa\u00e7\u00f5es Efetuadas");
        this.inicializaGeradorIndices();
    }

    private void inicializaGeradorIndices() {
        if (this.ultimoIndiceGerado.naoFormatado().trim().equals("")) {
            geradorIndices = 0L;
            return;
        }
        geradorIndices = Long.parseLong(this.ultimoIndiceGerado.naoFormatado());
    }

    private String proximoIndice() {
        this.ultimoIndiceGerado.setConteudo("" + geradorIndices++);
        return this.ultimoIndiceGerado.naoFormatado();
    }

    public void objetoInserido(Doacao doacao) {
        doacao.setFicha(this.getFicha());
    }

    public Doacao instanciaNovoObjeto() {
        Doacao doacao = new Doacao((DeclaracaoIRPF)((Object)this.declaracaoRef.get()));
        doacao.getIndice().setConteudo(this.proximoIndice());
        return doacao;
    }

    public Valor getTotalDeducaoIncentivo() {
        return this.totalDeducaoIncentivo;
    }

    public boolean existeValorDoacaoAlto() {
        for (Doacao doacao : this.itens()) {
            if (!doacao.getValorPago().comparacao(">", "50.000,00")) continue;
            return true;
        }
        return false;
    }
}

