/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.eca;

import java.util.ArrayList;
import java.util.List;
import serpro.ppgd.irpf.af;
import serpro.ppgd.irpf.ai;
import serpro.ppgd.irpf.eca.ColecaoEstatutoCriancaAdolescente;
import serpro.ppgd.irpf.eca.b;
import serpro.ppgd.irpf.eca.c;
import serpro.ppgd.irpf.eca.d;
import serpro.ppgd.irpf.eca.e;
import serpro.ppgd.irpf.eca.f;
import serpro.ppgd.irpf.eca.g;
import serpro.ppgd.irpf.eca.h;
import serpro.ppgd.irpf.eca.i;
import serpro.ppgd.irpf.eca.j;
import serpro.ppgd.irpf.eca.k;
import serpro.ppgd.irpf.eca.l;
import serpro.ppgd.irpf.eca.m;
import serpro.ppgd.irpf.eca.n;
import serpro.ppgd.irpf.gui.eca.PainelEstatutoCriancaAdolescenteLista;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.CNPJ;
import serpro.ppgd.negocio.Codigo;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.ObjetoFicha;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.ValidadorIf;
import serpro.ppgd.negocio.Valor;

public class EstatutoCriancaAdolescente
extends ObjetoNegocio
implements ObjetoFicha {
    public static final String CNPJ_FUNDO_NACIONAL = "19091798000152";
    public static final String TIPO_FUNDO_NACIONAL = "N";
    public static final String TIPO_FUNDO_ESTADUAL_DISTRITAL = "E";
    public static final String TIPO_FUNDO_MUNICIPAL = "M";
    public static final String TIPO_FUNDO_VAZIO = "V";
    private static final String PROP_CNPJ_FUNDO = "CNPJ do Fundo";
    private Alfa tipoFundo = new Alfa((ObjetoNegocio)this, "Tipo do Fundo", 1);
    private Codigo uf = new Codigo((ObjetoNegocio)this, "UF", new ArrayList());
    private Codigo municipio = new Codigo((ObjetoNegocio)this, "Munic\u00edpio", new ArrayList());
    private Alfa nomeMunicipio = new Alfa((ObjetoNegocio)this, "Nome do Munic\u00edpio");
    private Valor valor = new ai(this, "Valor");
    private CNPJ cnpjFundo = new CNPJ((ObjetoNegocio)this, "CNPJ do Fundo");
    private Alfa dvNumeroReferencia = new Alfa((ObjetoNegocio)this, "DV do N\u00famero de Refer\u00eancia");

    public EstatutoCriancaAdolescente(ColecaoEstatutoCriancaAdolescente colecaoEstatutoCriancaAdolescente) {
        this.setFicha("Doa\u00e7\u00f5es Diretamente na Declara\u00e7\u00e3o - ECA");
        this.adicionarValidadores(colecaoEstatutoCriancaAdolescente);
        this.adicionarObservadores();
    }

    private void adicionarValidadores(ColecaoEstatutoCriancaAdolescente colecaoEstatutoCriancaAdolescente) {
        this.tipoFundo.addValidador((ValidadorIf)new b(this, 3));
        this.uf.setColunaFiltro(1);
        this.uf.addValidador((ValidadorIf)new g(this, 3));
        this.municipio.addValidador((ValidadorIf)new h(this, 3));
        this.valor.addValidador((ValidadorIf)new af(3));
        this.valor.addValidador((ValidadorIf)new i(this, 3));
        this.municipio.addValidador((ValidadorIf)new j(this, 3, colecaoEstatutoCriancaAdolescente));
        this.uf.addValidador((ValidadorIf)new k(this, 3, colecaoEstatutoCriancaAdolescente));
        this.tipoFundo.addValidador((ValidadorIf)new l(this, 3, colecaoEstatutoCriancaAdolescente));
    }

    private void adicionarObservadores() {
        this.tipoFundo.addObservador((Observador)new m(this));
        this.tipoFundo.addObservador((Observador)new n(this));
        this.uf.addObservador((Observador)new c(this));
        this.uf.addObservador((Observador)new d(this));
        this.municipio.addObservador((Observador)new e(this));
        this.cnpjFundo.addObservador((Observador)new f(this));
    }

    private String calcularDvNumeroReferencia(String string) {
        string = new StringBuilder(string).reverse().toString();
        int n2 = 0;
        int n3 = 2;
        int n4 = 0;
        while (n4 < string.length()) {
            n2 += n3 * Integer.parseInt(Character.toString(string.charAt(n4)));
            ++n3;
            ++n4;
        }
        n4 = n2 % 11;
        String string2 = n4 == 0 ? "1" : (n4 == 1 ? "0" : String.valueOf(11 - n4));
        string = String.valueOf(string2) + string;
        n2 = 0;
        n3 = 2;
        n4 = 0;
        while (n4 < string.length()) {
            n2 += n3 * Integer.parseInt(Character.toString(string.charAt(n4)));
            ++n3;
            ++n4;
        }
        n4 = n2 % 11;
        string = n4 == 0 ? "1" : (n4 == 1 ? "0" : String.valueOf(11 - n4));
        return String.valueOf(string2) + string;
    }

    protected List<Informacao> recuperarListaCamposPendencia() {
        List list = super.recuperarListaCamposPendencia();
        list.add(this.tipoFundo);
        list.add(this.uf);
        list.add(this.municipio);
        list.add(this.valor);
        list.add(this.cnpjFundo);
        return list;
    }

    public boolean isVazio() {
        return (this.tipoFundo.isVazio() || this.tipoFundo.naoFormatado().equals(TIPO_FUNDO_VAZIO)) && this.uf.isVazio() && this.municipio.isVazio() && this.valor.isVazio();
    }

    public Alfa getTipoFundo() {
        return this.tipoFundo;
    }

    public Codigo getUf() {
        return this.uf;
    }

    public Codigo getMunicipio() {
        return this.municipio;
    }

    public Valor getValor() {
        return this.valor;
    }

    public CNPJ getCnpjFundo() {
        return this.cnpjFundo;
    }

    public Alfa getNomeMunicipio() {
        return this.nomeMunicipio;
    }

    public Alfa getDvNumeroReferencia() {
        return this.dvNumeroReferencia;
    }

    public String getClasseFicha() {
        return PainelEstatutoCriancaAdolescenteLista.class.getName();
    }

    public String getNomeAba() {
        return null;
    }

    public String getTituloFichaDashboard() {
        return "Doa\u00e7\u00f5es Diretamente na Declara\u00e7\u00e3o - ECA";
    }

    static /* synthetic */ Alfa a(EstatutoCriancaAdolescente estatutoCriancaAdolescente) {
        return estatutoCriancaAdolescente.tipoFundo;
    }

    static /* synthetic */ Codigo b(EstatutoCriancaAdolescente estatutoCriancaAdolescente) {
        return estatutoCriancaAdolescente.municipio;
    }

    static /* synthetic */ Valor c(EstatutoCriancaAdolescente estatutoCriancaAdolescente) {
        return estatutoCriancaAdolescente.valor;
    }

    static /* synthetic */ Codigo d(EstatutoCriancaAdolescente estatutoCriancaAdolescente) {
        return estatutoCriancaAdolescente.uf;
    }

    static /* synthetic */ CNPJ e(EstatutoCriancaAdolescente estatutoCriancaAdolescente) {
        return estatutoCriancaAdolescente.cnpjFundo;
    }

    static /* synthetic */ Alfa f(EstatutoCriancaAdolescente estatutoCriancaAdolescente) {
        return estatutoCriancaAdolescente.nomeMunicipio;
    }

    static /* synthetic */ Alfa g(EstatutoCriancaAdolescente estatutoCriancaAdolescente) {
        return estatutoCriancaAdolescente.dvNumeroReferencia;
    }

    static /* synthetic */ String a(EstatutoCriancaAdolescente estatutoCriancaAdolescente, String string) {
        return estatutoCriancaAdolescente.calcularDvNumeroReferencia(string);
    }
}

