/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.espolio;

import classes.dL;
import classes.dc;
import java.lang.ref.WeakReference;
import java.util.List;
import serpro.ppgd.cacheni.CacheNI;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.IdentificadorDeclaracao;
import serpro.ppgd.irpf.X;
import serpro.ppgd.irpf.Y;
import serpro.ppgd.irpf.ag;
import serpro.ppgd.irpf.espolio.DadosEscrituracaoPublica;
import serpro.ppgd.irpf.espolio.a;
import serpro.ppgd.irpf.espolio.b;
import serpro.ppgd.irpf.espolio.c;
import serpro.ppgd.irpf.espolio.d;
import serpro.ppgd.irpf.espolio.e;
import serpro.ppgd.irpf.espolio.f;
import serpro.ppgd.irpf.espolio.g;
import serpro.ppgd.irpf.espolio.h;
import serpro.ppgd.irpf.espolio.i;
import serpro.ppgd.irpf.espolio.j;
import serpro.ppgd.irpf.espolio.k;
import serpro.ppgd.irpf.espolio.l;
import serpro.ppgd.irpf.espolio.m;
import serpro.ppgd.irpf.espolio.n;
import serpro.ppgd.irpf.espolio.o;
import serpro.ppgd.irpf.espolio.p;
import serpro.ppgd.irpf.espolio.q;
import serpro.ppgd.irpf.espolio.r;
import serpro.ppgd.irpf.espolio.s;
import serpro.ppgd.irpf.gui.espolio.PainelEscolheEspolio;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.CPF;
import serpro.ppgd.negocio.Codigo;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.Data;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.Logico;
import serpro.ppgd.negocio.NI;
import serpro.ppgd.negocio.ObjetoFicha;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.ValidadorIf;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorCPF;

public class Espolio
extends ObjetoNegocio
implements ObjetoFicha {
    public static final String OPCAO_NAO_SE_TRATA_DE_MORTE_DE_AMBOS = "2";
    private CPF cpfInventariante = new CPF((ObjetoNegocio)this, "CPF");
    private Alfa nomeInventariante = new Alfa((ObjetoNegocio)this, "Nome", 60);
    private Alfa endInventariante = new Alfa((ObjetoNegocio)this, "Endere\u00e7o", 70);
    private Alfa numProcessoJudicial = new Alfa((ObjetoNegocio)this, "N\u00b0 do processo judicial");
    private Alfa idVaraCivil = new Alfa((ObjetoNegocio)this, "Identifica\u00e7\u00e3o da vara c\u00edvel");
    private Alfa comarca = new Alfa((ObjetoNegocio)this, "Comarca");
    private Codigo uf = new Codigo((ObjetoNegocio)this, "UF", dc.d(0));
    private Data dtDecisaoJud = new Data((ObjetoNegocio)this, "Data da decis\u00e3o judicial da partilha");
    private Data dtTransito = new Data((ObjetoNegocio)this, "Data do tr\u00e2nsito em julgado da decis\u00e3o judicial da partilha");
    private Alfa tipoJudicial = new Alfa((ObjetoNegocio)this, "Judicial");
    private Alfa morteAmbosConjuges = new Alfa((ObjetoNegocio)this, "Morte de ambos os c\u00f4njuges ou companheiros(as)");
    private Alfa conjugeMeeiro = new Alfa((ObjetoNegocio)this, "C\u00f4njuge meeiro");
    private Alfa inventarioConjunto = new Alfa((ObjetoNegocio)this, "Invent\u00e1rio Conjunto");
    private Alfa nomeConjugeCompanheiro = new Alfa((ObjetoNegocio)this, "Nome do c\u00f4njuge ou companheiro(a)", 60);
    private Alfa anoObito = new Alfa((ObjetoNegocio)this, "Ano de \u00f3bito");
    private DadosEscrituracaoPublica escrituracaoPublica = new DadosEscrituracaoPublica();
    private WeakReference<DeclaracaoIRPF> weakDec;

    public Espolio(DeclaracaoIRPF declaracaoIRPF) {
        Data data;
        this.weakDec = new WeakReference<DeclaracaoIRPF>(declaracaoIRPF);
        CacheNI.getInstancia().registrarNINome((NI)this.cpfInventariante, this.nomeInventariante);
        this.setFicha("Esp\u00f3lio");
        this.uf.setColunaFiltro(1);
        this.tipoJudicial.setConteudo(Logico.SIM);
        this.conjugeMeeiro.setConteudo(Logico.NAO);
        this.morteAmbosConjuges.setConteudo(Logico.NAO);
        this.morteAmbosConjuges.addObservador((Observador)new a(this));
        this.inventarioConjunto.setConteudo(Logico.NAO);
        this.inventarioConjunto.addObservador((Observador)new l(this));
        declaracaoIRPF = new ValidadorCPF(3);
        declaracaoIRPF.setMensagemValidacao(dL.a("espolio_cpf_invalido"));
        this.getCpfInventariante().addValidador((ValidadorIf)declaracaoIRPF);
        this.getCpfInventariante().addValidador((ValidadorIf)new m(this, 3));
        this.getCpfInventariante().addValidador((ValidadorIf)new n(this, 3, dL.a("espolio_cpf_branco")));
        this.getNomeInventariante().addObservador((Observador)new Y());
        this.getNomeInventariante().addValidador((ValidadorIf)new o(this, 3, dL.a("espolio_nome_branco")));
        this.getNomeInventariante().addValidador((ValidadorIf)new ag());
        this.getEndInventariante().addValidador((ValidadorIf)new p(this, 2));
        this.getEndInventariante().addObservador((Observador)new Y());
        if (((DeclaracaoIRPF)((Object)this.weakDec.get())).getIdentificadorDeclaracao().isEspolio()) {
            this.getAnoObito().addValidador((ValidadorIf)new q(this, 3));
            this.getAnoObito().addObservador((Observador)new X(ConstantesGlobais.ANO_BASE));
            this.getComarca().addObservador((Observador)new Y());
            declaracaoIRPF = new Data();
            data = new Data();
            declaracaoIRPF.setConteudo("01/01/" + ConstantesGlobais.EXERCICIO_ANTERIOR);
            data.setConteudo("31/12/" + ConstantesGlobais.EXERCICIO_ANTERIOR);
            this.getDtTransito().addValidador((ValidadorIf)new r(this, 3));
            this.getDtDecisaoJud().addValidador((ValidadorIf)new s(this, 3, 9999));
            this.getDtDecisaoJud().addValidador((ValidadorIf)new b(this, 3));
            this.getDtDecisaoJud().addValidador((ValidadorIf)new c(this, 3, (Data)declaracaoIRPF, data));
            this.getDtTransito().addValidador((ValidadorIf)new d(this, 3));
            this.getDtTransito().addValidador((ValidadorIf)new e(this, 3));
            this.nomeConjugeCompanheiro.addValidador((ValidadorIf)new f(this, 3));
            this.nomeConjugeCompanheiro.addObservador((Observador)new Y());
            this.nomeConjugeCompanheiro.addValidador((ValidadorIf)new ag());
            this.adicionaObservadorEspolio((DeclaracaoIRPF)((Object)this.weakDec.get()), this.getDtDecisaoJud());
            this.adicionaObservadorEspolio((DeclaracaoIRPF)((Object)this.weakDec.get()), this.escrituracaoPublica.getDataLavratura());
        }
        this.escrituracaoPublica.getDataLavratura().addValidador((ValidadorIf)new g(this, 3));
        this.escrituracaoPublica.getCnpjCartorio().addValidador((ValidadorIf)new h(this, 3));
        declaracaoIRPF = new Data();
        data = new Data();
        declaracaoIRPF.setConteudo("01/01/" + ConstantesGlobais.EXERCICIO_ANTERIOR);
        data.setConteudo("31/12/" + ConstantesGlobais.EXERCICIO_ANTERIOR);
        this.escrituracaoPublica.getDataLavratura().addValidador((ValidadorIf)new i(this, 3, 9999));
        this.escrituracaoPublica.getDataLavratura().addValidador((ValidadorIf)new j(this, 3, (Data)declaracaoIRPF, data));
    }

    private void adicionaObservadorEspolio(DeclaracaoIRPF declaracaoIRPF, Data data) {
        data.addObservador((Observador)new k(this, declaracaoIRPF));
    }

    public void setCpfInventariante(CPF cPF) {
        this.cpfInventariante = cPF;
    }

    public CPF getCpfInventariante() {
        return this.cpfInventariante;
    }

    public void setNomeInventariante(Alfa alfa) {
        this.nomeInventariante = alfa;
    }

    public Alfa getNomeInventariante() {
        return this.nomeInventariante;
    }

    public void setEndInventariante(Alfa alfa) {
        this.endInventariante = alfa;
    }

    public Alfa getEndInventariante() {
        return this.endInventariante;
    }

    public Alfa getComarca() {
        return this.comarca;
    }

    public Data getDtDecisaoJud() {
        return this.dtDecisaoJud;
    }

    public Data getDtTransito() {
        return this.dtTransito;
    }

    public IdentificadorDeclaracao getIdentificadorDeclaracao() {
        return ((DeclaracaoIRPF)((Object)this.weakDec.get())).getIdentificadorDeclaracao();
    }

    public Alfa getIdVaraCivil() {
        return this.idVaraCivil;
    }

    public Alfa getNumProcessoJudicial() {
        return this.numProcessoJudicial;
    }

    public Codigo getUf() {
        return this.uf;
    }

    public Alfa getMorteAmbosConjuges() {
        return this.morteAmbosConjuges;
    }

    public Alfa getNomeConjugeCompanheiro() {
        return this.nomeConjugeCompanheiro;
    }

    protected List<Informacao> recuperarListaCamposPendencia() {
        List list = this.recuperarCamposInformacao();
        return list;
    }

    public String getMesDecisaoJudicial() {
        return this.getDtDecisaoJud().formatado().substring(3, 5);
    }

    public String getAnoDecisaoJudicial() {
        return this.getDtDecisaoJud().formatado().substring(6);
    }

    public int getQtdMesesParaCalculos() {
        String string = this.getAnoDecisaoJudicial();
        String string2 = this.getMesDecisaoJudicial();
        int n2 = -1;
        if (this.tipoJudicial.naoFormatado().equals(Logico.SIM)) {
            if (!string.equals(ConstantesGlobais.EXERCICIO_ANTERIOR)) {
                n2 = 1;
            } else if (string2.trim().length() > 0) {
                n2 = Integer.parseInt(string2);
            }
        } else {
            string = this.getEscrituracaoPublica().getAnoEscrituracaoPublica();
            string2 = this.getEscrituracaoPublica().getMesEscrituracaoPublica();
            if (!string.equals(ConstantesGlobais.EXERCICIO_ANTERIOR)) {
                n2 = 1;
            } else if (string2.trim().length() > 0) {
                n2 = Integer.parseInt(string2);
            }
        }
        return n2;
    }

    public Alfa getTipoJudicial() {
        return this.tipoJudicial;
    }

    public DadosEscrituracaoPublica getEscrituracaoPublica() {
        return this.escrituracaoPublica;
    }

    public boolean isVazio() {
        boolean bl2;
        boolean bl3 = bl2 = this.cpfInventariante.isVazio() && this.nomeInventariante.isVazio() && this.endInventariante.isVazio();
        if (((DeclaracaoIRPF)((Object)this.weakDec.get())).getIdentificadorDeclaracao().isAjuste()) {
            return bl2;
        }
        if (((DeclaracaoIRPF)((Object)this.weakDec.get())).getIdentificadorDeclaracao().isEspolio()) {
            if (this.tipoJudicial.naoFormatado().equals(Logico.SIM)) {
                return bl2 && this.numProcessoJudicial.isVazio() && this.idVaraCivil.isVazio() && this.comarca.isVazio() && this.uf.isVazio() && this.dtDecisaoJud.isVazio() && this.dtTransito.isVazio();
            }
            return bl2 && this.escrituracaoPublica.isVazio();
        }
        return true;
    }

    public String getClasseFicha() {
        return PainelEscolheEspolio.class.getName();
    }

    public String getNomeAba() {
        return null;
    }

    public Alfa getInventarioConjunto() {
        return this.inventarioConjunto;
    }

    public Alfa getConjugeMeeiro() {
        return this.conjugeMeeiro;
    }

    public Alfa getAnoObito() {
        return this.anoObito;
    }

    public String getTituloFichaDashboard() {
        return "Esp\u00f3lio";
    }

    static /* synthetic */ Alfa a(Espolio espolio) {
        return espolio.conjugeMeeiro;
    }

    static /* synthetic */ Alfa b(Espolio espolio) {
        return espolio.inventarioConjunto;
    }

    static /* synthetic */ Alfa c(Espolio espolio) {
        return espolio.nomeConjugeCompanheiro;
    }

    static /* synthetic */ WeakReference d(Espolio espolio) {
        return espolio.weakDec;
    }

    static /* synthetic */ Alfa e(Espolio espolio) {
        return espolio.tipoJudicial;
    }

    static /* synthetic */ DadosEscrituracaoPublica f(Espolio espolio) {
        return espolio.escrituracaoPublica;
    }
}

