/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gcap.alienacao;

import classes.dD;
import java.util.ArrayList;
import serpro.ppgd.irpf.ah;
import serpro.ppgd.irpf.ai;
import serpro.ppgd.irpf.gcap.alienacao.AlienacaoBem;
import serpro.ppgd.irpf.gcap.apuracao.Apuracao;
import serpro.ppgd.irpf.gcap.calculo.Ajuste;
import serpro.ppgd.irpf.gcap.calculo.CalculoImposto;
import serpro.ppgd.irpf.gcap.consolidacao.Consolidacao;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.CPF;
import serpro.ppgd.negocio.Codigo;
import serpro.ppgd.negocio.Data;
import serpro.ppgd.negocio.Logico;
import serpro.ppgd.negocio.ObjetoNegocio;

public abstract class Alienacao
extends ObjetoNegocio {
    public static int CONSTANTE_ANO_MINIMO_ALIENACAO_PARCIAL = 2017;
    public static int TIPO_ALIENACAO_BEM_IMOVEL = 1;
    public static int TIPO_ALIENACAO_BEM_MOVEL = 2;
    public static int TIPO_ALIENACAO_PARTICIPACAO_SOCIETARIA = 3;
    public static final String LABEL_CAMPO_DATA_ALIENACAO = "Data de Aliena\u00e7\u00e3o";
    public static final String LABEL_CAMPO_DATA_TRANSITO_JULGADO = "Data do tr\u00e2nsito em julgado";
    public static final String LABEL_CAMPO_DATA_DECISAO_JUDICIAL = "Data da decis\u00e3o judicial";
    public static final String LABEL_CAMPO_DATA_LAVRATURA = "Data da Lavratura";
    public static final String LABEL_CAMPO_NATUREZA = "Natureza";
    public static final String LABEL_CAMPO_VALOR_RECEBIDO_ANOS_ANTERIORES = "Valor Recebido em Anos Anteriores";
    public static final String LABEL_CAMPO_CORRETAGEM_ANOS_ANTERIORES = "Corretagem em Anos Anteriores";
    public static final String LABEL_CAMPO_VALOR_LIQUIDO_RECEBIDO_ANOS_ANTERIORES = "Valor L\u00edquido Recebido em Anos Anteriores";
    public static final String CONSTANTE_ALIQUOTA_FIXA_15_PORCENTO = "0,150000000";
    public static final String CONSTANTE_ALIQUOTA_FIXA_20_PORCENTO = "0,200000000";
    private CPF cpf = new CPF((ObjetoNegocio)this, "CPF do declarante");
    private Data dataInicioPermanencia = new Data((ObjetoNegocio)this, "Data Inicio Perman\u00eancia");
    private Data dataFimPermanencia = new Data((ObjetoNegocio)this, "Data Fim Perman\u00eancia");
    private Alfa codigoOperacao = new Alfa((ObjetoNegocio)this, "C\u00f3digo de Opera\u00e7\u00e3o");
    private Alfa nomePaisDeclarante = new Alfa((ObjetoNegocio)this, "Pais Declarante");
    private Codigo natureza = new Codigo((ObjetoNegocio)this, "Natureza", new ArrayList());
    private Data dataAlienacao = new Data((ObjetoNegocio)this, "Data de Aliena\u00e7\u00e3o");
    private Data dataTransitoJulgado = new Data((ObjetoNegocio)this, "Data do tr\u00e2nsito em julgado");
    private Data dataRecebimentoUltimaParcela = new Data((ObjetoNegocio)this, "Data de Recebimento da \u00daltima Parcela");
    private Logico temUltimaParcela = new Logico((ObjetoNegocio)this, "A presta\u00e7\u00e3o/parcela final foi recebida em " + dD.d() + "?");
    private Logico motivoTransmissaoCausaMortisDecisaoJudicial = new Logico((ObjetoNegocio)this, "Decis\u00e3o Judicial?");
    private Logico alienacaoAPrazo = new Logico((ObjetoNegocio)this, "Aliena\u00e7\u00e3o foi a prazo/presta\u00e7\u00e3o");
    private ai valorAlienacao = new ai(this, "Valor de Aliena\u00e7\u00e3o (R$)");
    private ai custoCorretagem = new ai(this, "Custo Corretagem (R$)");
    private Logico alienacaoParcial = new Logico((ObjetoNegocio)this, "J\u00e1 houve aliena\u00e7\u00e3o parcial desse bem?");
    private Logico bemGrandeValor = new Logico((ObjetoNegocio)this, " O valor do conjundo dos bens ou direitos da mesma natureza, alienados em m\u00eas/ano, \u00e9 superior a 35.000,00?");
    private Logico bemGrandeValorOperacao = new Logico((ObjetoNegocio)this, " Resposta para bemGrandeValor se dados da opera\u00e7\u00e3o permitia");
    private ai ganhoCapitalAlienacaoAnterior = new ai(this, "Ganho de Capital de Aliena\u00e7\u00e3o anterior");
    private ai valorLiquidoRecebidoAnosAnteriores = new ai(this, "Valor L\u00edquido Recebido em Anos Anteriores");
    private ai valorRecebidoAnosAnteriores = new ai(this, "Valor Recebido em Anos Anteriores");
    private ai corretagemAnosAnteriores = new ai(this, "Corretagem em Anos Anteriores");
    private CalculoImposto calculoImposto = new CalculoImposto();
    private Ajuste ajuste = new Ajuste();
    private Consolidacao consolidacao = new Consolidacao();
    private transient Alfa alienacaoAPrazoAux = new Alfa((ObjetoNegocio)this, "Aliena\u00e7\u00e3o foi a prazo/presta\u00e7\u00e3o?", 1);
    private transient Alfa alienacaoParcialAux = new Alfa((ObjetoNegocio)this, "J\u00e1 houve aliena\u00e7\u00e3o parcial desse bem?", 1);
    private transient Data dataRecebimentoUltimaParcelaAux = new Data((ObjetoNegocio)this, "Data de Recebimento da \u00daltima Parcela");
    private transient Alfa bemGrandeValorAux = new Alfa((ObjetoNegocio)this, " O valor do conjundo dos bens ou direitos da mesma natureza, alienados em m\u00eas/ano, \u00e9 superior a 35.000,00?", 1);
    private Logico alienacaoAnoAnterior = new Logico((ObjetoNegocio)this, "Aliena\u00e7\u00e3o foi realizada no ano anterior?");
    private Alfa numeroItem = new Alfa((ObjetoNegocio)this, "N\u00famero do Item");
    private transient Alfa recebimentoUltimaParcelaAux = new Alfa((ObjetoNegocio)this, "A presta\u00e7ao/parcela final foi recebida em " + (dD.e() - 1) + "?");
    private Logico recebimentoUltimaParcelaAnoAnterior = new Logico((ObjetoNegocio)this, "A presta\u00e7\u00e3o/parcela final foi recebida em " + (dD.e() - 1) + "?");
    private Logico residenteBrasil = new Logico((ObjetoNegocio)this, "\u00c9 residente no Brasil?");
    private Data dataVencimentoTCM = new Data((ObjetoNegocio)this, "Data de vencimento do DARF para TCM");

    public Alienacao() {
        this.getTemUltimaParcela().addOpcao(Logico.SIM, Logico.LABEL_SIM);
        this.getTemUltimaParcela().addOpcao(Logico.NAO, Logico.LABEL_NAO);
        this.getTemUltimaParcela().setConteudo(Logico.NAO);
        this.getAlienacaoAPrazo().addOpcao(Logico.SIM, Logico.LABEL_SIM);
        this.getAlienacaoAPrazo().addOpcao(Logico.NAO, Logico.LABEL_NAO);
        this.getAlienacaoParcial().addOpcao(Logico.SIM, Logico.LABEL_SIM);
        this.getAlienacaoParcial().addOpcao(Logico.NAO, Logico.LABEL_NAO);
        this.getBemGrandeValor().addOpcao(Logico.SIM, Logico.LABEL_SIM);
        this.getBemGrandeValor().addOpcao(Logico.NAO, Logico.LABEL_NAO);
        this.getBemGrandeValorOperacao().addOpcao(Logico.SIM, Logico.LABEL_SIM);
        this.getBemGrandeValorOperacao().addOpcao(Logico.NAO, Logico.LABEL_NAO);
        this.getMotivoTransmissaoCausaMortisDecisaoJudicial().addOpcao(Logico.SIM, Logico.LABEL_SIM);
        this.getMotivoTransmissaoCausaMortisDecisaoJudicial().addOpcao(Logico.NAO, Logico.LABEL_NAO);
        this.getMotivoTransmissaoCausaMortisDecisaoJudicial().setConteudo(Logico.SIM);
        this.getRecebimentoUltimaParcelaAnoAnterior().addOpcao(Logico.SIM, Logico.LABEL_SIM);
        this.getRecebimentoUltimaParcelaAnoAnterior().addOpcao(Logico.NAO, Logico.LABEL_NAO);
        this.getResidenteBrasil().addOpcao(Logico.SIM, Logico.LABEL_SIM);
        this.getResidenteBrasil().addOpcao(Logico.NAO, Logico.LABEL_NAO);
        this.getDataRecebimentoUltimaParcela().setReadOnly(true);
        this.getTemUltimaParcela().setReadOnly(true);
        this.getValorLiquidoRecebidoAnosAnteriores().setReadOnly(true);
        this.setReadOnlyAlienacao();
    }

    public void setReadOnlyAlienacao() {
        this.natureza.setReadOnly(true);
        this.natureza.setHabilitado(false);
        this.dataAlienacao.setReadOnly(true);
        this.dataTransitoJulgado.setReadOnly(true);
        this.dataRecebimentoUltimaParcela.setReadOnly(true);
        this.temUltimaParcela.setReadOnly(true);
        this.motivoTransmissaoCausaMortisDecisaoJudicial.setReadOnly(true);
        this.alienacaoAPrazo.setReadOnly(true);
        this.valorAlienacao.setReadOnly(true);
        this.custoCorretagem.setReadOnly(true);
        this.alienacaoParcial.setReadOnly(true);
        this.bemGrandeValor.setReadOnly(true);
        this.bemGrandeValorOperacao.setReadOnly(true);
        this.ganhoCapitalAlienacaoAnterior.setReadOnly(true);
        this.valorLiquidoRecebidoAnosAnteriores.setReadOnly(true);
        this.valorRecebidoAnosAnteriores.setReadOnly(true);
        this.corretagemAnosAnteriores.setReadOnly(true);
        this.alienacaoAnoAnterior.setReadOnly(true);
        this.numeroItem.setReadOnly(true);
        this.recebimentoUltimaParcelaAnoAnterior.setReadOnly(true);
        this.residenteBrasil.setReadOnly(true);
    }

    public abstract Apuracao getApuracao();

    public Alfa getCodigoOperacao() {
        return this.codigoOperacao;
    }

    public CPF getCpf() {
        return this.cpf;
    }

    public Data getDataInicioPermanencia() {
        return this.dataInicioPermanencia;
    }

    public Data getDataFimPermanencia() {
        return this.dataFimPermanencia;
    }

    public Alfa getNomePaisDeclarante() {
        return this.nomePaisDeclarante;
    }

    public Codigo getNatureza() {
        return this.natureza;
    }

    public Data getDataAlienacao() {
        return this.dataAlienacao;
    }

    public Data getDataTransitoJulgado() {
        return this.dataTransitoJulgado;
    }

    public Data getDataRecebimentoUltimaParcela() {
        return this.dataRecebimentoUltimaParcela;
    }

    public Logico getTemUltimaParcela() {
        return this.temUltimaParcela;
    }

    public Logico getMotivoTransmissaoCausaMortisDecisaoJudicial() {
        return this.motivoTransmissaoCausaMortisDecisaoJudicial;
    }

    public Logico getAlienacaoAPrazo() {
        return this.alienacaoAPrazo;
    }

    public ai getValorAlienacao() {
        return this.valorAlienacao;
    }

    public ai getCustoCorretagem() {
        return this.custoCorretagem;
    }

    public Logico getAlienacaoParcial() {
        return this.alienacaoParcial;
    }

    public ai getGanhoCapitalAlienacaoAnterior() {
        return this.ganhoCapitalAlienacaoAnterior;
    }

    public ai getValorLiquidoRecebidoAnosAnteriores() {
        return this.valorLiquidoRecebidoAnosAnteriores;
    }

    public ai getValorRecebidoAnosAnteriores() {
        return this.valorRecebidoAnosAnteriores;
    }

    public ai getCorretagemAnosAnteriores() {
        return this.corretagemAnosAnteriores;
    }

    public CalculoImposto getCalculoImposto() {
        return this.calculoImposto;
    }

    public Ajuste getAjuste() {
        return this.ajuste;
    }

    public Consolidacao getConsolidacao() {
        return this.consolidacao;
    }

    public boolean isAlienacaoAPrazo() {
        return Logico.SIM.equals(this.getAlienacaoAPrazo().naoFormatado());
    }

    public boolean isAlienacaoAVista() {
        return Logico.NAO.equals(this.getAlienacaoAPrazo().naoFormatado());
    }

    public boolean temAlienacaoParcial() {
        return Logico.SIM.equals(this.getAlienacaoParcial().naoFormatado());
    }

    public Logico getBemGrandeValor() {
        return this.bemGrandeValor;
    }

    public Logico getBemGrandeValorOperacao() {
        return this.bemGrandeValorOperacao;
    }

    public boolean isBemPequenoValor() {
        return Logico.NAO.equals(this.getBemGrandeValor().naoFormatado());
    }

    public boolean isBemPequenoValorOperacao() {
        return Logico.NAO.equals(this.getBemGrandeValorOperacao().naoFormatado());
    }

    public boolean isAlienacaoBrasil() {
        return true;
    }

    public Codigo obterCodigoOrigemRendimentos() {
        return null;
    }

    public Alfa getAlienacaoAPrazoAux() {
        return this.alienacaoAPrazoAux;
    }

    public Alfa getAlienacaoParcialAux() {
        return this.alienacaoParcialAux;
    }

    public Data getDataRecebimentoUltimaParcelaAux() {
        return this.dataRecebimentoUltimaParcelaAux;
    }

    public Alfa getBemGrandeValorAux() {
        return this.bemGrandeValorAux;
    }

    public void calcularApuracao() {
    }

    public abstract String obterAliquotaFixa();

    public Logico getAlienacaoAnoAnterior() {
        return this.alienacaoAnoAnterior;
    }

    public boolean podeTerAlienacaoParcial() {
        boolean bl2 = false;
        int n2 = 0;
        try {
            n2 = Integer.valueOf(this.getDataAlienacao().getAno());
        }
        catch (Exception exception) {}
        if (n2 >= CONSTANTE_ANO_MINIMO_ALIENACAO_PARCIAL) {
            bl2 = true;
        }
        return bl2;
    }

    public boolean isAlienacaoEmAnoAnterior() {
        int n2 = dD.e();
        try {
            n2 = Integer.valueOf(this.dataAlienacao.getAno());
        }
        catch (Exception exception) {}
        return n2 < dD.e();
    }

    public boolean isTransmissaoCausaMortis() {
        int n2 = -1;
        try {
            n2 = Integer.valueOf(this.getNatureza().naoFormatado());
        }
        catch (Exception exception) {}
        return n2 == AlienacaoBem.CODIGO_NATUREZA_TRASMISSAO_CAUSA_MORTIS;
    }

    public boolean isDataTransitoJulgadoObrigatoria() {
        return this.isTransmissaoCausaMortis() && this.getMotivoTransmissaoCausaMortisDecisaoJudicial().naoFormatado().equals(Logico.SIM);
    }

    public boolean deveExibirMensagemValorecebidoAnoAnterior() {
        try {
            ah ah2 = new ah("0,00");
            if (this.dataAlienacao.naoFormatado().length() == 8 && Integer.parseInt(this.dataAlienacao.getAno()) < dD.e() && this.valorLiquidoRecebidoAnosAnteriores.comparacao(">", ah2) && this.valorRecebidoAnosAnteriores.comparacao("=", ah2)) {
                return true;
            }
        }
        catch (Exception exception) {}
        return false;
    }

    public boolean isIsento() {
        return this.isBemPequenoValor();
    }

    public Alfa getNumeroItem() {
        return this.numeroItem;
    }

    public Logico getResidenteBrasil() {
        return this.residenteBrasil;
    }

    public Alfa getRecebimentoUltimaParcelaAux() {
        return this.recebimentoUltimaParcelaAux;
    }

    public Logico getRecebimentoUltimaParcelaAnoAnterior() {
        return this.recebimentoUltimaParcelaAnoAnterior;
    }

    public Data getDataVencimentoTCM() {
        return this.dataVencimentoTCM;
    }

    public boolean isAdquirenteRequerido() {
        boolean bl2 = true;
        if (String.valueOf(AlienacaoBem.CODIGO_NATUREZA_DISSOLUCAO_DA_SOCIEDADE_CONJUGAL_OU_UNIAO_ESTAVEL).equals(this.getNatureza().naoFormatado())) {
            bl2 = false;
        }
        return bl2;
    }
}

