/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gcap.alienacao;

import classes.dc;
import serpro.ppgd.irpf.ai;
import serpro.ppgd.irpf.gcap.alienacao.Alienacao;
import serpro.ppgd.irpf.gcap.alienacao.AlienacaoBemImovel;
import serpro.ppgd.irpf.gcap.alienacao.ColecaoParcelaAlienacaoBem;
import serpro.ppgd.irpf.gcap.alienacao.ParcelaAlienacaoBem;
import serpro.ppgd.irpf.gcap.apuracao.ApuracaoBem;
import serpro.ppgd.irpf.gcap.aquisicao.Aquisicao;
import serpro.ppgd.negocio.Codigo;
import serpro.ppgd.negocio.Logico;
import serpro.ppgd.negocio.ObjetoNegocio;

public abstract class AlienacaoBem
extends Alienacao {
    public static int CODIGO_NATUREZA_VENDA = 1;
    public static int CODIGO_NATUREZA_PERMURTA_COM_RECEBIMENTO_DE_TORNA = 2;
    public static int CODIGO_NATUREZA_DESAPROPRIACAO = 3;
    public static int CODIGO_NATUREZA_DACAO_EM_PAGAMENTO = 4;
    public static int CODIGO_NATUREZA_OUTRAS_DOACOES = 5;
    public static int CODIGO_NATUREZA_PROCURACAO_EM_CAUSA_PROPRIA = 6;
    public static int CODIGO_NATUREZA_PROMESSA_DE_COMPRA_E_VENDA = 7;
    public static int CODIGO_NATUREZA_CESSAO_DE_DIREITOS = 8;
    public static int CODIGO_NATUREZA_LIQUID_OU_RESGATE_DE_APLIC_FINANCEIRA = 9;
    public static int CODIGO_NATUREZA_OUTROS = 10;
    public static int CODIGO_NATUREZA_DISSOLUCAO_DA_SOCIEDADE_CONJUGAL_OU_UNIAO_ESTAVEL = 11;
    public static int CODIGO_NATUREZA_TRASMISSAO_CAUSA_MORTIS = 12;
    public static int CODIGO_NATUREZA_DOACAO_ADIANTAMENTO_LEGITIMA = 13;
    public static int CODIGO_NATUREZA_ALIENACAO_RESGATES_OUTRAS = 14;
    public static String DESCRICAO_NATUREZA_VENDA = "Venda";
    public static String DESCRICAO_NATUREZA_PERMURTA_COM_RECEBIMENTO_DE_TORNA = "Permuta com Recebimento de Torna";
    public static String DESCRICAO_NATUREZA_DESAPROPRIACAO = "Desapropria\u00e7\u00e3o";
    public static String DESCRICAO_NATUREZA_DACAO_EM_PAGAMENTO = "Da\u00e7\u00e3o em Pagamento";
    public static String DESCRICAO_NATUREZA_OUTRAS_DOACOES = "Outras Doa\u00e7\u00f5es";
    public static String DESCRICAO_NATUREZA_PROCURACAO_EM_CAUSA_PROPRIA = "Procura\u00e7\u00e3o em Causa Pr\u00f3pria";
    public static String DESCRICAO_NATUREZA_PROMESSA_DE_COMPRA_E_VENDA = "Promessa de Compra e Venda";
    public static String DESCRICAO_NATUREZA_CESSAO_DE_DIREITOS = "Cess\u00e3o de Direitos/Cr\u00e9ditos";
    public static String DESCRICAO_NATUREZA_LIQUID_OU_RESGATE_DE_APLIC_FINANCEIRA = "Liquida\u00e7\u00e3o ou Resgate de Aplica\u00e7\u00e3o Financeira";
    public static String DESCRICAO_NATUREZA_OUTROS = "Outros";
    public static String DESCRICAO_NATUREZA_DISSOLUCAO_DA_SOCIEDADE_CONJUGAL_OU_UNIAO_ESTAVEL = "Dissolu\u00e7\u00e3o da Sociedade Conjugal ou Uni\u00e3o Est\u00e1vel";
    public static String DESCRICAO_NATUREZA_TRASMISSAO_CAUSA_MORTIS = "Transmiss\u00e3o Causa Mortis";
    public static String DESCRICAO_NATUREZA_DOACAO_ADIANTAMENTO_LEGITIMA = "Doa\u00e7\u00e3o em Adiantamento da Leg\u00edtima";
    public static String DESCRICAO_NATUREZA_ALIENACAO_RESGATES_OUTRAS = "Aliena\u00e7\u00f5es, resgates e outras transfer\u00eancias";
    public static final String VALOR_BEM_PEQUENO_VALOR = "35.000,00";
    private ai valorAlienacaoReal = new ai(this, "Valor de Aliena\u00e7\u00e3o - Moenda Nacional (R$)");
    private ai valorAlienacaoDolar = new ai(this, "Valor de Aliena\u00e7\u00e3o - Moeda Nacional (US$)");
    private ai valorCorretagemReal = new ai(this, "Custo de Corretagem - Moeda Nacional (R$)");
    private ai valorCorretagemDolar = new ai(this, "Custo de Corretagem - Moeda Nacional (US$)");
    private ai cotacaoDolarDataAlienacao = new ai(this, "Cota\u00e7\u00e3o do d\u00f3lar na data de aliena\u00e7\u00e3o", 9, 4);
    private Codigo paisAcordo = new Codigo((ObjetoNegocio)this, "Pa\u00eds com acordo Internacional/Reciprocidade de Tratamento", dc.c());
    private ai valorImpostoExteriorReal = new ai(this, "Valor do imposto em Reais (R$)");
    private ColecaoParcelaAlienacaoBem colecaoParcelaAlienacao = new ColecaoParcelaAlienacaoBem(this);
    private Logico inCobranca = new Logico((ObjetoNegocio)this, "Indicador de que o imposto devido dever\u00e1 ser cobrado e enviado ao CCPF");

    public AlienacaoBem() {
        this.getInCobranca().addOpcao(Logico.SIM, Logico.LABEL_SIM);
        this.getInCobranca().addOpcao(Logico.NAO, Logico.LABEL_NAO);
        this.setReadOnlyAlienacaoBem();
    }

    public void setReadOnlyAlienacaoBem() {
        this.valorAlienacaoDolar.setReadOnly(true);
        this.valorCorretagemDolar.setReadOnly(true);
        this.cotacaoDolarDataAlienacao.setReadOnly(true);
        this.paisAcordo.setReadOnly(true);
        this.paisAcordo.setHabilitado(false);
        this.valorImpostoExteriorReal.setReadOnly(true);
    }

    public ai getCotacaoDolarDataAlienacao() {
        return this.cotacaoDolarDataAlienacao;
    }

    public ai getValorAlienacaoDolar() {
        return this.valorAlienacaoDolar;
    }

    public ai getValorCorretagemDolar() {
        return this.valorCorretagemDolar;
    }

    public ai getValorAlienacaoReal() {
        return this.valorAlienacaoReal;
    }

    public ai getValorCorretagemReal() {
        return this.valorCorretagemReal;
    }

    public Codigo getPaisAcordo() {
        return this.paisAcordo;
    }

    public ai getValorImpostoExteriorReal() {
        return this.valorImpostoExteriorReal;
    }

    public ColecaoParcelaAlienacaoBem getColecaoParcelaAlienacao() {
        return this.colecaoParcelaAlienacao;
    }

    public Logico getInCobranca() {
        return this.inCobranca;
    }

    @Override
    public String obterAliquotaFixa() {
        String string = null;
        int n2 = -1;
        if (!this.getNatureza().isVazio()) {
            n2 = Integer.valueOf(this.getNatureza().naoFormatado());
        }
        if (n2 == CODIGO_NATUREZA_DISSOLUCAO_DA_SOCIEDADE_CONJUGAL_OU_UNIAO_ESTAVEL || n2 == CODIGO_NATUREZA_DOACAO_ADIANTAMENTO_LEGITIMA || n2 == CODIGO_NATUREZA_TRASMISSAO_CAUSA_MORTIS) {
            string = "0,150000000";
        }
        return string;
    }

    public ai getValorIsencao() {
        ai ai2 = new ai(null, "valorIsencao", 10, 2);
        ai2.setConteudo(VALOR_BEM_PEQUENO_VALOR);
        return ai2;
    }

    public boolean isValorOperacaoMaior35K() {
        boolean bl2 = false;
        ai ai2 = new ai();
        if (this.isAlienacaoBrasil()) {
            ai2.setConteudo(this.getValorAlienacao());
        } else {
            ai2.setConteudo(this.getValorAlienacaoDolar().operacao('*', this.getCotacaoDolarDataAlienacao()));
        }
        if (ai2.comparacao(">", VALOR_BEM_PEQUENO_VALOR)) {
            bl2 = true;
        }
        return bl2;
    }

    public boolean isValorOperacaoMaior440K() {
        boolean bl2 = false;
        ai ai2 = new ai();
        if (this.isAlienacaoBrasil()) {
            ai2.setConteudo(this.getValorAlienacao());
        } else {
            ai2.setConteudo(this.getValorAlienacaoDolar().operacao('*', this.getCotacaoDolarDataAlienacao()));
        }
        if (ai2.comparacao(">", AlienacaoBemImovel.VALOR_ISENCAO_UNICO_IMOVEL)) {
            bl2 = true;
        }
        return bl2;
    }

    public boolean isValorParcelasMaior35K() {
        boolean bl2 = false;
        ai ai2 = new ai();
        if (this.isAlienacaoBrasil()) {
            for (ParcelaAlienacaoBem parcelaAlienacaoBem : this.getColecaoParcelaAlienacao().itens()) {
                ai2.append('+', parcelaAlienacaoBem.getValorRecebido());
            }
        } else {
            for (ParcelaAlienacaoBem parcelaAlienacaoBem : this.getColecaoParcelaAlienacao().itens()) {
                ai ai3 = new ai();
                ai3.setConteudo(parcelaAlienacaoBem.getValorRecebidoDolar());
                ai3.append('*', parcelaAlienacaoBem.getCotacaoDolar());
                ai2.append('+', ai3);
            }
        }
        if (ai2.comparacao(">", VALOR_BEM_PEQUENO_VALOR)) {
            bl2 = true;
        }
        return bl2;
    }

    public boolean isValorParcelasMaior440K() {
        boolean bl2 = false;
        ai ai2 = new ai();
        if (this.isAlienacaoBrasil()) {
            for (ParcelaAlienacaoBem parcelaAlienacaoBem : this.getColecaoParcelaAlienacao().itens()) {
                ai2.append('+', parcelaAlienacaoBem.getValorRecebido());
            }
        } else {
            for (ParcelaAlienacaoBem parcelaAlienacaoBem : this.getColecaoParcelaAlienacao().itens()) {
                ai ai3 = new ai();
                ai3.setConteudo(parcelaAlienacaoBem.getValorRecebidoDolar());
                ai3.append('*', parcelaAlienacaoBem.getCotacaoDolar());
                ai2.append('+', ai3);
            }
        }
        if (ai2.comparacao(">", AlienacaoBemImovel.VALOR_ISENCAO_UNICO_IMOVEL)) {
            bl2 = true;
        }
        return bl2;
    }

    public abstract Aquisicao getAquisicao();

    @Override
    public abstract ApuracaoBem getApuracao();

    public abstract ApuracaoBem getApuracaoFinal();
}

