/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gcap.alienacao;

import classes.dD;
import classes.dL;
import classes.dc;
import java.util.Iterator;
import serpro.ppgd.irpf.ai;
import serpro.ppgd.irpf.gcap.a;
import serpro.ppgd.irpf.gcap.alienacao.AlienacaoBem;
import serpro.ppgd.irpf.gcap.alienacao.ParcelaAlienacaoBem;
import serpro.ppgd.irpf.gcap.apuracao.ApuracaoBemImovel;
import serpro.ppgd.irpf.gcap.aquisicao.Aquisicao;
import serpro.ppgd.irpf.gcap.aquisicao.ParcelaAquisicao;
import serpro.ppgd.irpf.gcap.bensimoveis.BemImovel;
import serpro.ppgd.irpf.gcap.perguntas.PerguntasImovel;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.Codigo;
import serpro.ppgd.negocio.Logico;
import serpro.ppgd.negocio.ObjetoNegocio;

public class AlienacaoBemImovel
extends AlienacaoBem
implements a {
    public static final String NOME_FICHA_BEM_IMOVEl = "Bens Im\u00f3veis";
    public static final String NOME_ABA_IDENTIFICACAO = "Identifica\u00e7\u00e3o";
    public static final String NOME_ABA_AQUISICAO = "Aquisi\u00e7\u00e3o";
    public static final String NOME_ABA_ADQUIRENTES = "Adquirentes";
    public static final String NOME_ABA_OPERACAO = "Opera\u00e7\u00e3o";
    public static final String NOME_ABA_PERGUNTAS = "Perguntas";
    public static final String NOME_ABA_CALCULO = "C\u00e1lculo do Imposto";
    public static int REDUCAO_AUSENTE = 0;
    public static int REDUCAO_IMOVEL_PEQUENO_VALOR = 1;
    public static int REDUCAO_UNICO_IMOVEL = 2;
    public static int REDUCAO_APLICACAO_OUTRO_IMOVEL = 3;
    private BemImovel bemImovel = new BemImovel(this);
    private ApuracaoBemImovel apuracao = new ApuracaoBemImovel();
    private ApuracaoBemImovel apuracaoFinal = new ApuracaoBemImovel();
    private ai valorAplicado = new ai(this, "Valor aplicado na aquisi\u00e7\u00e3o de im\u00f3vel residencial no prazo de 180 dias.");
    private PerguntasImovel perguntas = new PerguntasImovel();
    private Alfa alienacaoAPrazoImovelAux = new Alfa((ObjetoNegocio)this, "Aliena\u00e7\u00e3o foi a prazo/presta\u00e7\u00e3o?", 1);
    public static int ANO_TRANSICAO_LEI_180_DIAS = 2018;
    public static String VALOR_ISENCAO_UNICO_IMOVEL = "440.000,00";

    public AlienacaoBemImovel() {
        this.getNatureza().setColecaoElementoTabela(dc.s());
        this.setReadOnlyAlienacaoBemImovel();
    }

    public void setReadOnlyAlienacaoBemImovel() {
        this.valorAplicado.setReadOnly(true);
    }

    public BemImovel getBemImovel() {
        return this.bemImovel;
    }

    public ai getValorAplicado() {
        return this.valorAplicado;
    }

    public PerguntasImovel getPerguntas() {
        return this.perguntas;
    }

    public Alfa getAlienacaoAPrazoImovelAux() {
        return this.alienacaoAPrazoImovelAux;
    }

    @Override
    public boolean isAlienacaoBrasil() {
        return this.getBemImovel().isAdquiridoNoBrasil();
    }

    @Override
    public Aquisicao getAquisicao() {
        return this.getBemImovel().getAquisicao();
    }

    @Override
    public ApuracaoBemImovel getApuracao() {
        return this.apuracao;
    }

    @Override
    public ApuracaoBemImovel getApuracaoFinal() {
        return this.apuracaoFinal;
    }

    @Override
    public Codigo obterCodigoOrigemRendimentos() {
        return this.getBemImovel().getAquisicao().getOrigemRendimentos();
    }

    public ai getValorIsencaoUnicoImovel() {
        ai ai2 = new ai();
        ai2.setConteudo("440000,00");
        return ai2;
    }

    private boolean isValorAlienacaoMenor35k() {
        ai ai2 = new ai();
        if (this.getBemImovel().isAdquiridoNoBrasil()) {
            ai2.setConteudo(this.getValorAlienacao());
        } else {
            ai2.setConteudo(this.getValorAlienacaoDolar().operacao('*', this.getCotacaoDolarDataAlienacao()));
        }
        return ai2.comparacao("<=", this.getValorIsencao());
    }

    public boolean isIsentoPorPequenoValor() {
        boolean bl2 = false;
        boolean bl3 = this.getBemGrandeValor().formatado().equals("0");
        if (bl3) {
            bl2 = this.getDataRecebimentoUltimaParcela().isVazio() ? !this.isValorOperacaoMaior35K() : !this.isValorParcelasMaior35K();
        }
        return bl2;
    }

    private boolean isValorAlienacaoMenor440k() {
        ai ai2 = new ai();
        if (this.getBemImovel().isAdquiridoNoBrasil()) {
            ai2.setConteudo(this.getValorAlienacao());
        } else {
            ai2.setConteudo(this.getValorAlienacaoDolar().operacao('*', this.getCotacaoDolarDataAlienacao()));
        }
        return ai2.comparacao("<=", this.getValorIsencaoUnicoImovel());
    }

    @Override
    public boolean isIsento() {
        boolean bl2 = false;
        if (this.isAlienacaoBrasil()) {
            if (this.getApuracao().getGanhoCapital5().isVazio()) {
                bl2 = true;
            }
        } else {
            int n2 = REDUCAO_AUSENTE;
            if (this.getColecaoParcelaAlienacao().obterUltimaParcela() != null) {
                n2 = this.obterEnquadramentoFinal();
            }
            if (n2 == REDUCAO_IMOVEL_PEQUENO_VALOR || n2 == REDUCAO_UNICO_IMOVEL || this.getPerguntas().isValorReaplicadoTotalmente()) {
                bl2 = true;
            } else {
                Codigo codigo = this.obterCodigoOrigemRendimentos();
                ai ai2 = new ai();
                if (Aquisicao.STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_NACIONAL.equals(codigo.naoFormatado())) {
                    ai2.setConteudo(this.getApuracaoFinal().getGanhoCapital5OrigemMNReal());
                } else if (Aquisicao.STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_ESTRANGEIRA.equals(codigo.naoFormatado())) {
                    ai2.setConteudo(this.getApuracaoFinal().getGanhoCapital5OrigemMEReal());
                } else if (Aquisicao.STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_NACIONAL_E_ESTRANGEIRA.equals(codigo.naoFormatado())) {
                    ai2.setConteudo(this.getApuracaoFinal().getGanhoCapital5OrigemMNReal());
                    ai2.append('+', this.getApuracaoFinal().getGanhoCapital5OrigemMEReal());
                }
                if (ai2.isVazio()) {
                    bl2 = true;
                }
            }
        }
        return bl2;
    }

    public boolean isIsentoPorUnicoImovel() {
        boolean bl2;
        boolean bl3 = false;
        boolean bl4 = this.getPerguntas().naoTemOutraAlienacao();
        boolean bl5 = this.getPerguntas().getPropriedadeOutroImovel().formatado().equals("0");
        boolean bl6 = bl2 = !this.isIsentoPorPequenoValor();
        if (bl4 && bl5 && bl2) {
            bl3 = this.getDataRecebimentoUltimaParcela().isVazio() ? !this.isValorOperacaoMaior440K() : !this.isValorParcelasMaior440K();
        }
        return bl3;
    }

    public boolean isPermutaComTorna() {
        return String.valueOf(CODIGO_NATUREZA_PERMURTA_COM_RECEBIMENTO_DE_TORNA).equals(this.getNatureza().naoFormatado());
    }

    public boolean isPrevisaoPrejuizo() {
        boolean bl2 = false;
        if (!this.isAlienacaoBrasil()) {
            String string = this.obterCodigoOrigemRendimentos().naoFormatado();
            ai ai2 = new ai();
            if (Aquisicao.STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_NACIONAL.equals(string)) {
                ai2.setConteudo(this.getApuracao().getGanhoCapital1OrigemNacionalReal());
            } else if (Aquisicao.STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_ESTRANGEIRA.equals(string)) {
                ai2.setConteudo(this.getApuracao().getGanhoCapital1OrigemMEReal());
            } else if (Aquisicao.STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_NACIONAL_E_ESTRANGEIRA.equals(string)) {
                ai2.setConteudo(this.getApuracao().getGanhoCapital1OrigemNacionalReal().operacao('+', this.getApuracao().getGanhoCapital5OrigemMEReal()));
            }
            if (ai2.isVazio()) {
                bl2 = true;
            }
        }
        return bl2;
    }

    public boolean isPrejuizo() {
        boolean bl2 = false;
        if (!this.isAlienacaoBrasil() && this.isAlienacaoAPrazo() && !this.getDataRecebimentoUltimaParcela().isVazio() && this.getAjuste().getImpostoDevido2().isVazio()) {
            bl2 = true;
            System.out.println("Preju\u00edzo: " + this.getBemImovel().getEspecificacao().formatado());
        }
        return bl2;
    }

    public boolean existeDesdobramentoNaDataAquisicao() {
        boolean bl2 = false;
        if (!this.getAquisicao().getDataAquisicao().isVazio()) {
            for (ParcelaAquisicao parcelaAquisicao : this.getBemImovel().getAquisicao().getParcelasAquisicao().itens()) {
                if (!this.getAquisicao().getDataAquisicao().naoFormatado().equals(parcelaAquisicao.getData().naoFormatado())) continue;
                bl2 = true;
                break;
            }
        }
        return bl2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean existeCustoAquisicaoPosterior1969() {
        try {
            boolean bl2;
            boolean bl3;
            if (this.getAquisicao().getDataAquisicao().isVazio()) return false;
            if (1969 < Integer.parseInt(this.getAquisicao().getDataAquisicao().getAno())) {
                return true;
            }
            boolean bl4 = bl3 = false;
            if (bl4) {
                return true;
            }
            Iterator iterator = this.getBemImovel().getAquisicao().getParcelasAquisicao().itens().iterator();
            do {
                if (!iterator.hasNext()) {
                    return false;
                }
                ParcelaAquisicao parcelaAquisicao = (ParcelaAquisicao)((Object)iterator.next());
                if (1969 < Integer.valueOf(parcelaAquisicao.getData().getAno())) {
                    return true;
                }
                bl2 = bl3 = false;
            } while (!bl2);
            return true;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
        }
        return false;
    }

    public boolean existeGanhoDeCapitalSobreCustoAquisicao() {
        boolean bl2 = true;
        if (this.isAlienacaoBrasil()) {
            if (this.getApuracao().getGanhoCapital1().isVazio()) {
                bl2 = false;
            }
        } else if (this.getApuracao().getGanhoCapital1OrigemNacionalReal().isVazio() && this.getApuracao().getGanhoCapital1OrigemMEDolar().isVazio()) {
            bl2 = false;
        }
        return bl2;
    }

    public int obterEnquadramentoInicial() {
        int n2 = REDUCAO_AUSENTE;
        if ((Logico.NAO.equals(this.getBemGrandeValor().formatado()) || Logico.NAO.equals(this.getBemGrandeValorOperacao().formatado())) && this.isValorAlienacaoMenor35k()) {
            n2 = REDUCAO_IMOVEL_PEQUENO_VALOR;
        } else if (this.getPerguntas().naoTemOutraAlienacao() && this.isValorAlienacaoMenor440k()) {
            n2 = REDUCAO_UNICO_IMOVEL;
        } else if (this.getPerguntas().isValorReaplicado()) {
            n2 = REDUCAO_APLICACAO_OUTRO_IMOVEL;
        }
        return n2;
    }

    public int obterEnquadramentoFinal() {
        int n2 = REDUCAO_AUSENTE;
        ai ai2 = new ai();
        for (ParcelaAlienacaoBem parcelaAlienacaoBem : this.getColecaoParcelaAlienacao().itens()) {
            ai ai3 = new ai();
            ai3.setConteudo(parcelaAlienacaoBem.getValorRecebidoDolar());
            ai3.append('*', parcelaAlienacaoBem.getCotacaoDolar());
            ai2.append('+', ai3);
        }
        if (Logico.NAO.equals(this.getBemGrandeValor().formatado()) && ai2.comparacao("<=", "35.000,00")) {
            n2 = REDUCAO_IMOVEL_PEQUENO_VALOR;
        } else if (this.getPerguntas().naoTemOutraAlienacao() && ai2.comparacao("<=", this.getValorIsencaoUnicoImovel())) {
            n2 = REDUCAO_UNICO_IMOVEL;
        } else if (this.getPerguntas().isValorReaplicado()) {
            n2 = REDUCAO_APLICACAO_OUTRO_IMOVEL;
        }
        return n2;
    }

    public int obterEnquadramentoAtual() {
        int n2 = this.obterEnquadramentoInicial();
        if (this.getColecaoParcelaAlienacao().obterUltimaParcela() != null) {
            n2 = this.obterEnquadramentoFinal();
        }
        return n2;
    }

    public boolean mudouEnquadramento() {
        boolean bl2 = false;
        int n2 = this.obterEnquadramentoInicial();
        if (this.getColecaoParcelaAlienacao().obterUltimaParcela() != null && n2 != this.obterEnquadramentoFinal()) {
            bl2 = true;
        }
        return bl2;
    }

    public String obterMensagemMudancaEnquadramento() {
        String string = null;
        int n2 = this.obterEnquadramentoInicial();
        int n3 = this.obterEnquadramentoFinal();
        if (this.getColecaoParcelaAlienacao().obterUltimaParcela() != null && n2 != n3) {
            if (n2 == REDUCAO_AUSENTE) {
                if (n3 == REDUCAO_UNICO_IMOVEL) {
                    string = "<html>De acordo com o valor recebido (R$), h\u00e1 direito \u00e0 isen\u00e7\u00e3o por aliena\u00e7\u00e3o de \u00fanico im\u00f3vel.</html>";
                } else if (n3 == REDUCAO_IMOVEL_PEQUENO_VALOR) {
                    string = "<html>De acordo com o valor recebido (R$), h\u00e1 direito \u00e0 isen\u00e7\u00e3o por aliena\u00e7\u00e3o de bem de pequeno valor.</html>";
                }
            } else if (n2 == REDUCAO_IMOVEL_PEQUENO_VALOR) {
                if (n3 == REDUCAO_AUSENTE) {
                    string = "<html>De acordo com o valor recebido (R$), n\u00e3o h\u00e1 direito \u00e0 isen\u00e7\u00e3o por aliena\u00e7\u00e3o de bem de pequeno valor.<br>O imposto devido ser\u00e1 integralmente cobrado na \u00faltima parcela.</html>";
                } else if (n3 == REDUCAO_APLICACAO_OUTRO_IMOVEL) {
                    string = "<html>De acordo com o valor recebido (R$), n\u00e3o h\u00e1 direito \u00e0 isen\u00e7\u00e3o por aliena\u00e7\u00e3o de bem de pequeno valor.<br>Ser\u00e1 aplicada a isen\u00e7\u00e3o do art. 39 da Lei n\u00ba 11.196, de 2005.</html>";
                }
            } else if (n2 == REDUCAO_UNICO_IMOVEL) {
                if (n3 == REDUCAO_AUSENTE) {
                    string = "<html>De acordo com o valor recebido (R$), n\u00e3o h\u00e1 direito \u00e0 isen\u00e7\u00e3o por aliena\u00e7\u00e3o de \u00fanico im\u00f3vel.<br>O imposto devido ser\u00e1 integralmente cobrado na \u00faltima parcela.</html>";
                } else if (n3 == REDUCAO_APLICACAO_OUTRO_IMOVEL) {
                    string = "<html>De acordo com o valor recebido (R$), n\u00e3o h\u00e1 direito \u00e0 isen\u00e7\u00e3o por aliena\u00e7\u00e3o de \u00fanico im\u00f3vel.<br>Ser\u00e1 aplicada a isen\u00e7\u00e3o do art. 39 da Lei n\u00ba 11.196, de 2005.</html>";
                }
            } else if (n2 == REDUCAO_APLICACAO_OUTRO_IMOVEL) {
                if (n3 == REDUCAO_IMOVEL_PEQUENO_VALOR) {
                    string = "<html>De acordo com o valor recebido (R$), h\u00e1 direito \u00e0 isen\u00e7\u00e3o por aliena\u00e7\u00e3o de bem de pequeno valor.</html>";
                } else if (n3 == REDUCAO_UNICO_IMOVEL) {
                    string = "<html>De acordo com o valor recebido (R$), h\u00e1 direito \u00e0 isen\u00e7\u00e3o por aliena\u00e7\u00e3o de \u00fanico im\u00f3vel.</html>";
                }
            }
        }
        return string;
    }

    public String obterTextoIsencao() {
        String string = "";
        if (this.isAlienacaoAVista()) {
            if (this.getCalculoImposto().getImpostoDevido().isVazio()) {
                string = dL.a("impostoDevidoZero");
            }
        } else if (this.getDataRecebimentoUltimaParcela().isVazio()) {
            int n2 = this.obterEnquadramentoInicial();
            if (this.isPrevisaoPrejuizo() || n2 == REDUCAO_UNICO_IMOVEL || n2 == REDUCAO_IMOVEL_PEQUENO_VALOR || this.getPerguntas().isValorReaplicadoTotalmente()) {
                string = dL.a("impostoDevidoZero");
            }
        } else {
            String string2 = this.obterMensagemMudancaEnquadramento();
            if (string2 != null) {
                string = string2;
            } else if (this.getAjuste().getImpostoDevido().isVazio()) {
                string = dL.a("impostoDevidoZero");
            }
        }
        return string;
    }

    public boolean criticarLei180Dias() {
        int n2 = -1;
        try {
            n2 = Integer.valueOf(this.getDataAlienacao().getAno());
        }
        catch (Exception exception) {}
        return n2 >= ANO_TRANSICAO_LEI_180_DIAS;
    }

    public boolean podeResponderPerguntaPequenoValorNoExteriorPorParcelas() {
        boolean bl2 = false;
        boolean bl3 = Logico.SIM.equals(this.getResidenteBrasil().naoFormatado());
        ai ai2 = new ai();
        if (this.getBemImovel().isAdquiridoNoExterior()) {
            ai2.setConteudo(this.getValorAlienacaoDolar().operacao('*', this.getCotacaoDolarDataAlienacao()));
            if (ai2.comparacao(">", "35.000,00") && !this.getDataRecebimentoUltimaParcela().isVazio()) {
                ai2.clear();
                for (ParcelaAlienacaoBem parcelaAlienacaoBem : this.getColecaoParcelaAlienacao().itens()) {
                    ai ai3 = new ai();
                    ai3.setConteudo(parcelaAlienacaoBem.getValorRecebidoDolar());
                    ai3.append('*', parcelaAlienacaoBem.getCotacaoDolar());
                    ai2.append('+', ai3);
                }
                if (bl3 && ai2.comparacao("<=", "35.000,00") && this.getDataAlienacao().naoFormatado().length() == 8 && dD.d().equals(this.getDataAlienacao().getAno())) {
                    bl2 = true;
                }
            }
        }
        return bl2;
    }
}

