/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gcap.alienacao;

import classes.dD;
import classes.dL;
import classes.dc;
import java.util.ArrayList;
import serpro.ppgd.irpf.ai;
import serpro.ppgd.irpf.gcap.a;
import serpro.ppgd.irpf.gcap.alienacao.AlienacaoBem;
import serpro.ppgd.irpf.gcap.alienacao.AlienacaoBemImovel;
import serpro.ppgd.irpf.gcap.alienacao.ParcelaAlienacaoBem;
import serpro.ppgd.irpf.gcap.apuracao.ApuracaoBemMovel;
import serpro.ppgd.irpf.gcap.aquisicao.Aquisicao;
import serpro.ppgd.irpf.gcap.bensmoveis.BemMovel;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.Codigo;
import serpro.ppgd.negocio.Logico;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;

public class AlienacaoBemMovel
extends AlienacaoBem
implements a {
    public static final String NOME_FICHA_BEM_MOVEl = "Bens M\u00f3veis";
    public static final String NOME_ABA_IDENTIFICACAO = "Identifica\u00e7\u00e3o";
    public static final String NOME_ABA_ADQUIRENTES = "Adquirentes";
    public static final String NOME_ABA_OPERACAO = "Opera\u00e7\u00e3o";
    public static final String NOME_ABA_CALCULO = "C\u00e1lculo do Imposto";
    public static int REDUCAO_AUSENTE = 0;
    public static int REDUCAO_IMOVEL_PEQUENO_VALOR = 1;
    private BemMovel bemMovel = new BemMovel(this);
    private ApuracaoBemMovel apuracao = new ApuracaoBemMovel();
    private ApuracaoBemMovel apuracaoFinal = new ApuracaoBemMovel();
    private Alfa alienacaoAPrazoMovelAux = new Alfa((ObjetoNegocio)this, "Aliena\u00e7\u00e3o foi a prazo/presta\u00e7\u00e3o?", 1);

    public AlienacaoBemMovel() {
        this.bemMovel.getAquisicao().getCustoAquisicaoOrigemNacionalReal().setReadOnly(true);
        this.bemMovel.getAquisicao().getCustoAquisicaoTotalDolar().setReadOnly(true);
        this.getBemMovel().getBemAdquiridoNoBrasil().addObservador((Observador)new serpro.ppgd.irpf.gcap.alienacao.a(this));
        if (this.getBemMovel().isAdquiridoNoBrasil()) {
            this.getNatureza().setColecaoElementoTabela(dc.t());
            return;
        }
        if (this.getBemMovel().isAdquiridoNoExterior()) {
            this.getNatureza().setColecaoElementoTabela(dc.r());
            return;
        }
        this.getNatureza().setColecaoElementoTabela(new ArrayList());
    }

    public BemMovel getBemMovel() {
        return this.bemMovel;
    }

    public Alfa getAlienacaoAPrazoMovelAux() {
        return this.alienacaoAPrazoMovelAux;
    }

    @Override
    public Aquisicao getAquisicao() {
        return this.getBemMovel().getAquisicao();
    }

    @Override
    public ApuracaoBemMovel getApuracao() {
        return this.apuracao;
    }

    @Override
    public ApuracaoBemMovel getApuracaoFinal() {
        return this.apuracaoFinal;
    }

    @Override
    public Codigo obterCodigoOrigemRendimentos() {
        return this.getBemMovel().getAquisicao().getOrigemRendimentos();
    }

    @Override
    public boolean isAlienacaoBrasil() {
        return this.getBemMovel().isAdquiridoNoBrasil();
    }

    public boolean isVazio() {
        return this.getBemMovel().getBemAdquiridoNoBrasil().isVazio();
    }

    public boolean isPrevisaoPrejuizo() {
        boolean bl2 = false;
        if (!this.isAlienacaoBrasil()) {
            String string = this.obterCodigoOrigemRendimentos().naoFormatado();
            ai ai2 = new ai();
            if (Aquisicao.STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_NACIONAL.equals(string)) {
                ai2.setConteudo(this.getApuracao().getGanhoCapital1OrigemNacionalReal());
            } else if (Aquisicao.STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_ESTRANGEIRA.equals(string)) {
                ai2.setConteudo(this.getApuracao().getGanhoCapital1OrigemMEReal());
            } else if (Aquisicao.STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_NACIONAL_E_ESTRANGEIRA.equals(string)) {
                ai2.setConteudo(this.getApuracao().getGanhoCapital1OrigemNacionalReal().operacao('+', this.getApuracao().getGanhoCapital1OrigemMEReal()));
            }
            if (ai2.isVazio()) {
                bl2 = true;
            }
        }
        return bl2;
    }

    public int obterEnquadramentoInicial() {
        int n2 = REDUCAO_AUSENTE;
        if (!this.isValorOperacaoMaior35K() && (Logico.NAO.equals(this.getBemGrandeValor().formatado()) || Logico.NAO.equals(this.getBemGrandeValorOperacao().formatado()))) {
            n2 = REDUCAO_IMOVEL_PEQUENO_VALOR;
        }
        return n2;
    }

    public int obterEnquadramentoFinal() {
        int n2 = REDUCAO_AUSENTE;
        if (!this.isValorParcelasMaior35K() && Logico.NAO.equals(this.getBemGrandeValor().formatado())) {
            n2 = REDUCAO_IMOVEL_PEQUENO_VALOR;
        }
        return n2;
    }

    public String obterMensagemMudancaEnquadramento() {
        String string = null;
        int n2 = this.obterEnquadramentoInicial();
        int n3 = this.obterEnquadramentoFinal();
        if (this.getColecaoParcelaAlienacao().obterUltimaParcela() != null && n2 != n3) {
            if (n2 == AlienacaoBemImovel.REDUCAO_AUSENTE) {
                if (n3 == AlienacaoBemImovel.REDUCAO_IMOVEL_PEQUENO_VALOR) {
                    string = "<html>De acordo com o valor recebido (R$), h\u00e1 direito \u00e0 isen\u00e7\u00e3o por aliena\u00e7\u00e3o de bem de pequeno valor.</html>";
                }
            } else if (n2 == AlienacaoBemImovel.REDUCAO_IMOVEL_PEQUENO_VALOR && n3 == AlienacaoBemImovel.REDUCAO_AUSENTE) {
                string = "<html>De acordo com o valor recebido (R$), n\u00e3o h\u00e1 direito \u00e0 isen\u00e7\u00e3o por aliena\u00e7\u00e3o de bem de pequeno valor.<br>O imposto devido ser\u00e1 integralmente cobrado na \u00faltima parcela.</html>";
            }
        }
        return string;
    }

    public String obterTextoIsencao() {
        String string = "";
        if (this.isAlienacaoAVista()) {
            if (this.getCalculoImposto().getImpostoDevido().isVazio()) {
                string = dL.a("impostoDevidoZero");
            }
        } else if (this.getDataRecebimentoUltimaParcela().isVazio()) {
            if (this.isPrevisaoPrejuizo() || this.isIsento()) {
                string = dL.a("impostoDevidoZero");
            }
        } else {
            String string2 = this.obterMensagemMudancaEnquadramento();
            if (string2 != null) {
                string = string2;
            } else if (this.getAjuste().getImpostoDevido().isVazio()) {
                string = dL.a("impostoDevidoZero");
            }
        }
        return string;
    }

    public boolean podeResponderPerguntaPequenoValorNoExteriorPorParcelas() {
        boolean bl2 = false;
        boolean bl3 = Logico.SIM.equals(this.getResidenteBrasil().naoFormatado());
        ai ai2 = new ai();
        if (this.getBemMovel().isAdquiridoNoExterior()) {
            ai2.setConteudo(this.getValorAlienacaoDolar().operacao('*', this.getCotacaoDolarDataAlienacao()));
            if (ai2.comparacao(">", "35.000,00") && !this.getDataRecebimentoUltimaParcela().isVazio()) {
                ai2.clear();
                for (ParcelaAlienacaoBem parcelaAlienacaoBem : this.getColecaoParcelaAlienacao().itens()) {
                    ai ai3 = new ai();
                    ai3.setConteudo(parcelaAlienacaoBem.getValorRecebidoDolar());
                    ai3.append('*', parcelaAlienacaoBem.getCotacaoDolar());
                    ai2.append('+', ai3);
                }
                if (bl3 && ai2.comparacao("<=", "35.000,00") && this.getDataAlienacao().naoFormatado().length() == 8 && dD.d().equals(this.getDataAlienacao().getAno())) {
                    bl2 = true;
                }
            }
        }
        return bl2;
    }

    @Override
    public boolean isAdquirenteRequerido() {
        boolean bl2 = super.isAdquirenteRequerido();
        if (bl2 && !this.isAlienacaoBrasil() && String.valueOf(AlienacaoBem.CODIGO_NATUREZA_LIQUID_OU_RESGATE_DE_APLIC_FINANCEIRA).equals(this.getNatureza().naoFormatado())) {
            bl2 = false;
        }
        return bl2;
    }
}

