/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gcap.alienacao;

import java.lang.ref.WeakReference;
import java.util.Iterator;
import serpro.ppgd.irpf.ai;
import serpro.ppgd.irpf.gcap.alienacao.Alienacao;
import serpro.ppgd.irpf.gcap.alienacao.ParcelaAlienacao;
import serpro.ppgd.negocio.Colecao;
import serpro.ppgd.negocio.Data;

public class ColecaoParcelaAlienacao
extends Colecao<ParcelaAlienacao> {
    private ai valorRecebidoTotal = new ai();
    private ai custoCorretagemTotal = new ai();
    private ai valorLiquidoAlienacaoTotal = new ai();
    private ai ganhoProporcionalTotal = new ai();
    private ai impostoDevidoTotal = new ai();
    private ai impostoPagoTotal = new ai();
    private ai impostoDevido2Total = new ai();
    private ai irrfLei110332004Total = new ai();
    private ai custoAquisicaoProporcionalTotal = new ai();
    private WeakReference<Alienacao> weakAlienacao = null;

    public ColecaoParcelaAlienacao(Alienacao alienacao) {
        super(ParcelaAlienacao.class.getName());
        this.weakAlienacao = new WeakReference<Alienacao>(alienacao);
        this.valorRecebidoTotal.setReadOnly(true);
        this.custoCorretagemTotal.setReadOnly(true);
        this.valorLiquidoAlienacaoTotal.setReadOnly(true);
        this.ganhoProporcionalTotal.setReadOnly(true);
        this.impostoDevidoTotal.setReadOnly(true);
        this.impostoPagoTotal.setReadOnly(true);
        this.custoAquisicaoProporcionalTotal.setReadOnly(true);
    }

    public void ajustarPosicaoParcela(ParcelaAlienacao parcelaAlienacao) {
        if (parcelaAlienacao.getDataRecebimento().validar().getPrimeiroRetornoValidacaoMaisSevero().isValido()) {
            parcelaAlienacao.setEmReordenacao(true);
            this.itens().remove((Object)parcelaAlienacao);
            int n2 = 0;
            Iterator iterator = this.itens().iterator();
            while (iterator.hasNext()) {
                if (((ParcelaAlienacao)((Object)iterator.next())).getDataRecebimento().maisNova(parcelaAlienacao.getDataRecebimento())) break;
                ++n2;
            }
            this.itens().add(n2, parcelaAlienacao);
            parcelaAlienacao.setEmReordenacao(false);
        }
    }

    public Data getDataRecebimentoUltimaParcela() {
        Data data = new Data();
        for (ParcelaAlienacao parcelaAlienacao : this.itens()) {
            if (!parcelaAlienacao.isUltimaParcela()) continue;
            data.setConteudo(parcelaAlienacao.getDataRecebimento());
        }
        return data;
    }

    public boolean jaTemUltimaParcela() {
        int n2 = 0;
        for (ParcelaAlienacao parcelaAlienacao : this.itens()) {
            if (!parcelaAlienacao.isUltimaParcela()) continue;
            ++n2;
        }
        return n2 > 1;
    }

    public ai obterImpostoPagoUltimaParcela() {
        ai ai2 = new ai();
        for (ParcelaAlienacao parcelaAlienacao : this.itens()) {
            if (!parcelaAlienacao.isUltimaParcela()) continue;
            ai2.setConteudo(parcelaAlienacao.getImpostoPago());
            break;
        }
        return ai2;
    }

    public ai obterGanhoCapitalRealTotalSemUltimaParcela() {
        ai ai2 = new ai();
        for (ParcelaAlienacao parcelaAlienacao : this.itens()) {
            if (parcelaAlienacao.isUltimaParcela()) continue;
            ai2.append('+', parcelaAlienacao.getGanhoCapital1Proporcional());
        }
        return ai2;
    }

    public ai obterImpostoDevidoSemUltimaParcela() {
        ai ai2 = new ai();
        for (ParcelaAlienacao parcelaAlienacao : this.itens()) {
            if (parcelaAlienacao.isUltimaParcela()) continue;
            ai2.append('+', parcelaAlienacao.getImpostoDevido());
        }
        return ai2;
    }

    public ParcelaAlienacao obterUltimaParcela() {
        ParcelaAlienacao parcelaAlienacao = null;
        for (ParcelaAlienacao parcelaAlienacao2 : this.itens()) {
            if (!parcelaAlienacao2.isUltimaParcela()) continue;
            parcelaAlienacao = parcelaAlienacao2;
        }
        return parcelaAlienacao;
    }

    public boolean existeParcelaAposUltima(ParcelaAlienacao parcelaAlienacao) {
        boolean bl2 = false;
        for (ParcelaAlienacao parcelaAlienacao2 : this.itens()) {
            if (!parcelaAlienacao.isUltimaParcela() || parcelaAlienacao2.isUltimaParcela() || parcelaAlienacao2.getDataRecebimento().isVazio() || !parcelaAlienacao.getDataRecebimento().maisAntiga(parcelaAlienacao2.getDataRecebimento())) continue;
            bl2 = true;
        }
        return bl2;
    }

    public boolean parcelaPosteriorUltima(Data data) {
        boolean bl2 = false;
        Data data2 = this.getDataRecebimentoUltimaParcela();
        if (!data2.isVazio() && data.maisNova(data2)) {
            bl2 = true;
        }
        return bl2;
    }

    public boolean existeParcelaNaMesmaData(ParcelaAlienacao parcelaAlienacao) {
        boolean bl2 = false;
        for (ParcelaAlienacao parcelaAlienacao2 : this.itens()) {
            if (parcelaAlienacao == parcelaAlienacao2 || parcelaAlienacao.getDataRecebimento().isVazio() || !parcelaAlienacao.getDataRecebimento().igual(parcelaAlienacao2.getDataRecebimento())) continue;
            bl2 = true;
        }
        return bl2;
    }

    public ai getValorRecebidoTotal() {
        return this.valorRecebidoTotal;
    }

    public ai getGanhoProporcionalTotal() {
        return this.ganhoProporcionalTotal;
    }

    public ai getImpostoDevidoTotal() {
        return this.impostoDevidoTotal;
    }

    public ai getImpostoPagoTotal() {
        return this.impostoPagoTotal;
    }

    public ai getCustoCorretagemTotal() {
        return this.custoCorretagemTotal;
    }

    public ai getValorLiquidoAlienacaoTotal() {
        return this.valorLiquidoAlienacaoTotal;
    }

    public ai getImpostoDevido2Total() {
        return this.impostoDevido2Total;
    }

    public ai getIrrfLei110332004Total() {
        return this.irrfLei110332004Total;
    }

    public ai getCustoAquisicaoProporcionalTotal() {
        return this.custoAquisicaoProporcionalTotal;
    }
}

