/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gcap.perguntas;

import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.Logico;
import serpro.ppgd.negocio.ObjetoNegocio;

public class PerguntasImovel
extends ObjetoNegocio {
    public static String LABEL_CAMPO_MP252 = "O produto da aliena\u00e7\u00e3o foi ou ser\u00e1 aplicado na aquisi\u00e7\u00e3o de im\u00f3vel residencial no Brasil no prazo de cento e oitenta dias, em conformidade com o art. 39 da Lei n\u00ba 11.196, de 2005?";
    private Logico propriedadeOutroImovel = new Logico((ObjetoNegocio)this, "Voc\u00ea possui outro im\u00f3vel, seja como propriet\u00e1rio individual, em condom\u00ednio ou em comunh\u00e3o?");
    private Logico outraAlienacao = new Logico((ObjetoNegocio)this, "Nos \u00faltimos cinco anos, voc\u00ea efetuou outra aliena\u00e7\u00e3o de im\u00f3vel a qualquer t\u00edtulo, tributada ou n\u00e3o?");
    private Logico mP252 = new Logico((ObjetoNegocio)this, LABEL_CAMPO_MP252);
    private Logico imovelResidencial = new Logico((ObjetoNegocio)this, "O im\u00f3vel objeto desta aliena\u00e7\u00e3o \u00e9 residencial?");
    private Alfa propriedadeOutroImovelAux = new Alfa((ObjetoNegocio)this, "Propriet\u00e1rio de outro im\u00f3vel?");
    private Alfa outraAlienacaoAux = new Alfa((ObjetoNegocio)this, "Nos \u00faltimos cinco anos voc\u00ea efetuou outra aliena\u00e7ao?");
    private Alfa mP252Aux = new Alfa((ObjetoNegocio)this, "Valor da aliena\u00e7\u00e3o foi aplicado no prazo de 180 dias?");
    private Alfa imovelResidencialAux = new Alfa((ObjetoNegocio)this, "Im\u00f3vel Residencial?");

    public PerguntasImovel() {
        this.adicionaOpcaoSimNao(this.propriedadeOutroImovel);
        this.adicionaOpcaoSimNao(this.outraAlienacao);
        this.adicionaOpcaoSimNao(this.imovelResidencial);
        this.adicionaOpcaoSimNaoParcialmente(this.mP252);
        this.setReadOnlyPerguntasImovel();
    }

    public void setReadOnlyPerguntasImovel() {
        this.propriedadeOutroImovel.setReadOnly(true);
        this.propriedadeOutroImovel.setHabilitado(false);
        this.outraAlienacao.setReadOnly(true);
        this.outraAlienacao.setHabilitado(false);
        this.mP252.setReadOnly(true);
        this.mP252.setHabilitado(false);
        this.imovelResidencial.setReadOnly(true);
        this.imovelResidencial.setHabilitado(false);
    }

    protected void adicionaOpcaoSimNao(Logico logico) {
        logico.addOpcao(Logico.SIM, Logico.LABEL_SIM);
        logico.addOpcao(Logico.NAO, Logico.LABEL_NAO);
    }

    protected void adicionaOpcaoSimNaoParcialmente(Logico logico) {
        this.adicionaOpcaoSimNao(logico);
        logico.addOpcao("P", "Parcialmente");
    }

    public Logico getPropriedadeOutroImovel() {
        return this.propriedadeOutroImovel;
    }

    public Logico getOutraAlienacao() {
        return this.outraAlienacao;
    }

    public Logico getMP252() {
        return this.mP252;
    }

    public Logico getImovelResidencial() {
        return this.imovelResidencial;
    }

    public Alfa getPropriedadeOutroImovelAux() {
        return this.propriedadeOutroImovelAux;
    }

    public Alfa getOutraAlienacaoAux() {
        return this.outraAlienacaoAux;
    }

    public Alfa getMP252Aux() {
        return this.mP252Aux;
    }

    public Alfa getImovelResidencialAux() {
        return this.imovelResidencialAux;
    }

    public boolean isImovelResidencial() {
        return Logico.SIM.equals(this.getImovelResidencial().naoFormatado());
    }

    public boolean isValorReaplicadoTotalmente() {
        return Logico.SIM.equals(this.getMP252().naoFormatado());
    }

    public boolean isValorReaplicadoParcialmente() {
        return "P".equals(this.getMP252().naoFormatado());
    }

    public boolean isValorReaplicado() {
        return this.isValorReaplicadoTotalmente() || this.isValorReaplicadoParcialmente();
    }

    public boolean naoTemOutraAlienacao() {
        return Logico.NAO.equals(this.getOutraAlienacao().naoFormatado());
    }

    public boolean unicoImovel() {
        return Logico.NAO.equals(this.getPropriedadeOutroImovel().naoFormatado());
    }
}

