/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.pagamentos;

import classes.bq;
import classes.dL;
import classes.dN;
import classes.dc;
import java.lang.ref.WeakReference;
import java.util.List;
import serpro.ppgd.cacheni.CacheNI;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.IdentificadorDeclaracao;
import serpro.ppgd.irpf.ai;
import serpro.ppgd.irpf.gui.pagamentos.PainelPagamentosLista;
import serpro.ppgd.irpf.pagamentos.Pagamentos;
import serpro.ppgd.irpf.pagamentos.d;
import serpro.ppgd.irpf.pagamentos.f;
import serpro.ppgd.irpf.pagamentos.g;
import serpro.ppgd.irpf.pagamentos.h;
import serpro.ppgd.irpf.pagamentos.i;
import serpro.ppgd.irpf.pagamentos.j;
import serpro.ppgd.irpf.pagamentos.k;
import serpro.ppgd.irpf.pagamentos.l;
import serpro.ppgd.irpf.pagamentos.m;
import serpro.ppgd.irpf.pagamentos.n;
import serpro.ppgd.irpf.pagamentos.o;
import serpro.ppgd.irpf.pagamentos.p;
import serpro.ppgd.irpf.pagamentos.q;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.CPF;
import serpro.ppgd.negocio.Codigo;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.NI;
import serpro.ppgd.negocio.ObjetoFicha;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.ValidadorIf;
import serpro.ppgd.negocio.Valor;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorCodigo;

public class Pagamento
extends ObjetoNegocio
implements dN,
ObjetoFicha {
    public static final String PAGAMENTO_INSTRUCAO_BR = "01";
    public static final String PAGAMENTO_INSTRUCAO_EX = "02";
    public static final String PAGAMENTO_FONOAUDIOLOGO_BR = "09";
    public static final String PAGAMENTO_MEDICO_BR = "10";
    public static final String PAGAMENTO_DENTISTA_BR = "11";
    public static final String PAGAMENTO_PSICOLOGO_BR = "12";
    public static final String PAGAMENTO_FISIOTERAPEUTA_BR = "13";
    public static final String PAGAMENTO_TERAPEUTA_OCUPACIONAL_BR = "14";
    public static final String PAGAMENTO_MEDICO_EX = "15";
    public static final String PAGAMENTO_DENTISTA_EX = "16";
    public static final String PAGAMENTO_PSICOLOGO_EX = "17";
    public static final String PAGAMENTO_FISIOTERAPEUTA_EX = "18";
    public static final String PAGAMENTO_TERAPEUTA_OCUPACIONAL_EX = "19";
    public static final String PAGAMENTO_FONOAUDIOLOGO_EX = "20";
    public static final String PAGAMENTO_HOSPITAL_BR = "21";
    public static final String PAGAMENTO_HOSPITAL_EX = "22";
    public static final String PAGAMENTO_PLANOSAUDE_BR = "26";
    public static final String PAGAMENTO_PENSAOALIMENTICIA_BR = "30";
    public static final String PAGAMENTO_PENSAOALIMENTICIA_EX = "31";
    public static final String PAGAMENTO_PENSAODIVORCIO_BR = "33";
    public static final String PAGAMENTO_PENSAODIVORCIO_EX = "34";
    public static final String PAGAMENTO_PREVIPRIVADA = "36";
    public static final String PAGAMENTO_FUNPRESP = "37";
    public static final String PAGAMENTO_FAPI = "38";
    public static final String PAGAMENTO_CONTRIBUICAO_PATRONAL = "50";
    public static final String PAGAMENTO_ADVOGADOS = "60";
    public static final String PAGAMENTO_ADVOGADOS_TRAB = "61";
    public static final String PAGAMENTO_ADVOGADOS_HONORARIOS = "62";
    public static final String PAGAMENTO_PROFLIBERAL = "66";
    public static final String PAGAMENTO_ALUGUEIS = "70";
    public static final String PAGAMENTO_ADMINISTRADOR_IMOVEL = "71";
    public static final String PAGAMENTO_CORRETOR_IMOVEIS = "72";
    public static final String PAGAMENTO_ARRENDRURAL = "76";
    public static final String PAGAMENTO_OUTROS = "99";
    public static final String NOME_CODIGO = "C\u00f3digo";
    public static final String NOME_TIPO = "Tipo";
    private Codigo codigo = new Codigo((ObjetoNegocio)this, "C\u00f3digo", dc.g());
    private Alfa tipo = new Alfa((ObjetoNegocio)this, "Tipo");
    public static final String TIPO_TITULAR = "T";
    public static final String TIPO_DEPENDENTE = "D";
    public static final String TIPO_ALIMENTANDO = "A";
    public static final String TIPO_PADRAO = "V";
    private Alfa dependenteOuAlimentando = new Alfa((ObjetoNegocio)this, "Dependente/Alimentando", 60);
    private Alfa nomeBeneficiario = new Alfa((ObjetoNegocio)this, "Nome do Benefici\u00e1rio", 60);
    private NI niBeneficiario = new NI((ObjetoNegocio)this, "CPF/CNPJ do Beneficiario");
    private ai valorPago = new ai(this, "Valor Pago");
    private ai parcelaNaoDedutivel = new ai(this, "Parcela N\u00e3o Dedut\u00edvel/Valor Reembolsado");
    private ai contribuicaoEntePatrocinador = new ai(this, "Contribui\u00e7\u00e3o do ente p\u00fablico patrocinador");
    private Alfa nitEmpregadoDomestico = new Alfa((ObjetoNegocio)this, "NIT do empregado dom\u00e9stico");
    private Alfa indice = new Alfa((ObjetoNegocio)this, "\u00cdndice");
    private CPF cpfDependente = new CPF((ObjetoNegocio)this, "CPF Dependente");
    private CPF cpfAlimentando = new CPF((ObjetoNegocio)this, "CPF Alimentando");
    protected transient IdentificadorDeclaracao identificadorDeclaracao = null;
    private WeakReference<DeclaracaoIRPF> declaracaoRef = null;

    public Pagamento(DeclaracaoIRPF declaracaoIRPF) {
        this.identificadorDeclaracao = declaracaoIRPF.getIdentificadorDeclaracao();
        this.declaracaoRef = new WeakReference<DeclaracaoIRPF>(declaracaoIRPF);
        CacheNI.getInstancia().registrarNINome(this.niBeneficiario, this.nomeBeneficiario);
        this.tipo.addObservador((Observador)new d(this));
        this.getCodigo().setColunaFiltro(1);
        this.getDependenteOuAlimentando().addValidador((ValidadorIf)new f(this, 3));
        this.getNitEmpregadoDomestico().addValidador((ValidadorIf)new j(this, 3, dL.a("pagamento_nit_branco")));
        this.getNitEmpregadoDomestico().addValidador((ValidadorIf)new k(this, 3, dL.a("pagamento_nit_invalido")));
        this.getCodigo().addObservador((Observador)new l(this));
        this.getCodigo().addValidador((ValidadorIf)new m(this, 3, dL.a("pagamento_codigo_invalido")));
        this.getCodigo().addValidador((ValidadorIf)new ValidadorCodigo(3, dL.a("pagamento_codigo_invalido")));
        this.getNomeBeneficiario().addValidador((ValidadorIf)new n(this, 3));
        this.getNiBeneficiario().addValidador((ValidadorIf)new o(this, 3));
        this.getParcelaNaoDedutivel().addValidador((ValidadorIf)new p(this, 3));
        this.getValorPago().addValidador((ValidadorIf)new q(this, 3));
        this.getDependenteOuAlimentando().addValidador((ValidadorIf)new g(this, 3));
        this.getNiBeneficiario().addValidador((ValidadorIf)new h(this, 3));
        this.getTipo().addValidador((ValidadorIf)new i(this, 3, dL.a("pagamento_tipo_pagamento_vazio")));
    }

    public Codigo getCodigo() {
        return this.codigo;
    }

    public NI getNiBeneficiario() {
        return this.niBeneficiario;
    }

    public Alfa getNomeBeneficiario() {
        return this.nomeBeneficiario;
    }

    public Valor getParcelaNaoDedutivel() {
        return this.parcelaNaoDedutivel;
    }

    public Valor getContribuicaoEntePatrocinador() {
        return this.contribuicaoEntePatrocinador;
    }

    public Valor getValorPago() {
        return this.valorPago;
    }

    public Alfa getDependenteOuAlimentando() {
        return this.dependenteOuAlimentando;
    }

    protected List<Informacao> recuperarListaCamposPendencia() {
        List list = super.recuperarListaCamposPendencia();
        list.add(this.codigo);
        list.add(this.dependenteOuAlimentando);
        list.add(this.nomeBeneficiario);
        list.add(this.niBeneficiario);
        list.add(this.nitEmpregadoDomestico);
        list.add(this.valorPago);
        list.add(this.parcelaNaoDedutivel);
        list.add(this.contribuicaoEntePatrocinador);
        list.add(this.tipo);
        return list;
    }

    public Alfa getNitEmpregadoDomestico() {
        return this.nitEmpregadoDomestico;
    }

    public boolean isVazio() {
        for (Informacao informacao : this.recuperarCamposInformacao()) {
            if (informacao.isVazio() || informacao.getNomeCampo().equals("\u00cdndice") || informacao.getNomeCampo().equals(NOME_TIPO) || informacao.getNomeCampo().equals(NOME_CODIGO)) continue;
            return false;
        }
        return true;
    }

    public int compareTo(Object object) {
        object = (Pagamento)object;
        int n2 = ((Pagamento)object).getCodigo().asInteger();
        return n2 - this.getCodigo().asInteger();
    }

    public String getChave() {
        return this.getCodigo().naoFormatado();
    }

    public Alfa getIndice() {
        return this.indice;
    }

    public Alfa getTipo() {
        return this.tipo;
    }

    public CPF getCPFDependente() {
        return this.cpfDependente;
    }

    public CPF getCPFAlimentando() {
        return this.cpfAlimentando;
    }

    public boolean ehTitularBrasil() {
        return this.getTipo().naoFormatado().equals(TIPO_TITULAR) && this.getCodigo().naoFormatado().equals(PAGAMENTO_INSTRUCAO_BR);
    }

    public boolean ehTitularExterior() {
        return this.getTipo().naoFormatado().equals(TIPO_TITULAR) && this.getCodigo().naoFormatado().equals(PAGAMENTO_INSTRUCAO_EX);
    }

    public boolean ehDependenteBrasil() {
        return this.getTipo().naoFormatado().equals(TIPO_DEPENDENTE) && this.getCodigo().naoFormatado().equals(PAGAMENTO_INSTRUCAO_BR);
    }

    public boolean ehDependenteExterior() {
        return this.getTipo().naoFormatado().equals(TIPO_DEPENDENTE) && this.getCodigo().naoFormatado().equals(PAGAMENTO_INSTRUCAO_EX);
    }

    public boolean ehAlimentandoBrasil() {
        return this.getTipo().naoFormatado().equals(TIPO_ALIMENTANDO) && this.getCodigo().naoFormatado().equals(PAGAMENTO_INSTRUCAO_BR);
    }

    public boolean ehAlimentandoExterior() {
        return this.getTipo().naoFormatado().equals(TIPO_ALIMENTANDO) && this.getCodigo().naoFormatado().equals(PAGAMENTO_INSTRUCAO_EX);
    }

    public boolean isPensao() {
        return this.getCodigo().naoFormatado().equals(PAGAMENTO_PENSAOALIMENTICIA_BR) || this.getCodigo().naoFormatado().equals(PAGAMENTO_PENSAOALIMENTICIA_EX) || this.getCodigo().naoFormatado().equals(PAGAMENTO_PENSAODIVORCIO_BR) || this.getCodigo().naoFormatado().equals(PAGAMENTO_PENSAODIVORCIO_EX);
    }

    public boolean isPrevidenciaPrivadaFapi() {
        return this.getCodigo().naoFormatado().equals(PAGAMENTO_PREVIPRIVADA) || this.getCodigo().naoFormatado().equals(PAGAMENTO_FAPI);
    }

    public boolean isFunpresp() {
        return this.getCodigo().naoFormatado().equals(PAGAMENTO_FUNPRESP);
    }

    public boolean isSomenteTitular() {
        return this.getCodigo().naoFormatado().equals(PAGAMENTO_CONTRIBUICAO_PATRONAL) || this.getCodigo().naoFormatado().equals(PAGAMENTO_ADVOGADOS) || this.getCodigo().naoFormatado().equals(PAGAMENTO_ADVOGADOS_TRAB) || this.getCodigo().naoFormatado().equals(PAGAMENTO_ADVOGADOS_HONORARIOS) || this.getCodigo().naoFormatado().equals(PAGAMENTO_PROFLIBERAL) || this.getCodigo().naoFormatado().equals(PAGAMENTO_ALUGUEIS) || this.getCodigo().naoFormatado().equals(PAGAMENTO_ADMINISTRADOR_IMOVEL) || this.getCodigo().naoFormatado().equals(PAGAMENTO_CORRETOR_IMOVEIS) || this.getCodigo().naoFormatado().equals(PAGAMENTO_ARRENDRURAL) || this.getCodigo().naoFormatado().equals(PAGAMENTO_OUTROS);
    }

    public Valor getValorPagoFunprespCalculado() {
        Valor valor = new Valor();
        if (this.getContribuicaoEntePatrocinador().comparacao("<", this.getValorPago())) {
            valor.setConteudo(this.getContribuicaoEntePatrocinador());
        } else {
            valor.setConteudo(this.getValorPago());
        }
        return valor;
    }

    public Valor getValorPagoFapiAtravesFunpresp() {
        Valor valor = new Valor();
        if (this.getValorPago().comparacao(">", this.getContribuicaoEntePatrocinador())) {
            valor.setConteudo(this.getValorPago().subtract(this.getContribuicaoEntePatrocinador()));
        }
        return valor;
    }

    public String obterMensagemExcedeuLimiteDeducaoPrevPrivadaFapiFunpresp() {
        boolean bl2 = this.isFunpresp() || this.isPrevidenciaPrivadaFapi();
        String string = null;
        if (bl2) {
            Pagamentos pagamentos = ((DeclaracaoIRPF)((Object)this.getDeclaracaoRef().get())).getPagamentos();
            Valor valor = bq.a(pagamentos, new String[]{PAGAMENTO_PREVIPRIVADA}, true);
            Valor valor2 = bq.a(pagamentos, new String[]{PAGAMENTO_FAPI}, true);
            Valor valor3 = bq.a(pagamentos);
            Valor valor4 = new Valor();
            valor4.append('+', valor);
            valor4.append('+', valor2);
            valor4.append('+', valor3);
            pagamentos = pagamentos.getTotalContribuicaoFAPI();
            Valor valor5 = new Valor();
            valor5.setConteudo(((DeclaracaoIRPF)((Object)this.getDeclaracaoRef().get())).getResumo().getRendimentosTributaveisDeducoes().getTotalRendimentos());
            Valor valor6 = new Valor();
            valor6.setConteudo(valor5);
            valor6.append('*', "0,12");
            if (valor4.comparacao(">", (Valor)pagamentos)) {
                string = dL.a("pagamento_limite_prevpriv_fapi", new String[]{valor4.formatado(), pagamentos.formatado(), valor.formatado(), valor2.formatado(), valor3.formatado(), valor4.formatado(), valor5.formatado(), valor6.formatado()});
            }
        }
        return string;
    }

    public WeakReference<DeclaracaoIRPF> getDeclaracaoRef() {
        return this.declaracaoRef;
    }

    public String getClasseFicha() {
        return PainelPagamentosLista.class.getName();
    }

    public String getNomeAba() {
        return null;
    }

    public String getTituloFichaDashboard() {
        return "Pagamentos Efetuados";
    }

    static /* synthetic */ WeakReference a(Pagamento pagamento) {
        return pagamento.declaracaoRef;
    }

    static /* synthetic */ Alfa b(Pagamento pagamento) {
        return pagamento.tipo;
    }

    static /* synthetic */ Codigo c(Pagamento pagamento) {
        return pagamento.codigo;
    }

    static /* synthetic */ Alfa d(Pagamento pagamento) {
        return pagamento.nomeBeneficiario;
    }

    static /* synthetic */ NI e(Pagamento pagamento) {
        return pagamento.niBeneficiario;
    }
}

