/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.pagamentos;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.pagamentos.Pagamento;
import serpro.ppgd.irpf.pagamentos.r;
import serpro.ppgd.irpf.pagamentos.s;
import serpro.ppgd.irpf.pagamentos.t;
import serpro.ppgd.irpf.pagamentos.u;
import serpro.ppgd.irpf.pagamentos.v;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.Colecao;
import serpro.ppgd.negocio.NI;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Valor;

public class Pagamentos
extends Colecao<Pagamento> {
    private Valor totalDeducoesInstrucao = new Valor((ObjetoNegocio)this, "");
    private Valor totalContribuicaoFAPI = new Valor((ObjetoNegocio)this, "");
    private Valor totalContribuicaoFunpresp = new Valor((ObjetoNegocio)this, "");
    private Valor totalDespesasMedicas = new Valor((ObjetoNegocio)this, "");
    private Valor totalPensao = new Valor((ObjetoNegocio)this, "");
    private Valor totalPensaoCartoral = new Valor((ObjetoNegocio)this, "");
    private Valor totalContribEmpregadoDomestico = new Valor((ObjetoNegocio)this, "");
    private Alfa ultimoIndiceGerado = new Alfa();
    private static long geradorIndices;
    private WeakReference<DeclaracaoIRPF> declaracaoRef = null;

    public Pagamentos(DeclaracaoIRPF declaracaoIRPF) {
        this.declaracaoRef = new WeakReference<DeclaracaoIRPF>(declaracaoIRPF);
        this.setFicha("Pagamentos Efetuados");
        this.inicializaGeradorIndices();
    }

    private void inicializaGeradorIndices() {
        if (this.ultimoIndiceGerado.naoFormatado().trim().equals("")) {
            geradorIndices = 0L;
            return;
        }
        geradorIndices = Long.parseLong(this.ultimoIndiceGerado.naoFormatado());
    }

    private String proximoIndice() {
        this.ultimoIndiceGerado.setConteudo("" + geradorIndices++);
        return this.ultimoIndiceGerado.naoFormatado();
    }

    public void reordenaPorCodigo() {
        Collections.sort(this.itens(), new r(this));
    }

    public void objetoInserido(Pagamento pagamento) {
        pagamento.setFicha(this.getFicha());
    }

    public Pagamento instanciaNovoObjeto() {
        Pagamento pagamento = new Pagamento((DeclaracaoIRPF)((Object)this.declaracaoRef.get()));
        pagamento.getIndice().setConteudo(this.proximoIndice());
        return pagamento;
    }

    public boolean existeValorPagoAlto() {
        for (Pagamento pagamento : this.itens()) {
            if (!pagamento.getValorPago().comparacao(">", "50.000,00")) continue;
            return true;
        }
        return false;
    }

    public String[] recuperarCNPJsMaioresPrevComplementar(int n2) {
        String[] stringArray;
        Object object;
        Iterator iterator = this.itens().iterator();
        HashMap<String[], s> hashMap = new HashMap<String[], s>();
        while (iterator.hasNext()) {
            object = (Pagamento)iterator.next();
            if (!((Pagamento)object).isPrevidenciaPrivadaFapi()) continue;
            stringArray = ((Pagamento)object).getNiBeneficiario().naoFormatado();
            s s2 = (s)hashMap.get(stringArray);
            if (s2 == null) {
                s2 = new s(this, (String)stringArray, new Valor());
                hashMap.put(stringArray, s2);
            }
            s2.b.append('+', ((Pagamento)object).getValorPago());
        }
        object = new ArrayList(hashMap.values());
        Collections.sort(object, new t(this));
        stringArray = new String[n2];
        int n3 = n2 - 1;
        while (n3 >= 0) {
            stringArray[n3] = n3 < object.size() ? ((s)object.get((int)(object.size() - 1 - n3))).a : "";
            --n3;
        }
        return stringArray;
    }

    public String recuperarCpfMaiorPensaoAlimenticia() {
        Iterator iterator = this.itens().iterator();
        String string = "";
        Valor valor = null;
        while (iterator.hasNext()) {
            Pagamento pagamento = (Pagamento)iterator.next();
            if (!pagamento.getCodigo().naoFormatado().equals("30") && !pagamento.getCodigo().naoFormatado().equals("31") && !pagamento.getCodigo().naoFormatado().equals("33") && !pagamento.getCodigo().naoFormatado().equals("34") || pagamento.getNiBeneficiario().naoFormatado().trim().length() < 11) continue;
            if (valor == null) {
                valor = pagamento.getValorPago();
                string = pagamento.getNiBeneficiario().naoFormatado().substring(0, 11);
                continue;
            }
            if (!pagamento.getValorPago().comparacao(">", valor)) continue;
            valor = pagamento.getValorPago();
            string = pagamento.getNiBeneficiario().naoFormatado().substring(0, 11);
        }
        return string;
    }

    public String recuperarCpfMaiorEmpregadaDomestica() {
        Iterator iterator = this.itens().iterator();
        String string = "";
        Valor valor = null;
        while (iterator.hasNext()) {
            Pagamento pagamento = (Pagamento)iterator.next();
            if (!pagamento.getCodigo().naoFormatado().equals("50") || pagamento.getNiBeneficiario().naoFormatado().trim().length() < 11) continue;
            if (valor == null) {
                valor = pagamento.getValorPago();
                string = pagamento.getNiBeneficiario().naoFormatado().substring(0, 11);
                continue;
            }
            if (!pagamento.getValorPago().comparacao(">", valor)) continue;
            valor = pagamento.getValorPago();
            string = pagamento.getNiBeneficiario().naoFormatado().substring(0, 11);
        }
        return string;
    }

    public ArrayList<String[]> recuperarDadosTresMaioresEmpregadasDomesticas() {
        Valor valor;
        Object object;
        Object object22;
        Cloneable cloneable = new HashMap();
        for (Object object22 : this.itens()) {
            if (!((Pagamento)object22).getCodigo().naoFormatado().equals("50") || ((Pagamento)object22).getNiBeneficiario().naoFormatado().trim().length() < 11) continue;
            object = ((Pagamento)object22).getNitEmpregadoDomestico().naoFormatado().length() > 0 ? String.valueOf(((Pagamento)object22).getNiBeneficiario().naoFormatado()) + "-" + ((Pagamento)object22).getNitEmpregadoDomestico().naoFormatado() : String.valueOf(((Pagamento)object22).getNiBeneficiario().naoFormatado()) + "- ";
            if (cloneable.containsKey(object)) {
                ((Valor)cloneable.get(object)).append('+', ((Pagamento)object22).getValorPago());
                continue;
            }
            valor = new Valor();
            valor.setConteudo(((Pagamento)object22).getValorPago());
            cloneable.put(object, valor);
        }
        object22 = new v(this, (Map)((Object)cloneable));
        object = new TreeMap(object22);
        ((TreeMap)object).putAll(cloneable);
        valor = ((TreeMap)object).keySet();
        cloneable = new ArrayList();
        for (Object object3 : valor) {
            ((ArrayList)cloneable).add(((String)object3).split("-"));
        }
        return cloneable;
    }

    public NI[] recuperarMaioresNIsDepesasMedicas(int n2) {
        HashMap<String, Valor> hashMap = new HashMap<String, Valor>();
        NI[] nIArray = new NI[n2];
        Valor[] valorArray = new Valor[n2];
        block0: for (Pagamento pagamento : this.itens()) {
            if (!"09".equals(pagamento.getCodigo().naoFormatado()) && !"10".equals(pagamento.getCodigo().naoFormatado()) && !"11".equals(pagamento.getCodigo().naoFormatado()) && !"12".equals(pagamento.getCodigo().naoFormatado()) && !"13".equals(pagamento.getCodigo().naoFormatado()) && !"14".equals(pagamento.getCodigo().naoFormatado()) && !"21".equals(pagamento.getCodigo().naoFormatado()) && !"26".equals(pagamento.getCodigo().naoFormatado())) continue;
            Valor valor = (Valor)hashMap.get(pagamento.getNiBeneficiario().naoFormatado());
            if (valor == null) {
                valor = new Valor();
                hashMap.put(pagamento.getNiBeneficiario().naoFormatado(), valor);
            }
            valor.append('+', pagamento.getValorPago());
            int n3 = 0;
            while (n3 < n2) {
                if (valorArray[n3] == null || valor.comparacao(">", valorArray[n3])) {
                    int n4 = n3 + 1;
                    if (n4 < n2) {
                        valorArray[n4] = valorArray[n3];
                        nIArray[n4] = nIArray[n3];
                    }
                    valorArray[n3] = valor;
                    nIArray[n3] = pagamento.getNiBeneficiario();
                    continue block0;
                }
                ++n3;
            }
        }
        return nIArray;
    }

    public boolean possuiDependente(String string) {
        this.excluirRegistrosEmBranco();
        Iterator iterator = this.itens().iterator();
        if (string != null && !string.isEmpty()) {
            while (iterator.hasNext()) {
                Pagamento pagamento = (Pagamento)iterator.next();
                if (!pagamento.getDependenteOuAlimentando().naoFormatado().equals(string) || !pagamento.getTipo().naoFormatado().equals("D")) continue;
                return true;
            }
        }
        return false;
    }

    public void excluirPagamentosComDependente(String string) {
        this.excluirRegistrosEmBranco();
        Iterator iterator = this.itens().iterator();
        while (iterator.hasNext()) {
            Pagamento pagamento = (Pagamento)iterator.next();
            if (!pagamento.getDependenteOuAlimentando().naoFormatado().equals(string) || !pagamento.getTipo().naoFormatado().equals("D")) continue;
            iterator.remove();
        }
    }

    public void excluirPagamentosComAlimentando(String string) {
        this.excluirRegistrosEmBranco();
        Iterator iterator = this.itens().iterator();
        while (iterator.hasNext()) {
            Pagamento pagamento = (Pagamento)iterator.next();
            if (!pagamento.getDependenteOuAlimentando().naoFormatado().equals(string) || !pagamento.getTipo().naoFormatado().equals("A")) continue;
            iterator.remove();
        }
    }

    public boolean existePagamentosComAlimentando(String string) {
        this.excluirRegistrosEmBranco();
        for (Pagamento pagamento : this.itens()) {
            if (pagamento.getDependenteOuAlimentando().naoFormatado().isEmpty() || !pagamento.getDependenteOuAlimentando().naoFormatado().equals(string) || !pagamento.getTipo().naoFormatado().equals("A")) continue;
            return true;
        }
        return false;
    }

    public int obterTotalDependentesEnvolvidos() {
        HashSet<String> hashSet = new HashSet<String>();
        this.excluirRegistrosEmBranco();
        for (Pagamento pagamento : this.itens()) {
            if (pagamento.getDependenteOuAlimentando().isVazio() || pagamento.getCodigo().isVazio() || !pagamento.ehDependenteBrasil() && !pagamento.ehDependenteExterior()) continue;
            hashSet.add(pagamento.getDependenteOuAlimentando().formatado());
        }
        int n2 = 0;
        if (!hashSet.isEmpty()) {
            n2 = hashSet.size();
        }
        return n2;
    }

    public int obterTotalAlimentandosEnvolvidos() {
        HashSet<String> hashSet = new HashSet<String>();
        this.excluirRegistrosEmBranco();
        for (Pagamento pagamento : this.itens()) {
            if (pagamento.getDependenteOuAlimentando().isVazio() || pagamento.getCodigo().isVazio() || !pagamento.ehAlimentandoBrasil() && !pagamento.ehAlimentandoExterior()) continue;
            hashSet.add(pagamento.getDependenteOuAlimentando().formatado());
        }
        int n2 = 0;
        if (!hashSet.isEmpty()) {
            n2 = hashSet.size();
        }
        return n2;
    }

    public Valor obterTotalFunprespAteLimite(String string) {
        Valor valor = new Valor();
        this.excluirRegistrosEmBranco();
        for (Pagamento pagamento : this.itens()) {
            if (!pagamento.isFunpresp() || !pagamento.getTipo().naoFormatado().equals(string)) continue;
            valor.append('+', pagamento.getValorPagoFunprespCalculado());
        }
        return valor;
    }

    public Valor obterTotalFunprespAcimaLimite(String string) {
        Valor valor = new Valor();
        this.excluirRegistrosEmBranco();
        for (Pagamento pagamento : this.itens()) {
            if (!pagamento.isFunpresp() || !pagamento.getTipo().naoFormatado().equals(string)) continue;
            valor.append('+', pagamento.getValorPagoFapiAtravesFunpresp());
        }
        return valor;
    }

    public List<String> recuperarNISeisMaioresPagamentos() {
        Object object;
        Object object22;
        ArrayList<String> arrayList = new ArrayList<String>();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (Object object22 : this.itens()) {
            if (!this.getCodigosPagamentosDedutiveis().containsKey(((Pagamento)object22).getCodigo().formatado())) continue;
            Valor valor = (Valor)hashMap.get(((Pagamento)object22).getNiBeneficiario().naoFormatado());
            object = ((Pagamento)object22).getValorPago().operacao('-', ((Pagamento)object22).getParcelaNaoDedutivel());
            if (object.comparacao("<", "0,00")) {
                valor.setConteudo("0,00");
            }
            if (valor != null) {
                hashMap.put(((Pagamento)object22).getNiBeneficiario().naoFormatado(), object.operacao('+', valor));
                continue;
            }
            hashMap.put(((Pagamento)object22).getNiBeneficiario().naoFormatado(), object);
        }
        object22 = new LinkedList(hashMap.entrySet());
        Collections.sort(object22, new u(this));
        int n2 = object22.size() > 6 ? 6 : object22.size();
        int n3 = 1;
        while (n3 <= n2) {
            object = (Map.Entry)object22.get(n3 - 1);
            arrayList.add((String)object.getKey());
            ++n3;
        }
        n3 = object22.size();
        while (n3 < 6) {
            arrayList.add("");
            ++n3;
        }
        return arrayList;
    }

    public String recuperarCNPJMaiorPagamentoFunpresp() {
        String string = "";
        Valor valor = new Valor("0,00");
        for (Pagamento pagamento : this.itens()) {
            if (!"37".equals(pagamento.getCodigo().formatado()) || !pagamento.getValorPago().comparacao(">", valor)) continue;
            valor.setConteudo(pagamento.getValorPago());
            string = pagamento.getNiBeneficiario().naoFormatado();
        }
        return string;
    }

    public HashMap<String, String> getCodigosPagamentosDedutiveis() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("01", "01");
        hashMap.put("09", "09");
        hashMap.put("10", "10");
        hashMap.put("11", "11");
        hashMap.put("12", "12");
        hashMap.put("13", "13");
        hashMap.put("14", "14");
        hashMap.put("21", "21");
        hashMap.put("26", "26");
        hashMap.put("30", "30");
        hashMap.put("33", "33");
        hashMap.put("36", "36");
        hashMap.put("37", "37");
        hashMap.put("38", "38");
        hashMap.put("50", "50");
        return hashMap;
    }

    public Valor getTotalDeducoesInstrucao() {
        return this.totalDeducoesInstrucao;
    }

    public Valor getTotalContribuicaoFAPI() {
        return this.totalContribuicaoFAPI;
    }

    public Valor getTotalDespesasMedicas() {
        return this.totalDespesasMedicas;
    }

    public Valor getTotalPensao() {
        return this.totalPensao;
    }

    public Valor getTotalPensaoCartoral() {
        return this.totalPensaoCartoral;
    }

    public Valor getTotalContribEmpregadoDomestico() {
        return this.totalContribEmpregadoDomestico;
    }

    public Valor getTotalContribuicaoFunpresp() {
        return this.totalContribuicaoFunpresp;
    }
}

