/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.rendTributacaoExclusiva;

import classes.dc;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import serpro.ppgd.irpf.ColecaoItemQuadroOutrosRendimentos;
import serpro.ppgd.irpf.ColecaoItemQuadroTransporteDetalhado;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.ItemQuadroAuxiliar;
import serpro.ppgd.irpf.ItemQuadroAuxiliarAb;
import serpro.ppgd.irpf.ai;
import serpro.ppgd.irpf.gui.rendTributacaoExclusiva.PainelRendTributacaoExclusiva;
import serpro.ppgd.irpf.rendTributacaoExclusiva.b;
import serpro.ppgd.irpf.rendTributacaoExclusiva.c;
import serpro.ppgd.irpf.rendTributacaoExclusiva.d;
import serpro.ppgd.irpf.rendTributacaoExclusiva.e;
import serpro.ppgd.irpf.rendTributacaoExclusiva.f;
import serpro.ppgd.irpf.rendTributacaoExclusiva.g;
import serpro.ppgd.irpf.rendTributacaoExclusiva.h;
import serpro.ppgd.irpf.rendTributacaoExclusiva.i;
import serpro.ppgd.negocio.CPF;
import serpro.ppgd.negocio.Colecao;
import serpro.ppgd.negocio.ElementoTabela;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.ObjetoFicha;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.Pendencia;
import serpro.ppgd.negocio.ValidadorIf;
import serpro.ppgd.negocio.Valor;

public class RendTributacaoExclusiva
extends ObjetoNegocio
implements ObjetoFicha {
    public static final String COD_OUTROS_RENDIMENTOS_TRIBUTACAO_EXCLUSIVA = "2";
    private ai decimoTerceiro = new ai(this, "13o Sal\u00e1rio");
    private ai ganhosCapital = new ai(this, "Ganhos de Capital - Aliena\u00e7\u00e3o de Bens ou Direitos");
    private ai ganhosCapitalEstrangeira = new ai(this, "Ganhos de Capital - Aliena\u00e7\u00e3o de Bens ou Direitos em Moeda Estrangeira");
    private ai ganhosCapitalEmEspecie = new ai(this, "Ganhos de Capital - Aliena\u00e7\u00e3o de Moeda Estrangeira em Esp\u00e9cie");
    private ai ganhosRendaVariavel = new ai(this, "Ganhos L\u00edquidos em Renda Vari\u00e1vel");
    private ai rendAplicacoes = new ai(this, "Rendimentos de Aplica\u00e7\u00f5es Financeiras");
    private ColecaoItemQuadroTransporteDetalhado rendAplicacoesQuadroAuxiliar = new ColecaoItemQuadroTransporteDetalhado(this);
    private ai outros = new ai(this, "Outros Rendimentos do Titular");
    private ColecaoItemQuadroOutrosRendimentos outrosQuadroAuxiliar = new ColecaoItemQuadroOutrosRendimentos(this);
    private ai decimoTerceiroDependentes = new ai(this, "13o Sal\u00e1rio dos Dependentes");
    private ai rraTitular = new ai(this, "Rendimentos Recebidos Acumuladamente");
    private ai rraDependentes = new ai(this, "Rendimentos Recebidos Acumuladamente pelos Dependentes");
    private ai jurosCapitalProprio = new ai(this, "juros Capital Proprio");
    private ColecaoItemQuadroTransporteDetalhado jurosCapitalProprioQuadroAuxiliar = new ColecaoItemQuadroTransporteDetalhado(this);
    private ai participacaoLucrosResultados = new ai(this, "participacao Lucros Resultados");
    private ColecaoItemQuadroTransporteDetalhado participacaoLucrosResultadosQuadroAuxiliar = new ColecaoItemQuadroTransporteDetalhado(this);
    private ai total = new ai(this, "Total dos Rendimentos");
    private WeakReference<DeclaracaoIRPF> weakDec = null;

    public RendTributacaoExclusiva(DeclaracaoIRPF declaracaoIRPF) {
        this.weakDec = new WeakReference<DeclaracaoIRPF>(declaracaoIRPF);
        this.getRendAplicacoesQuadroAuxiliar().setDec(this.weakDec);
        this.getJurosCapitalProprioQuadroAuxiliar().setDec(this.weakDec);
        this.getParticipacaoLucrosResultadosQuadroAuxiliar().setDec(this.weakDec);
        this.getOutrosQuadroAuxiliar().setDec(this.weakDec);
        this.getDecimoTerceiro().setReadOnly(true);
        this.getGanhosCapital().setReadOnly(true);
        this.getGanhosCapitalEstrangeira().setReadOnly(true);
        this.getGanhosCapitalEmEspecie().setReadOnly(true);
        this.getGanhosRendaVariavel().setReadOnly(true);
        this.getRendAplicacoes().setReadOnly(true);
        this.getDecimoTerceiroDependentes().setReadOnly(true);
        this.getRraTitular().setReadOnly(true);
        this.getRraDependentes().setReadOnly(true);
        this.getJurosCapitalProprio().setReadOnly(true);
        this.getParticipacaoLucrosResultados().setReadOnly(true);
        this.getOutros().setReadOnly(true);
        this.getTotal().setReadOnly(true);
        this.getRendAplicacoesQuadroAuxiliar().getTotais().addObservador((Observador)new b(this));
        this.getJurosCapitalProprioQuadroAuxiliar().getTotais().addObservador((Observador)new c(this));
        this.getParticipacaoLucrosResultadosQuadroAuxiliar().getTotais().addObservador((Observador)new d(this));
        this.getOutrosQuadroAuxiliar().getTotais().addObservador((Observador)new e(this));
        this.rendAplicacoes.addValidador((ValidadorIf)new f(this, 3, declaracaoIRPF));
        this.jurosCapitalProprio.addValidador((ValidadorIf)new g(this, 3, declaracaoIRPF));
        this.participacaoLucrosResultados.addValidador((ValidadorIf)new h(this, 3, declaracaoIRPF));
        this.outros.addValidador((ValidadorIf)new i(this, 3, declaracaoIRPF));
        this.setFicha("Rendimentos Sujeitos \u00e0 Tributa\u00e7\u00e3o Exclusiva/Definitiva");
    }

    public List<Pendencia> verificarPendencias(int n2) {
        List list = super.verificarPendencias(n2);
        List<ElementoTabela> list2 = dc.O();
        List<Colecao<? extends ItemQuadroAuxiliarAb>> list32 = this.getColecoesRendimentos();
        int n3 = 0;
        int n4 = 1;
        for (Colecao<? extends ItemQuadroAuxiliarAb> colecao : list32) {
            list.addAll(classes.b.a(colecao, n4, list2.get(n3).getConteudo(1), false));
            n4 += colecao.itens().size();
            ++n3;
        }
        return list;
    }

    protected List<Informacao> recuperarListaCamposPendencia() {
        List list = super.recuperarListaCamposPendencia();
        list.add(this.rendAplicacoes);
        list.add(this.jurosCapitalProprio);
        list.add(this.participacaoLucrosResultados);
        list.add(this.outros);
        list.add(this.total);
        return list;
    }

    public void addObservador(Observador observador) {
        this.ganhosCapital.addObservador(observador);
        this.ganhosCapitalEstrangeira.addObservador(observador);
        this.ganhosCapitalEmEspecie.addObservador(observador);
        this.ganhosRendaVariavel.addObservador(observador);
        this.rendAplicacoes.addObservador(observador);
        this.outros.addObservador(observador);
        this.decimoTerceiroDependentes.addObservador(observador);
        this.rraTitular.addObservador(observador);
        this.rraDependentes.addObservador(observador);
        this.jurosCapitalProprio.addObservador(observador);
        this.participacaoLucrosResultados.addObservador(observador);
    }

    public boolean totalAlto() {
        return this.total.comparacao(">", "1.000.000,00");
    }

    public Valor recuperarExclusivosTitular() {
        Valor valor = new Valor();
        valor.append('+', (Valor)this.ganhosCapital);
        valor.append('+', (Valor)this.ganhosCapitalEstrangeira);
        valor.append('+', (Valor)this.ganhosCapitalEmEspecie);
        valor.append('+', (Valor)this.decimoTerceiro);
        valor.append('+', (Valor)this.ganhosRendaVariavel);
        valor.append('+', (Valor)this.rraTitular);
        valor.append('+', classes.b.a(this.rendAplicacoesQuadroAuxiliar));
        valor.append('+', classes.b.a(this.outrosQuadroAuxiliar));
        valor.append('+', classes.b.a(this.jurosCapitalProprioQuadroAuxiliar));
        valor.append('+', classes.b.a(this.participacaoLucrosResultadosQuadroAuxiliar));
        return valor;
    }

    public Valor recuperarExclusivosDependentes() {
        Valor valor = new Valor();
        valor.append('+', (Valor)this.decimoTerceiroDependentes);
        valor.append('+', (Valor)this.rraDependentes);
        valor.append('+', classes.b.b(this.rendAplicacoesQuadroAuxiliar));
        valor.append('+', classes.b.b(this.outrosQuadroAuxiliar));
        valor.append('+', classes.b.b(this.jurosCapitalProprioQuadroAuxiliar));
        valor.append('+', classes.b.b(this.participacaoLucrosResultadosQuadroAuxiliar));
        return valor;
    }

    public Valor recuperarTotalTitularExceto13_RV_e_GC() {
        Valor valor = new Valor();
        valor.append('+', (Valor)this.rraTitular);
        valor.append('+', classes.b.a(this.rendAplicacoesQuadroAuxiliar));
        valor.append('+', classes.b.a(this.outrosQuadroAuxiliar));
        valor.append('+', classes.b.a(this.jurosCapitalProprioQuadroAuxiliar));
        valor.append('+', classes.b.a(this.participacaoLucrosResultadosQuadroAuxiliar));
        return valor;
    }

    public Valor recuperarExclusivosDependentesExceto13Salario() {
        Valor valor = new Valor();
        valor.append('+', (Valor)this.rraDependentes);
        valor.append('+', classes.b.b(this.rendAplicacoesQuadroAuxiliar));
        valor.append('+', classes.b.b(this.outrosQuadroAuxiliar));
        valor.append('+', classes.b.b(this.jurosCapitalProprioQuadroAuxiliar));
        valor.append('+', classes.b.b(this.participacaoLucrosResultadosQuadroAuxiliar));
        return valor;
    }

    public Valor recuperarTotalPorBeneficiario(CPF cPF) {
        Valor valor = new Valor();
        valor.append('+', classes.b.a((Colecao<? extends ItemQuadroAuxiliar>)this.rendAplicacoesQuadroAuxiliar, cPF));
        valor.append('+', classes.b.a((Colecao<? extends ItemQuadroAuxiliar>)this.outrosQuadroAuxiliar, cPF));
        valor.append('+', classes.b.a((Colecao<? extends ItemQuadroAuxiliar>)this.jurosCapitalProprioQuadroAuxiliar, cPF));
        valor.append('+', classes.b.a((Colecao<? extends ItemQuadroAuxiliar>)this.participacaoLucrosResultadosQuadroAuxiliar, cPF));
        return valor;
    }

    public String getClasseFicha() {
        return PainelRendTributacaoExclusiva.class.getName();
    }

    public boolean isVazio() {
        return this.decimoTerceiro.isVazio() && this.ganhosRendaVariavel.isVazio() && this.rendAplicacoes.isVazio() && this.outros.isVazio() && this.decimoTerceiroDependentes.isVazio() && this.ganhosCapital.isVazio() && this.ganhosCapitalEstrangeira.isVazio() && this.ganhosCapitalEmEspecie.isVazio() && this.rraTitular.isVazio() && this.rraDependentes.isVazio() && this.jurosCapitalProprio.isVazio() && this.participacaoLucrosResultados.isVazio();
    }

    public String getNomeAba() {
        return null;
    }

    public boolean possuiDependenteComCPF(String string) {
        if (string == null || string.trim().isEmpty()) {
            return false;
        }
        return this.getRendAplicacoesQuadroAuxiliar().possuiDependenteComCPF(string) || this.getJurosCapitalProprioQuadroAuxiliar().possuiDependenteComCPF(string) || this.getParticipacaoLucrosResultadosQuadroAuxiliar().possuiDependenteComCPF(string) || this.getOutrosQuadroAuxiliar().possuiDependenteComCPF(string);
    }

    public void excluirDependentesComCPF(String string) {
        this.getRendAplicacoesQuadroAuxiliar().excluirDependentesComCPF(string);
        this.getJurosCapitalProprioQuadroAuxiliar().excluirDependentesComCPF(string);
        this.getParticipacaoLucrosResultadosQuadroAuxiliar().excluirDependentesComCPF(string);
        this.getOutrosQuadroAuxiliar().excluirDependentesComCPF(string);
    }

    public List<Colecao<? extends ItemQuadroAuxiliarAb>> getColecoesRendimentos() {
        ArrayList<Colecao<? extends ItemQuadroAuxiliarAb>> arrayList = new ArrayList<Colecao<? extends ItemQuadroAuxiliarAb>>();
        arrayList.add(this.getRendAplicacoesQuadroAuxiliar());
        arrayList.add(this.getJurosCapitalProprioQuadroAuxiliar());
        arrayList.add(this.getParticipacaoLucrosResultadosQuadroAuxiliar());
        arrayList.add(this.getOutrosQuadroAuxiliar());
        return arrayList;
    }

    public Valor getValorPorTipoRendimento(int n2) {
        switch (n2) {
            case 1: {
                return this.getDecimoTerceiro();
            }
            case 2: {
                return this.getGanhosCapital();
            }
            case 3: {
                return this.getGanhosCapitalEstrangeira();
            }
            case 4: {
                return this.getGanhosCapitalEmEspecie();
            }
            case 5: {
                return this.getGanhosRendaVariavel();
            }
            case 6: {
                return this.getRendAplicacoes();
            }
            case 7: {
                return this.getRraTitular();
            }
            case 8: {
                return this.getDecimoTerceiroDependentes();
            }
            case 9: {
                return this.getRraDependentes();
            }
            case 10: {
                return this.getJurosCapitalProprio();
            }
            case 11: {
                return this.getParticipacaoLucrosResultados();
            }
            case 12: {
                return this.getOutros();
            }
        }
        return null;
    }

    public ColecaoItemQuadroOutrosRendimentos getOutrosQuadroAuxiliar() {
        return this.outrosQuadroAuxiliar;
    }

    public ColecaoItemQuadroTransporteDetalhado getRendAplicacoesQuadroAuxiliar() {
        return this.rendAplicacoesQuadroAuxiliar;
    }

    public Valor getTotal() {
        return this.total;
    }

    public Valor getDecimoTerceiro() {
        return this.decimoTerceiro;
    }

    public Valor getDecimoTerceiroDependentes() {
        return this.decimoTerceiroDependentes;
    }

    public Valor getGanhosCapital() {
        return this.ganhosCapital;
    }

    public Valor getGanhosCapitalEmEspecie() {
        return this.ganhosCapitalEmEspecie;
    }

    public Valor getGanhosCapitalEstrangeira() {
        return this.ganhosCapitalEstrangeira;
    }

    public Valor getGanhosRendaVariavel() {
        return this.ganhosRendaVariavel;
    }

    public Valor getOutros() {
        return this.outros;
    }

    public Valor getRendAplicacoes() {
        return this.rendAplicacoes;
    }

    public Valor getJurosCapitalProprio() {
        return this.jurosCapitalProprio;
    }

    public ColecaoItemQuadroTransporteDetalhado getJurosCapitalProprioQuadroAuxiliar() {
        return this.jurosCapitalProprioQuadroAuxiliar;
    }

    public Valor getParticipacaoLucrosResultados() {
        return this.participacaoLucrosResultados;
    }

    public ColecaoItemQuadroTransporteDetalhado getParticipacaoLucrosResultadosQuadroAuxiliar() {
        return this.participacaoLucrosResultadosQuadroAuxiliar;
    }

    public ai getRraTitular() {
        return this.rraTitular;
    }

    public ai getRraDependentes() {
        return this.rraDependentes;
    }

    public String getTituloFichaDashboard() {
        return "Rendimentos Sujeitos \u00e0 Tributa\u00e7\u00e3o Exclusiva/Definitiva";
    }

    static /* synthetic */ ColecaoItemQuadroTransporteDetalhado a(RendTributacaoExclusiva rendTributacaoExclusiva) {
        return rendTributacaoExclusiva.rendAplicacoesQuadroAuxiliar;
    }

    static /* synthetic */ ColecaoItemQuadroTransporteDetalhado b(RendTributacaoExclusiva rendTributacaoExclusiva) {
        return rendTributacaoExclusiva.jurosCapitalProprioQuadroAuxiliar;
    }

    static /* synthetic */ ColecaoItemQuadroTransporteDetalhado c(RendTributacaoExclusiva rendTributacaoExclusiva) {
        return rendTributacaoExclusiva.participacaoLucrosResultadosQuadroAuxiliar;
    }

    static /* synthetic */ ColecaoItemQuadroOutrosRendimentos d(RendTributacaoExclusiva rendTributacaoExclusiva) {
        return rendTributacaoExclusiva.outrosQuadroAuxiliar;
    }
}

