/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.rendacm;

import java.util.Iterator;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.rendacm.ColecaoRendAcmTitular;
import serpro.ppgd.irpf.rendacm.RendAcmDependente;
import serpro.ppgd.negocio.CPF;
import serpro.ppgd.negocio.Valor;

public class ColecaoRendAcmDependente
extends ColecaoRendAcmTitular {
    public ColecaoRendAcmDependente(DeclaracaoIRPF declaracaoIRPF) {
        super(declaracaoIRPF);
        this.setFicha("Rendimentos Recebidos Acumuladamente pelos Dependentes");
    }

    @Override
    public RendAcmDependente instanciaNovoObjeto() {
        DeclaracaoIRPF declaracaoIRPF = (DeclaracaoIRPF)((Object)this.weakDec.get());
        return new RendAcmDependente(declaracaoIRPF, this);
    }

    public boolean possuiDependenteComCPF(String string) {
        if (string.trim().isEmpty()) {
            return false;
        }
        for (RendAcmDependente rendAcmDependente : this.itens()) {
            if (!rendAcmDependente.getCpfDependente().naoFormatado().equals(string)) continue;
            return true;
        }
        return false;
    }

    public void excluirDependentesComCPF(String string) {
        Iterator iterator = this.itens().iterator();
        while (iterator.hasNext()) {
            RendAcmDependente rendAcmDependente = (RendAcmDependente)((Object)iterator.next());
            if (!rendAcmDependente.getCpfDependente().naoFormatado().equals(string)) continue;
            iterator.remove();
        }
    }

    public Valor obterRendimentosRecebidosPorDependente(CPF cPF) {
        Valor valor = new Valor();
        for (RendAcmDependente rendAcmDependente : this.itens()) {
            if (!rendAcmDependente.getCpfDependente().naoFormatado().equals(cPF.naoFormatado())) continue;
            valor.append('+', (Valor)rendAcmDependente.getRendRecebidos());
        }
        return valor;
    }
}

